/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import oracle.ewt.dnd.DnDUtils;
import oracle.ewt.dnd.DragGestureListener;
import oracle.ewt.dnd.DragSource;
import oracle.ewt.dnd.MouseDragGestureRecognizer;
import oracle.ewt.util.InputEventUtils;

class EWTDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private boolean _startDrag;
    private int _x;
    private int _y;
    private static final int _DRAG_START_DELTA = 3;

    public EWTDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        super(dragSource, component, n, dragGestureListener);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.resetRecognizer();
        if (mouseEvent.getClickCount() <= 1 && (InputEventUtils.getMods(mouseEvent) & 0xC) == 0 && !this._isDragInProgress()) {
            this._startDrag = true;
            this._x = mouseEvent.getX();
            this._y = mouseEvent.getY();
            this.appendEvent(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._startDrag = false;
        this.resetRecognizer();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._startDrag && !this._isDragInProgress()) {
            this.appendEvent(mouseEvent);
            if (Math.abs(mouseEvent.getX() - this._x) >= 3 || Math.abs(mouseEvent.getY() - this._y) >= 3) {
                int n = DnDUtils.getDefaultActions(InputEventUtils.getMods(mouseEvent)) & this.getSourceActions();
                if (n != 0) {
                    if (n != 1 && n != 2 && n != 0x40000000) {
                        n = (n & 1) != 0 ? 1 : 2;
                    }
                    this.fireDragGestureRecognized(n, new Point(this._x, this._y));
                }
                this._startDrag = false;
            }
        }
    }

    private boolean _isDragInProgress() {
        return DragSource.getCurrentDragSourceContext() != null;
    }
}

