/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.event.tracking;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.scrolling.MouseWheelScrolling;
import oracle.ewt.scrolling.MouseWheelUtils;
import oracle.ewt.util.ComponentUtils;

public class GlassMouseGrabProvider
implements MouseGrabProvider {
    private MouseListener _grabs;
    private MouseMotionListener _motionGrabs;
    private Component _proxy;

    @Override
    public void addMouseGrab(MouseListener mouseListener) {
        this._grabs = AWTEventMulticaster.add(mouseListener, this._grabs);
    }

    @Override
    public void addMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this._motionGrabs = AWTEventMulticaster.add(mouseMotionListener, this._motionGrabs);
    }

    @Override
    public Component getProxyComponent() {
        if (this._proxy == null) {
            this._proxy = new Proxy();
            Disp disp = new Disp();
            this._proxy.addMouseListener(disp);
            this._proxy.addMouseMotionListener(disp);
        }
        return this._proxy;
    }

    @Override
    public void processMouseGrabs(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 503 || n == 506) {
            if (this._motionGrabs != null) {
                switch (mouseEvent.getID()) {
                    case 503: {
                        this._motionGrabs.mouseMoved(mouseEvent);
                        break;
                    }
                    case 506: {
                        this._motionGrabs.mouseDragged(mouseEvent);
                    }
                }
            }
        } else if (this._grabs != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this._grabs.mouseClicked(mouseEvent);
                    break;
                }
                case 501: {
                    this._grabs.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this._grabs.mouseReleased(mouseEvent);
                    break;
                }
                case 504: {
                    this._grabs.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this._grabs.mouseExited(mouseEvent);
                }
            }
        }
    }

    @Override
    public void removeMouseGrab(MouseListener mouseListener) {
        this._grabs = AWTEventMulticaster.remove(this._grabs, mouseListener);
    }

    @Override
    public void removeMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this._motionGrabs = AWTEventMulticaster.remove(this._motionGrabs, mouseMotionListener);
    }

    protected Cursor getCursor(Component component, boolean bl, boolean bl2) {
        if (!bl) {
            return component.getCursor();
        }
        return null;
    }

    private class Disp
    implements MouseListener,
    MouseMotionListener {
        private Component _dragComponent;
        private Component _mouseComponent;
        private Component _clickComponent;
        private boolean _enterGrabbed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = new Point();
            Component component = this._checkTarget(mouseEvent, point);
            try {
                this._redispatchEvent(mouseEvent, component, 501, point);
            }
            finally {
                this._dragComponent = this._clickComponent = component;
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = new Point();
            Component component = this._checkTarget(mouseEvent, point);
            if (component == this._clickComponent) {
                this._redispatchEvent(mouseEvent, component, 500, point);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this._dragComponent != null) {
                try {
                    this._redispatchEvent(mouseEvent, this._dragComponent, 502);
                }
                finally {
                    this._dragComponent = null;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this._checkTarget(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this._checkTarget(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this._checkTarget(mouseEvent);
            this._redispatchEvent(mouseEvent, this._dragComponent, 506);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Component component = this._mouseComponent;
            Point point = new Point();
            Component component2 = this._checkTarget(mouseEvent, point);
            if (component == component2 && component2 != null) {
                this._redispatchEvent(mouseEvent, component2, 503, point);
            }
        }

        private Component _checkTarget(MouseEvent mouseEvent) {
            return this._checkTarget(mouseEvent, new Point());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Component _checkTarget(MouseEvent mouseEvent, Point point) {
            Component component = null;
            if (mouseEvent.getID() != 505) {
                point.x = mouseEvent.getX();
                point.y = mouseEvent.getY();
                Component component2 = GlassMouseGrabProvider.this.getProxyComponent();
                component = ComponentUtils.getTargetComponent(component2.getParent(), point);
            }
            if (component != this._mouseComponent) {
                if (this._mouseComponent != null && (this._dragComponent == null || this._dragComponent == this._mouseComponent)) {
                    try {
                        this._redispatchEvent(mouseEvent, this._mouseComponent, 505);
                    }
                    finally {
                        this._mouseComponent = null;
                    }
                }
                if (component != null && (this._dragComponent == null || this._dragComponent == component)) {
                    try {
                        this._redispatchEvent(mouseEvent, component, 504, point);
                    }
                    finally {
                        this._mouseComponent = component;
                    }
                }
            }
            return component;
        }

        private void _redispatchEvent(MouseEvent mouseEvent, Component component, int n) {
            if (component == null) {
                return;
            }
            Container container = GlassMouseGrabProvider.this.getProxyComponent().getParent();
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            for (Component component2 = component; component2 != container && component2 != null; component2 = component2.getParent()) {
                Point point2 = component2.getLocation();
                point.x -= point2.x;
                point.y -= point2.y;
            }
            this._redispatchEvent(mouseEvent, component, n, point);
        }

        private void _redispatchEvent(MouseEvent mouseEvent, Component component, int n, Point point) {
            Cursor cursor;
            if (component == null) {
                return;
            }
            int n2 = mouseEvent.getModifiers() | mouseEvent.getModifiersEx();
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), n2, point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            GlassMouseGrabProvider.this.processMouseGrabs(mouseEvent2);
            Component component2 = GlassMouseGrabProvider.this.getProxyComponent();
            boolean bl = mouseEvent2.isConsumed();
            if (n == 504) {
                this._enterGrabbed = bl;
            }
            if (n == 505) {
                if (bl && !this._enterGrabbed) {
                    bl = false;
                    mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                }
                this._enterGrabbed = false;
            }
            if (!bl && component != component2.getParent()) {
                if (component instanceof LWComponent) {
                    ((LWComponent)component).redispatchEvent(mouseEvent2);
                } else {
                    component.dispatchEvent(mouseEvent2);
                }
            }
            if ((cursor = GlassMouseGrabProvider.this.getCursor(component, bl, mouseEvent2.isConsumed())) == null) {
                cursor = Cursor.getDefaultCursor();
            }
            if (cursor != component2.getCursor()) {
                component2.setCursor(cursor);
            }
        }
    }

    private static class Proxy
    extends LWComponent
    implements MouseWheelScrolling {
        public Proxy() {
            MouseWheelUtils mouseWheelUtils = new MouseWheelUtils();
            mouseWheelUtils.addMouseWheelListener(this);
        }

        @Override
        public boolean handleWheelScrolling(int n, int n2, int n3) {
            return false;
        }

        @Override
        public Component getMouseWheelScrollingComponent() {
            return this;
        }

        @Override
        protected void processEventImpl(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            super.processEventImpl(aWTEvent);
            if (aWTEvent instanceof MouseEvent && !(mouseEvent = (MouseEvent)aWTEvent).isConsumed() && MouseWheelUtils.isMouseWheelEvent(mouseEvent)) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                Container container = this.getParent();
                Component component = ComponentUtils.getTargetComponent(container, point);
                if (component != null && component != container) {
                    MouseWheelUtils.dispatchMouseWheelEvent(mouseEvent, component, point);
                }
            }
        }

        @Override
        public final void repaint(long l, int n, int n2, int n3, int n4) {
        }
    }
}

