/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.event.tracking;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import oracle.ewt.event.tracking.MouseGrabProvider;

public class ListenerMouseGrabProvider
implements MouseGrabProvider,
MouseListener,
MouseMotionListener,
ContainerListener {
    private Component _comp;
    private MouseListener _grabs;
    private MouseMotionListener _motionGrabs;

    public ListenerMouseGrabProvider(Component component) {
        this._comp = component;
        this._addListeners(this._comp);
    }

    @Override
    public synchronized void addMouseGrab(MouseListener mouseListener) {
        this._grabs = AWTEventMulticaster.add(mouseListener, this._grabs);
    }

    @Override
    public synchronized void addMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this._motionGrabs = AWTEventMulticaster.add(mouseMotionListener, this._motionGrabs);
    }

    @Override
    public Component getProxyComponent() {
        return null;
    }

    @Override
    public void processMouseGrabs(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 503 || n == 506) {
            if (this._motionGrabs != null) {
                switch (mouseEvent.getID()) {
                    case 503: {
                        this._motionGrabs.mouseMoved(mouseEvent);
                        break;
                    }
                    case 506: {
                        this._motionGrabs.mouseDragged(mouseEvent);
                    }
                }
            }
        } else if (this._grabs != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this._grabs.mouseClicked(mouseEvent);
                    break;
                }
                case 501: {
                    this._grabs.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this._grabs.mouseReleased(mouseEvent);
                    break;
                }
                case 504: {
                    this._grabs.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this._grabs.mouseExited(mouseEvent);
                }
            }
        }
    }

    @Override
    public synchronized void removeMouseGrab(MouseListener mouseListener) {
        this._grabs = AWTEventMulticaster.remove(this._grabs, mouseListener);
    }

    @Override
    public synchronized void removeMouseMotionGrab(MouseMotionListener mouseMotionListener) {
        this._motionGrabs = AWTEventMulticaster.remove(this._motionGrabs, mouseMotionListener);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this._addListeners(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this._removeListeners(containerEvent.getChild());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.processMouseGrabs(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.processMouseGrabs(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.processMouseGrabs(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.processMouseGrabs(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.processMouseGrabs(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouseGrabs(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.processMouseGrabs(mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addListeners(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = component.getTreeLock();
            synchronized (object) {
                container.addContainerListener(this);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this._addListeners(container.getComponent(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeListeners(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = component.getTreeLock();
            synchronized (object) {
                container.removeContainerListener(this);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this._removeListeners(container.getComponent(i));
                }
            }
        }
    }
}

