/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.font;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.LookAndFeel;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.LocaleUtils;

public class FontPreviewArea
extends LWComponent {
    private static final String _KEY_EXAMPLE_TEXT = "FONTPANE.EXAMPLE_TEXT";
    private static final int _MIN_WIDTH = 100;
    private static final int _MIN_HEIGHT = 100;
    private static final int _OUTER_HINSETS = 8;
    private static final int _OUTER_VINSETS = 8;
    private static final int _INNER_HINSETS = 4;
    private static final int _INNER_VINSETS = 4;
    private static final String _RESOURCE = "oracle.ewt.font.resource.FontBundle";
    private Color _fontColor;
    private Color _fontBorderColor;
    private Color _fontBackground;
    private int _hAlignment;
    private int _vAlignment;
    private int _fontStyle;
    private int _fontBaselineStyle;
    private String _exampleText;
    private boolean _fontBorderVisible;
    private boolean _baselineVisible;
    private Font _currentFont;

    public FontPreviewArea() {
        this.setBackground(Color.white);
        this._hAlignment = 1;
        this._vAlignment = 6;
        this._fontStyle = 0;
        this._fontBaselineStyle = 1;
    }

    public Font getCurrentFont() {
        if (this._currentFont == null) {
            this._currentFont = this.getFont();
        }
        return this._currentFont;
    }

    public void setCurrentFont(Font font) {
        if (font == null) {
            font = this.getFont();
        }
        if (this._currentFont != font) {
            boolean bl;
            this._currentFont = font;
            int n = this.getFontStyle();
            boolean bl2 = (n & 1) != 0;
            boolean bl3 = (n & 2) != 0;
            int n2 = this._currentFont.getStyle();
            boolean bl4 = (n2 & 1) != 0;
            boolean bl5 = bl = (n2 & 2) != 0;
            if (bl2 != bl4) {
                n = bl2 ? (n &= 0xFFFFFFFE) : (n |= 1);
            }
            if (bl3 != bl) {
                n = bl3 ? (n &= 0xFFFFFFFD) : (n |= 2);
            }
            this._fontStyle = n;
            this.repaint();
        }
    }

    public void setFontColor(Color color) {
        if (this._fontColor != color) {
            this._fontColor = color;
            this.repaint();
        }
    }

    public Color getFontColor() {
        if (this._fontColor == null) {
            this._fontColor = this.getUIDefaults().getColor(LookAndFeel.TEXT_TEXT);
        }
        return this._fontColor;
    }

    public void setFontBackgroundColor(Color color) {
        if (this._fontBackground != color) {
            this._fontBackground = color;
            this.repaint();
        }
    }

    public Color getFontBackgroundColor() {
        if (this._fontBackground == null) {
            this._fontBackground = this.getUIDefaults().getColor(LookAndFeel.TEXT);
        }
        return this._fontBackground;
    }

    public void setFontBorderColor(Color color) {
        if (this._fontBorderColor != color) {
            this._fontBorderColor = color;
            if (this.isFontBorderVisible()) {
                this.repaint();
            }
        }
    }

    public Color getFontBorderColor() {
        if (this._fontBorderColor == null) {
            this._fontBorderColor = this.getFontBackgroundColor();
        }
        return this._fontBorderColor;
    }

    public boolean isFontBorderVisible() {
        return this._fontBorderVisible;
    }

    public void setFontBorderVisible(boolean bl) {
        if (this._fontBorderVisible != bl) {
            this._fontBorderVisible = bl;
            this.repaint();
        }
    }

    public void setFontHorizontalAlignment(int n) {
        if (this._hAlignment != n) {
            this._hAlignment = n;
            this.repaint();
        }
    }

    public int getFontHorizontalAlignment() {
        return this._hAlignment;
    }

    public void setFontVerticalAlignment(int n) {
        if (this._vAlignment != n) {
            this._vAlignment = n;
            this.repaint();
        }
    }

    public int getFontVerticalAlignment() {
        return this._vAlignment;
    }

    public void setFontStyle(int n) {
        if (this._fontStyle != n) {
            this._fontStyle = n;
            boolean bl = (n & 1) != 0;
            boolean bl2 = (n & 2) != 0;
            Font font = this.getCurrentFont();
            if (font != null && (font.isBold() != bl || font.isItalic() != bl2)) {
                int n2 = 0;
                if (bl) {
                    n2 |= 1;
                }
                if (bl2) {
                    n2 |= 2;
                }
                font = new Font(font.getName(), n2, font.getSize());
                this.setCurrentFont(font);
            }
            this.repaint();
        }
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    public void setFontBaselineStyle(int n) {
        if (this._fontBaselineStyle != n) {
            this._fontBaselineStyle = n;
            this.repaint();
        }
    }

    public int getFontBaselineStyle() {
        return this._fontBaselineStyle;
    }

    public boolean isBaselineVisible() {
        return this._baselineVisible;
    }

    public void setBaselineVisible(boolean bl) {
        if (this._baselineVisible != bl) {
            this._baselineVisible = bl;
            this.repaint();
        }
    }

    public void setPreviewText(String string) {
        if (this._exampleText != string) {
            this._exampleText = string;
            this.repaint();
        }
    }

    public String getPreviewText() {
        if (this._exampleText == null) {
            Locale locale = LocaleUtils.getDefaultableLocale(this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
            this._exampleText = resourceBundle.getString(_KEY_EXAMPLE_TEXT);
        }
        return this._exampleText;
    }

    @Override
    public void paintInterior(Graphics graphics) {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4 = this.getInnerWidth();
        int n5 = this.getInnerHeight();
        PaintContext paintContext = this.getPaintContext();
        boolean bl2 = (paintContext.getPaintState() & 1) == 0;
        ImmInsets immInsets = this.getBorderInsets();
        if (bl2) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(paintContext.getPaintUIDefaults().getColor("lightIntensity"));
        }
        graphics.fillRect(immInsets.left, immInsets.top, n4, n5);
        immInsets = new ImmInsets(immInsets.top + 8, immInsets.left + 8, immInsets.bottom + 8, immInsets.right + 8);
        n4 -= immInsets.left + immInsets.right;
        n5 -= immInsets.top + immInsets.bottom;
        if (bl2) {
            graphics.setColor(this.getFontBackgroundColor());
        } else {
            graphics.setColor(paintContext.getPaintUIDefaults().getColor("lightIntensity"));
        }
        graphics.fillRect(immInsets.left, immInsets.top, n4, n5);
        if (this.isFontBorderVisible()) {
            graphics.setColor(this.getFontBorderColor());
            graphics.drawRect(immInsets.left, immInsets.top, n4 - 1, n5 - 1);
            graphics.drawRect(immInsets.left + 1, immInsets.top + 1, n4 - 3, n5 - 3);
        }
        graphics.setFont(this.getCurrentFont());
        String string = this.getPreviewText();
        FontMetrics fontMetrics = this.getFontMetrics(graphics.getFont());
        int n6 = fontMetrics.stringWidth(string);
        int n7 = this.getFontHorizontalAlignment();
        int n8 = 0;
        Locale locale = LocaleUtils.getDefaultableLocale(this);
        boolean bl3 = bl = locale != LocaleUtils.ARABIC;
        if (n7 == 3) {
            n7 = bl ? 0 : 2;
        } else if (n7 == 4) {
            n7 = bl ? 2 : 0;
        }
        switch (n7) {
            case 1: {
                n8 = (this.getInnerWidth() - n6) / 2;
                break;
            }
            case 2: {
                n8 = this.getInnerWidth() - (immInsets.right + 4) - n6;
                break;
            }
            default: {
                n8 = immInsets.left + 4;
            }
        }
        int n9 = 0;
        int n10 = this.getFontVerticalAlignment();
        switch (n10) {
            case 5: {
                n9 = immInsets.top + fontMetrics.getAscent() + 4;
                break;
            }
            case 7: {
                n9 = this.getInnerHeight() - (immInsets.top + immInsets.bottom + fontMetrics.getDescent() + 4);
                break;
            }
            default: {
                n9 = immInsets.top + (n5 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
            }
        }
        if (this.isBaselineVisible()) {
            graphics.setColor(Color.gray);
            n3 = immInsets.left + 1;
            n2 = this.getInnerWidth() - immInsets.right - 3;
            graphics.drawLine(n3, n9 - 3, n3, n9 + 3);
            graphics.drawLine(++n3, n9 - 2, n3, n9 + 2);
            graphics.drawLine(++n3, n9 - 1, n3, n9 + 1);
            graphics.drawLine(n2, n9 - 3, n2, n9 + 3);
            graphics.drawLine(--n2, n9 - 2, n2, n9 + 2);
            graphics.drawLine(--n2, n9 - 1, n2, n9 + 1);
            for (n = n3; n < n2; n += 3) {
                graphics.drawLine(n, n9, n + 1, n9);
            }
        }
        n3 = this.getFontBaselineStyle();
        switch (n3) {
            case 2: {
                n9 -= 3;
                break;
            }
            case 3: {
                n9 += 3;
            }
        }
        graphics.setColor(this.getFontColor());
        graphics.clipRect(immInsets.left, immInsets.top, n4, n5);
        GraphicUtils.drawString(graphics, string, n8, n9);
        n2 = graphics.getFont().getSize();
        n = n2 / 10 + 1;
        int n11 = this.getFontStyle();
        if ((n11 & 4) != 0) {
            graphics.fillRect(n8, n9 + 2, n6, n);
        }
        if ((n11 & 8) != 0) {
            int n12 = n9 - fontMetrics.getAscent() / 2;
            graphics.fillRect(n8, n12, n6, n);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }
}

