/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.util.InputEventUtils;

public class ChoiceInputHandler
extends CellInputHandler {
    private static LWChoice _choice;
    static boolean _dirty;
    private String[] _items;

    public void setItems(String[] stringArray) {
        if (this._items != null) {
            for (int i = 0; i < this._items.length; ++i) {
                this._items[i] = null;
            }
        }
        this._items = null;
        if (stringArray != null) {
            this._items = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this._items, 0, stringArray.length);
        }
    }

    public String[] getItems() {
        if (this._items == null) {
            return null;
        }
        String[] stringArray = new String[this._items.length];
        System.arraycopy(this._items, 0, stringArray, 0, this._items.length);
        return stringArray;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        Cell cell = grid.getFocusCell();
        if (cell.column == n && cell.row == n2 && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
        super.mousePressed(mouseEvent, grid, n, n2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        keyEvent.consume();
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(n, n2);
    }

    @Override
    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    @Override
    public boolean isDirty(Grid grid, int n, int n2) {
        return _dirty;
    }

    @Override
    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (_choice == null) {
            _choice = new LWChoice(){

                @Override
                protected void processKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getID() == 401 && this.isDropDownVisible() && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27)) {
                        this.hideDropDown(keyEvent.getKeyCode() == 10);
                        keyEvent.consume();
                    }
                    super.processKeyEvent(keyEvent);
                }
            };
            _choice.addItemListener(new Dirty());
        }
        return _choice;
    }

    @Override
    public void startEdit(Grid grid, int n, int n2, Object object) {
        LWChoice lWChoice = (LWChoice)this.getEditControl(grid, n, n2);
        lWChoice.removeAll();
        String string = (String)object;
        if (this._items != null) {
            for (int i = 0; i < this._items.length; ++i) {
                lWChoice.add(this._items[i]);
            }
        } else if (string != null) {
            lWChoice.add(string);
        }
        if (string != null) {
            lWChoice.select(string);
            _dirty = false;
        } else {
            _dirty = true;
        }
    }

    @Override
    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        LWChoice lWChoice = (LWChoice)this.getEditControl(grid, n, n2);
        String string = lWChoice.getSelectedItem();
        return string;
    }

    private static class Dirty
    implements ItemListener {
        private Dirty() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            _dirty = true;
        }
    }
}

