/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import oracle.ewt.EwtComponent;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.NullTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.GraphicsProxy;
import oracle.ewt.graphics.separator.Separator;
import oracle.ewt.grid.AccessibleGrid;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.CellPainter;
import oracle.ewt.grid.GeometryManager;
import oracle.ewt.grid.GridAutoScroller;
import oracle.ewt.grid.GridCellSelectListener;
import oracle.ewt.grid.GridColSelectListener;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridFocusListener;
import oracle.ewt.grid.GridKeyAdapter;
import oracle.ewt.grid.GridKeyNavigator;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridScrollListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.GridValidateEvent;
import oracle.ewt.grid.NullGridSelection;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.SingleAppearanceManager;
import oracle.ewt.grid.SingleSelection;
import oracle.ewt.grid.StandardNavigator;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.GridUI;
import oracle.ewt.popup.ToolTipManager;
import oracle.ewt.print.PrintGraphicsProxy;
import oracle.ewt.print.PrinterUtils;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.util.EventQueueUtils;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;

public class Grid
extends EwtComponent {
    public static final int ANCHOR_NONE = -1;
    public static final String CELL_KEY = "Cell";
    public static final String APPEARANCE_KEY = "Appearance";
    public static final String DATASOURCE_KEY = "DataSource";
    public static final String GRID_KEY = "Grid";
    public static final String CLIP_RECT_KEY = "grid.clipRect";
    public static final Object DISPLAY_HORIZONTAL_SEPARATOR = "grid.dispHSep";
    public static final Object DISPLAY_VERTICAL_SEPARATOR = "grid.dispVSep";
    private static final int _FOCUS_INDEX_NONE = -1;
    private ListenerManager _cellSelectListeners;
    private ListenerManager _colSelectListeners;
    private ListenerManager _rowSelectListeners;
    private ListenerManager _focusListeners;
    private ListenerManager _editListeners;
    private ListenerManager _scrollListeners;
    private GridKeyNavigator _keyNavigator;
    private AppearanceManager _appearanceManager;
    private GridSelection _gridSelection;
    private GeometryManager _columnGM;
    private GeometryManager _rowGM;
    private TwoDDataSource _dataSource;
    private DSListen _dsListener;
    private CellPainter _defaultCellPainter;
    private Painter _defaultPainter;
    private CellInputHandler _defaultInputHandler;
    private boolean _horizontalSeparatorsVisible;
    private boolean _verticalSeparatorsVisible;
    private Separator _horizontalSeparator;
    private Separator _verticalSeparator;
    private Painter _horizontalPainter;
    private Painter _verticalPainter;
    private int _vpWidth;
    int _focusColumn = -1;
    int _focusRow = -1;
    private transient Component _editControl;
    private boolean _drawFocusCellHighlite;
    private boolean _overlayVisible;
    private int _preferredRows;
    private int _preferredColumns;
    private ArrayOneDDataSource _cellPainters;
    private ArrayOneDDataSource _painters;
    private ArrayOneDDataSource _cellInputHandlers;
    private GridKeyAdapter _keyAdapter;
    private FocusAdapter _focusListener;
    private transient Cell _mouseGrabCell;
    private Cell _moveCell;
    private Cell _anchorCell;
    private boolean _scrollByColumn;
    private boolean _scrollByRow;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private Cell _mouseCell;
    private transient boolean _removing;
    private boolean _isUpperLeft;
    private boolean _isUpperRight;
    private boolean _isLowerLeft;
    private boolean _isLowerRight;
    private transient int _lastColumn;
    private transient int _lastRow;
    private int _firstColumn = -1;
    private int _firstRow = -1;
    private transient Object _scrollLock = new Object();
    transient Object __paintLock = new Object();
    private AccessibleGrid _accessibleGrid;
    private boolean _accessibleGridCreated;
    private boolean _autoScrollingEnabled;
    private boolean _canRequestFocus = true;
    private Component[] _editControlChildren;

    public Grid() {
        this(null);
    }

    public Grid(TwoDDataSource twoDDataSource) {
        this(twoDDataSource, (Painter)null, NullInputHandler.getCellInputHandler());
    }

    public Grid(TwoDDataSource twoDDataSource, CellPainter cellPainter, CellInputHandler cellInputHandler) {
        this(twoDDataSource, (Painter)null, cellInputHandler);
        this.setDefaultCellPainter(cellPainter);
    }

    public Grid(TwoDDataSource twoDDataSource, Painter painter, CellInputHandler cellInputHandler) {
        if (twoDDataSource == null) {
            twoDDataSource = NullTwoDDataSource.getTwoDDataSource();
        }
        super.setLayout(null);
        this._dataSource = twoDDataSource;
        this._defaultPainter = painter;
        this._defaultInputHandler = cellInputHandler;
        this._dsListener = new DSListen();
        this._dataSource.addDataSourceListener(this._dsListener);
        this._scrollByColumn = true;
        this._scrollByRow = true;
        this._drawFocusCellHighlite = true;
        this.setAutoScrollingEnabled(true);
        this.setHorizontalSeparatorsVisible(true);
        this.setVerticalSeparatorsVisible(true);
        this._columnGM = new GeometryManager(this._dataSource.getColumnCount());
        this._columnGM.setReadingDirection(this.getActualReadingDirection());
        this._rowGM = new GeometryManager(this._dataSource.getRowCount());
        long l = 62L;
        this.enableEvents(l);
        this.updateUI(Grid.class);
        FocusUtils.setFocusTraversalKeysEnabled(this, false);
    }

    @Override
    public Object getUIClassID() {
        return "GridUI";
    }

    public int getColumnCount() {
        return this._dataSource.getColumnCount();
    }

    public int getVisibleColumnCount() {
        return this._columnGM.getVisibleItemCount();
    }

    public int getRowCount() {
        return this._dataSource.getRowCount();
    }

    public int getVisibleRowCount() {
        return this._rowGM.getVisibleItemCount();
    }

    public TwoDDataSource getDataSource() {
        return this._dataSource;
    }

    @Override
    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        Painter painter;
        boolean bl;
        int n;
        int n2;
        Painter painter2;
        GraphicsProxy graphicsProxy = graphics instanceof PrintGraphics ? new PrintGraphicsProxy(graphics, (PrintGraphics)((Object)graphics)) : new GraphicsProxy(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        graphicsProxy.put(CLIP_RECT_KEY, rectangle);
        this._paintGrid(this.getPrintPaintContext(graphics), graphicsProxy);
        boolean bl2 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_HORIZONTAL_SEPARATOR, true);
        if (bl2 && (painter2 = this.getHorizontalSeparatorPainter()) != null) {
            int n3 = rectangle.width;
            n2 = this.getCanvasWidth();
            if (rectangle.x + n3 > n2) {
                n3 = n2 - rectangle.x;
            }
            n = painter2.getPreferredSize((PaintContext)paintContext).height;
            painter2.paint(paintContext, graphics, rectangle.x, rectangle.y, n3, n);
        }
        if ((bl = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_VERTICAL_SEPARATOR, true)) && (painter = this.getVerticalSeparatorPainter()) != null) {
            n2 = rectangle.height;
            n = this.getCanvasHeight();
            if (rectangle.y + n2 > n) {
                n2 = n - rectangle.y;
            }
            int n4 = painter.getPreferredSize((PaintContext)paintContext).width;
            painter.paint(paintContext, graphics, rectangle.x, rectangle.y, n4, n2);
        }
        graphics.setClip(rectangle);
    }

    public void setDataSource(TwoDDataSource twoDDataSource) {
        TwoDDataSource twoDDataSource2 = this.getDataSource();
        if (twoDDataSource == null) {
            twoDDataSource = NullTwoDDataSource.getTwoDDataSource();
        }
        if (twoDDataSource != twoDDataSource2) {
            twoDDataSource2.removeDataSourceListener(this._dsListener);
            twoDDataSource.addDataSourceListener(this._dsListener);
            this._dataSource = twoDDataSource;
            int n = this.getDefaultColumnWidth();
            this._columnGM = new GeometryManager(this._dataSource.getColumnCount());
            this._columnGM.setReadingDirection(this.getActualReadingDirection());
            this._columnGM.setDefaultItemSize(n);
            n = this.getDefaultRowHeight();
            this._rowGM = new GeometryManager(this._dataSource.getRowCount());
            this._rowGM.setDefaultItemSize(n);
            this._cellInputHandlers = null;
            this._cellPainters = null;
            this._painters = null;
            if (this._appearanceManager != null) {
                this._appearanceManager.setParent(null);
                this._appearanceManager.setParent(this);
            }
            if (this._gridSelection != null) {
                this._gridSelection.setParent(null);
                this._gridSelection.setParent(this);
            }
            this._mouseGrabCell = null;
            this._moveCell = null;
            this.setAnchorCell(null);
            this.__setFocusCell(-1, -1);
            this._firstColumn = Math.min(this._firstColumn, twoDDataSource.getColumnCount() - 1);
            this._firstRow = Math.min(this._firstRow, twoDDataSource.getRowCount() - 1);
            this.invalidateCanvas();
        }
    }

    public final CellPainter getDefaultCellPainter() {
        return this._defaultCellPainter;
    }

    public final void setDefaultCellPainter(CellPainter cellPainter) {
        this._defaultCellPainter = cellPainter;
        this.setDefaultPainter(new PainterAdapter(cellPainter));
    }

    public void setDefaultPainter(Painter painter) {
        this._defaultPainter = painter;
    }

    public Painter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = ((GridUI)this.getUI()).getDefaultPainter(this);
        }
        return this._defaultPainter;
    }

    public CellInputHandler getDefaultInputHandler() {
        return this._defaultInputHandler;
    }

    public void setDefaultInputHandler(CellInputHandler cellInputHandler) {
        this._defaultInputHandler = cellInputHandler == null ? NullInputHandler.getCellInputHandler() : cellInputHandler;
    }

    public void setAppearanceManager(AppearanceManager appearanceManager) {
        if (this._appearanceManager != null) {
            this._appearanceManager.setParent(null);
        }
        this._appearanceManager = appearanceManager;
        if (this._appearanceManager != null) {
            this._appearanceManager.setParent(this);
        }
        this.repaintInterior();
    }

    public AppearanceManager getAppearanceManager() {
        if (this._appearanceManager == null) {
            this._appearanceManager = new SingleAppearanceManager();
            this._appearanceManager.setParent(this);
        }
        return this._appearanceManager;
    }

    public synchronized void addCellSelectListener(GridCellSelectListener gridCellSelectListener) {
        if (this._cellSelectListeners == null) {
            this._cellSelectListeners = new ListenerManager();
        }
        this._cellSelectListeners.addListener(gridCellSelectListener);
    }

    public synchronized void removeCellSelectListener(GridCellSelectListener gridCellSelectListener) {
        if (this._cellSelectListeners != null) {
            this._cellSelectListeners.removeListener(gridCellSelectListener);
        }
    }

    public synchronized void addColSelectListener(GridColSelectListener gridColSelectListener) {
        if (this._colSelectListeners == null) {
            this._colSelectListeners = new ListenerManager();
        }
        this._colSelectListeners.addListener(gridColSelectListener);
    }

    public synchronized void removeColSelectListener(GridColSelectListener gridColSelectListener) {
        if (this._colSelectListeners != null) {
            this._colSelectListeners.removeListener(gridColSelectListener);
        }
    }

    public synchronized void addRowSelectListener(GridRowSelectListener gridRowSelectListener) {
        if (this._rowSelectListeners == null) {
            this._rowSelectListeners = new ListenerManager();
        }
        this._rowSelectListeners.addListener(gridRowSelectListener);
    }

    public synchronized void removeRowSelectListener(GridRowSelectListener gridRowSelectListener) {
        if (this._rowSelectListeners != null) {
            this._rowSelectListeners.removeListener(gridRowSelectListener);
        }
    }

    public synchronized void addFocusListener(GridFocusListener gridFocusListener) {
        if (this._focusListeners == null) {
            this._focusListeners = new ListenerManager();
        }
        this._focusListeners.addListener(gridFocusListener);
    }

    public synchronized void removeFocusListener(GridFocusListener gridFocusListener) {
        if (this._focusListeners != null) {
            this._focusListeners.removeListener(gridFocusListener);
        }
    }

    public synchronized void addEditListener(GridEditListener gridEditListener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener(gridEditListener);
    }

    public synchronized void removeEditListener(GridEditListener gridEditListener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener(gridEditListener);
        }
    }

    public synchronized void addScrollListener(GridScrollListener gridScrollListener) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new ListenerManager();
        }
        this._scrollListeners.addListener(gridScrollListener);
    }

    public synchronized void removeScrollListener(GridScrollListener gridScrollListener) {
        if (this._scrollListeners != null) {
            this._scrollListeners.removeListener(gridScrollListener);
        }
    }

    public boolean isEditing() {
        return this._editControl != null;
    }

    public void cancelCellEdit() {
        this._doneEditing(false);
    }

    public void commitCellEdit() {
        this._doneEditing(true);
    }

    public void setGridSelection(GridSelection gridSelection) {
        if (this._gridSelection != null) {
            this._gridSelection.setParent(null);
        }
        if (gridSelection == null) {
            gridSelection = NullGridSelection.getGridSelection();
        }
        this._gridSelection = gridSelection;
        this._gridSelection.setParent(this);
        this.repaintInterior();
    }

    public GridSelection getGridSelection() {
        if (this._gridSelection == null) {
            this._gridSelection = new SingleSelection();
            this._gridSelection.setParent(this);
        }
        return this._gridSelection;
    }

    public int getPreviousVisibleColumn(int n) {
        int n2 = n < this.getColumnCount() ? this._columnGM.convertDSIndexToVIndex(n) : n;
        int n3 = n2 - 1;
        if (n3 < 0) {
            return -1;
        }
        while (n3 >= 0) {
            int n4 = this._columnGM.convertVIndexToDSIndex(n3);
            if (this._columnGM.isItemVisible(n4)) {
                return n4;
            }
            --n3;
        }
        return -1;
    }

    public int getPreviousVisibleRow(int n) {
        int n2 = n < this.getRowCount() ? this._rowGM.convertDSIndexToVIndex(n) : n;
        for (int i = n2 - 1; i >= 0; --i) {
            int n3 = this._rowGM.convertVIndexToDSIndex(i);
            if (!this._rowGM.isItemVisible(n3)) continue;
            return n3;
        }
        return -1;
    }

    public int getNextVisibleColumn(int n) {
        int n2 = n >= 0 ? this._columnGM.convertDSIndexToVIndex(n) : n;
        int n3 = this.getColumnCount();
        for (int i = n2 + 1; i < n3; ++i) {
            int n4 = this._columnGM.convertVIndexToDSIndex(i);
            if (!this._columnGM.isItemVisible(n4)) continue;
            return n4;
        }
        return -1;
    }

    public int getNextVisibleRow(int n) {
        int n2 = n >= 0 ? this._rowGM.convertDSIndexToVIndex(n) : n;
        int n3 = this.getRowCount();
        for (int i = n2 + 1; i < n3; ++i) {
            int n4 = this._rowGM.convertVIndexToDSIndex(i);
            if (!this._rowGM.isItemVisible(n4)) continue;
            return n4;
        }
        return -1;
    }

    public void setHorizontalSeparatorsVisible(boolean bl) {
        if (this._horizontalSeparatorsVisible != bl) {
            this._horizontalSeparatorsVisible = bl;
            this.invalidateCanvas();
        }
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._horizontalSeparatorsVisible;
    }

    public final void setHorizontalSeparator(Separator separator) {
        this._horizontalSeparator = separator;
        if (separator == null) {
            this.setHorizontalSeparatorPainter(null);
        } else {
            this.setHorizontalSeparatorPainter(new SeparatorAdapt(separator, true));
        }
    }

    public final Separator getHorizontalSeparator() {
        return this._horizontalSeparator;
    }

    public void setHorizontalSeparatorPainter(Painter painter) {
        if (this._horizontalPainter != painter) {
            this._horizontalPainter = painter;
            this.invalidateCanvas();
        }
    }

    public Painter getHorizontalSeparatorPainter() {
        if (this._horizontalPainter == null) {
            return NullPainter.getPainter();
        }
        return this._horizontalPainter;
    }

    public void setVerticalSeparatorsVisible(boolean bl) {
        if (this._verticalSeparatorsVisible != bl) {
            this._verticalSeparatorsVisible = bl;
            this.invalidateCanvas();
        }
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._verticalSeparatorsVisible;
    }

    public final void setVerticalSeparator(Separator separator) {
        this._verticalSeparator = separator;
        if (separator == null) {
            this.setVerticalSeparatorPainter(null);
        } else {
            this.setVerticalSeparatorPainter(new SeparatorAdapt(separator, false));
        }
    }

    public final Separator getVerticalSeparator() {
        return this._verticalSeparator;
    }

    public void setVerticalSeparatorPainter(Painter painter) {
        if (this._verticalPainter != painter) {
            this._verticalPainter = painter;
            int n = this._vpWidth;
            this._vpWidth = painter == null ? 0 : painter.getPreferredSize((PaintContext)this.getPaintContext()).width;
            if (this.getVerticalSeparatorsVisible()) {
                this.invalidateCanvas();
            }
        }
    }

    public Painter getVerticalSeparatorPainter() {
        if (this._verticalPainter == null) {
            return NullPainter.getPainter();
        }
        return this._verticalPainter;
    }

    public Cell getFocusCell() {
        if (this._focusColumn == -1) {
            return null;
        }
        return new Cell(this._focusColumn, this._focusRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestFocus(int n, int n2, AWTEvent aWTEvent) {
        if (this._focusColumn == n && this._focusRow == n2) {
            return true;
        }
        if (this.fireCancelableCellEvent(n, n2, 2017)) {
            return false;
        }
        this.freezeRepaints();
        try {
            Grid grid = this;
            synchronized (grid) {
                CellInputHandler cellInputHandler;
                int n3 = this._focusColumn;
                int n4 = this._focusRow;
                if (n3 != -1) {
                    cellInputHandler = this.getColumnCellInputHandler(n3);
                    if (!cellInputHandler.validateFocus(this, n3, n4)) {
                        // empty if block
                    }
                    this.commitCellEdit();
                    cellInputHandler.focusLost(aWTEvent, this, n3, n4);
                    this._focusColumn = -1;
                    this._focusRow = -1;
                    if (this.getDrawFocusCellHighlite()) {
                        this.paintCell(n3, n4);
                    }
                }
                this._focusColumn = n;
                this._focusRow = n2;
                this._fireActiveDescendantEvent(n3, n4, this._focusColumn, this._focusRow);
                cellInputHandler = this.getColumnCellInputHandler(this._focusColumn);
                cellInputHandler.focusGained(aWTEvent, this, n, n2);
                this.fireCellEvent(n, n2, 2018);
                if (this.getDrawFocusCellHighlite()) {
                    this.paintCell(n, n2);
                }
            }
        }
        finally {
            this.unfreezeRepaints();
        }
        return true;
    }

    public void setDrawFocusCellHighlite(boolean bl) {
        if (this.getDrawFocusCellHighlite() != bl) {
            this._drawFocusCellHighlite = bl;
            if (this._focusColumn != -1 && this._focusRow != -1) {
                this.paintCell(this._focusColumn, this._focusRow);
            }
        }
    }

    public boolean getDrawFocusCellHighlite() {
        return this._drawFocusCellHighlite;
    }

    public final void setAnchorCell(Cell cell) {
        if (cell == null) {
            this.setAnchorCell(-1, -1);
        } else {
            this.setAnchorCell(cell.column, cell.row);
        }
    }

    public void setAnchorCell(int n, int n2) {
        this._anchorCell = n == -1 || n2 == -1 ? null : new Cell(n, n2);
    }

    public Cell getAnchorCell() {
        return this._anchorCell;
    }

    public void setDefaultColumnWidth(int n) {
        this._columnGM.setDefaultItemSize(n);
        this.invalidateCanvas();
    }

    public int getDefaultColumnWidth() {
        int n = this._columnGM.getDefaultItemSize();
        if (n == 0) {
            GridUI gridUI = (GridUI)this.getUI();
            n = gridUI.getDefaultColumnWidth(this);
            this._columnGM.setDefaultItemSize(n);
            this.invalidateCanvas();
        }
        return n;
    }

    public void setDefaultRowHeight(int n) {
        this._rowGM.setDefaultItemSize(n);
        this.invalidateCanvas();
    }

    public int getDefaultRowHeight() {
        int n = this._rowGM.getDefaultItemSize();
        if (n == 0) {
            GridUI gridUI = (GridUI)this.getUI();
            n = gridUI.getDefaultRowHeight(this);
            this._rowGM.setDefaultItemSize(n);
            this.invalidateCanvas();
        }
        return n;
    }

    public int getOnScreenRowCount() {
        int n = this.getFirstRowOnScreen();
        int n2 = this.getRowCount();
        if (n2 == 0 || n == -1) {
            return 0;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        int n3 = 0;
        int n4 = -point.y + dimension2.height;
        if (n4 > dimension.height) {
            n4 = dimension.height;
        }
        for (int i = this._rowGM.convertDSIndexToVIndex(n); i < n2; ++i) {
            int n5 = this._rowGM.convertVIndexToDSIndex(i);
            if (!this._rowGM.isItemVisible(n5)) continue;
            int n6 = this._rowGM.getItemPosition(n5);
            if (n6 > n4) break;
            ++n3;
        }
        return n3;
    }

    public int getOnScreenColumnCount() {
        int n = this.getFirstColumnOnScreen();
        int n2 = this.getColumnCount();
        if (n2 == 0 || n == -1) {
            return 0;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        int n3 = 0;
        int n4 = -point.x + dimension2.width;
        if (n4 > dimension.width) {
            n4 = dimension.width;
        }
        for (int i = this._columnGM.convertDSIndexToVIndex(n); i < n2; ++i) {
            int n5 = this._columnGM.convertVIndexToDSIndex(i);
            if (!this._columnGM.isItemVisible(n5)) continue;
            int n6 = this._columnGM.getItemPosition(n5);
            if (n6 > n4) break;
            ++n3;
        }
        return n3;
    }

    public int getFirstRowOnScreen() {
        if (this._firstRow != -1) {
            return this._firstRow;
        }
        Point point = this.getCanvasOrigin();
        return this._rowGM.getItemAt(-point.y);
    }

    public void setFirstRowOnScreen(int n) {
        if (n < 0 || n >= this.getRowCount() || !this._rowGM.isItemVisible(n)) {
            throw new IllegalArgumentException();
        }
        if (this.getCanvasHeight() == 0) {
            this._firstRow = n;
        } else {
            int n2;
            this._firstRow = -1;
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if (!this.isRowVisible(n2)) continue;
                ++n3;
            }
            n2 = this.getVOffsetOfValue(n3);
            if (n2 != this.getCanvasOriginY()) {
                this.commitCellEdit();
                this.setCanvasOrigin(this.getCanvasOriginX(), n2);
            }
        }
    }

    public int getFirstColumnOnScreen() {
        if (this._firstColumn != -1) {
            return this._firstColumn;
        }
        Point point = this.getCanvasOrigin();
        return this._columnGM.getItemAt(-point.x);
    }

    public void setFirstColumnOnScreen(int n) {
        if (n < 0 || n >= this.getColumnCount() || !this._columnGM.isItemVisible(n)) {
            throw new IllegalArgumentException();
        }
        if (this.getCanvasWidth() == 0) {
            this._firstColumn = n;
        } else {
            int n2;
            this._firstColumn = -1;
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if (!this.isColumnVisible(n2)) continue;
                ++n3;
            }
            n2 = this.getHOffsetOfValue(n3);
            if (n2 != this.getCanvasOriginX()) {
                this.commitCellEdit();
                this.setCanvasOrigin(n2, this.getCanvasOriginY());
            }
        }
    }

    public void setPreferredRowsOnScreen(int n) {
        this._preferredRows = n;
    }

    public int getPreferredRowsOnScreen() {
        return this._preferredRows;
    }

    public void setPreferredColumnsOnScreen(int n) {
        this._preferredColumns = n;
    }

    public int getPreferredColumnsOnScreen() {
        return this._preferredColumns;
    }

    public void setGridKeyNavigator(GridKeyNavigator gridKeyNavigator) {
        this._keyNavigator = gridKeyNavigator;
    }

    public GridKeyNavigator getGridKeyNavigator() {
        if (this._keyNavigator == null) {
            this._keyNavigator = StandardNavigator.getGridKeyNavigator();
        }
        return this._keyNavigator;
    }

    @Override
    public void handleVScroll(int n, int n2) {
        this.commitCellEdit();
        super.handleVScroll(n, n2);
    }

    @Override
    public void handleHScroll(int n, int n2) {
        this.commitCellEdit();
        super.handleHScroll(n, n2);
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    public void setScrollByColumn(boolean bl) {
        if (bl != this.getScrollByColumn()) {
            this._scrollByColumn = bl;
            Dimension dimension = this.getCanvasSize();
            this.setCanvasSize(dimension.width, dimension.height);
        }
    }

    public boolean getScrollByColumn() {
        return this._scrollByColumn;
    }

    public void setScrollByRow(boolean bl) {
        if (bl != this.getScrollByRow()) {
            this._scrollByRow = bl;
            Dimension dimension = this.getCanvasSize();
            this.setCanvasSize(dimension.width, dimension.height);
        }
    }

    public boolean getScrollByRow() {
        return this._scrollByRow;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        super.setLayout(null);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.commitCellEdit();
        }
    }

    @Override
    public int getRepaintFlags() {
        return super.getRepaintFlags() | 1 | 4 | 0x20 | 0x80 | 0x100 | 0x200 | 0x400;
    }

    @Override
    public int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x4000;
    }

    public synchronized void setColumnVisibleIndex(int n, int n2) {
        if (this.getColumnVisibleIndex(n) != n2) {
            int n3 = this._columnGM.getItemPosition(n);
            boolean bl = this.isColumnOnScreen(n);
            this._columnGM.setItemVisibleIndex(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            boolean bl2 = this.isColumnOnScreen(n);
            if (bl2 || bl) {
                if (!bl2 || !bl) {
                    this.repaintInterior();
                } else {
                    dimension = this.getInnerSize();
                    int n4 = this._columnGM.getItemPosition(n);
                    if (n3 < n4) {
                        n4 = n3;
                    }
                    Point point = this.getCanvasOrigin();
                    this.repaintCanvas(n4 - 1, -point.y, dimension.width, dimension.height);
                }
            }
        }
    }

    public int getColumnVisibleIndex(int n) {
        return this._columnGM.convertDSIndexToVIndex(n);
    }

    public synchronized void setRowVisibleIndex(int n, int n2) {
        if (this.getRowVisibleIndex(n) != n2) {
            int n3 = this._rowGM.getItemPosition(n);
            boolean bl = this.isRowOnScreen(n);
            this._rowGM.setItemVisibleIndex(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            boolean bl2 = this.isRowOnScreen(n);
            if (bl2 || bl) {
                if (!bl2 || !bl) {
                    this.repaintInterior();
                } else {
                    dimension = this.getInnerSize();
                    int n4 = this._rowGM.getItemPosition(n);
                    if (n3 < n4) {
                        n4 = n3;
                    }
                    Point point = this.getCanvasOrigin();
                    this.repaintCanvas(-point.x, n4 - 1, dimension.width, dimension.height);
                }
            }
        }
    }

    public int getRowVisibleIndex(int n) {
        return this._rowGM.convertDSIndexToVIndex(n);
    }

    public void setColumnVisible(int n, boolean bl) {
        if (this.isColumnVisible(n) != bl) {
            this._columnGM.setItemVisible(n, bl);
            this.invalidateCanvas();
            if (!bl) {
                Cell[] cellArray;
                GridSelection gridSelection;
                if (this._firstColumn == n) {
                    this._firstColumn = this.getNextVisibleColumn(this._firstColumn);
                }
                if ((gridSelection = this.getGridSelection()).isColumnSelected(n)) {
                    gridSelection.setColumnSelected(n, false);
                }
                if ((cellArray = gridSelection.getSelectedCells()) != null) {
                    for (int i = 0; i < cellArray.length; ++i) {
                        if (cellArray[i].column != n) continue;
                        gridSelection.setCellSelected(n, cellArray[i].row, false);
                    }
                }
                if (n == this._focusColumn) {
                    this.__setFocusCell(-1, -1);
                }
            }
        }
    }

    public boolean isColumnVisible(int n) {
        return this._columnGM.isItemVisible(n);
    }

    public void setRowVisible(int n, boolean bl) {
        if (this.isRowVisible(n) != bl) {
            this._rowGM.setItemVisible(n, bl);
            this.invalidateCanvas();
            if (!bl) {
                Cell[] cellArray;
                GridSelection gridSelection;
                if (this._firstRow == n) {
                    this._firstRow = this.getNextVisibleRow(this._firstRow);
                }
                if ((gridSelection = this.getGridSelection()).isRowSelected(n)) {
                    gridSelection.setRowSelected(n, false);
                }
                if ((cellArray = gridSelection.getSelectedCells()) != null) {
                    for (int i = 0; i < cellArray.length; ++i) {
                        if (cellArray[i].row != n) continue;
                        gridSelection.setCellSelected(cellArray[i].column, n, false);
                    }
                }
                if (n == this._focusRow) {
                    this.__setFocusCell(-1, -1);
                }
            }
        }
    }

    public boolean isRowVisible(int n) {
        return this._rowGM.isItemVisible(n);
    }

    public void setColumnWidth(int n, int n2) {
        if (this.getColumnWidth(n) != n2) {
            GeometryManager geometryManager = this._columnGM;
            geometryManager.setItemSize(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            if (this.isColumnOnScreen(n)) {
                dimension = this.getInnerSize();
                Point point = this.getCanvasOrigin();
                int n3 = geometryManager.getItemPosition(n);
                if (n3 < -point.x) {
                    n3 = -point.x;
                }
                this.repaintCanvas(n3, -point.y, dimension.width, dimension.height);
            }
            if (this.isEditing() && (this.getActualReadingDirection() == 2 || geometryManager.convertDSIndexToVIndex(n) <= geometryManager.convertDSIndexToVIndex(this._focusColumn))) {
                this._moveEditControl();
            }
        }
    }

    public int getColumnWidth(int n) {
        return this._columnGM.getItemSize(n);
    }

    public void setRowHeight(int n, int n2) {
        if (this.getRowHeight(n) != n2) {
            GeometryManager geometryManager = this._rowGM;
            geometryManager.setItemSize(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            if (this.isRowOnScreen(n)) {
                dimension = this.getInnerSize();
                Point point = this.getCanvasOrigin();
                int n3 = geometryManager.getItemPosition(n);
                if (n3 < -point.y) {
                    n3 = -point.y;
                }
                this.repaintCanvas(-point.x, n3, dimension.width, dimension.height);
            }
            if (this.isEditing() && geometryManager.convertDSIndexToVIndex(n) <= geometryManager.convertDSIndexToVIndex(this._focusRow)) {
                this._moveEditControl();
            }
        }
    }

    public int getRowHeight(int n) {
        return this._rowGM.getItemSize(n);
    }

    public final void setColumnCellPainter(int n, CellPainter cellPainter) {
        if (this._cellPainters == null) {
            this._cellPainters = new ArrayOneDDataSource(this.getColumnCount());
        }
        this._cellPainters.setData(n, cellPainter);
        this.setColumnPainter(n, new AlignmentPainter(new PainterAdapter(cellPainter)));
    }

    public final CellPainter getColumnCellPainter(int n) {
        Object object;
        if (this._cellPainters != null && (object = this._cellPainters.getData(n)) != null) {
            return (CellPainter)object;
        }
        return this.getDefaultCellPainter();
    }

    public void setColumnPainter(int n, Painter painter) {
        if (this._painters == null) {
            this._painters = new ArrayOneDDataSource(this.getColumnCount());
        }
        this._painters.setData(n, painter);
        this.paintColumn(n);
    }

    public Painter getColumnPainter(int n) {
        Object object;
        if (this._painters != null && (object = this._painters.getData(n)) != null) {
            return (Painter)object;
        }
        return this.getDefaultPainter();
    }

    public void setColumnCellInputHandler(int n, CellInputHandler cellInputHandler) {
        if (this._cellInputHandlers == null) {
            this._cellInputHandlers = new ArrayOneDDataSource(this.getColumnCount());
        }
        this._cellInputHandlers.setData(n, cellInputHandler);
    }

    public CellInputHandler getColumnCellInputHandler(int n) {
        Object object;
        if (this._cellInputHandlers != null && (object = this._cellInputHandlers.getData(n)) != null) {
            return (CellInputHandler)object;
        }
        return this.getDefaultInputHandler();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getDefaultRowHeight();
        this.getDefaultColumnWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCellEdit(final int n, final int n2) {
        Grid grid = this;
        synchronized (grid) {
            int n3 = this._focusColumn;
            int n4 = this._focusRow;
            if (this.isEditing() && n3 == n && n4 == n2) {
                return;
            }
        }
        this.commitCellEdit();
        this.freezeRepaints();
        EventQueueUtils.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Grid.this._startCellEdit(n, n2);
                }
                finally {
                    Grid.this.unfreezeRepaints();
                }
            }
        });
    }

    public boolean isRowOnScreen(int n) {
        if (!this.isRowVisible(n)) {
            return false;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = this._rowGM.getItemPosition(n);
        int n3 = this._rowGM.getItemSize(n);
        point.y = -point.y;
        return n2 + n3 >= point.y && n2 <= point.y + dimension.height;
    }

    public boolean isColumnOnScreen(int n) {
        if (!this.isColumnVisible(n)) {
            return false;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = this._columnGM.getItemPosition(n);
        int n3 = this._columnGM.getItemSize(n);
        point.x = -point.x;
        return n2 + n3 >= point.x && n2 <= point.x + dimension.width;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        this.validate();
        int n = this.getPreferredColumnsOnScreen();
        int n2 = this.getPreferredRowsOnScreen();
        int n3 = this.getVisibleRowCount();
        int n4 = this.getVisibleColumnCount();
        int n5 = this._columnGM.getTotalItemSize();
        int n6 = this._rowGM.getTotalItemSize();
        int n7 = n5 == 0 ? n * this.getDefaultColumnWidth() : (n != 0 && n4 != 0 ? n * n5 / n4 : n5);
        int n8 = n6 == 0 ? n2 * this.getDefaultRowHeight() : (n2 != 0 && n3 != 0 ? n2 * n6 / n3 : n6);
        return this.convertInnerToOuterSize(n7, n8);
    }

    @Override
    public Dimension getMinimumSize() {
        int n = this.getDefaultColumnWidth();
        int n2 = this.getDefaultRowHeight();
        return this.convertInnerToOuterSize(n, n2);
    }

    public int getColumnPosition(int n) {
        return this._columnGM.getItemPosition(n);
    }

    public int getRowPosition(int n) {
        return this._rowGM.getItemPosition(n);
    }

    public int getColumnAt(int n) {
        return this._columnGM.getItemAt(n);
    }

    public int getRowAt(int n) {
        return this._rowGM.getItemAt(n);
    }

    public void setUpperLeft(boolean bl) {
        if (this._isUpperLeft != bl) {
            this._isUpperLeft = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isUpperLeft() {
        return this._isUpperLeft;
    }

    public void setUpperRight(boolean bl) {
        if (this._isUpperRight != bl) {
            this._isUpperRight = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isUpperRight() {
        return this._isUpperRight;
    }

    public void setLowerLeft(boolean bl) {
        if (this._isLowerLeft != bl) {
            this._isLowerLeft = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isLowerLeft() {
        return this._isLowerLeft;
    }

    public void setLowerRight(boolean bl) {
        if (this._isLowerRight != bl) {
            this._isLowerRight = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isLowerRight() {
        return this._isLowerRight;
    }

    public boolean isOverlayBorderVisible() {
        return this._overlayVisible;
    }

    public void setOverlayBorderVisible(boolean bl) {
        if (this._overlayVisible != bl) {
            this._overlayVisible = bl;
            this.repaint();
        }
    }

    public PaintContext getCellPaintContext(int n, int n2) {
        return new CellPaintContext(this.getPaintContext(), n, n2);
    }

    public PaintContext getCellPrintPaintContext(Graphics graphics, int n, int n2) {
        return new CellPrintPaintContext(this.getPrintPaintContext(graphics), n, n2);
    }

    public final void fireColumnEvent(int n, int n2) {
        GridEvent gridEvent = new GridEvent(this, n2, n, -1);
        this.processEvent(gridEvent);
    }

    public final void fireRowEvent(int n, int n2) {
        GridEvent gridEvent = new GridEvent(this, n2, -1, n);
        this.processEvent(gridEvent);
    }

    public final void fireCellEvent(int n, int n2, int n3) {
        GridEvent gridEvent = new GridEvent(this, n3, n, n2);
        this.processEvent(gridEvent);
    }

    public final boolean fireCancelableColumnEvent(int n, int n2) {
        GridValidateEvent gridValidateEvent = new GridValidateEvent(this, n2, n, -1);
        this.processEvent(gridValidateEvent);
        return gridValidateEvent.isCancelled();
    }

    public final boolean fireCancelableRowEvent(int n, int n2) {
        GridValidateEvent gridValidateEvent = new GridValidateEvent(this, n2, -1, n);
        this.processEvent(gridValidateEvent);
        return gridValidateEvent.isCancelled();
    }

    public final boolean fireCancelableCellEvent(int n, int n2, int n3) {
        GridValidateEvent gridValidateEvent = new GridValidateEvent(this, n3, n, n2);
        this.processEvent(gridValidateEvent);
        return gridValidateEvent.isCancelled();
    }

    public void paintColumn(int n) {
        if (this.getVisibleRowCount() == 0 || !this.isColumnVisible(n) || !this.isColumnOnScreen(n)) {
            return;
        }
        this.validate();
        Rectangle rectangle = this._getColumnRect(n);
        this.paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintRow(int n) {
        if (this.getVisibleColumnCount() == 0 || !this.isRowVisible(n) || !this.isRowOnScreen(n)) {
            return;
        }
        this.validate();
        Rectangle rectangle = this._getRowRect(n);
        this.paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintCell(int n, int n2) {
        if (!this.isColumnVisible(n) || !this.isRowVisible(n2)) {
            return;
        }
        this.validate();
        int n3 = this._getColumnX(n) - 1;
        int n4 = this._rowGM.getItemPosition(n2) - 1;
        int n5 = this._columnGM.getItemSize(n) + 1;
        int n6 = this._rowGM.getItemSize(n2) + 1;
        this.paintImmediateCanvas(n3, n4, n5, n6);
    }

    public void setAutoScrollingEnabled(boolean bl) {
        this._autoScrollingEnabled = bl;
    }

    public boolean isAutoScrollingEnabled() {
        return this._autoScrollingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCanvasSize(int n, int n2) {
        if (this.getActualReadingDirection() == 2) {
            int n3 = this.getCanvasSize().width;
            this.freezeRepaints();
            try {
                int n4;
                super.setCanvasSize(n, n2);
                int n5 = this.getInnerSize().width;
                if (n5 == 0) return;
                int n6 = this.getCanvasSize().width;
                Point point = this.getCanvasOrigin();
                if (n3 <= 0) {
                    n4 = n5 - n6;
                } else {
                    n4 = point.x + n3 - n6;
                    if (n4 > 0) {
                        if (n6 > n5) {
                            n4 = 0;
                        } else if (n4 + n6 > n5) {
                            n4 = n5 - n6;
                        }
                    }
                }
                this.setCanvasOrigin(n4, point.y);
                return;
            }
            finally {
                this.unfreezeRepaints();
            }
        } else {
            super.setCanvasSize(n, n2);
        }
    }

    @Override
    public void setCanvasOrigin(int n, int n2) {
        int n3;
        int n4;
        if (this.getActualReadingDirection() == 2 && n + (n4 = this.getCanvasSize().width) < (n3 = this.getInnerSize().width)) {
            n = n3 - n4;
        }
        super.setCanvasOrigin(n, n2);
    }

    @Override
    protected void updateReadingDirection(int n) {
        super.updateReadingDirection(n);
        GeometryManager geometryManager = this._columnGM;
        if (geometryManager != null) {
            int n2 = this.getFirstRowOnScreen();
            int n3 = this.getFirstColumnOnScreen();
            geometryManager.setReadingDirection(n);
            if (n3 != -1 && n2 != -1) {
                this.scrollCellIntoView(n3, n2);
            }
        }
    }

    @Override
    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        this._vAdjustable = adjustable;
    }

    @Override
    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        this._hAdjustable = adjustable;
    }

    @Override
    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (adjustable == this.getHAdjustable()) {
            this._hAdjustable = null;
        } else if (adjustable == this.getVAdjustable()) {
            this._vAdjustable = null;
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    @Override
    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    @Override
    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    @Override
    public void removeNotify() {
        GridAutoScroller.getAutoScroller().cancel(this);
        super.removeNotify();
    }

    @Override
    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        GeometryManager geometryManager = this._columnGM;
        GeometryManager geometryManager2 = this._rowGM;
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = geometryManager.getItemAt(n);
        int n8 = geometryManager2.getItemAt(n2);
        int n9 = geometryManager.getItemAt(n5);
        int n10 = geometryManager2.getItemAt(n6);
        int n11 = 0;
        int n12 = 0;
        if (n9 != -1 && n7 != n9) {
            n3 = geometryManager.getItemPosition(n9) - n;
            n11 = geometryManager.getSeparatorSize();
        }
        if (n10 != -1 && n7 != n9) {
            n4 = geometryManager2.getItemPosition(n10) - n2;
            n12 = geometryManager2.getSeparatorSize();
        }
        Rectangle rectangle = new Rectangle(n3, n4, n3, n4);
        return rectangle;
    }

    public AccessibleGrid getAccessibleGrid() {
        return this._accessibleGrid;
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == Grid.class) {
            this.updateUI();
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getInnerSize().width;
        super.reshape(n, n2, n3, n4);
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
        this._checkForFirstColumnRow(dimension);
        if (this.getActualReadingDirection() == 2) {
            int n6 = dimension.width;
            int n7 = this.getInnerSize().width;
            if (n5 <= 0) {
                this.setCanvasOrigin(n7 - n6, this.getCanvasOrigin().y);
            } else if (n5 != n7) {
                this.commitCellEdit();
                Point point = this.getCanvasOrigin();
                int n8 = point.x + n7 - n5;
                if (n8 > 0) {
                    if (n6 > n7) {
                        n8 = 0;
                    } else if (n8 + n6 > n7) {
                        n8 = n7 - n6;
                    }
                }
                this.setCanvasOrigin(n8, point.y);
            }
        }
    }

    @Override
    protected void processContainerEvent(ContainerEvent containerEvent) {
        super.processContainerEvent(containerEvent);
        if (containerEvent.getID() == 301 && containerEvent.getChild() == this._editControl && !this._removing) {
            this.commitCellEdit();
        }
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof GridEvent) {
            switch (aWTEvent.getID()) {
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processCellSelectEvent((GridEvent)aWTEvent);
                    break;
                }
                case 2005: 
                case 2006: 
                case 2007: 
                case 2008: {
                    this.processRowSelectEvent((GridEvent)aWTEvent);
                    break;
                }
                case 2009: 
                case 2010: 
                case 2011: 
                case 2012: {
                    this.processColSelectEvent((GridEvent)aWTEvent);
                    break;
                }
                case 2017: 
                case 2018: {
                    this.processFocusCellEvent((GridEvent)aWTEvent);
                    break;
                }
                case 2021: 
                case 2022: 
                case 2023: 
                case 2024: {
                    this.processScrollEvent((GridEvent)aWTEvent);
                    break;
                }
                case 2019: 
                case 2020: {
                    this.processEditEvent((GridEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processColSelectEvent(GridEvent gridEvent) {
        int n = gridEvent.getID();
        if (this._colSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._colSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (n) {
            case 2009: {
                while (enumeration.hasMoreElements()) {
                    ((GridColSelectListener)enumeration.nextElement()).columnSelecting(gridEvent);
                }
                break;
            }
            case 2011: {
                while (enumeration.hasMoreElements()) {
                    ((GridColSelectListener)enumeration.nextElement()).columnDeselecting(gridEvent);
                }
                break;
            }
            case 2010: {
                while (enumeration.hasMoreElements()) {
                    ((GridColSelectListener)enumeration.nextElement()).columnSelected(gridEvent);
                }
                this._fireSelectionProperty();
                break;
            }
            case 2012: {
                while (enumeration.hasMoreElements()) {
                    ((GridColSelectListener)enumeration.nextElement()).columnDeselected(gridEvent);
                }
                this._fireSelectionProperty();
            }
        }
    }

    protected void processRowSelectEvent(GridEvent gridEvent) {
        int n = gridEvent.getID();
        if (this._rowSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._rowSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (n) {
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((GridRowSelectListener)enumeration.nextElement()).rowSelecting(gridEvent);
                }
                break;
            }
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((GridRowSelectListener)enumeration.nextElement()).rowDeselecting(gridEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((GridRowSelectListener)enumeration.nextElement()).rowSelected(gridEvent);
                }
                this._fireSelectionProperty();
                break;
            }
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((GridRowSelectListener)enumeration.nextElement()).rowDeselected(gridEvent);
                }
                this._fireSelectionProperty();
            }
        }
    }

    protected void processCellSelectEvent(GridEvent gridEvent) {
        int n = gridEvent.getID();
        if (this._cellSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._cellSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (n) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((GridCellSelectListener)enumeration.nextElement()).cellSelecting(gridEvent);
                }
                break;
            }
            case 2003: {
                while (enumeration.hasMoreElements()) {
                    ((GridCellSelectListener)enumeration.nextElement()).cellDeselecting(gridEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((GridCellSelectListener)enumeration.nextElement()).cellSelected(gridEvent);
                }
                this._fireSelectionProperty();
                break;
            }
            case 2004: {
                while (enumeration.hasMoreElements()) {
                    ((GridCellSelectListener)enumeration.nextElement()).cellDeselected(gridEvent);
                }
                this._fireSelectionProperty();
            }
        }
    }

    protected void processFocusCellEvent(GridEvent gridEvent) {
        if (this._focusListeners == null) {
            return;
        }
        Enumeration enumeration = this._focusListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (gridEvent.getID()) {
            case 2017: {
                while (enumeration.hasMoreElements()) {
                    ((GridFocusListener)enumeration.nextElement()).focusCellChanging(gridEvent);
                }
                break;
            }
            case 2018: {
                while (enumeration.hasMoreElements()) {
                    ((GridFocusListener)enumeration.nextElement()).focusCellChanged(gridEvent);
                }
                break;
            }
        }
    }

    protected void processEditEvent(GridEvent gridEvent) {
        if (gridEvent.getID() == 2020) {
            this._fireActiveDescendantEvent(-1, -1, gridEvent.getColumn(), gridEvent.getRow());
        }
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (gridEvent.getID()) {
            case 2019: {
                while (enumeration.hasMoreElements()) {
                    ((GridEditListener)enumeration.nextElement()).cellEditing(gridEvent);
                }
                break;
            }
            case 2020: {
                while (enumeration.hasMoreElements()) {
                    ((GridEditListener)enumeration.nextElement()).cellEdited(gridEvent);
                }
                this._fireVisibleDataProperty();
            }
        }
    }

    protected void processScrollEvent(GridEvent gridEvent) {
        if (this._scrollListeners == null) {
            return;
        }
        Enumeration enumeration = this._scrollListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (gridEvent.getID()) {
            case 2021: {
                while (enumeration.hasMoreElements()) {
                    ((GridScrollListener)enumeration.nextElement()).columnScrolling(gridEvent);
                }
                break;
            }
            case 2023: {
                while (enumeration.hasMoreElements()) {
                    ((GridScrollListener)enumeration.nextElement()).rowScrolling(gridEvent);
                }
                break;
            }
            case 2022: {
                while (enumeration.hasMoreElements()) {
                    ((GridScrollListener)enumeration.nextElement()).columnScrolled(gridEvent);
                }
                break;
            }
            case 2024: {
                while (enumeration.hasMoreElements()) {
                    ((GridScrollListener)enumeration.nextElement()).rowScrolled(gridEvent);
                }
                break;
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        Cell cell;
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        this._mouseCell = cell = this.__getCellAt(point.x, point.y);
        CellInputHandler cellInputHandler = null;
        if (cell != null) {
            cellInputHandler = this.getColumnCellInputHandler(cell.column);
        }
        switch (mouseEvent.getID()) {
            case 500: {
                this._handleMouseClicked(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 504: {
                this._handleMouseEntered(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 505: {
                this._handleMouseExited(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 501: {
                this._handleMousePressed(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 502: {
                this._handleMouseReleased(mouseEvent, cell, cellInputHandler);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        Cell cell;
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        this._mouseCell = cell = this.__getCellAt(point.x, point.y);
        CellInputHandler cellInputHandler = null;
        if (cell != null) {
            cellInputHandler = this.getColumnCellInputHandler(cell.column);
        }
        switch (mouseEvent.getID()) {
            case 503: {
                this._handleMouseMoved(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 506: {
                this._handleMouseDragged(mouseEvent, cell, cellInputHandler);
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            this._fireActiveDescendantEvent(-1, -1, this._focusColumn, this._focusRow);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (this._editControl != null) {
            this._editControl.requestFocus();
            return;
        }
        int n = keyEvent.getID();
        if (n == 401) {
            this._handleKeyPressed(keyEvent);
        } else if (n == 400) {
            this._handleKeyTyped(keyEvent);
        } else if (n == 402) {
            this._handleKeyReleased(keyEvent);
        }
    }

    @Override
    protected int getHMaximum() {
        if (!this.getScrollByColumn()) {
            return super.getHMaximum();
        }
        return this.getVisibleColumnCount();
    }

    @Override
    protected int getHValueOfOffset(int n) {
        if (!this.getScrollByColumn()) {
            return super.getHValueOfOffset(n);
        }
        GeometryManager geometryManager = this._columnGM;
        int n2 = geometryManager.getItemAt(-n);
        return geometryManager.convertDSIndexToVIndex(n2);
    }

    @Override
    protected int getHOffsetOfValue(int n) {
        if (!this.getScrollByColumn()) {
            return super.getHOffsetOfValue(n);
        }
        int n2 = this._convertVisibleColumnIndexToColumnIndex(n);
        n2 = this._columnGM.convertVIndexToDSIndex(n2);
        int n3 = this._columnGM.getItemPosition(n2);
        int n4 = this.getCanvasSize().width;
        int n5 = this.getInnerSize().width;
        int n6 = 0;
        if (n4 > n5 && n4 != 0 && n5 != 0) {
            n6 = n5 - n4;
        }
        if (-n3 < n6) {
            n3 = -n6;
        }
        return -n3;
    }

    @Override
    protected int getVMaximum() {
        if (!this.getScrollByRow()) {
            return super.getVMaximum();
        }
        return this.getVisibleRowCount();
    }

    @Override
    protected int getVValueOfOffset(int n) {
        if (!this.getScrollByRow()) {
            return super.getVValueOfOffset(n);
        }
        GeometryManager geometryManager = this._rowGM;
        int n2 = geometryManager.getItemAt(-n);
        return geometryManager.convertDSIndexToVIndex(n2);
    }

    @Override
    protected int getVOffsetOfValue(int n) {
        if (!this.getScrollByRow()) {
            return super.getVOffsetOfValue(n);
        }
        int n2 = this._convertVisibleRowIndexToRowIndex(n);
        n2 = this._rowGM.convertVIndexToDSIndex(n2);
        int n3 = this._rowGM.getItemPosition(n2);
        int n4 = this.getCanvasSize().height;
        int n5 = this.getInnerSize().height;
        int n6 = 0;
        if (n4 > n5 && n4 != 0 && n5 != 0) {
            n6 = n5 - n4;
        }
        if (-n3 < n6) {
            n3 = -n6;
        }
        return -n3;
    }

    @Override
    protected Dimension layoutCanvas() {
        Painter painter;
        int n = !this.getHorizontalSeparatorsVisible() ? 0 : ((painter = this.getHorizontalSeparatorPainter()) == null ? 0 : painter.getPreferredSize((PaintContext)this.getPaintContext()).height);
        this._rowGM.setSeparatorSize(n);
        this._rowGM.setDefaultItemSize(this.getDefaultRowHeight());
        n = !this.getVerticalSeparatorsVisible() ? 0 : this._vpWidth;
        this._columnGM.setSeparatorSize(n);
        this._columnGM.setDefaultItemSize(this.getDefaultColumnWidth());
        int n2 = this._columnGM.doLayout();
        int n3 = this._rowGM.doLayout();
        Dimension dimension = new Dimension(n2, n3);
        if ((this._focusColumn == -1 || this._focusRow == -1) && this.getVisibleColumnCount() != 0 && this.getVisibleRowCount() != 0) {
            int n4 = this.getActualReadingDirection() == 2 ? this.getPreviousVisibleColumn(this.getColumnCount()) : this.getNextVisibleColumn(-1);
            this.__setFocusCell(n4, this.getNextVisibleRow(-1));
        }
        this._checkForFirstColumnRow(dimension);
        return dimension;
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        this._paintGrid(this.getPaintContext(), graphics);
    }

    protected void paintFocusCell(PaintContext paintContext, Graphics graphics) {
        if (this.getDrawFocusCellHighlite() && this._focusColumn != -1 && this.hasFocus()) {
            Rectangle rectangle = this.__getCellRect(this._focusColumn, this._focusRow);
            if (rectangle == null) {
                return;
            }
            GridUI gridUI = (GridUI)this.getUI();
            BorderPainter borderPainter = gridUI.getFocusCellPainter(this);
            if (borderPainter != null) {
                borderPainter.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNewFocusCell(Cell cell, KeyEvent keyEvent, boolean bl) {
        int n = cell.column;
        int n2 = cell.row;
        boolean bl2 = false;
        this.freezeRepaints();
        try {
            bl2 = this.requestFocus(n, n2, keyEvent);
            if (bl2) {
                GridSelection gridSelection = this.getGridSelection();
                if (bl) {
                    boolean bl3 = !gridSelection.isCellSelected(n, n2);
                    gridSelection.setCellSelected(n, n2, bl3);
                } else if (!keyEvent.isControlDown()) {
                    if (keyEvent.isShiftDown() && this.getAnchorCell() != null) {
                        gridSelection.selectCellRange(n, n2, this.getAnchorCell().column, this.getAnchorCell().row);
                    } else {
                        this.setAnchorCell(cell);
                        gridSelection.deselectAll();
                        gridSelection.setCellSelected(n, n2, true);
                    }
                }
            }
        }
        finally {
            this.unfreezeRepaints();
        }
        if (bl2) {
            this.scrollCellIntoView(n, n2);
        }
    }

    public void scrollCellIntoView(int n, int n2) {
        int n3;
        int n4 = this._scrollColumnIntoView(n);
        int n5 = this._convertDSColumnIndexToScrollBoxIndex(n4);
        int n6 = this._scrollRowIntoView(n2);
        int n7 = this._convertDSRowIndexToScrollBoxIndex(n6);
        if (n4 == -1 && n6 == -1) {
            return;
        }
        if (n4 != -1 && this.fireCancelableColumnEvent(n5, 2021)) {
            return;
        }
        if (n6 != -1 && this.fireCancelableRowEvent(n7, 2023)) {
            return;
        }
        Point point = this.getCanvasOrigin();
        int n8 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (!this.isColumnVisible(n3)) continue;
            ++n8;
        }
        int n9 = n4 != -1 ? this.getHOffsetOfValue(n8) : point.x;
        n8 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            if (!this.isRowVisible(n3)) continue;
            ++n8;
        }
        int n10 = n6 != -1 ? this.getVOffsetOfValue(n8) : point.y;
        this.setCanvasOrigin(n9, n10);
        if (n4 != -1) {
            this.fireColumnEvent(n5, 2022);
        }
        if (n6 != -1) {
            this.fireRowEvent(n7, 2024);
        }
    }

    public void scrollColumnIntoView(int n) {
        int n2 = this._scrollColumnIntoView(n);
        int n3 = this._convertDSColumnIndexToScrollBoxIndex(n2);
        if (n2 == -1) {
            return;
        }
        if (this.fireCancelableColumnEvent(n3, 2021)) {
            return;
        }
        this.setFirstColumnOnScreen(n3);
        this.fireColumnEvent(n3, 2022);
    }

    public void scrollRowIntoView(int n) {
        int n2 = this._scrollRowIntoView(n);
        int n3 = this._convertDSRowIndexToScrollBoxIndex(n2);
        if (n2 == -1) {
            return;
        }
        if (this.fireCancelableRowEvent(n3, 2023)) {
            return;
        }
        this.setFirstRowOnScreen(n3);
        this.fireRowEvent(n3, 2024);
    }

    protected int getCellPaintState(int n, int n2, int n3) {
        return n;
    }

    @Override
    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (DATASOURCE_KEY.equals(object)) {
            object2 = this.getDataSource();
        } else if (GRID_KEY.equals(object)) {
            object2 = this;
        } else if (CELL_KEY == object) {
            object2 = this._mouseCell;
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    @Override
    protected final AccessibleContext createAccessibleContext() {
        if (this._accessibleGrid == null) {
            this._accessibleGrid = this.createAccessibleGrid();
        }
        this._accessibleGridCreated = true;
        return this._accessibleGrid;
    }

    protected AccessibleGrid createAccessibleGrid() {
        return new AccessibleGrid(this);
    }

    void attachAccessibleGrid(AccessibleGrid accessibleGrid) {
        if (this._accessibleGridCreated && this._accessibleGrid != null) {
            throw new IllegalStateException("You must create an AccessibleGrid when you create the Grid object.");
        }
        this._accessibleGrid = accessibleGrid;
    }

    void focusLost(FocusEvent focusEvent) {
        if (!this._removing) {
            Component component;
            if (this._editControlChildren != null && (component = FocusUtils.getOppositeComponent(focusEvent)) != null) {
                int n = this._editControlChildren.length;
                for (int i = 0; i < n; ++i) {
                    if (component != this._editControlChildren[i]) continue;
                    return;
                }
            }
            this._canRequestFocus = false;
            this.commitCellEdit();
        }
    }

    void internalRowsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
        Object object;
        int n = this.getFirstRowOnScreen();
        int n2 = twoDDataSourceEvent.getRowStartIndex();
        int n3 = twoDDataSourceEvent.getRowCount();
        this.getAppearanceManager().rowsAdded(n2, n3);
        this.getGridSelection().rowsAdded(n2, n3);
        this._rowGM.itemsAdded(n2, n3);
        if (this._focusColumn != -1 && this._focusRow != -1) {
            object = new Cell(this._focusColumn, this._focusRow);
            object = this._addRowsToCell((Cell)object, n2, n3);
            this.__setFocusCell(((Cell)object).column, ((Cell)object).row);
        }
        this.setAnchorCell(this._addRowsToCell(this.getAnchorCell(), n2, n3));
        this._moveCell = this._addRowsToCell(this._moveCell, n2, n3);
        this._mouseGrabCell = this._addRowsToCell(this._mouseGrabCell, n2, n3);
        object = this.layoutCanvas();
        this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
        int n4 = -this.getCanvasOriginY() + this.getInnerHeight();
        int n5 = n2 + n3;
        for (int i = n2; i < n5; ++i) {
            if (!this.isRowVisible(i) || this.getRowPosition(i) >= n4) continue;
            this.repaint();
            break;
        }
        this._fireVisibleDataProperty();
    }

    void internalRowsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getRowStartIndex();
        int n2 = twoDDataSourceEvent.getRowCount();
        int n3 = -this.getCanvasOriginY() + this.getInnerHeight();
        boolean bl = false;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            if (!this.isRowVisible(i) || this.getRowPosition(i) >= n3) continue;
            bl = true;
            break;
        }
        this.getAppearanceManager().rowsRemoved(n, n2);
        this.getGridSelection().rowsRemoved(n, n2);
        this._rowGM.itemsRemoved(n, n2);
        if (this._focusRow >= n && this._focusRow < n + n2 && this.isEditing()) {
            this.cancelCellEdit();
        }
        if (this._focusColumn != -1 && this._focusRow != -1) {
            Cell cell = new Cell(this._focusColumn, this._focusRow);
            if ((cell = this._removeRowsFromCell(cell, n, n2)) == null) {
                this.__setFocusCell(-1, -1);
            } else {
                this.__setFocusCell(cell.column, cell.row);
            }
        }
        this.setAnchorCell(this._removeRowsFromCell(this.getAnchorCell(), n, n2));
        this._moveCell = this._removeRowsFromCell(this._moveCell, n, n2);
        this._mouseGrabCell = this._removeRowsFromCell(this._mouseGrabCell, n, n2);
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        if (bl) {
            this.repaint();
        }
        this._fireVisibleDataProperty();
    }

    void internalInvalidateRows(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getRowStartIndex();
        int n2 = n + twoDDataSourceEvent.getRowCount() - 1;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        boolean bl = false;
        for (int i = n; i <= n2; ++i) {
            if (!this.isRowOnScreen(i)) continue;
            if (!bl) {
                rectangle = new Rectangle();
                rectangle.x = -this.getCanvasOrigin().x;
                rectangle.y = this._rowGM.getItemPosition(i);
                rectangle.width = this.getInnerSize().width;
                rectangle.height = this._rowGM.getItemSize(i);
                rectangle2 = new Rectangle();
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                bl = true;
                continue;
            }
            rectangle2.y = this._rowGM.getItemPosition(i);
            rectangle2.height = this._rowGM.getItemSize(i);
            rectangle = rectangle.union(rectangle2);
        }
        if (bl) {
            this.repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this._fireVisibleDataProperty();
        }
    }

    void internalColumnsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
        Object object;
        int n = this.getFirstColumnOnScreen();
        int n2 = twoDDataSourceEvent.getColumnStartIndex();
        int n3 = twoDDataSourceEvent.getColumnCount();
        this._columnsAdded(n2, n3);
        this.getAppearanceManager().columnsAdded(n2, n3);
        this.getGridSelection().columnsAdded(n2, n3);
        this._columnGM.itemsAdded(n2, n3);
        if (this._focusColumn != -1 && this._focusRow != -1) {
            object = new Cell(this._focusColumn, this._focusRow);
            object = this._addColumnsToCell((Cell)object, n2, n3);
            this.__setFocusCell(((Cell)object).column, ((Cell)object).row);
        }
        this.setAnchorCell(this._addColumnsToCell(this.getAnchorCell(), n2, n3));
        this._moveCell = this._addColumnsToCell(this._moveCell, n2, n3);
        this._mouseGrabCell = this._addColumnsToCell(this._mouseGrabCell, n2, n3);
        object = this.layoutCanvas();
        this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
        int n4 = -this.getCanvasOriginX();
        int n5 = n4 + this.getInnerWidth();
        boolean bl = this.getActualReadingDirection() == 1;
        boolean bl2 = false;
        int n6 = n2 + n3;
        for (int i = n2; i < n6; ++i) {
            if (!this.isColumnVisible(i)) continue;
            boolean bl3 = bl ? this.getColumnPosition(i) < n5 : (bl2 = this.getColumnPosition(i) + this.getColumnWidth(i) >= n4);
            if (!bl2) continue;
            this.repaint();
            break;
        }
        this._fireVisibleDataProperty();
    }

    void internalColumnsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getColumnStartIndex();
        int n2 = twoDDataSourceEvent.getColumnCount();
        int n3 = -this.getCanvasOriginX();
        int n4 = n3 + this.getInnerWidth();
        boolean bl = this.getActualReadingDirection() == 1;
        boolean bl2 = false;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            if (!this.isColumnVisible(i)) continue;
            boolean bl3 = bl ? this.getColumnPosition(i) < n4 : (bl2 = this.getColumnPosition(i) + this.getColumnWidth(i) >= n3);
            if (!bl2) continue;
            bl2 = true;
            break;
        }
        this._columnsRemoved(n, n2);
        this.getAppearanceManager().columnsRemoved(n, n2);
        this.getGridSelection().columnsRemoved(n, n2);
        this._columnGM.itemsRemoved(n, n2);
        if (this._focusRow >= n && this._focusRow < n + n2 && this.isEditing()) {
            this.cancelCellEdit();
        }
        if (this._focusColumn != -1 && this._focusRow != -1) {
            Cell cell = new Cell(this._focusColumn, this._focusRow);
            if ((cell = this._removeColumnsFromCell(cell, n, n2)) == null) {
                this.__setFocusCell(-1, -1);
            } else {
                this.__setFocusCell(cell.column, cell.row);
            }
        }
        this.setAnchorCell(this._removeColumnsFromCell(this.getAnchorCell(), n, n2));
        this._moveCell = this._removeColumnsFromCell(this._moveCell, n, n2);
        this._mouseGrabCell = this._removeColumnsFromCell(this._mouseGrabCell, n, n2);
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        if (bl2) {
            this.repaint();
        }
        this._fireVisibleDataProperty();
    }

    void internalInvalidateColumns(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getColumnStartIndex();
        int n2 = n + twoDDataSourceEvent.getColumnCount() - 1;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        boolean bl = false;
        for (int i = n; i <= n2; ++i) {
            if (!this.isColumnOnScreen(i)) continue;
            if (!bl) {
                rectangle = new Rectangle();
                rectangle.x = this._columnGM.getItemPosition(i);
                rectangle.y = -this.getCanvasOrigin().y;
                rectangle.width = this._columnGM.getItemSize(i);
                rectangle.height = this.getInnerSize().height;
                rectangle2 = new Rectangle();
                rectangle2.y = rectangle.y;
                rectangle2.height = rectangle.height;
                bl = true;
                continue;
            }
            rectangle2.x = this._columnGM.getItemPosition(i);
            rectangle2.width = this._columnGM.getItemSize(i);
            rectangle = rectangle.union(rectangle2);
        }
        if (bl) {
            this.repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this._fireVisibleDataProperty();
        }
    }

    void internalInvalidateCells(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getColumnStartIndex();
        int n2 = twoDDataSourceEvent.getColumnCount();
        int n3 = twoDDataSourceEvent.getRowStartIndex();
        int n4 = twoDDataSourceEvent.getRowCount();
        if (n2 == 1 && n4 == 1) {
            if (this.isColumnOnScreen(n) && this.isRowOnScreen(n3)) {
                this.repaintCanvas(this._columnGM.getItemPosition(n), this._rowGM.getItemPosition(n3), this._columnGM.getItemSize(n), this._rowGM.getItemSize(n3));
                this._fireVisibleDataProperty();
            }
        } else if (n2 == 1) {
            if (this.isColumnOnScreen(n)) {
                this.repaintCanvas(this._columnGM.getItemPosition(n), -this.getCanvasOrigin().y, this._columnGM.getItemSize(n), this.getInnerSize().height);
                this._fireVisibleDataProperty();
            }
        } else if (n4 == 1) {
            if (this.isRowOnScreen(n3)) {
                this.repaintCanvas(-this.getCanvasOrigin().x, this._rowGM.getItemPosition(n3), this.getInnerSize().width, this._rowGM.getItemSize(n3));
                this._fireVisibleDataProperty();
            }
        } else {
            Point point = this.getCanvasOrigin();
            this.repaintCanvas(-point.x, -point.y, this.getInnerWidth(), this.getInnerHeight());
            this._fireVisibleDataProperty();
        }
    }

    Component __getEditControl() {
        return this._editControl;
    }

    private Cell _addColumnsToCell(Cell cell, int n, int n2) {
        if (cell != null && cell.column >= n) {
            cell.column += n2;
        }
        return cell;
    }

    private Cell _removeColumnsFromCell(Cell cell, int n, int n2) {
        if (cell != null) {
            if (cell.column >= n && cell.column < n + n2) {
                cell.column = n;
                if (cell.column >= this.getColumnCount()) {
                    cell.column = this.getColumnCount() - 1;
                }
                if (cell.column < 0) {
                    cell = null;
                }
            } else if (cell.column >= n + n2) {
                cell.column -= n2;
            }
        }
        return cell;
    }

    private Cell _addRowsToCell(Cell cell, int n, int n2) {
        if (cell != null && cell.row >= n) {
            cell.row += n2;
        }
        return cell;
    }

    private Cell _removeRowsFromCell(Cell cell, int n, int n2) {
        if (cell != null) {
            if (cell.row >= n && cell.row < n + n2) {
                cell.row = n;
                if (cell.row >= this.getRowCount()) {
                    cell.row = this.getRowCount() - 1;
                }
                if (cell.row < 0) {
                    cell = null;
                }
            } else if (cell.row >= n + n2) {
                cell.row -= n2;
            }
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _paintGrid(PaintContext paintContext, Graphics graphics) {
        Object object = this.__paintLock;
        synchronized (object) {
            GridUI gridUI;
            BorderPainter borderPainter;
            if (this.getVisibleColumnCount() != 0 && this.getVisibleRowCount() != 0) {
                this._paintCells(paintContext, graphics);
            }
            if (this.isOverlayBorderVisible() & !(graphics instanceof PrintGraphics) && (borderPainter = (gridUI = (GridUI)this.getUI()).getOverlayBorderPainter(this)) != null) {
                Dimension dimension = this.getInnerSize();
                Point point = this.getCanvasOrigin();
                borderPainter.paint(paintContext, graphics, -point.x, -point.y, dimension.width, dimension.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doneEditing(boolean bl) {
        int n;
        int n2;
        Component component;
        Grid grid = this;
        synchronized (grid) {
            component = this._editControl;
            n2 = this._focusColumn;
            n = this._focusRow;
            if (component == null || n2 == -1) {
                return;
            }
            this._removing = true;
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(n2);
            if (bl) {
                Object object = cellInputHandler.commitEdit(this, n2, n);
                if (cellInputHandler.isDirty(this, n2, n)) {
                    this.getDataSource().setData(n2, n, object);
                }
            } else {
                cellInputHandler.cancelEdit(this, n2, n);
            }
            this._editControl = null;
        }
        component.setVisible(false);
        this._removeListeners(this._editControlChildren);
        this._editControlChildren = null;
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            FocusUtils.setFocusTraversalKeysEnabled(component, true, true);
        }
        this.remove(component);
        if (this._canRequestFocus) {
            this.requestFocus();
        } else {
            this._canRequestFocus = true;
        }
        this._removing = false;
        this.fireCellEvent(n2, n, 2020);
    }

    Cell __getCellAt(int n, int n2) {
        int n3 = this._columnGM.getItemAt(n);
        int n4 = this._rowGM.getItemAt(n2);
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        return new Cell(n3, n4);
    }

    private void _paintCells(PaintContext paintContext, Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this._columnGM.getItemAt(rectangle.x);
        int n2 = this._rowGM.getItemAt(rectangle.y);
        if (n != -1 && n2 != -1) {
            n = this._columnGM.convertDSIndexToVIndex(n);
            n2 = this._rowGM.convertDSIndexToVIndex(n2);
            int n3 = this._columnGM.getItemAt(rectangle.x + rectangle.width);
            if (n3 == -1) {
                n3 = this.getPreviousVisibleColumn(this.getColumnCount());
            }
            n3 = this._columnGM.convertDSIndexToVIndex(n3);
            int n4 = this._rowGM.getItemAt(rectangle.y + rectangle.height);
            if (n4 == -1) {
                n4 = this.getPreviousVisibleRow(this.getRowCount());
            }
            n4 = this._rowGM.convertDSIndexToVIndex(n4);
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                return;
            }
            if (n > n3) {
                int n5 = n3;
                n3 = n;
                n = n5;
            }
            for (int i = n; i <= n3; ++i) {
                int n6 = this._columnGM.convertVIndexToDSIndex(i);
                if (!this._columnGM.isItemVisible(n6)) continue;
                this._paintColumn(paintContext, graphics, rectangle, n6, n2, n4);
            }
            if (n2 != 0) {
                --n2;
            }
            if (n != 0) {
                --n;
            }
            this._paintVerticalGridLines(paintContext, graphics, rectangle, n2, n4, n, n3);
            this._paintHorizontalGridLines(paintContext, graphics, rectangle, n, n3, n2, n4);
            this.paintFocusCell(paintContext, graphics);
        }
    }

    private void _paintColumn(PaintContext paintContext, Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        Shape shape = graphics.getClip();
        GridSelection gridSelection = this.getGridSelection();
        Painter painter = this.getColumnPainter(n);
        boolean bl = graphics instanceof PrintGraphics;
        CellPaintContext cellPaintContext = !bl ? new CellPaintContext(paintContext, -1, -1) : new CellPrintPaintContext(paintContext, -1, -1);
        int n4 = this._getColumnX(n);
        int n5 = this._columnGM.getItemSize(n);
        boolean bl2 = this.isOverlayBorderVisible() && this.isActive();
        int n6 = n4;
        int n7 = n5;
        if (bl2 && n == this.getFirstColumnOnScreen()) {
            ++n6;
            --n7;
        }
        int n8 = this.getFirstRowOnScreen();
        for (int i = n2; i <= n3; ++i) {
            int n9 = this._rowGM.convertVIndexToDSIndex(i);
            if (!this._rowGM.isItemVisible(n9)) continue;
            int n10 = this._rowGM.getItemPosition(n9);
            int n11 = this._rowGM.getItemSize(n9);
            graphics.setClip(shape);
            graphics.clipRect(n4, n10, n5, n11);
            cellPaintContext.setCell(n, n9);
            Color color = cellPaintContext.getPaintBackground();
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(n4, n10, n5, n11);
            }
            graphics.setColor(cellPaintContext.getPaintForeground());
            graphics.setFont(cellPaintContext.getPaintFont());
            ImmInsets immInsets = cellPaintContext.getAppearance().getInsets();
            BorderPainter borderPainter = cellPaintContext.getAppearance().getBorderPainter();
            if (borderPainter != null) {
                int n12 = n10;
                int n13 = n11;
                if (bl2 && i == n8) {
                    ++n12;
                    --n13;
                }
                borderPainter.paint(cellPaintContext, graphics, n6, n12, n7, n13);
                ImmInsets immInsets2 = borderPainter.getInsets(cellPaintContext);
                immInsets = new ImmInsets(immInsets.top + immInsets2.top, immInsets.left + immInsets2.left, immInsets.bottom + immInsets2.bottom, immInsets.right + immInsets2.right);
            }
            painter.paint(cellPaintContext, graphics, n4 + immInsets.left, n10 + immInsets.top, n5 - (immInsets.left + immInsets.right), n11 - (immInsets.top + immInsets.bottom));
        }
        graphics.setClip(shape);
    }

    private void _paintHorizontalGridLines(PaintContext paintContext, Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (this.getHorizontalSeparatorsVisible() || this.getVerticalSeparatorsVisible()) {
            Painter painter;
            Painter painter2 = this.getHorizontalSeparatorPainter();
            if (painter2 == null) {
                return;
            }
            int n5 = painter2.getPreferredSize((PaintContext)paintContext).height;
            if (!this.getHorizontalSeparatorsVisible()) {
                n3 = n4 = this.getRowCount() - 1;
            }
            int n6 = this._columnGM.convertVIndexToDSIndex(n);
            int n7 = this._getColumnX(n6);
            n6 = this._columnGM.convertVIndexToDSIndex(n2);
            int n8 = this._getColumnX(n6) + this._columnGM.getItemSize(n6) - n7 + 1;
            if (this.getVerticalSeparatorsVisible() && (painter = this.getVerticalSeparatorPainter()) != null) {
                int n9 = painter.getPreferredSize((PaintContext)paintContext).width;
                n7 -= n9;
                n8 += n9;
            }
            for (int i = n3; i <= n4; ++i) {
                n6 = this._rowGM.convertVIndexToDSIndex(i);
                if (!this._rowGM.isItemVisible(n6)) continue;
                int n10 = this._rowGM.getItemSize(n6) + this._rowGM.getItemPosition(n6);
                painter2.paint(paintContext, graphics, n7, n10, n8, n5);
            }
        }
    }

    private void _paintVerticalGridLines(PaintContext paintContext, Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (this.getVerticalSeparatorsVisible() || this.getHorizontalSeparatorsVisible()) {
            Painter painter;
            boolean bl = this.getActualReadingDirection() == 1;
            Painter painter2 = this.getVerticalSeparatorPainter();
            if (painter2 == null) {
                return;
            }
            int n5 = painter2.getPreferredSize((PaintContext)paintContext).width;
            if (!this.getVerticalSeparatorsVisible()) {
                n3 = n4 = this.getColumnCount() - 1;
            }
            int n6 = this._rowGM.convertVIndexToDSIndex(n);
            int n7 = this._rowGM.getItemPosition(n6);
            n6 = this._rowGM.convertVIndexToDSIndex(n2);
            int n8 = this._rowGM.getItemPosition(n6) + this._rowGM.getItemSize(n6) - n7 + 1;
            if (this.getHorizontalSeparatorsVisible() && (painter = this.getHorizontalSeparatorPainter()) != null) {
                int n9 = painter.getPreferredSize((PaintContext)paintContext).height;
                n7 -= n9;
                n8 += n9;
            }
            for (int i = n3; i <= n4; ++i) {
                n6 = this._columnGM.convertVIndexToDSIndex(i);
                if (!this._columnGM.isItemVisible(n6)) continue;
                int n10 = this._columnGM.getItemPosition(n6);
                if (bl) {
                    n10 += this._columnGM.getItemSize(n6);
                }
                painter2.paint(paintContext, graphics, n10, n7, n5, n8);
            }
        }
    }

    private int _convertVisibleColumnIndexToColumnIndex(int n) {
        if (this.getVisibleColumnCount() == this.getColumnCount()) {
            return n;
        }
        int n2 = 0;
        int n3 = -1;
        while (n3 < n) {
            int n4 = this._columnGM.convertVIndexToDSIndex(n2);
            if (this._columnGM.isItemVisible(n4)) {
                ++n3;
            }
            ++n2;
        }
        return n2 - 1;
    }

    private int _convertVisibleRowIndexToRowIndex(int n) {
        if (this.getVisibleRowCount() == this.getRowCount()) {
            return n;
        }
        int n2 = 0;
        int n3 = -1;
        while (n3 < n) {
            int n4 = this._rowGM.convertVIndexToDSIndex(n2);
            if (this._rowGM.isItemVisible(n4)) {
                ++n3;
            }
            ++n2;
        }
        return n2 - 1;
    }

    private void _handleKeyTyped(KeyEvent keyEvent) {
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusColumn != -1) {
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusColumn);
            cellInputHandler.keyTyped(keyEvent, this, this._focusColumn, this._focusRow);
        }
    }

    private void _handleKeyReleased(KeyEvent keyEvent) {
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusColumn != -1) {
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusColumn);
            cellInputHandler.keyReleased(keyEvent, this, this._focusColumn, this._focusRow);
        }
    }

    private void _handleKeyPressed(KeyEvent keyEvent) {
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            if (!keyEvent.isConsumed() && FocusUtils.areNewFocusAPIsAvailable() && keyEvent.getKeyCode() == 9) {
                FocusUtils.transferFocus(this, !keyEvent.isShiftDown());
            }
            return;
        }
        if (this._focusColumn != -1) {
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusColumn);
            cellInputHandler.keyPressed(keyEvent, this, this._focusColumn, this._focusRow);
        }
        if (!keyEvent.isConsumed()) {
            this._sendKeyToNavigator(keyEvent);
        }
        if (!keyEvent.isConsumed() && FocusUtils.areNewFocusAPIsAvailable() && keyEvent.getKeyCode() == 9) {
            FocusUtils.transferFocus(this, !keyEvent.isShiftDown());
        }
    }

    private void _sendKeyToNavigator(KeyEvent keyEvent) {
        if (keyEvent.isAltDown()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        Cell cell = this.getFocusCell();
        Cell cell2 = null;
        GridKeyNavigator gridKeyNavigator = this.getGridKeyNavigator();
        boolean bl = InputEventUtils.isOnlyShiftDown(keyEvent);
        boolean bl2 = false;
        switch (n) {
            case 32: {
                bl2 = true;
                cell2 = cell;
                break;
            }
            case 10: {
                cell2 = gridKeyNavigator.enter(this, cell, keyEvent, bl);
                break;
            }
            case 9: {
                cell2 = gridKeyNavigator.tab(this, cell, keyEvent, bl);
                break;
            }
            case 40: {
                cell2 = gridKeyNavigator.down(this, cell, keyEvent);
                break;
            }
            case 38: {
                cell2 = gridKeyNavigator.up(this, cell, keyEvent);
                break;
            }
            case 37: {
                cell2 = gridKeyNavigator.left(this, cell, keyEvent);
                break;
            }
            case 39: {
                cell2 = gridKeyNavigator.right(this, cell, keyEvent);
                break;
            }
            case 35: {
                cell2 = gridKeyNavigator.end(this, cell, keyEvent);
                break;
            }
            case 36: {
                cell2 = gridKeyNavigator.home(this, cell, keyEvent);
                break;
            }
            case 34: {
                cell2 = gridKeyNavigator.pageDown(this, cell, keyEvent);
                break;
            }
            case 33: {
                cell2 = gridKeyNavigator.pageUp(this, cell, keyEvent);
            }
        }
        if (!bl2 && (cell2 == null || cell2.column == cell.column && cell2.row == cell.row)) {
            return;
        }
        ToolTipManager.getToolTipManager().leave(this);
        this.processNewFocusCell(cell2, keyEvent, bl2);
    }

    private Rectangle _getColumnRect(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        Rectangle rectangle = new Rectangle();
        rectangle.x = this._getColumnX(n);
        rectangle.y = -point.y;
        rectangle.width = this._columnGM.getItemSize(n);
        rectangle.height = dimension.height;
        return rectangle;
    }

    private Rectangle _getRowRect(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        Rectangle rectangle = new Rectangle();
        rectangle.x = -point.x;
        rectangle.y = this._rowGM.getItemPosition(n);
        rectangle.width = dimension.width;
        rectangle.height = this._rowGM.getItemSize(n);
        return rectangle;
    }

    Rectangle __getCellRect(int n, int n2) {
        if (!this.isColumnOnScreen(n) || !this.isRowOnScreen(n2)) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        rectangle.x = this._getColumnX(n);
        rectangle.y = this._rowGM.getItemPosition(n2);
        rectangle.width = this._columnGM.getItemSize(n);
        rectangle.height = this._rowGM.getItemSize(n2);
        if (this.isOverlayBorderVisible()) {
            ImmInsets immInsets;
            GridUI gridUI = (GridUI)this.getUI();
            BorderPainter borderPainter = gridUI.getOverlayBorderPainter(this);
            ImmInsets immInsets2 = immInsets = borderPainter == null ? null : borderPainter.getInsets(this.getPaintContext());
            if (n == this.getFirstColumnOnScreen() && immInsets != null) {
                rectangle.x += immInsets.left;
                rectangle.width -= immInsets.left;
            }
            if (n2 == this.getFirstRowOnScreen() && immInsets != null) {
                rectangle.y += immInsets.left;
                rectangle.height -= immInsets.top;
            }
        }
        return rectangle;
    }

    private int _getColumnX(int n) {
        int n2 = this._columnGM.getItemPosition(n);
        if (this.getActualReadingDirection() == 2 && this.getVerticalSeparatorsVisible()) {
            n2 += this._vpWidth;
        }
        return n2;
    }

    private void _moveEditControl() {
        if (this._editControl == null) {
            return;
        }
        CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusColumn);
        Rectangle rectangle = cellInputHandler.getEditControlBounds(this, this._focusColumn, this._focusRow);
        if (rectangle != null) {
            rectangle.x += this._getColumnX(this._focusColumn);
            rectangle.y += this._rowGM.getItemPosition(this._focusRow);
        } else {
            rectangle = this.__getCellRect(this._focusColumn, this._focusRow);
        }
        Point point = this.getCanvasOrigin();
        if (rectangle == null) {
            this._editControl.setVisible(false);
        } else {
            rectangle.x += point.x;
            rectangle.y += point.y;
            this._editControl.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this._editControl.setVisible(true);
            this._editControl.validate();
            this._editControl.repaint();
        }
    }

    private int _scrollRowIntoView(int n) {
        if (this._isRowCompletelyOnScreen(n)) {
            return -1;
        }
        int n2 = -1;
        int n3 = this.getFirstRowOnScreen();
        if (this._rowGM.convertDSIndexToVIndex(n3) < this._rowGM.convertDSIndexToVIndex(n)) {
            int n4 = this._rowGM.getItemPosition(n) + this._rowGM.getItemSize(n) - this.getInnerSize().height;
            if (n4 < 0) {
                n2 = this.getNextVisibleRow(-1);
            } else {
                int n5 = this._rowGM.getItemAt(n4);
                n2 = this.getNextVisibleRow(n5);
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    private int _scrollColumnIntoView(int n) {
        if (this._isColumnCompletelyOnScreen(n)) {
            return -1;
        }
        int n2 = -1;
        int n3 = this.getFirstColumnOnScreen();
        if (this._columnGM.convertDSIndexToVIndex(n3) < this._columnGM.convertDSIndexToVIndex(n)) {
            int n4 = this._columnGM.getItemPosition(n) + this._columnGM.getItemSize(n) - this.getInnerSize().width;
            if (n4 < 0) {
                n2 = this.getNextVisibleColumn(-1);
            } else {
                int n5 = this._columnGM.getItemAt(n4);
                n2 = this.getNextVisibleColumn(n5);
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    private int _convertDSColumnIndexToScrollBoxIndex(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.getPreviousVisibleColumn(n);
        while (n3 != -1) {
            n3 = this.getPreviousVisibleColumn(n3);
            ++n2;
        }
        int n4 = n2;
        for (int i = 0; i <= n4; ++i) {
            if (this.isColumnVisible(i)) continue;
            ++n4;
        }
        return n4;
    }

    private int _convertDSRowIndexToScrollBoxIndex(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.getPreviousVisibleRow(n);
        while (n3 != -1) {
            n3 = this.getPreviousVisibleRow(n3);
            ++n2;
        }
        int n4 = n2;
        for (int i = 0; i <= n4; ++i) {
            if (this.isRowVisible(i)) continue;
            ++n4;
        }
        return n4;
    }

    private boolean _isColumnCompletelyOnScreen(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = this._columnGM.getItemPosition(n);
        int n3 = this._columnGM.getItemSize(n);
        point.x = -point.x;
        if (n2 < point.x || n2 > point.x + dimension.width) {
            return false;
        }
        return n2 + n3 <= point.x + dimension.width || n3 >= dimension.width;
    }

    private boolean _isRowCompletelyOnScreen(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = this._rowGM.getItemPosition(n);
        int n3 = this._rowGM.getItemSize(n);
        point.y = -point.y;
        if (n2 < point.y || n2 > point.y + dimension.height) {
            return false;
        }
        return n2 + n3 <= point.y + dimension.height || n3 >= dimension.height;
    }

    private GridKeyAdapter _getKeyListener() {
        if (this._keyAdapter == null) {
            this._keyAdapter = new GridKeyAdapter(this);
        }
        return this._keyAdapter;
    }

    private FocusAdapter _getFocusListener() {
        if (this._focusListener == null) {
            this._focusListener = new EditFocus();
        }
        return this._focusListener;
    }

    private void _handleMouseClicked(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        if (cell != null) {
            Point point = this.getCanvasOrigin();
            int n = -point.x - this.getColumnPosition(cell.column);
            int n2 = -point.y - this.getRowPosition(cell.row);
            mouseEvent.translatePoint(n, n2);
            cellInputHandler.mouseClicked(mouseEvent, this, cell.column, cell.row);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleMousePressed(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        boolean bl = InputEventUtils.isLeftMouseButton(mouseEvent);
        Rectangle rectangle = this.getInnerBounds();
        if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        this.freezeRepaints();
        try {
            if (bl) {
                this.requestFocus();
            }
            this._mouseGrabCell = cell;
            if (cell != null) {
                Point point = this.getCanvasOrigin();
                int n = -point.x - this.getColumnPosition(cell.column);
                int n2 = -point.y - this.getRowPosition(cell.row);
                mouseEvent.translatePoint(n, n2);
                cellInputHandler.mousePressed(mouseEvent, this, cell.column, cell.row);
                mouseEvent.translatePoint(-n, -n2);
                if (mouseEvent.isConsumed() || !bl) {
                    return;
                }
                GridSelection gridSelection = this.getGridSelection();
                if (mouseEvent.isShiftDown()) {
                    if (this.getAnchorCell() == null) {
                        this.setAnchorCell(cell);
                    }
                    gridSelection.selectCellRange(cell.column, cell.row, this.getAnchorCell().column, this.getAnchorCell().row);
                } else {
                    int n3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                    if ((n3 & InputEventUtils.getMods(mouseEvent)) != 0) {
                        if (gridSelection.isCellSelected(cell.column, cell.row)) {
                            gridSelection.removeCellFromSelection(cell.column, cell.row);
                        } else {
                            gridSelection.addCellToSelection(cell.column, cell.row);
                        }
                    } else {
                        gridSelection.selectCellRange(cell.column, cell.row, cell.column, cell.row);
                    }
                    this.setAnchorCell(cell);
                }
                mouseEvent.consume();
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _handleMouseEntered(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        this._moveCell = cell;
        if (this._moveCell != null) {
            Point point = this.getCanvasOrigin();
            int n = -point.x - this.getColumnPosition(this._moveCell.column);
            int n2 = -point.y - this.getRowPosition(this._moveCell.row);
            mouseEvent.translatePoint(n, n2);
            cellInputHandler.mouseEntered(mouseEvent, this, this._moveCell.column, this._moveCell.row);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    private void _handleMouseExited(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        if (this._moveCell != null) {
            CellInputHandler cellInputHandler2 = this.getColumnCellInputHandler(this._moveCell.column);
            Point point = this.getCanvasOrigin();
            int n = -point.x - this.getColumnPosition(this._moveCell.column);
            int n2 = -point.y - this.getRowPosition(this._moveCell.row);
            mouseEvent.translatePoint(n, n2);
            cellInputHandler2.mouseExited(mouseEvent, this, this._moveCell.column, this._moveCell.row);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    private void _handleMouseReleased(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        GridAutoScroller.getAutoScroller().cancel();
        if (this._mouseGrabCell != null) {
            int n = this._mouseGrabCell.column;
            int n2 = this._mouseGrabCell.row;
            CellInputHandler cellInputHandler2 = this.getColumnCellInputHandler(n);
            Point point = this.getCanvasOrigin();
            int n3 = -point.x - this.getColumnPosition(n);
            int n4 = -point.y - this.getRowPosition(n2);
            mouseEvent.translatePoint(n3, n4);
            cellInputHandler2.mouseReleased(mouseEvent, this, n, n2);
            mouseEvent.translatePoint(-n3, -n4);
            this._mouseGrabCell = null;
        }
    }

    private void _handleMouseMoved(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (cell != null) {
            n3 = cell.column;
            n4 = cell.row;
        }
        if (this._moveCell != null) {
            n5 = this._moveCell.column;
            n6 = this._moveCell.row;
        }
        Point point = this.getCanvasOrigin();
        if (n3 != n5 || n4 != n6) {
            CellInputHandler cellInputHandler2;
            MouseEvent mouseEvent2;
            if (this._moveCell != null) {
                mouseEvent2 = new MouseEvent(this, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), n - point.x - this.getColumnPosition(n5), n2 - point.y - this.getRowPosition(n6), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                cellInputHandler2 = this.getColumnCellInputHandler(n5);
                cellInputHandler2.mouseExited(mouseEvent2, this, n5, n6);
            }
            if (cell != null) {
                mouseEvent2 = new MouseEvent(this, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), n - point.x - this.getColumnPosition(n3), n2 - point.y - this.getRowPosition(n4), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                cellInputHandler2 = this.getColumnCellInputHandler(n3);
                cellInputHandler2.mouseEntered(mouseEvent2, this, n3, n4);
            }
            this._moveCell = cell;
        }
        if (this._moveCell != null) {
            int n7 = -point.x - this.getColumnPosition(this._moveCell.column);
            int n8 = -point.y - this.getRowPosition(this._moveCell.row);
            mouseEvent.translatePoint(n7, n8);
            cellInputHandler.mouseMoved(mouseEvent, this, this._moveCell.column, this._moveCell.row);
            mouseEvent.translatePoint(-n7, -n8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleMouseDragged(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        if (this._mouseGrabCell != null) {
            int n = this._mouseGrabCell.column;
            int n2 = this._mouseGrabCell.row;
            CellInputHandler cellInputHandler2 = this.getColumnCellInputHandler(n);
            Point point = this.getCanvasOrigin();
            int n3 = -point.x - this.getColumnPosition(n);
            int n4 = -point.y - this.getRowPosition(n2);
            mouseEvent.translatePoint(n3, n4);
            cellInputHandler2.mouseDragged(mouseEvent, this, n, n2);
            mouseEvent.translatePoint(-n3, -n4);
            if (!(mouseEvent.isConsumed() || mouseEvent.isShiftDown() || mouseEvent.isControlDown() || mouseEvent.isMetaDown() || cell == null)) {
                this.freezeRepaints();
                try {
                    GridSelection gridSelection = this.getGridSelection();
                    Object object = this._scrollLock;
                    synchronized (object) {
                        gridSelection.selectCellRange(n, n2, cell.column, cell.row);
                        this._lastColumn = cell.column;
                        this._lastRow = cell.row;
                    }
                }
                finally {
                    this.unfreezeRepaints();
                }
            }
        }
        if (!mouseEvent.isConsumed()) {
            this._checkScroller(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void growSelection(boolean bl, int n) {
        if (this._mouseGrabCell != null) {
            GridSelection gridSelection = this.getGridSelection();
            Object object = this._scrollLock;
            synchronized (object) {
                if (bl) {
                    this._lastColumn = n;
                } else {
                    this._lastRow = n;
                }
                gridSelection.selectCellRange(this._mouseGrabCell.column, this._mouseGrabCell.row, this._lastColumn, this._lastRow);
            }
        }
    }

    private void _checkScroller(MouseEvent mouseEvent) {
        int n;
        if (!this.isAutoScrollingEnabled()) {
            return;
        }
        GridAutoScroller gridAutoScroller = GridAutoScroller.getAutoScroller();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = mouseEvent.getX();
        int n3 = this.getInnerSize().width;
        int n4 = this.getColumnCount();
        int n5 = n = n4 == 0 ? 0 : this._columnGM.getTotalItemSize() / n4;
        if (n2 < (n /= 2)) {
            bl = true;
            bl3 = true;
        } else if (n2 > n3 - n) {
            bl = true;
            bl3 = false;
        }
        n2 = mouseEvent.getY();
        n3 = this.getInnerSize().height;
        n4 = this.getRowCount();
        int n6 = n = n4 == 0 ? 0 : this._rowGM.getTotalItemSize() / n4;
        if (n2 < (n /= 2)) {
            bl2 = true;
            bl4 = true;
        } else if (n2 > n3 - n) {
            bl2 = true;
            bl4 = false;
        }
        if (!bl2 & !bl) {
            gridAutoScroller.cancel();
        } else {
            gridAutoScroller.schedule(this, bl, bl3, bl2, bl4);
        }
    }

    private void _columnsAdded(int n, int n2) {
        if (this._cellPainters != null) {
            this._cellPainters.addItems(n, n2);
        }
        if (this._painters != null) {
            this._painters.addItems(n, n2);
        }
        if (this._cellInputHandlers != null) {
            this._cellInputHandlers.addItems(n, n2);
        }
    }

    private void _columnsRemoved(int n, int n2) {
        if (this._cellPainters != null) {
            this._cellPainters.removeItems(n, n2);
        }
        if (this._painters != null) {
            this._painters.removeItems(n, n2);
        }
        if (this._cellInputHandlers != null) {
            this._cellInputHandlers.removeItems(n, n2);
        }
    }

    private void _checkForFirstColumnRow(Dimension dimension) {
        int n;
        Dimension dimension2 = this.getInnerSize();
        if (this._firstColumn != -1) {
            if (dimension.width != 0) {
                if (!this.isColumnVisible(this._firstColumn)) {
                    this._firstColumn = this.getNextVisibleColumn(this._firstColumn);
                }
                this.setFirstColumnOnScreen(this._firstColumn);
            }
        } else if (dimension2.width >= dimension.width && dimension.width != 0 && (n = this.getNextVisibleColumn(-1)) != -1) {
            this.setFirstColumnOnScreen(n);
        }
        if (this._firstRow != -1) {
            if (dimension.height != 0) {
                this.setFirstRowOnScreen(this._firstRow);
            }
        } else if (dimension2.height >= dimension.height && dimension.height != 0 && (n = this.getNextVisibleRow(-1)) != -1) {
            this.setFirstRowOnScreen(n);
        }
    }

    private void __setFocusCell(int n, int n2) {
        int n3 = this._focusColumn;
        int n4 = this._focusRow;
        if (n != n3 || n2 != n4) {
            this._focusColumn = n;
            this._focusRow = n2;
            this._fireActiveDescendantEvent(n3, n4, this._focusColumn, this._focusRow);
        }
    }

    private void _fireActiveDescendantEvent(int n, int n2, int n3, int n4) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (this.hasFocus() && accessibleContext != null) {
            AccessibleGrid accessibleGrid = (AccessibleGrid)accessibleContext;
            int n5 = accessibleGrid.getAccessibleIndexAt(n, n2);
            int n6 = accessibleGrid.getAccessibleIndexAt(n3, n4);
            accessibleGrid.firePropertyChange("AccessibleActiveDescendant", accessibleGrid.getAccessibleChild(n5), accessibleGrid.getAccessibleChild(n6));
        }
    }

    private void _fireVisibleDataProperty() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private void _fireSelectionProperty() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startCellEdit(int n, int n2) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            int n3 = this._focusColumn;
            int n4 = this._focusRow;
            if (this.isEditing() && n3 == n && n4 == n2) {
                return;
            }
        }
        object2 = this.getColumnCellInputHandler(n);
        Component component = ((CellInputHandler)object2).getEditControl(this, n, n2);
        if (component == null) {
            return;
        }
        if (this.fireCancelableCellEvent(n, n2, 2019)) {
            return;
        }
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            FocusUtils.setFocusTraversalKeysEnabled(component, false, true);
        }
        this._editControlChildren = this._getFocusableComponents(component);
        this._addListeners(this._editControlChildren);
        component.setVisible(false);
        this.add(component);
        this._editControl = component;
        AppearanceManager appearanceManager = this.getAppearanceManager();
        Appearance appearance = appearanceManager.getCellPaintingAppearance(n, n2);
        component.setFont(appearance.getFont());
        if (component instanceof LWComponent) {
            object = (LWComponent)component;
            ((LWComponent)object).setFill(new FGBGColorChange(FilledRectPainter.getPainter(), false));
            ((LWComponent)object).setAlignment(appearance.getHorizontalJustify());
            ((LWComponent)object).setReadingDirection(appearance.getReadingDirection());
        }
        this.requestFocus(n, n2, null);
        this.scrollCellIntoView(n, n2);
        object = this.getDataSource().getData(n, n2);
        try {
            ((CellInputHandler)object2).startEdit(this, n, n2, object);
        }
        catch (Exception exception) {
            this._doneEditing(false);
            return;
        }
        this._moveEditControl();
        if (component.isVisible()) {
            component.requestFocus();
        }
    }

    private Component[] _getFocusableComponents(Component component) {
        Component[] componentArray = new Component[]{};
        if (FocusUtils.isFocusable(component)) {
            componentArray = new Component[]{component};
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component[] componentArray2 = this._getFocusableComponents(container.getComponent(i));
                if (componentArray2.length <= 0) continue;
                int n2 = componentArray.length + componentArray2.length;
                Component[] componentArray3 = componentArray;
                componentArray = new Component[n2];
                System.arraycopy(componentArray3, 0, componentArray, 0, componentArray3.length);
                System.arraycopy(componentArray2, 0, componentArray, componentArray3.length, componentArray2.length);
            }
        }
        return componentArray;
    }

    private void _addListeners(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            component.addFocusListener(this._getFocusListener());
            component.addKeyListener(this._getKeyListener());
        }
    }

    private void _removeListeners(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            component.removeKeyListener(this._getKeyListener());
            component.removeFocusListener(this._getFocusListener());
        }
    }

    private class SeparatorAdapt
    extends AbstractPainter {
        private Separator _toAdapt;
        private boolean _horizontal;

        public SeparatorAdapt(Separator separator, boolean bl) {
            this._toAdapt = separator;
            this._horizontal = bl;
        }

        @Override
        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = this._toAdapt.getSize();
            if (this._horizontal) {
                this._toAdapt.paint(graphics, n, n2 += n5 / 2, n + n3 - 1, n2);
            } else {
                this._toAdapt.paint(graphics, n += n5 / 2, n2, n, n2 + n4 - 1);
            }
        }

        @Override
        public Dimension getMinimumSize(PaintContext paintContext) {
            int n = this._toAdapt.getSize();
            return new Dimension(n, n);
        }

        @Override
        public int getRepaintFlags(PaintContext paintContext) {
            return 0;
        }
    }

    private class PainterAdapter
    extends AbstractPainter {
        private CellPainter _toAdapt;
        private final Dimension _minSize = new Dimension(0, 0);

        public PainterAdapter(CellPainter cellPainter) {
            this._toAdapt = cellPainter;
        }

        @Override
        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Appearance appearance = (Appearance)paintContext.getPaintData(Grid.APPEARANCE_KEY);
            if (appearance == null) {
                return;
            }
            Object object = paintContext.getPaintData(null);
            boolean bl = (paintContext.getPaintState() & 0x80) != 0;
            this._toAdapt.paint(graphics, n, n2, n3, n4, object, appearance, bl);
        }

        @Override
        public Dimension getMinimumSize(PaintContext paintContext) {
            return this._minSize;
        }

        @Override
        public int getRepaintFlags(PaintContext paintContext) {
            return 0;
        }
    }

    private class CellPaintContext
    extends PaintContextProxy {
        private int _column;
        private int _row;
        private PaintContext _context;

        public CellPaintContext(PaintContext paintContext, int n, int n2) {
            this._context = paintContext;
            this.setCell(n, n2);
        }

        public void setCell(int n, int n2) {
            this._column = n;
            this._row = n2;
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._context;
        }

        @Override
        public int getPaintState() {
            int n = super.getPaintState();
            GridSelection gridSelection = Grid.this.getGridSelection();
            if (Grid.this.isEnabled() && (gridSelection.isCellSelected(this._column, this._row) || gridSelection.isColumnSelected(this._column) || gridSelection.isRowSelected(this._row)) && (!Grid.this.isEditing() || this._column != Grid.this._focusColumn || this._row != Grid.this._focusRow)) {
                n |= 0x80;
            }
            return Grid.this.getCellPaintState(n, this._column, this._row);
        }

        @Override
        public Color getPaintForeground() {
            int n = this.getPaintState();
            if ((n & 0x80) == 0) {
                return this.getAppearance().getForeground();
            }
            return this.getAppearance().getSelectForeground();
        }

        @Override
        public Color getPaintBackground() {
            Color color;
            int n = this.getPaintState();
            GridUI gridUI = (GridUI)Grid.this.getUI();
            if ((n & 0x80) != 0) {
                color = this.getAppearance().getSelectBackground();
                color = gridUI.getSelectionBackgroundColor(Grid.this, color);
            } else {
                color = (n & 1) != 0 ? gridUI.getDisabledBackgroundColor(Grid.this) : this.getAppearance().getBackground();
            }
            return color;
        }

        @Override
        public Font getPaintFont() {
            int n = this.getPaintState();
            Font font = null;
            if ((n & 0x80) != 0) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        @Override
        public float getInteriorAlignmentX() {
            float f;
            Appearance appearance = this.getAppearance();
            int n = appearance.getHorizontalJustify();
            if (n == 0) {
                int n2 = appearance.getReadingDirection();
                switch (n2) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                n = LocaleUtils.getAlignmentForReadingDirection(n2);
            }
            switch (n) {
                case 3: {
                    f = 0.5f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            return f;
        }

        @Override
        public float getInteriorAlignmentY() {
            int n = this.getAppearance().getVerticalJustify();
            float f = 0.0f;
            switch (n) {
                case 1: {
                    f = 0.5f;
                    break;
                }
                case 0: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                }
            }
            return f;
        }

        @Override
        public int getReadingDirection() {
            int n = this.getAppearance().getReadingDirection();
            if (n == 0) {
                n = super.getReadingDirection();
            }
            return n;
        }

        @Override
        public Object getPaintData(Object object) {
            int n = this._column;
            if (object == ComponentUI.MNEMONIC_INDEX_KEY) {
                return null;
            }
            if (Grid.APPEARANCE_KEY.equals(object)) {
                return this.getAppearance();
            }
            if (Grid.CELL_KEY.equals(object)) {
                return new Cell(n, this._row);
            }
            Object object2 = super.getPaintData(object);
            if (object2 == null) {
                object2 = Grid.this.getDataSource().getData(n, this._row);
            }
            return object2;
        }

        public Appearance getAppearance() {
            AppearanceManager appearanceManager = Grid.this.getAppearanceManager();
            return appearanceManager.getCellPaintingAppearance(this._column, this._row);
        }
    }

    private class CellPrintPaintContext
    extends CellPaintContext {
        public CellPrintPaintContext(PaintContext paintContext, int n, int n2) {
            super(paintContext, n, n2);
        }

        @Override
        public int getPaintState() {
            return this.getPaintContext().getPaintState();
        }
    }

    private class DSListen
    implements TwoDDataSourceListener {
        private DSListen() {
        }

        @Override
        public void rowsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            Grid.this.internalRowsAdded(twoDDataSourceEvent);
        }

        @Override
        public void rowsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            Grid.this.internalRowsRemoved(twoDDataSourceEvent);
        }

        @Override
        public void invalidateRows(TwoDDataSourceEvent twoDDataSourceEvent) {
            Grid.this.internalInvalidateRows(twoDDataSourceEvent);
        }

        @Override
        public void columnsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            Grid.this.internalColumnsAdded(twoDDataSourceEvent);
        }

        @Override
        public void columnsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            Grid.this.internalColumnsRemoved(twoDDataSourceEvent);
        }

        @Override
        public void invalidateColumns(TwoDDataSourceEvent twoDDataSourceEvent) {
            Grid.this.internalInvalidateColumns(twoDDataSourceEvent);
        }

        @Override
        public void invalidateCells(TwoDDataSourceEvent twoDDataSourceEvent) {
            Grid.this.internalInvalidateCells(twoDDataSourceEvent);
        }
    }

    private class EditFocus
    extends FocusAdapter {
        private EditFocus() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Grid.this.focusLost(focusEvent);
            }
        }
    }
}

