/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;

public class SingleRowSelection
implements GridSelection {
    private Grid _grid;
    private int _row;

    @Override
    public void setParent(Grid grid) {
        this._row = -1;
        this._grid = grid;
    }

    @Override
    public void rowsAdded(int n, int n2) {
        if (this._row == -1 || this._row < n) {
            return;
        }
        this._row += n2;
    }

    @Override
    public void rowsRemoved(int n, int n2) {
        if (this._row == -1 || this._row < n) {
            return;
        }
        this._row = this._row < n + n2 ? -1 : (this._row -= n2);
    }

    @Override
    public void columnsAdded(int n, int n2) {
    }

    @Override
    public void columnsRemoved(int n, int n2) {
    }

    @Override
    public void selectAll() {
        this.deselectAll();
        this.setRowSelected(0, true);
    }

    @Override
    public void deselectAll() {
        if (this._row != -1) {
            this.setRowSelected(this._row, false);
        }
    }

    @Override
    public boolean isSomethingSelected() {
        return this._row != -1;
    }

    @Override
    public void setColumnSelected(int n, boolean bl) {
    }

    @Override
    public boolean isColumnSelected(int n) {
        return false;
    }

    @Override
    public int[] getSelectedColumns() {
        return null;
    }

    @Override
    public void setRowSelected(int n, boolean bl) {
        if (this.isRowSelected(n) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableRowEvent(n, 2005)) {
                return;
            }
            this.deselectAll();
            if (this._row != -1) {
                return;
            }
            this._row = n;
            this._grid.fireRowEvent(n, 2006);
        } else {
            if (this._grid.fireCancelableRowEvent(n, 2007)) {
                return;
            }
            this._row = -1;
            this._grid.fireRowEvent(n, 2008);
        }
        this._grid.paintRow(n);
    }

    @Override
    public boolean isRowSelected(int n) {
        return this._row == n;
    }

    @Override
    public int[] getSelectedRows() {
        if (this._row == -1) {
            return null;
        }
        int[] nArray = new int[]{this._row};
        return nArray;
    }

    @Override
    public void setCellSelected(int n, int n2, boolean bl) {
        this.setRowSelected(n2, bl);
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        return this.isRowSelected(n2);
    }

    @Override
    public Cell[] getSelectedCells() {
        return null;
    }

    @Override
    public void selectCellRange(int n, int n2, int n3, int n4) {
        this.setRowSelected(n2, true);
    }

    @Override
    public void addCellToSelection(int n, int n2) {
        this.setRowSelected(n2, true);
    }

    @Override
    public void removeCellFromSelection(int n, int n2) {
        this.setRowSelected(n2, false);
    }
}

