/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid.hGrid;

import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.grid.AccessibleGrid;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.hGrid.HDataObject;

public class AccessibleHGrid
extends AccessibleGrid {
    public AccessibleHGrid(Grid grid) {
        super(grid);
    }

    @Override
    protected String getAccessibleName(int n, int n2, Object object) {
        if (object instanceof HDataObject) {
            object = ((HDataObject)object).getData();
        }
        return super.getAccessibleName(n, n2, object);
    }

    @Override
    protected AccessibleGrid.AccessibleCell createAccessibleCell(int n) {
        return new AccessibleHGridCell(n);
    }

    private class AccessibleHGridCell
    extends AccessibleGrid.AccessibleCell {
        public AccessibleHGridCell(int n) {
            super(n);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            HDataObject hDataObject;
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            int n = this.getAccessibleIndexInParent();
            int n2 = AccessibleHGrid.this.getAccessibleRowAtIndex(n);
            int n3 = AccessibleHGrid.this.getAccessibleColumnAtIndex(n);
            Object object = AccessibleHGrid.this.getGrid().getDataSource().getData(n3, n2);
            if (object instanceof HDataObject && (hDataObject = (HDataObject)object).hasChildren()) {
                accessibleStateSet.add(AccessibleState.EXPANDABLE);
                if (hDataObject.isExpanded()) {
                    accessibleStateSet.add(AccessibleState.EXPANDED);
                } else {
                    accessibleStateSet.add(AccessibleState.COLLAPSED);
                }
            }
            return accessibleStateSet;
        }
    }
}

