/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid.hGrid;

import java.util.Enumeration;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.grid.hGrid.HDataObject;
import oracle.ewt.grid.hGrid.HTwoDDataSource;

public class HArrayTwoDDataSource
implements HTwoDDataSource {
    public static final int ROW_NOT_VISIBLE = -1;
    public static final int ROOT_PARENT_INDEX = -1;
    private int[] _visibleToStoreTable;
    private ArrayTwoDDataSource _store;
    private ListenerManager _listeners;

    public HArrayTwoDDataSource(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Must have at least one column");
        }
        this._store = new ArrayTwoDDataSource(n, 0);
        this.addRowsAtDepth(0, n2, 0, -1);
    }

    @Override
    public int getColumnCount() {
        return this._store.getColumnCount();
    }

    @Override
    public final int getRowCount() {
        if (this._visibleToStoreTable == null) {
            return 0;
        }
        return this._visibleToStoreTable.length;
    }

    @Override
    public final Object getData(int n, int n2) {
        return this.getExpandedData(n, this._visibleToStoreTable[n2]);
    }

    @Override
    public final void setData(int n, int n2, Object object) {
        this.setExpandedData(n, this._visibleToStoreTable[n2], object);
    }

    @Override
    public final void expandRow(int n, int n2) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        this.expandExpandedRow(this._visibleToStoreTable[n2]);
    }

    @Override
    public final void collapseRow(int n, int n2) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        this.collapseExpandedRow(this._visibleToStoreTable[n2]);
    }

    public int getExpandedRowCount() {
        return this._store.getRowCount();
    }

    public Object getExpandedData(int n, int n2) {
        return this._store.getData(n, n2);
    }

    public void setExpandedData(int n, int n2, Object object) {
        if (n == 0) {
            Data data = this._getRowHData(n2);
            data._data = object;
            object = data;
        }
        this.setStoreData(n, n2, object);
    }

    public void expandExpandedRow(int n) {
        Data data = this._getRowHData(n);
        if (data.isExpanded()) {
            return;
        }
        data._expanded = true;
        this.sendCellInvalidateEvent(0, n);
        if (!this.isRowVisible(n)) {
            return;
        }
        if (data._hasChildren) {
            int n2 = this._getVisibleDescendantCount(n);
            int n3 = this.getVisibleIndex(n) + 1;
            this._expandTable(n3, n2);
            int[] nArray = this._visibleToStoreTable;
            int n4 = data.getDepth();
            int n5 = this.getExpandedRowCount();
            int n6 = n3;
            while (++n < n5 && (data = this._getRowHData(n)).getDepth() > n4) {
                nArray[n6++] = n;
                if (!data.hasChildren() || data.isExpanded()) continue;
                n += this.getDescendantCount(n);
            }
            if (this._listeners != null) {
                TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2004, n3, n2);
                this.processTwoDDataSourceEvent(twoDDataSourceEvent);
            }
        }
    }

    public void collapseExpandedRow(int n) {
        Data data = this._getRowHData(n);
        if (!data.isExpanded()) {
            return;
        }
        if (!this.isRowVisible(n)) {
            data._expanded = false;
            return;
        }
        int n2 = -1;
        int n3 = -1;
        if (data._hasChildren) {
            n2 = this._getVisibleDescendantCount(n);
            n3 = this.getVisibleIndex(n) + 1;
            this._shrinkTable(n3, n2);
        }
        data._expanded = false;
        if (n2 != -1 && this._listeners != null) {
            TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2005, n3, n2);
            this.processTwoDDataSourceEvent(twoDDataSourceEvent);
        }
        this.sendCellInvalidateEvent(0, n);
    }

    public int getExpandedIndex(int n) {
        return this._visibleToStoreTable[n];
    }

    public int getVisibleIndex(int n) {
        if (!this.isRowVisible(n)) {
            return -1;
        }
        int n2 = this._findNewVisibleIndex(n);
        return n2;
    }

    @Override
    public void addDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(twoDDataSourceListener);
    }

    @Override
    public void removeDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        this._listeners.removeListener(twoDDataSourceListener);
    }

    public void addChildrenRows(int n, int n2) {
        this.addRowsAtDepth(n + 1, n2, this._getRowDepth(n) + 1, n);
    }

    public void addRootRows(int n, int n2) {
        if (n < this.getExpandedRowCount() && this._getRowDepth(n) > 0) {
            throw new IllegalArgumentException("Can't insert root item here");
        }
        this.addRowsAtDepth(n, n2, 0, -1);
    }

    public int addSiblingRows(int n, int n2) {
        int n3 = this._getRowDepth(n);
        int n4 = this.getParentRow(n);
        n += this.getDescendantCount(n) + 1;
        this.addRowsAtDepth(n, n2, n3, n4);
        return n;
    }

    public int removeRows(int n, int n2) {
        Data data;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = this._getRowDepth(n);
        int n9 = n;
        int n10 = this.getVisibleIndex(n);
        int n11 = this.getParentRow(n);
        for (n6 = 0; n6 < n2; ++n6) {
            if (this._getRowDepth(n9) != n8) {
                throw new IllegalArgumentException("Illegal numberOfRows");
            }
            n5 = this.getDescendantCount(n9) + 1;
            n9 += n5;
            n7 += n5;
        }
        n6 = 0;
        if (n10 != -1) {
            n5 = n + n7 - 1;
            n6 = this._findNewVisibleIndex(n5) - n10 + 1;
            if (!this.isRowVisible(n5)) {
                --n6;
            }
            this._shrinkTable(n10, n6);
        }
        int[] nArray = this._visibleToStoreTable;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            n3 = nArray[n4];
            if (n3 < n) continue;
            nArray[n4] = n3 - n7;
        }
        this._store.removeRows(n, n7);
        n4 = this._store.getRowCount();
        for (n3 = n; n3 < n4; ++n3) {
            data = this._getRowHData(n3);
            int n12 = data.getParentRow();
            if (n12 < n) continue;
            data._parentRow = n12 - n7;
        }
        if (n6 > 0 && this._listeners != null) {
            TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2005, n10, n6);
            this.processTwoDDataSourceEvent(twoDDataSourceEvent);
        }
        if (n11 != -1) {
            boolean bl;
            if (this.getExpandedRowCount() - 1 == n11) {
                bl = true;
            } else {
                boolean bl2 = bl = this._getRowDepth(n11 + 1) != n8;
            }
            if (bl) {
                data = this._getRowHData(n11);
                data._hasChildren = false;
                if (!data._claimHasChildren) {
                    this.sendCellInvalidateEvent(0, n11);
                }
            }
        }
        return n7;
    }

    public void claimRowHasChildren(int n, boolean bl) {
        Data data = this._getRowHData(n);
        boolean bl2 = data.hasChildren();
        data._claimHasChildren = bl;
        if (bl2 != data.hasChildren()) {
            this.sendCellInvalidateEvent(0, n);
        }
    }

    public int getParentRow(int n) {
        return this._getRowHData(n).getParentRow();
    }

    public boolean isRowVisible(int n) {
        while (n >= 0) {
            if ((n = this.getParentRow(n)) == -1 || this._getRowHData(n).isExpanded()) continue;
            return false;
        }
        return true;
    }

    public int getDescendantCount(int n) {
        int n2 = this._getRowDepth(n);
        int n3 = this.getExpandedRowCount();
        int n4 = 0;
        while (++n < n3 && this._getRowDepth(n) > n2) {
            ++n4;
        }
        return n4;
    }

    protected void addRowsAtDepth(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n2 == 0) {
            return;
        }
        if (n < this.getExpandedRowCount() && this._getRowDepth(n) > n3) {
            throw new IllegalArgumentException();
        }
        if (n4 == -1) {
            if (n3 != 0) {
                throw new IllegalArgumentException();
            }
        } else {
            Data data = this._getRowHData(n4);
            n6 = data.getDepth();
            if (n6 != n3 - 1) {
                throw new IllegalArgumentException();
            }
            if (!data._hasChildren) {
                data._hasChildren = true;
                if (!data._claimHasChildren) {
                    this.sendCellInvalidateEvent(0, n4);
                }
            }
        }
        this._store.addRows(n, n2);
        for (int i = 0; i < n2; ++i) {
            Data data = new Data(n3, n4);
            this._store.setData(0, n + i, data);
        }
        int[] nArray = this._visibleToStoreTable;
        if (nArray != null) {
            for (n6 = 0; n6 < nArray.length; ++n6) {
                n5 = nArray[n6];
                if (n5 < n) continue;
                nArray[n6] = n5 + n2;
            }
        }
        n6 = this._store.getRowCount();
        for (n5 = n + n2; n5 < n6; ++n5) {
            Data data = this._getRowHData(n5);
            int n7 = data.getParentRow();
            if (n7 < n) continue;
            data._parentRow = n7 + n2;
        }
        if (this.isRowVisible(n)) {
            n5 = n > 0 ? this._findNewVisibleIndex(n) : 0;
            this._expandTable(n5, n2);
            nArray = this._visibleToStoreTable;
            for (int i = 0; i < n2; ++i) {
                nArray[n5 + i] = n + i;
            }
            if (this._listeners != null) {
                TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2004, n5, n2);
                this.processTwoDDataSourceEvent(twoDDataSourceEvent);
            }
        }
    }

    protected void setStoreData(int n, int n2, Object object) {
        this._store.setData(n, n2, object);
        this.sendCellInvalidateEvent(n, n2);
    }

    protected void sendCellInvalidateEvent(int n, int n2) {
        if (this._listeners == null) {
            return;
        }
        int n3 = this.getVisibleIndex(n2);
        if (n3 != -1) {
            TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2007, n, 1, n3, 1);
            this.processTwoDDataSourceEvent(twoDDataSourceEvent);
        }
    }

    protected void processTwoDDataSourceEvent(TwoDDataSourceEvent twoDDataSourceEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
                switch (twoDDataSourceEvent.getID()) {
                    case 2004: {
                        twoDDataSourceListener.rowsAdded(twoDDataSourceEvent);
                        break;
                    }
                    case 2005: {
                        twoDDataSourceListener.rowsRemoved(twoDDataSourceEvent);
                        break;
                    }
                    case 2007: {
                        twoDDataSourceListener.invalidateCells(twoDDataSourceEvent);
                        break;
                    }
                }
            }
        }
    }

    private Data _getRowHData(int n) {
        return (Data)this.getExpandedData(0, n);
    }

    private int _getRowDepth(int n) {
        return ((HDataObject)this.getExpandedData(0, n)).getDepth();
    }

    private void _shrinkTable(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int[] nArray = this._visibleToStoreTable;
        int n3 = nArray == null ? 0 : nArray.length;
        int[] nArray2 = new int[n3 - n2];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        System.arraycopy(nArray, n + n2, nArray2, n, n3 - n2 - n);
        this._visibleToStoreTable = nArray2;
    }

    private void _expandTable(int n, int n2) {
        int[] nArray = this._visibleToStoreTable;
        int n3 = nArray == null ? 0 : nArray.length;
        int[] nArray2 = new int[n3 + n2];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n3 > n) {
            System.arraycopy(nArray, n, nArray2, n + n2, n3 - n);
        }
        this._visibleToStoreTable = nArray2;
    }

    private int _findNewVisibleIndex(int n) {
        int[] nArray = this._visibleToStoreTable;
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n > nArray[i]) continue;
            return i;
        }
        return n2;
    }

    private int _getVisibleDescendantCount(int n) {
        Data data;
        if (!this._getRowHData(n).isExpanded()) {
            return 0;
        }
        int n2 = this._getRowDepth(n);
        int n3 = this.getExpandedRowCount();
        int n4 = 0;
        while (++n < n3 && (data = this._getRowHData(n)).getDepth() > n2) {
            ++n4;
            if (!data._hasChildren || data.isExpanded()) continue;
            n += this.getDescendantCount(n);
        }
        return n4;
    }

    private final class Data
    implements HDataObject {
        Object _data;
        boolean _expanded;
        boolean _hasChildren;
        boolean _claimHasChildren;
        int _parentRow;
        private int _depth;

        public Data(int n, int n2) {
            this._depth = n;
            this._parentRow = n2;
        }

        @Override
        public Object getData() {
            return this._data;
        }

        @Override
        public int getDepth() {
            return this._depth;
        }

        @Override
        public boolean isExpanded() {
            return this._expanded;
        }

        @Override
        public boolean hasChildren() {
            return this._hasChildren || this._claimHasChildren;
        }

        public int getParentRow() {
            return this._parentRow;
        }
    }
}

