/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.header;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import oracle.ewt.EwtComponent;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.EmptyOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.header.AccessibleHeader;
import oracle.ewt.header.AutoScroller;
import oracle.ewt.header.GeometryManager;
import oracle.ewt.header.HeaderEvent;
import oracle.ewt.header.HeaderFocusListener;
import oracle.ewt.header.HeaderItemInputHandler;
import oracle.ewt.header.HeaderItemPainter;
import oracle.ewt.header.HeaderKeyHandler;
import oracle.ewt.header.HeaderMoveListener;
import oracle.ewt.header.HeaderResizeListener;
import oracle.ewt.header.HeaderScrollListener;
import oracle.ewt.header.HeaderSelectListener;
import oracle.ewt.header.HeaderSelection;
import oracle.ewt.header.HeaderValidateEvent;
import oracle.ewt.header.Mover;
import oracle.ewt.header.NullInputHandler;
import oracle.ewt.header.SelectionAutoScroller;
import oracle.ewt.header.SingleItemSelection;
import oracle.ewt.header.StandardHeaderKeyHandler;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.TableHeaderUI;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;

public class Header
extends EwtComponent {
    public static final Object KEY_APPEARANCE = "header.Appearance";
    public static final Object KEY_DRAW_RAISED = "header.drawRaised";
    private static final char _NONE = '\u0000';
    private static final char _RESIZE = '\u0001';
    private static final char _MOVE = '\u0002';
    private static final char _CANCEL = '\u0003';
    private static final int _TARGET = 5;
    private boolean _firstEdge;
    private boolean _lastEdge;
    private HeaderItemPainter _itemPainter;
    private Painter _defaultPainter;
    private BorderPainter _borderPainter;
    private BorderPainter _firstBorderPainter;
    private BorderPainter _lastBorderPainter;
    private HeaderItemInputHandler _inputHandler;
    private ArrayOneDDataSource _itemGraphics;
    private ArrayOneDDataSource _itemPainters;
    private ArrayOneDDataSource _painters;
    private ArrayOneDDataSource _notmovable;
    private ArrayOneDDataSource _notresizable;
    private OneDDataSource _ds;
    private DSListen _dsListener;
    private GeometryManager _gm;
    private Appearance _appearanceObject;
    private HeaderKeyHandler _keyHandler;
    private int _mouseItem = -1;
    private int _moveItem = -1;
    private int _anchorItem = -1;
    private int _focusItem = -1;
    private int _armedItem = -1;
    private char _state = '\u0000';
    private boolean _isHorizontal;
    private boolean _drawSelected;
    private boolean _drawRaised;
    private boolean _canMove;
    private boolean _canResize;
    private int _redrawInfo = -1;
    private int _outlinePosition = -1;
    private int _outlineOffset = -1;
    private HeaderSelection _headerSelection;
    private boolean _scrollByItem;
    private Adjustable _adjustable;
    private ListenerManager _selectListeners;
    private ListenerManager _resizeListeners;
    private ListenerManager _moveListeners;
    private ListenerManager _scrollListeners;
    private ListenerManager _focusListeners;
    private int _firstItem = -1;
    private AccessibleHeader _accessibleHeader;

    public Header() {
        this(null);
    }

    public Header(OneDDataSource oneDDataSource) {
        this(oneDDataSource, true);
    }

    public Header(OneDDataSource oneDDataSource, boolean bl) {
        if (oneDDataSource == null) {
            oneDDataSource = EmptyOneDDataSource.getOneDDataSource();
        }
        this._isHorizontal = bl;
        this._ds = oneDDataSource;
        this._dsListener = new DSListen();
        this._ds.addDataSourceListener(this._dsListener);
        this._gm = new GeometryManager(this._ds.getItemCount());
        if (bl) {
            this._gm.setReadingDirection(this.getActualReadingDirection());
        }
        this._canResize = true;
        this._canMove = true;
        this._drawSelected = true;
        this._drawRaised = true;
        this._scrollByItem = true;
        long l = 60L;
        this.enableEvents(l);
        this.updateUI(Header.class);
    }

    @Override
    public Object getUIClassID() {
        return "TableHeaderUI";
    }

    public BorderPainter getHeaderItemBorderPainter() {
        if (this._borderPainter == null) {
            TableHeaderUI tableHeaderUI = (TableHeaderUI)this.getUI();
            this._borderPainter = tableHeaderUI.getHeaderItemBorderPainter(this);
        }
        return this._borderPainter;
    }

    public void setHeaderItemBorderPainter(BorderPainter borderPainter) {
        if (this._borderPainter != borderPainter) {
            this._borderPainter = borderPainter;
            this.invalidate();
            this.repaint();
        }
    }

    public BorderPainter getFirstItemBorderPainter() {
        if (this._firstBorderPainter == null) {
            TableHeaderUI tableHeaderUI = (TableHeaderUI)this.getUI();
            this._firstBorderPainter = tableHeaderUI.getFirstItemBorderPainter(this);
        }
        return this._firstBorderPainter;
    }

    public void setFirstItemBorderPainter(BorderPainter borderPainter) {
        if (this._firstBorderPainter != borderPainter) {
            this._firstBorderPainter = borderPainter;
            this.invalidate();
            this.repaint();
        }
    }

    public BorderPainter getLastItemBorderPainter() {
        if (this._lastBorderPainter == null) {
            TableHeaderUI tableHeaderUI = (TableHeaderUI)this.getUI();
            this._lastBorderPainter = tableHeaderUI.getLastItemBorderPainter(this);
        }
        return this._lastBorderPainter;
    }

    public void setLastItemBorderPainter(BorderPainter borderPainter) {
        if (this._lastBorderPainter != borderPainter) {
            this._lastBorderPainter = borderPainter;
            this.invalidate();
            this.repaint();
        }
    }

    public void setFirstEdge(boolean bl) {
        if (bl != this._firstEdge) {
            this._firstEdge = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isFirstEdge() {
        return this._firstEdge;
    }

    public void setLastEdge(boolean bl) {
        if (this._lastEdge != bl) {
            this._lastEdge = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isLastEdge() {
        return this._lastEdge;
    }

    public synchronized void addSelectListener(HeaderSelectListener headerSelectListener) {
        if (this._selectListeners == null) {
            this._selectListeners = new ListenerManager();
        }
        this._selectListeners.addListener(headerSelectListener);
    }

    public synchronized void removeSelectListener(HeaderSelectListener headerSelectListener) {
        if (this._selectListeners != null) {
            this._selectListeners.removeListener(headerSelectListener);
        }
    }

    public synchronized void addResizeListener(HeaderResizeListener headerResizeListener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener(headerResizeListener);
    }

    public synchronized void removeResizeListener(HeaderResizeListener headerResizeListener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener(headerResizeListener);
        }
    }

    public synchronized void addMoveListener(HeaderMoveListener headerMoveListener) {
        if (this._moveListeners == null) {
            this._moveListeners = new ListenerManager();
        }
        this._moveListeners.addListener(headerMoveListener);
    }

    public synchronized void removeMoveListener(HeaderMoveListener headerMoveListener) {
        if (this._moveListeners != null) {
            this._moveListeners.removeListener(headerMoveListener);
        }
    }

    public synchronized void addScrollListener(HeaderScrollListener headerScrollListener) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new ListenerManager();
        }
        this._scrollListeners.addListener(headerScrollListener);
    }

    public synchronized void removeScrollListener(HeaderScrollListener headerScrollListener) {
        if (this._scrollListeners != null) {
            this._scrollListeners.removeListener(headerScrollListener);
        }
    }

    public synchronized void addFocusListener(HeaderFocusListener headerFocusListener) {
        if (this._focusListeners == null) {
            this._focusListeners = new ListenerManager();
        }
        this._focusListeners.addListener(headerFocusListener);
    }

    public synchronized void removeFocusListener(HeaderFocusListener headerFocusListener) {
        if (this._focusListeners != null) {
            this._focusListeners.removeListener(headerFocusListener);
        }
    }

    public synchronized void setItemVisibleIndex(int n, int n2) {
        if (this.getItemVisibleIndex(n) != n2) {
            int n3 = this._gm.getItemPosition(n);
            boolean bl = this.isItemOnScreen(n);
            this._gm.setItemVisibleIndex(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            boolean bl2 = this.isItemOnScreen(n);
            if (bl || bl2) {
                if (!bl2 || !bl) {
                    this.repaintCanvas();
                } else {
                    dimension = this.getInnerSize();
                    int n4 = this._gm.getItemPosition(n);
                    if (n3 < n4) {
                        n4 = n3;
                    }
                    Point point = this.getCanvasOrigin();
                    if (this.isHorizontal()) {
                        this.repaintCanvas(n4, -point.y, dimension.width, dimension.height);
                    } else {
                        this.repaintCanvas(-point.x, n4, dimension.width, dimension.height);
                    }
                }
            }
            this._fireVisibleDataChanged();
        }
    }

    public int getItemVisibleIndex(int n) {
        return this._gm.convertDSIndexToVIndex(n);
    }

    public int getItemCount() {
        return this._ds.getItemCount();
    }

    public boolean isHorizontal() {
        return this._isHorizontal;
    }

    public boolean getDrawSelected() {
        return this._drawSelected;
    }

    public void setDrawSelected(boolean bl) {
        if (this.getDrawSelected() != bl) {
            this._drawSelected = bl;
            this.repaintCanvas();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setDrawRaised(boolean bl) {
        if (bl != this.getDrawRaised()) {
            this._drawRaised = bl;
            this.repaintCanvas();
        }
    }

    public void setHeaderSelection(HeaderSelection headerSelection) {
        if (this._headerSelection != null) {
            this._headerSelection.setParent(null);
        }
        this._headerSelection = headerSelection;
        this._headerSelection.setParent(this);
        this.repaintCanvas();
    }

    public HeaderSelection getHeaderSelection() {
        if (this._headerSelection == null) {
            this._headerSelection = new SingleItemSelection();
            this._headerSelection.setParent(this);
        }
        return this._headerSelection;
    }

    public int getOnScreenItemCount() {
        int n;
        int n2 = this.getFirstItemOnScreen();
        int n3 = this.getItemCount();
        if (n3 == 0 || n2 == -1) {
            return 0;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        int n4 = 0;
        point.x = -point.x;
        point.y = -point.y;
        if (this.isHorizontal()) {
            n = point.x + dimension2.width;
            if (n > dimension.width) {
                n = dimension.width;
            }
        } else {
            n = point.y + dimension2.height;
            if (n > dimension.height) {
                n = dimension.height;
            }
        }
        for (int i = this._gm.convertDSIndexToVIndex(n2); i < n3; ++i) {
            int n5 = this._gm.convertVIndexToDSIndex(i);
            if (!this._gm.isItemVisible(n5)) continue;
            int n6 = this._gm.getItemPosition(n5);
            if (n6 >= n) break;
            ++n4;
        }
        return n4;
    }

    public void setFirstItemOnScreen(int n) {
        int n2;
        if (n < 0 || n >= this.getItemCount() || !this._gm.isItemVisible(n)) {
            throw new IllegalArgumentException();
        }
        if (this.isHorizontal()) {
            if (this.getCanvasWidth() == 0) {
                this._firstItem = n;
                return;
            }
        } else if (this.getCanvasHeight() == 0) {
            this._firstItem = n;
            return;
        }
        this._firstItem = -1;
        Point point = this.getCanvasOrigin();
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!this.isItemVisible(n2)) continue;
            ++n3;
        }
        if (this.isHorizontal()) {
            n2 = this.getHOffsetOfValue(n3);
            this.setCanvasOrigin(n2, point.y);
        } else {
            n2 = this.getVOffsetOfValue(n3);
            this.setCanvasOrigin(point.x, n2);
        }
    }

    public int getFirstItemOnScreen() {
        if (this._firstItem != -1) {
            return this._firstItem;
        }
        Point point = this.getCanvasOrigin();
        if (this.isHorizontal()) {
            return this._gm.getItemAt(-point.x);
        }
        return this._gm.getItemAt(-point.y);
    }

    public boolean getCanResizeItems() {
        return this._canResize;
    }

    public void setCanResizeItems(boolean bl) {
        this._canResize = bl;
    }

    public boolean getCanMoveItems() {
        return this._canMove;
    }

    public void setCanMoveItems(boolean bl) {
        this._canMove = bl;
    }

    public boolean isItemMovable(int n) {
        if (!this.getCanMoveItems()) {
            return false;
        }
        if (this._notmovable == null) {
            return true;
        }
        Object object = this._notmovable.getData(n);
        return !Boolean.TRUE.equals(object);
    }

    public void setItemMovable(int n, boolean bl) {
        if (this._notmovable == null) {
            this._notmovable = new ArrayOneDDataSource(this.getItemCount());
        }
        Boolean bl2 = bl ? Boolean.FALSE : Boolean.TRUE;
        this._notmovable.setData(n, bl2);
    }

    public boolean isItemResizable(int n) {
        if (!this.getCanResizeItems()) {
            return false;
        }
        if (this._notresizable == null) {
            return true;
        }
        Object object = this._notresizable.getData(n);
        return !Boolean.TRUE.equals(object);
    }

    public void setItemResizable(int n, boolean bl) {
        if (this._notresizable == null) {
            this._notresizable = new ArrayOneDDataSource(this.getItemCount());
        }
        Boolean bl2 = bl ? Boolean.FALSE : Boolean.TRUE;
        this._notresizable.setData(n, bl2);
    }

    public void setHeaderKeyHandler(HeaderKeyHandler headerKeyHandler) {
        this._keyHandler = headerKeyHandler;
    }

    public HeaderKeyHandler getHeaderKeyHandler() {
        if (this._keyHandler == null) {
            this._keyHandler = StandardHeaderKeyHandler.getHeaderKeyHandler();
        }
        return this._keyHandler;
    }

    public int getFocusItem() {
        return this._focusItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFocusItem(int n) {
        if (n != this._focusItem) {
            this.freezeRepaints();
            try {
                if (this.fireCancelableEvent(2011, n)) {
                    boolean bl = false;
                    return bl;
                }
                int n2 = this._focusItem;
                if (n2 != -1) {
                    this.paintItem(n2);
                }
                this._focusItem = n;
                if (this._focusItem != -1) {
                    this.paintItem(this._focusItem);
                }
                if (this.getArmedItem() != -1) {
                    this.setArmedItem(-1);
                }
                this.fireEvent(2012, n);
                this._fireActiveEvent(n2, this._focusItem);
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        return true;
    }

    private void _fireActiveEvent(int n, int n2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleActiveDescendant", accessibleContext.getAccessibleChild(n), accessibleContext.getAccessibleChild(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCanvasSize(int n, int n2) {
        if (this.isHorizontal() && this.getActualReadingDirection() == 2) {
            int n3 = this.getCanvasSize().width;
            this.freezeRepaints();
            try {
                super.setCanvasSize(n, n2);
                int n4 = this.getInnerSize().width;
                if (n4 == 0) return;
                int n5 = this.getCanvasSize().width;
                Point point = this.getCanvasOrigin();
                if (n3 == 0) {
                    point.x = n4 - n5;
                } else {
                    point.x += n3 - n5;
                    if (point.x > 0) {
                        if (n5 > n4) {
                            point.x = 0;
                        } else if (point.x + n5 > n4) {
                            point.x = n4 - n5;
                        }
                    }
                }
                this.setCanvasOrigin(point.x, point.y);
                return;
            }
            finally {
                this.unfreezeRepaints();
            }
        } else {
            super.setCanvasSize(n, n2);
        }
    }

    @Override
    public void setCanvasOrigin(int n, int n2) {
        int n3;
        int n4;
        if (this.isHorizontal() && this.getActualReadingDirection() == 2 && n + (n4 = this.getCanvasSize().width) < (n3 = this.getInnerSize().width)) {
            n = n3 - n4;
        }
        super.setCanvasOrigin(n, n2);
        this._fireVisibleDataChanged();
    }

    @Override
    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this.isHorizontal()) {
            throw new ScrollableException();
        }
        this._adjustable = adjustable;
    }

    @Override
    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        if (!this.isHorizontal()) {
            throw new ScrollableException();
        }
        this._adjustable = adjustable;
    }

    @Override
    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (adjustable == this._adjustable) {
            this._adjustable = null;
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    @Override
    public Adjustable getHAdjustable() {
        return this.isHorizontal() ? this._adjustable : null;
    }

    @Override
    public Adjustable getVAdjustable() {
        return !this.isHorizontal() ? this._adjustable : null;
    }

    @Override
    public boolean isHScrollable() {
        return this.isHorizontal();
    }

    @Override
    public boolean isVScrollable() {
        return !this.isHorizontal();
    }

    public void setScrollByItem(boolean bl) {
        if (bl != this.getScrollByItem()) {
            this._scrollByItem = bl;
            Dimension dimension = this.getCanvasSize();
            this.setCanvasSize(dimension.width, dimension.height);
        }
    }

    public boolean getScrollByItem() {
        return this._scrollByItem;
    }

    public void setItemInputHandler(HeaderItemInputHandler headerItemInputHandler) {
        this._inputHandler = headerItemInputHandler;
    }

    public HeaderItemInputHandler getItemInputHandler() {
        if (this._inputHandler == null) {
            this._inputHandler = NullInputHandler.getHeaderItemInputHandler();
        }
        return this._inputHandler;
    }

    public final HeaderItemPainter getDefaultItemPainter() {
        return this._itemPainter;
    }

    public final void setDefaultItemPainter(HeaderItemPainter headerItemPainter) {
        if (headerItemPainter != this.getDefaultItemPainter()) {
            this._itemPainter = headerItemPainter;
        }
        this.setDefaultPainter(new PainterAdapter(headerItemPainter));
    }

    public void setDefaultPainter(Painter painter) {
        if (painter != this._defaultPainter) {
            this._defaultPainter = painter;
            this.repaintCanvas();
        }
    }

    public Painter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = ((TableHeaderUI)this.getUI()).getDefaultPainter(this);
        }
        return this._defaultPainter;
    }

    public final void setItemPainter(int n, HeaderItemPainter headerItemPainter) {
        if (this._itemPainters == null) {
            this._itemPainters = new ArrayOneDDataSource(this.getItemCount());
        }
        this._itemPainters.setData(n, headerItemPainter);
        this.setPainter(n, new PainterAdapter(headerItemPainter));
    }

    public final HeaderItemPainter getItemPainter(int n) {
        Object object;
        if (this._itemPainters != null && (object = this._itemPainters.getData(n)) != null) {
            return (HeaderItemPainter)object;
        }
        return this.getDefaultItemPainter();
    }

    public Painter getPainter(int n) {
        Object object;
        if (this._painters != null && (object = this._painters.getData(n)) != null) {
            return (Painter)object;
        }
        return this.getDefaultPainter();
    }

    public void setPainter(int n, Painter painter) {
        if (this._painters == null) {
            this._painters = new ArrayOneDDataSource(this.getItemCount());
        }
        this._painters.setData(n, painter);
    }

    public void setAppearance(Appearance appearance) {
        this._appearanceObject = appearance.copy();
        this.repaintCanvas();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public Appearance getItemAppearance(int n) {
        return this._getItemAppearance(n).copy();
    }

    public void setItemAppearance(int n, Appearance appearance) {
        if (this._itemGraphics == null) {
            this._itemGraphics = new ArrayOneDDataSource(this.getItemCount());
        }
        this._itemGraphics.setData(n, appearance.copy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemSize(int n, int n2) {
        this.freezeRepaints();
        try {
            if (this.getItemSize(n) != n2) {
                this._gm.setItemSize(n, n2);
                Dimension dimension = this.layoutCanvas();
                if (this._state == '\u0001') {
                    if (this.isHorizontal()) {
                        if (dimension.width > this.getCanvasSize().width || this.getActualReadingDirection() == 2) {
                            this.setCanvasSize(dimension.width, dimension.height);
                        }
                    } else if (dimension.height > this.getCanvasSize().height) {
                        this.setCanvasSize(dimension.width, dimension.height);
                    }
                } else {
                    this.setCanvasSize(dimension.width, dimension.height);
                }
                if (this.isItemOnScreen(n) && this.getActualReadingDirection() != 2) {
                    dimension = this.getInnerSize();
                    Point point = this.getCanvasOrigin();
                    int n3 = this._gm.getItemPosition(n);
                    if (this.isHorizontal()) {
                        if (n3 < -point.x) {
                            n3 = -point.x;
                        }
                        this.repaintCanvas(n3, -point.y, dimension.width, dimension.height);
                    } else {
                        if (n3 < -point.y) {
                            n3 = -point.y;
                        }
                        this.repaintCanvas(-point.x, n3, dimension.width, dimension.height);
                    }
                }
                this._fireVisibleDataChanged();
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public int getItemSize(int n) {
        return this._gm.getItemSize(n);
    }

    public void setItemVisible(int n, boolean bl) {
        if (bl) {
            this.setFocusItem(n);
        } else {
            this.setFocusItem(-1);
        }
        if (this.isItemVisible(n) != bl) {
            this._gm.setItemVisible(n, bl);
            this.invalidateCanvas();
            if (!bl) {
                HeaderSelection headerSelection = this.getHeaderSelection();
                headerSelection.setItemSelected(n, false);
            }
            this._fireVisibleDataChanged();
        }
    }

    public boolean isItemVisible(int n) {
        return this._gm.isItemVisible(n);
    }

    public boolean isItemOnScreen(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = this._gm.getItemPosition(n);
        int n3 = this._gm.getItemSize(n);
        point.x = -point.x;
        point.y = -point.y;
        if (this.isHorizontal()) {
            return n2 + n3 >= point.x && n2 < point.x + dimension.width;
        }
        return n2 + n3 >= point.y && n2 < point.y + dimension.height;
    }

    public int getItemAt(int n, int n2) {
        Point point = this.convertOuterToCanvas(n, n2);
        int n3 = this.isHorizontal() ? point.x : point.y;
        return this._gm.getItemAt(n3);
    }

    public int getItemPosition(int n) {
        return this._gm.getItemPosition(n);
    }

    public void setDefaultItemSize(int n) {
        this._gm.setDefaultItemSize(n);
        this.invalidateCanvas();
        this._fireVisibleDataChanged();
    }

    public int getDefaultItemSize() {
        return this._gm.getDefaultItemSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.getDefaultItemSize() != 0) {
            return;
        }
        if (this.isHorizontal()) {
            this.setDefaultItemSize(fontMetrics.stringWidth("eeeee"));
        } else {
            this.setDefaultItemSize(fontMetrics.getHeight() + 4);
        }
    }

    @Override
    public void removeNotify() {
        AutoScroller.getAutoScroller().cancel(this);
        SelectionAutoScroller.getSelectionAutoScroller().cancel(this);
        super.removeNotify();
    }

    public void paintItem(int n) {
        if (n >= this.getItemCount()) {
            return;
        }
        if (!this.isItemVisible(n)) {
            return;
        }
        this.validate();
        int n2 = this._gm.getItemPosition(n);
        int n3 = this._gm.getItemSize(n);
        Dimension dimension = this.getInnerSize();
        if (this.isHorizontal()) {
            this.paintImmediateCanvas(n2, 0, n3, dimension.height);
        } else {
            this.paintImmediateCanvas(0, n2, dimension.width, n3);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        this.validate();
        int n = 0;
        int n2 = 0;
        int n3 = this._gm.getVisibleItemCount();
        int n4 = this._gm.getTotalItemSize();
        int n5 = n4 == 0 ? this.getDefaultItemSize() : n4;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            if (this.isHorizontal()) {
                n2 = fontMetrics.getHeight() + 4;
            } else {
                n = fontMetrics.stringWidth("eeeee");
            }
        }
        if (this.isHorizontal()) {
            n = n5;
        } else {
            n2 = n5;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    @Override
    public Dimension getMinimumSize() {
        this.validate();
        int n = 0;
        int n2 = 0;
        int n3 = this._gm.getVisibleItemCount();
        int n4 = this._gm.getTotalItemSize();
        int n5 = n3 == 0 ? this.getDefaultItemSize() : n4 / n3;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            if (this.isHorizontal()) {
                n2 = fontMetrics.getHeight() + 4;
            } else {
                n = fontMetrics.stringWidth("eeeee");
            }
        }
        if (this.isHorizontal()) {
            n = n5;
        } else {
            n2 = n5;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    @Override
    public int getRepaintFlags() {
        return super.getRepaintFlags() | 1 | 4 | 0x20 | 0x80 | 0x100 | 0x200 | 0x400;
    }

    @Override
    public int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x4000;
    }

    public OneDDataSource getDataSource() {
        return this._ds;
    }

    public void setDataSource(OneDDataSource oneDDataSource) {
        OneDDataSource oneDDataSource2;
        if (oneDDataSource == null) {
            oneDDataSource = EmptyOneDDataSource.getOneDDataSource();
        }
        if (oneDDataSource != (oneDDataSource2 = this.getDataSource())) {
            oneDDataSource2.removeDataSourceListener(this._dsListener);
            oneDDataSource.addDataSourceListener(this._dsListener);
            this._ds = oneDDataSource;
            int n = this.getDefaultItemSize();
            this._gm = new GeometryManager(this._ds.getItemCount());
            this._gm.setDefaultItemSize(n);
            this._itemGraphics = null;
            this._itemPainters = null;
            this._painters = null;
            this._notmovable = null;
            this._notresizable = null;
            if (this._headerSelection != null) {
                this._headerSelection.setParent(null);
                this._headerSelection.setParent(this);
            }
            this._mouseItem = -1;
            this._moveItem = -1;
            this.setAnchorItem(-1);
            this.setArmedItem(-1);
            this.setFocusItem(-1);
            this._firstItem = Math.min(this._firstItem, oneDDataSource.getItemCount() - 1);
        }
        this.invalidateCanvas();
    }

    public PaintContext getItemPaintContext(int n) {
        return new ItemPaintContext(this.getPaintContext(), n);
    }

    @Override
    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this._paintHeader(graphics, paintContext);
    }

    public void scrollItemIntoView(int n) {
        int n2 = this._scrollItemIntoView(n);
        if (n2 == -1) {
            return;
        }
        if (this.fireCancelableEvent(2009, n2)) {
            return;
        }
        this.setFirstItemOnScreen(n2);
        this.fireEvent(2010, n2);
    }

    public AccessibleHeader getAccessibleHeader() {
        return this._accessibleHeader;
    }

    public int getPreviousVisibleItem(int n) {
        int n2 = n < this.getItemCount() ? this._gm.convertDSIndexToVIndex(n) : n;
        int n3 = n2 - 1;
        if (n3 < 0) {
            return -1;
        }
        while (n3 >= 0) {
            int n4 = this._gm.convertVIndexToDSIndex(n3);
            if (this._gm.isItemVisible(n4)) {
                return n4;
            }
            --n3;
        }
        return -1;
    }

    public int getNextVisibleItem(int n) {
        int n2 = n >= 0 ? this._gm.convertDSIndexToVIndex(n) : n;
        int n3 = this.getItemCount();
        for (int i = n2 + 1; i < n3; ++i) {
            int n4 = this._gm.convertVIndexToDSIndex(i);
            if (!this._gm.isItemVisible(n4)) continue;
            return n4;
        }
        return -1;
    }

    public final void fireEvent(int n, int n2) {
        HeaderEvent headerEvent = new HeaderEvent(this, n, n2);
        this.processEvent(headerEvent);
    }

    public final boolean fireCancelableEvent(int n, int n2) {
        HeaderValidateEvent headerValidateEvent = new HeaderValidateEvent(this, n, n2);
        this.processEvent(headerValidateEvent);
        return headerValidateEvent.isCancelled();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getInnerSize().width;
        super.reshape(n, n2, n3, n4);
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
        this._checkForFirstItem(dimension);
        if (this.isHorizontal() && this.getActualReadingDirection() == 2) {
            int n6 = dimension.width;
            int n7 = this.getInnerSize().width;
            Point point = this.getCanvasOrigin();
            int n8 = point.x;
            if (n5 <= 0) {
                n8 = n7 - n6;
            } else if (n5 != n7 && (n8 = point.x + n7 - n5) > 0) {
                if (n6 > n7) {
                    n8 = 0;
                } else if (n8 + n6 > n7) {
                    n8 = n7 - n6;
                }
            }
            this.setCanvasOrigin(n8, point.y);
        }
    }

    @Override
    protected final AccessibleContext createAccessibleContext() {
        if (this._accessibleHeader == null) {
            this._accessibleHeader = this.createAccessibleHeader();
        }
        return this._accessibleHeader;
    }

    protected AccessibleHeader createAccessibleHeader() {
        return new AccessibleHeader(this);
    }

    protected void paintFocusItem(PaintContext paintContext, Graphics graphics) {
        if (this.getFocusItem() != -1 && this.hasFocus()) {
            Rectangle rectangle = this.__getItemRect(paintContext, this.getFocusItem());
            if (rectangle == null) {
                return;
            }
            TableHeaderUI tableHeaderUI = (TableHeaderUI)this.getUI();
            BorderPainter borderPainter = tableHeaderUI.getFocusItemPainter(this);
            if (borderPainter != null) {
                borderPainter.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    @Override
    protected void updateReadingDirection(int n) {
        GeometryManager geometryManager;
        super.updateReadingDirection(n);
        if (this.isHorizontal() && (geometryManager = this._gm) != null) {
            int n2 = this.getFirstItemOnScreen();
            geometryManager.setReadingDirection(n);
            if (n2 != -1) {
                this.scrollItemIntoView(n2);
            }
        }
    }

    @Override
    protected Object getPaintData(Object object) {
        if (KEY_DRAW_RAISED.equals(object)) {
            return this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getPaintData(object);
    }

    protected int getItemPaintState(int n, int n2) {
        return n;
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == Header.class) {
            this.updateUI();
        }
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this._borderPainter = null;
        this._firstBorderPainter = null;
        this._lastBorderPainter = null;
        this._defaultPainter = null;
        this._appearanceObject = null;
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof HeaderEvent) {
            switch (aWTEvent.getID()) {
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processSelectEvent((HeaderEvent)aWTEvent);
                    break;
                }
                case 2005: 
                case 2006: {
                    this.processResizeEvent((HeaderEvent)aWTEvent);
                    break;
                }
                case 2007: 
                case 2008: {
                    this.processMoveEvent((HeaderEvent)aWTEvent);
                    break;
                }
                case 2009: 
                case 2010: {
                    this.processScrollEvent((HeaderEvent)aWTEvent);
                    break;
                }
                case 2011: 
                case 2012: {
                    this.processFocusItemEvent((HeaderEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processSelectEvent(HeaderEvent headerEvent) {
        int n = headerEvent.getID();
        if (this._selectListeners == null) {
            return;
        }
        Enumeration enumeration = this._selectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (n) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderSelectListener)enumeration.nextElement()).itemSelecting(headerEvent);
                }
                break;
            }
            case 2003: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderSelectListener)enumeration.nextElement()).itemDeselecting(headerEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderSelectListener)enumeration.nextElement()).itemSelected(headerEvent);
                }
                break;
            }
            case 2004: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderSelectListener)enumeration.nextElement()).itemDeselected(headerEvent);
                }
                break;
            }
        }
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }
    }

    protected void processResizeEvent(HeaderEvent headerEvent) {
        if (this._resizeListeners == null) {
            return;
        }
        Enumeration enumeration = this._resizeListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (headerEvent.getID()) {
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderResizeListener)enumeration.nextElement()).itemResizing(headerEvent);
                }
                break;
            }
            case 2006: {
                Dimension dimension = this.layoutCanvas();
                this.setCanvasSize(dimension.width, dimension.height);
                while (enumeration.hasMoreElements()) {
                    ((HeaderResizeListener)enumeration.nextElement()).itemResized(headerEvent);
                }
                break;
            }
        }
    }

    protected void processMoveEvent(HeaderEvent headerEvent) {
        int n = headerEvent.getID();
        if (this._moveListeners == null) {
            return;
        }
        Enumeration enumeration = this._moveListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (headerEvent.getID()) {
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderMoveListener)enumeration.nextElement()).itemMoving(headerEvent);
                }
                break;
            }
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderMoveListener)enumeration.nextElement()).itemMoved(headerEvent);
                }
                break;
            }
        }
    }

    protected void processScrollEvent(HeaderEvent headerEvent) {
        if (this._scrollListeners == null) {
            return;
        }
        Enumeration enumeration = this._scrollListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (headerEvent.getID()) {
            case 2009: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderScrollListener)enumeration.nextElement()).itemScrolling(headerEvent);
                }
                break;
            }
            case 2010: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderScrollListener)enumeration.nextElement()).itemScrolled(headerEvent);
                }
                break;
            }
        }
    }

    protected void processFocusItemEvent(HeaderEvent headerEvent) {
        if (this._focusListeners == null) {
            return;
        }
        Enumeration enumeration = this._focusListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (headerEvent.getID()) {
            case 2011: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderFocusListener)enumeration.nextElement()).focusItemChanging(headerEvent);
                }
                break;
            }
            case 2012: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderFocusListener)enumeration.nextElement()).focusItemChanged(headerEvent);
                }
                break;
            }
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        HeaderKeyHandler headerKeyHandler = this.getHeaderKeyHandler();
        headerKeyHandler.handleKeyEvent(this, keyEvent);
        int n = keyEvent.getKeyCode();
        int n2 = this.getFocusItem();
        if (keyEvent.isConsumed() || !keyEvent.isAltDown() || keyEvent.getID() != 401 || n2 == -1) {
            return;
        }
        int n3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((n3 & InputEventUtils.getMods(keyEvent)) != 0) {
            if (this.isItemMovable(n2)) {
                int n4 = this.getItemVisibleIndex(n2);
                if (this.isHorizontal() && n == 37 || !this.isHorizontal() && n == 38) {
                    if (n4 != 0 && !this.fireCancelableEvent(2007, n2)) {
                        this.setItemVisibleIndex(n2, n4 - 1);
                        this.fireEvent(2008, n2);
                    }
                } else if ((this.isHorizontal() && n == 39 || !this.isHorizontal() && n == 40) && n4 != this.getItemCount() - 1 && !this.fireCancelableEvent(2007, n2)) {
                    this.setItemVisibleIndex(n2, n4 + 1);
                    this.fireEvent(2008, n2);
                }
            }
        } else if (this.isItemResizable(n2)) {
            int n5 = this.getItemSize(n2);
            if (this.isHorizontal() && n == 37 || !this.isHorizontal() && n == 38) {
                if (n5 != 0 && !this.fireCancelableEvent(2005, n2)) {
                    this.setItemSize(n2, n5 - 1);
                    this.fireEvent(2006, n2);
                }
            } else if ((this.isHorizontal() && n == 39 || !this.isHorizontal() && n == 40) && !this.fireCancelableEvent(2005, n2)) {
                this.setItemSize(n2, n5 + 1);
                this.fireEvent(2006, n2);
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() != 1004) {
            return;
        }
        if (this.getFocusItem() == -1) {
            int n = this.getNextVisibleItem(-1);
            this.setFocusItem(n);
        } else {
            this._fireActiveEvent(-1, this.getFocusItem());
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            if (mouseEvent.getID() == 502) {
                AutoScroller.getAutoScroller().cancel();
                SelectionAutoScroller.getSelectionAutoScroller().cancel();
                Mover.getMover().cancel(this);
                this._resetFeedback();
                this._state = '\u0000';
                this.resetCursor();
                if (this.getArmedItem() != -1) {
                    int n = this.getArmedItem();
                    this.setArmedItem(-1);
                }
            }
            return;
        }
        if (!this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this._handleMousePressed(mouseEvent);
                break;
            }
            case 502: {
                AutoScroller.getAutoScroller().cancel();
                SelectionAutoScroller.getSelectionAutoScroller().cancel();
                this._handleMouseReleased(mouseEvent);
                break;
            }
            case 500: {
                this._handleMouseClicked(mouseEvent);
                break;
            }
            case 504: {
                this._handleMouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this._handleMouseExited(mouseEvent);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            Mover.getMover().cancel(this);
            return;
        }
        switch (mouseEvent.getID()) {
            case 506: {
                this._handleMouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this._handleMouseMoved(mouseEvent);
            }
        }
    }

    @Override
    protected int getHMaximum() {
        if (this.isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHMaximum();
            }
            return this._gm.getVisibleItemCount();
        }
        return 0;
    }

    @Override
    protected int getHValueOfOffset(int n) {
        if (this.isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHValueOfOffset(n);
            }
            GeometryManager geometryManager = this._gm;
            int n2 = geometryManager.getItemAt(-n);
            return geometryManager.convertDSIndexToVIndex(n2);
        }
        return 0;
    }

    @Override
    protected int getHOffsetOfValue(int n) {
        if (this.isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHOffsetOfValue(n);
            }
            int n2 = this._convertVisibleIndexToIndex(n);
            n2 = this._gm.convertVIndexToDSIndex(n2);
            int n3 = this._gm.getItemPosition(n2);
            int n4 = this.getCanvasSize().width;
            int n5 = this.getInnerSize().width;
            int n6 = 0;
            if (n4 > n5 && n4 != 0 && n5 != 0) {
                n6 = n5 - n4;
            }
            if (-n3 < n6) {
                n3 = -n6;
            }
            return -n3;
        }
        return 0;
    }

    @Override
    protected int getVMaximum() {
        if (!this.isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVMaximum();
            }
            return this._gm.getVisibleItemCount();
        }
        return 0;
    }

    @Override
    protected int getVValueOfOffset(int n) {
        if (!this.isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVValueOfOffset(n);
            }
            int n2 = this._gm.getItemAt(-n);
            return this._gm.convertDSIndexToVIndex(n2);
        }
        return 0;
    }

    @Override
    protected int getVOffsetOfValue(int n) {
        if (!this.isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVOffsetOfValue(n);
            }
            int n2 = this._convertVisibleIndexToIndex(n);
            n2 = this._gm.convertVIndexToDSIndex(n2);
            int n3 = this._gm.getItemPosition(n2);
            int n4 = this.getCanvasSize().height;
            int n5 = this.getInnerSize().height;
            int n6 = 0;
            if (n4 > n5 && n4 != 0 && n5 != 0) {
                n6 = n5 - n4;
            }
            if (-n3 < n6) {
                n3 = -n6;
            }
            return -n3;
        }
        return 0;
    }

    @Override
    protected Dimension layoutCanvas() {
        Dimension dimension = new Dimension();
        this._gm.setDefaultItemSize(this.getDefaultItemSize());
        if (this.isHorizontal()) {
            dimension.width = this._gm.doLayout();
            dimension.height = this.getInnerSize().height;
        } else {
            dimension.width = this.getInnerSize().width;
            dimension.height = this._gm.doLayout();
        }
        if (this._state != '\u0001') {
            this._checkForFirstItem(dimension);
        }
        return dimension;
    }

    protected void paintExtraCanvas(Graphics graphics, PaintContext paintContext, int n, int n2, int n3, int n4) {
        graphics.setColor(this.getAppearance().getBackground());
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        TableHeaderUI tableHeaderUI = (TableHeaderUI)this.getUI();
        Painter painter = tableHeaderUI.getExtraCanvasPainter(this);
        painter.paint(paintContext, graphics, n, n2, n3, n4);
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        this._paintHeader(graphics, this.getPaintContext());
    }

    protected void setMoveCursor() {
        if (!this.getCanMoveItems() || this._state == '\u0001') {
            return;
        }
        Cursor cursor = Cursor.getPredefinedCursor(13);
        Cursor cursor2 = this.getCursor();
        if (cursor2 != cursor) {
            this.setCursor(cursor);
        }
    }

    protected void setResizeCursor() {
        if (!this.getCanResizeItems() || this._state == '\u0002') {
            return;
        }
        Cursor cursor = this.isHorizontal() ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(9);
        Cursor cursor2 = this.getCursor();
        if (cursor2 != cursor) {
            this.setCursor(cursor);
        }
    }

    protected void resetCursor() {
        if (this._state == '\u0001' || this._state == '\u0002') {
            return;
        }
        Cursor cursor = Cursor.getDefaultCursor();
        Cursor cursor2 = this.getCursor();
        if (cursor2 != cursor) {
            this.setCursor(cursor);
        }
    }

    void attachAccessibleHeader(AccessibleHeader accessibleHeader) {
        if (this._accessibleHeader != null) {
            throw new IllegalStateException("Only one AccessibleHeader per Header");
        }
        this._accessibleHeader = accessibleHeader;
    }

    int getAnchorItem() {
        return this._anchorItem;
    }

    void setAnchorItem(int n) {
        this._anchorItem = n;
    }

    int getArmedItem() {
        return this._armedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setArmedItem(int n) {
        if (this._armedItem != n) {
            this.freezeRepaints();
            try {
                int n2 = this._armedItem;
                this._armedItem = n;
                if (n2 != -1) {
                    this._repaintIfNeeded(n2);
                }
                if (this._armedItem != -1) {
                    this._repaintIfNeeded(this._armedItem);
                }
            }
            finally {
                this.unfreezeRepaints();
            }
        }
    }

    void internalItemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
        int n = oneDDataSourceEvent.getStartIndex();
        int n2 = oneDDataSourceEvent.getItemCount();
        this.getHeaderSelection().itemsAdded(n, n2);
        this._gm.itemsAdded(n, n2);
        if (this._itemGraphics != null) {
            this._itemGraphics.addItems(n, n2);
        }
        if (this._itemPainters != null) {
            this._itemPainters.addItems(n, n2);
        }
        if (this._painters != null) {
            this._painters.addItems(n, n2);
        }
        if (this._notmovable != null) {
            this._notmovable.addItems(n, n2);
        }
        if (this._notresizable != null) {
            this._notresizable.addItems(n, n2);
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        boolean bl = this.getActualReadingDirection() == 1;
        int n3 = this.isHorizontal() ? -this.getCanvasOriginX() + this.getInnerWidth() : -this.getCanvasOriginY() + this.getInnerHeight();
        int n4 = -this.getCanvasOriginX();
        boolean bl2 = false;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            if (!this.isItemVisible(i)) continue;
            boolean bl3 = !this.isHorizontal() || bl ? this.getItemPosition(i) < n3 : (bl2 = this.getItemPosition(i) + this.getItemSize(i) >= n4);
            if (!bl2) continue;
            this.repaintCanvas();
            break;
        }
        this._fireVisibleDataChanged();
    }

    void internalItemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
        int n = oneDDataSourceEvent.getStartIndex();
        int n2 = oneDDataSourceEvent.getItemCount();
        boolean bl = this.getActualReadingDirection() == 1;
        int n3 = this.isHorizontal() ? -this.getCanvasOriginX() + this.getInnerWidth() : -this.getCanvasOriginY() + this.getInnerHeight();
        int n4 = -this.getCanvasOriginX();
        boolean bl2 = false;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            if (!this.isItemVisible(i)) continue;
            boolean bl3 = !this.isHorizontal() || bl ? this.getItemPosition(i) < n3 : (bl2 = this.getItemPosition(i) + this.getItemSize(i) >= n4);
            if (bl2) break;
        }
        this.getHeaderSelection().itemsRemoved(n, n2);
        this._gm.itemsRemoved(n, n2);
        this._moveItem = -1;
        this._mouseItem = -1;
        this.setArmedItem(-1);
        this.setAnchorItem(-1);
        this.setFocusItem(-1);
        if (this._itemGraphics != null) {
            this._itemGraphics.removeItems(n, n2);
        }
        if (this._itemPainters != null) {
            this._itemPainters.removeItems(n, n2);
        }
        if (this._painters != null) {
            this._painters.removeItems(n, n2);
        }
        if (this._notmovable != null) {
            this._notmovable.removeItems(n, n2);
        }
        if (this._notresizable != null) {
            this._notresizable.removeItems(n, n2);
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        if (bl2) {
            this.repaintCanvas();
        }
        this._fireVisibleDataChanged();
    }

    void internalInvalidateItems(OneDDataSourceEvent oneDDataSourceEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = oneDDataSourceEvent.getStartIndex();
        int n6 = n5 + oneDDataSourceEvent.getItemCount() - 1;
        Dimension dimension = this.getInnerSize();
        if (this.isHorizontal()) {
            n4 = this._gm.getItemPosition(n5);
            n3 = 0;
            n2 = this._gm.getItemPosition(n6) + this._gm.getItemSize(n6);
            n = dimension.height;
        } else {
            n4 = 0;
            n3 = this._gm.getItemPosition(n5);
            n2 = dimension.width;
            n = this._gm.getItemPosition(n6) + this._gm.getItemSize(n6);
        }
        this.repaintCanvas(n4, n3, n2, n);
        this._fireVisibleDataChanged();
    }

    final void growItemSelection(int n) {
        if (this._mouseItem == -1) {
            return;
        }
        this.freezeRepaints();
        HeaderSelection headerSelection = this.getHeaderSelection();
        headerSelection.selectItemRange(this._mouseItem, n);
        this.unfreezeRepaints();
    }

    void startMoving(int n, int n2) {
        if (this.isItemMovable(n) && !this.fireCancelableEvent(2007, n)) {
            this._state = (char)2;
            this._outlineOffset = n2 - this._gm.getItemPosition(n);
            this._outlinePosition = n2;
            this.paintImmediate();
            this.setMoveCursor();
        }
    }

    Rectangle __getItemRect(PaintContext paintContext, int n) {
        if (!this.isItemOnScreen(n)) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        if (this.isHorizontal()) {
            rectangle.x = this.getItemPosition(n);
            rectangle.y = 0;
            rectangle.width = this.getItemSize(n);
            rectangle.height = this.getInnerHeight();
        } else {
            rectangle.x = 0;
            rectangle.y = this.getItemPosition(n);
            rectangle.width = this.getInnerWidth();
            rectangle.height = this.getItemSize(n);
        }
        ++rectangle.x;
        ++rectangle.y;
        rectangle.width -= 2;
        rectangle.height -= 2;
        return rectangle;
    }

    private int _getLastItemOnScreen() {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        if (this.isHorizontal()) {
            return this._gm.getItemAt(-point.x + dimension.width - 1);
        }
        return this._gm.getItemAt(-point.y + dimension.height - 1);
    }

    private void _resetFeedback() {
        if (this._redrawInfo != -1) {
            this.repaint();
        }
        this._redrawInfo = -1;
        this._outlineOffset = -1;
        this._outlinePosition = -1;
    }

    private int _scrollItemIntoView(int n) {
        if (this._isItemCompletelyOnScreen(n)) {
            return -1;
        }
        int n2 = this.getFirstItemOnScreen();
        int n3 = this._gm.convertDSIndexToVIndex(n);
        if (n3 > (n2 = this._gm.convertDSIndexToVIndex(n2))) {
            Dimension dimension = this.getInnerSize();
            int n4 = this._gm.getItemPosition(n) + this._gm.getItemSize(n);
            int n5 = this.isHorizontal() ? n4 - 1 - dimension.width : n4 - 1 - dimension.height;
            n = this._gm.getItemAt(n5);
            if (this._gm.getItemPosition(n) != n5) {
                n = this.getNextVisibleItem(n);
            }
            return n;
        }
        return n3;
    }

    private void _paintHeader(Graphics graphics, PaintContext paintContext) {
        if (this.getItemCount() == 0) {
            Dimension dimension = this.getInnerSize();
            this.paintExtraCanvas(graphics, paintContext, 0, 0, dimension.width, dimension.height);
            return;
        }
        if (this.isHorizontal()) {
            this._paintHorizontalHeader(graphics, paintContext);
        } else {
            this._paintVerticalHeader(graphics, paintContext);
        }
        this.paintFocusItem(paintContext, graphics);
        this._drawFeedback(graphics);
        this._drawOutline(graphics);
    }

    private void _handleMousePressed(MouseEvent mouseEvent) {
        int n;
        this.requestFocus();
        Rectangle rectangle = this.getInnerBounds();
        if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n2 = this.isHorizontal() ? point.x : point.y;
        this._mouseItem = this._gm.getItemAt(n2);
        if (this._mouseItem == -1) {
            return;
        }
        boolean bl = InputEventUtils.isLeftMouseButton(mouseEvent);
        int n3 = this.isResizing(this._mouseItem, n2);
        if (bl && n3 != -1) {
            this._mouseItem = n3;
            if (!this.fireCancelableEvent(2005, this._mouseItem)) {
                this._state = '\u0001';
                this.setResizeCursor();
            } else {
                this._state = (char)3;
                this.resetCursor();
            }
            return;
        }
        Point point2 = this.getCanvasOrigin();
        if (this.isHorizontal()) {
            n = -point2.x - this.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(n, 0);
        } else {
            n = -point2.y - this.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(0, n);
        }
        this.setFocusItem(this._mouseItem);
        this.getItemInputHandler().mousePressed(mouseEvent, this, this._mouseItem);
        if (this.isHorizontal()) {
            mouseEvent.translatePoint(-n, 0);
        } else {
            mouseEvent.translatePoint(0, -n);
        }
        if (mouseEvent.isConsumed() || !bl) {
            this.resetCursor();
            return;
        }
        this.setArmedItem(this._mouseItem);
        Mover.getMover().schedule(this, this._mouseItem, n2);
        this.freezeRepaints();
        HeaderSelection headerSelection = this.getHeaderSelection();
        if (mouseEvent.isShiftDown()) {
            if (this.getAnchorItem() == -1) {
                this.setAnchorItem(this._mouseItem);
            }
            headerSelection.selectItemRange(this._mouseItem, this.getAnchorItem());
        } else {
            if (mouseEvent.isControlDown()) {
                if (!headerSelection.isItemSelected(this._mouseItem)) {
                    headerSelection.addItemToSelection(this._mouseItem);
                } else {
                    headerSelection.removeItemFromSelection(this._mouseItem);
                }
            } else {
                headerSelection.selectItemRange(this._mouseItem, this._mouseItem);
            }
            this.setAnchorItem(this._mouseItem);
        }
        this.unfreezeRepaints();
    }

    private void _handleMouseReleased(MouseEvent mouseEvent) {
        int n;
        Mover.getMover().cancel(this);
        this._resetFeedback();
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n2 = n = this.isHorizontal() ? point.x : point.y;
        if (this._state == '\u0001') {
            this._resizeItemByMouse(mouseEvent);
            this.fireEvent(2006, this._mouseItem);
        } else if (this._state == '\u0002') {
            int n3 = this._gm.getItemAt(n);
            n3 = n3 == -1 ? (n < 0 ? 0 : this.getItemCount() - 1) : this._gm.convertDSIndexToVIndex(n3);
            this.setItemVisibleIndex(this._mouseItem, n3);
            this.fireEvent(2008, this._mouseItem);
        }
        if (this._mouseItem != -1) {
            int n4;
            Point point2 = this.getCanvasOrigin();
            if (this.isHorizontal()) {
                n4 = -point2.x - this.getItemPosition(this._mouseItem);
                mouseEvent.translatePoint(n4, 0);
            } else {
                n4 = -point2.y - this.getItemPosition(this._mouseItem);
                mouseEvent.translatePoint(0, n4);
            }
            this.getItemInputHandler().mouseReleased(mouseEvent, this, this._mouseItem);
            if (this.isHorizontal()) {
                mouseEvent.translatePoint(-n4, 0);
            } else {
                mouseEvent.translatePoint(0, -n4);
            }
            if (this.getArmedItem() != -1) {
                this.setArmedItem(-1);
            }
            this._mouseItem = -1;
        }
        this._state = '\u0000';
        this.resetCursor();
    }

    private void _handleMouseClicked(MouseEvent mouseEvent) {
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n = this.isHorizontal() ? point.x : point.y;
        int n2 = this._gm.getItemAt(n);
        if (n2 != -1) {
            int n3;
            Point point2 = this.getCanvasOrigin();
            if (this.isHorizontal()) {
                n3 = -point2.x - this.getItemPosition(n2);
                mouseEvent.translatePoint(n3, 0);
            } else {
                n3 = -point2.y - this.getItemPosition(n2);
                mouseEvent.translatePoint(0, n3);
            }
            this.getItemInputHandler().mouseClicked(mouseEvent, this, n2);
            if (this.isHorizontal()) {
                mouseEvent.translatePoint(-n3, 0);
            } else {
                mouseEvent.translatePoint(0, -n3);
            }
        }
    }

    private void _handleMouseMoved(MouseEvent mouseEvent) {
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n = this.isHorizontal() ? point.x : point.y;
        int n2 = this._gm.getItemAt(n);
        HeaderItemInputHandler headerItemInputHandler = this.getItemInputHandler();
        Point point2 = this.getCanvasOrigin();
        if (n2 != this._moveItem) {
            MouseEvent mouseEvent2;
            Point point3;
            if (this._moveItem != -1) {
                point3 = this.isHorizontal() ? new Point(point.x - point2.x - this.getItemPosition(this._moveItem), point.y) : new Point(point.x, point.y - point2.y - this.getItemPosition(this._moveItem));
                mouseEvent2 = new MouseEvent(this, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                headerItemInputHandler.mouseExited(mouseEvent2, this, this._moveItem);
            }
            if (n2 != -1) {
                point3 = this.isHorizontal() ? new Point(point.x - point2.x - this.getItemPosition(n2), point.y) : new Point(point.x, point.y - point2.y - this.getItemPosition(n2));
                mouseEvent2 = new MouseEvent(this, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                headerItemInputHandler.mouseEntered(mouseEvent2, this, n2);
            }
            this._moveItem = n2;
        }
        if (this._moveItem != -1) {
            int n3;
            if (this.isHorizontal()) {
                n3 = -point2.x - this.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(n3, 0);
            } else {
                n3 = -point2.y - this.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(0, n3);
            }
            headerItemInputHandler.mouseMoved(mouseEvent, this, this._moveItem);
            if (this.isHorizontal()) {
                mouseEvent.translatePoint(-n3, 0);
            } else {
                mouseEvent.translatePoint(0, -n3);
            }
        }
        if (this.isResizing(this._moveItem, n) != -1) {
            this.setResizeCursor();
        } else {
            this.resetCursor();
        }
    }

    private void _handleMouseDragged(MouseEvent mouseEvent) {
        AutoScroller autoScroller;
        int n;
        int n2;
        int n3;
        if (this._mouseItem == -1) {
            return;
        }
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n4 = this.isHorizontal() ? point.x : point.y;
        if (n4 < (n3 = Mover.getMover().getPoint()) - 3 || n4 > n3 + 3) {
            Mover.getMover().cancel(this);
        }
        int n5 = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        boolean bl = InputEventUtils.isLeftMouseButton(mouseEvent);
        if (this._state == '\u0001') {
            this._resizeItemByMouse(mouseEvent);
        } else if (this._state == '\u0002') {
            if (n5 != -1) {
                n2 = this._gm.getItemPosition(n5);
                if (this._gm.convertDSIndexToVIndex(n5) > this._gm.convertDSIndexToVIndex(this._mouseItem)) {
                    n2 += this._gm.getItemSize(n5);
                }
            } else {
                n = this.getPreviousVisibleItem(this.getItemCount());
                n2 = this._gm.getItemPosition(n) + this._gm.getItemSize(n) + 1;
            }
            if (this._redrawInfo != n2) {
                this._redrawInfo = n2;
            }
            this._outlinePosition = n4;
            this.paintImmediate();
            autoScroller = AutoScroller.getAutoScroller();
            this._checkScroller(autoScroller, mouseEvent);
        } else if (bl) {
            n2 = (n5 == this._mouseItem ? 1 : 0) & this.contains(mouseEvent.getX(), mouseEvent.getY());
            if (n2 != 0) {
                if (this.getArmedItem() == -1) {
                    this.setArmedItem(this._mouseItem);
                }
            } else {
                this.setArmedItem(-1);
            }
        }
        Point point2 = this.getCanvasOrigin();
        if (this.isHorizontal()) {
            n = -point2.x - this.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(n, 0);
        } else {
            n = -point2.y - this.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(0, n);
        }
        this.getItemInputHandler().mouseDragged(mouseEvent, this, this._mouseItem);
        if (this.isHorizontal()) {
            mouseEvent.translatePoint(-n, 0);
        } else {
            mouseEvent.translatePoint(0, -n);
        }
        if (this._state != '\u0000' || n5 == -1 || mouseEvent.isConsumed() || mouseEvent.isControlDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown()) {
            return;
        }
        HeaderSelection headerSelection = this.getHeaderSelection();
        headerSelection.selectItemRange(this._mouseItem, n5);
        int[] nArray = headerSelection.getSelectedItems();
        if (nArray != null && nArray.length >= 1) {
            autoScroller = SelectionAutoScroller.getSelectionAutoScroller();
            this._checkScroller(autoScroller, mouseEvent);
        }
    }

    private void _repaintIfNeeded(int n) {
        ItemPaintContext itemPaintContext;
        BorderPainter borderPainter = this.getHeaderItemBorderPainter();
        if ((borderPainter.getRepaintFlags(itemPaintContext = new ItemPaintContext(this.getPaintContext(), n)) & 2) != 0) {
            this.paintItem(n);
        }
    }

    private void _checkScroller(AutoScroller autoScroller, MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.isHorizontal()) {
            n2 = mouseEvent.getX();
            n = this.getInnerSize().width;
        } else {
            n2 = mouseEvent.getY();
            n = this.getInnerSize().height;
        }
        int n3 = this._gm.getTotalItemSize() / this.getItemCount();
        if (n2 < (n3 /= 2)) {
            autoScroller.schedule(this, true);
        } else if (n2 > n - n3) {
            autoScroller.schedule(this, false);
        } else {
            autoScroller.cancel();
        }
    }

    private void _resizeItemByMouse(MouseEvent mouseEvent) {
        int n = this._mouseItem;
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n2 = this.isHorizontal() ? point.x : point.y;
        Dimension dimension = this.getInnerSize();
        int n3 = this.isHorizontal() ? dimension.width : dimension.height;
        int n4 = this._gm.getItemPosition(n);
        int n5 = this._gm.getItemSize(n);
        int n6 = this.isHorizontal() && this.getActualReadingDirection() == 2 ? (n2 > n4 + n5 ? 2 : n5 + n4 - n2) : (n2 < n4 ? 2 : n2 - n4);
        if (this.getScrollByItem() && n6 > n3 && n5 <= n3 && this._gm.getVisibleItemCount() > 1) {
            n6 = n3;
        }
        this.setItemSize(n, n6);
    }

    private void _handleMouseEntered(MouseEvent mouseEvent) {
        this._moveItem = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        if (this._moveItem != -1) {
            int n;
            Point point = this.getCanvasOrigin();
            if (this.isHorizontal()) {
                n = -point.x - this.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(n, 0);
            } else {
                n = -point.y - this.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(0, n);
            }
            this.getItemInputHandler().mouseEntered(mouseEvent, this, this._moveItem);
            if (this.isHorizontal()) {
                mouseEvent.translatePoint(-n, 0);
            } else {
                mouseEvent.translatePoint(0, -n);
            }
        }
    }

    private void _handleMouseExited(MouseEvent mouseEvent) {
        this.resetCursor();
        if (this._moveItem != -1) {
            int n;
            Point point = this.getCanvasOrigin();
            if (this.isHorizontal()) {
                n = -point.x - this.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(n, 0);
            } else {
                n = -point.y - this.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(0, n);
            }
            this.getItemInputHandler().mouseExited(mouseEvent, this, this._moveItem);
            if (this.isHorizontal()) {
                mouseEvent.translatePoint(n, 0);
            } else {
                mouseEvent.translatePoint(0, n);
            }
        }
    }

    private int _convertVisibleIndexToIndex(int n) {
        if (this._gm.getVisibleItemCount() == this.getItemCount()) {
            return n;
        }
        int n2 = 0;
        int n3 = -1;
        while (n3 < n) {
            int n4 = this._gm.convertVIndexToDSIndex(n2);
            if (this._gm.isItemVisible(n4)) {
                ++n3;
            }
            ++n2;
        }
        return n2 - 1;
    }

    private void _drawOutline(Graphics graphics) {
        if (this._outlinePosition == -1) {
            return;
        }
        int n = this._mouseItem;
        if (n == -1) {
            return;
        }
        Dimension dimension = this.getInnerSize();
        int n2 = this._gm.getItemSize(n) - 2;
        graphics.setColor(Color.black);
        if (this.isHorizontal()) {
            graphics.drawRect(this._outlinePosition - this._outlineOffset, 2, n2, dimension.height - 5);
        } else {
            graphics.drawRect(2, this._outlinePosition - this._outlineOffset, dimension.width - 5, n2);
        }
    }

    private void _drawFeedback(Graphics graphics) {
        if (this._redrawInfo == -1) {
            return;
        }
        Dimension dimension = this.getInnerSize();
        graphics.setColor(Color.black);
        if (this.isHorizontal()) {
            graphics.fillRect(this._redrawInfo, 0, 4, dimension.height);
        } else {
            graphics.fillRect(0, this._redrawInfo, dimension.width, 4);
        }
    }

    private void _paintVerticalHeader(Graphics graphics, PaintContext paintContext) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this._gm.getItemAt(rectangle.y);
        if (n == -1) {
            this._finishVerticalHeader(graphics, paintContext, this.getInnerSize());
            return;
        }
        n = this._gm.convertDSIndexToVIndex(n);
        int n2 = this._gm.getItemAt(rectangle.y + rectangle.height);
        if (n2 == -1) {
            n2 = this.getPreviousVisibleItem(this.getItemCount());
        }
        n2 = this._gm.convertDSIndexToVIndex(n2);
        Dimension dimension = this.getInnerSize();
        int n3 = graphics instanceof PrintGraphics ? 0 : -this.getCanvasOrigin().y;
        Shape shape = graphics.getClip();
        int n4 = rectangle.y + rectangle.height;
        ItemPaintContext itemPaintContext = new ItemPaintContext(paintContext, 0);
        BorderPainter borderPainter = this.getHeaderItemBorderPainter();
        BorderPainter borderPainter2 = this.getFirstItemBorderPainter();
        BorderPainter borderPainter3 = this.getLastItemBorderPainter();
        int n5 = this.getFirstItemOnScreen();
        int n6 = this._getLastItemOnScreen();
        for (int i = n; i <= n2; ++i) {
            int n7 = this._gm.convertVIndexToDSIndex(i);
            if (!this._gm.isItemVisible(n7)) continue;
            BorderPainter borderPainter4 = n7 == n5 ? borderPainter2 : (n7 == n6 ? borderPainter3 : borderPainter);
            ImmInsets immInsets = borderPainter4.getInsets(paintContext);
            int n8 = this._gm.getItemPosition(n7);
            int n9 = this._gm.getItemSize(n7);
            Object object = this._ds.getData(n7);
            graphics.setClip(shape);
            graphics.clipRect(0, n8, dimension.width, n9);
            itemPaintContext.setItem(n7);
            Painter painter = this.getPainter(n7);
            graphics.setColor(itemPaintContext.getPaintBackground());
            graphics.fillRect(0, n8, dimension.width, n9);
            borderPainter4.paint(itemPaintContext, graphics, 0, n8, dimension.width, n9);
            graphics.setColor(itemPaintContext.getPaintForeground());
            graphics.setFont(itemPaintContext.getPaintFont());
            ImmInsets immInsets2 = itemPaintContext.getAppearance().getInsets();
            painter.paint(itemPaintContext, graphics, immInsets.left + immInsets2.left, n8 + immInsets.top + immInsets2.top, dimension.width - immInsets.left - immInsets.right - (immInsets2.left + immInsets2.right), n9 - immInsets.top - immInsets.bottom - (immInsets2.top + immInsets2.bottom));
        }
        this._finishVerticalHeader(graphics, paintContext, dimension);
        graphics.setClip(shape);
    }

    private void _finishVerticalHeader(Graphics graphics, PaintContext paintContext, Dimension dimension) {
        Shape shape = graphics.getClip();
        Dimension dimension2 = this.getCanvasSize();
        int n = dimension2.height;
        if (n < dimension.height) {
            graphics.setClip(shape);
            graphics.clipRect(0, n, dimension.width, dimension.height - n);
            this.paintExtraCanvas(graphics, paintContext, 0, n, dimension.width, dimension.height - n);
        } else {
            Point point = this.getCanvasOrigin();
            int n2 = dimension2.height + point.y;
            int n3 = dimension.height - n2;
            if (n3 > 0) {
                graphics.setClip(shape);
                graphics.clipRect(0, n, dimension2.width, n3);
                this.paintExtraCanvas(graphics, paintContext, 0, n, dimension2.width, n3);
            }
        }
        graphics.setClip(shape);
    }

    private void _paintHorizontalHeader(Graphics graphics, PaintContext paintContext) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this._gm.getItemAt(rectangle.x);
        if (n == -1) {
            this._finishHorizontalHeader(graphics, paintContext, this.getInnerSize());
            return;
        }
        n = this._gm.convertDSIndexToVIndex(n);
        int n2 = this._gm.getItemAt(rectangle.x + rectangle.width);
        if (n2 == -1) {
            n2 = this.getPreviousVisibleItem(this.getItemCount());
        }
        n2 = this._gm.convertDSIndexToVIndex(n2);
        int n3 = graphics instanceof PrintGraphics ? 0 : -this.getCanvasOrigin().x;
        Dimension dimension = this.getInnerSize();
        Shape shape = graphics.getClip();
        int n4 = rectangle.x + rectangle.width;
        ItemPaintContext itemPaintContext = new ItemPaintContext(paintContext, 0);
        BorderPainter borderPainter = this.getHeaderItemBorderPainter();
        BorderPainter borderPainter2 = this.getFirstItemBorderPainter();
        BorderPainter borderPainter3 = this.getLastItemBorderPainter();
        int n5 = this.getFirstItemOnScreen();
        int n6 = this._getLastItemOnScreen();
        for (int i = n; i <= n2; ++i) {
            int n7 = this._gm.convertVIndexToDSIndex(i);
            if (!this._gm.isItemVisible(n7)) continue;
            BorderPainter borderPainter4 = n7 == n5 ? borderPainter2 : (n7 == n6 ? borderPainter3 : borderPainter);
            ImmInsets immInsets = borderPainter4.getInsets(paintContext);
            int n8 = this._gm.getItemPosition(n7);
            int n9 = this._gm.getItemSize(n7);
            graphics.setClip(shape);
            graphics.clipRect(n8, 0, n9, dimension.height);
            itemPaintContext.setItem(n7);
            Painter painter = this.getPainter(n7);
            graphics.setColor(itemPaintContext.getPaintBackground());
            graphics.fillRect(n8, 0, n9, dimension.height);
            borderPainter4.paint(itemPaintContext, graphics, n8, 0, n9, dimension.height);
            graphics.setColor(itemPaintContext.getPaintForeground());
            graphics.setFont(itemPaintContext.getPaintFont());
            ImmInsets immInsets2 = itemPaintContext.getAppearance().getInsets();
            painter.paint(itemPaintContext, graphics, n8 + immInsets.left + immInsets2.left, immInsets.top + immInsets2.top, n9 - (immInsets.left + immInsets.right) - (immInsets2.left + immInsets2.right), dimension.height - (immInsets.top + immInsets.bottom) - (immInsets2.top + immInsets2.bottom));
        }
        this._finishHorizontalHeader(graphics, paintContext, dimension);
        graphics.setClip(shape);
    }

    private void _finishHorizontalHeader(Graphics graphics, PaintContext paintContext, Dimension dimension) {
        boolean bl;
        Shape shape = graphics.getClip();
        Dimension dimension2 = this.getCanvasSize();
        int n = dimension2.width;
        int n2 = dimension.height;
        boolean bl2 = bl = this.getActualReadingDirection() == 1;
        if (n < dimension.width) {
            graphics.setClip(shape);
            int n3 = bl ? n : n - dimension.width;
            graphics.clipRect(n3, 0, dimension.width - n, n2);
            this.paintExtraCanvas(graphics, paintContext, n3, 0, dimension.width - n, n2);
        } else {
            Point point = this.getCanvasOrigin();
            int n4 = dimension2.width + point.x;
            int n5 = dimension.width - n4;
            if (n5 > 0) {
                int n6 = bl ? n : 0;
                graphics.setClip(shape);
                graphics.clipRect(n6, 0, n5, n2);
                this.paintExtraCanvas(graphics, paintContext, n6, 0, n5, n2);
            }
        }
        graphics.setClip(shape);
    }

    private Appearance _createAppearance() {
        TableHeaderUI tableHeaderUI = (TableHeaderUI)this.getUI();
        return tableHeaderUI.getDefaultAppearance(this);
    }

    private Appearance _getAppearance() {
        if (this._appearanceObject == null) {
            this._appearanceObject = this._createAppearance();
        }
        return this._appearanceObject;
    }

    Appearance _getItemAppearance(int n) {
        Object object;
        if (this._itemGraphics != null && (object = this._itemGraphics.getData(n)) != null) {
            return (Appearance)object;
        }
        return this._getAppearance();
    }

    private int isResizing(int n, int n2) {
        int n3 = this.pointInResize(n, n2);
        if (n3 == -1) {
            return -1;
        }
        return this.isItemResizable(n3) ? n3 : -1;
    }

    private int pointInResize(int n, int n2) {
        int n3;
        boolean bl;
        boolean bl2;
        int n4;
        if (n == -1) {
            return -1;
        }
        int n5 = this._gm.getItemPosition(n);
        boolean bl3 = n2 >= n5 + (n4 = this._gm.getItemSize(n)) - 5;
        boolean bl4 = bl2 = n2 >= n5 && n2 <= n5 + 5;
        if (!bl3 && !bl2) {
            return -1;
        }
        boolean bl5 = bl = !this.isHorizontal() || this.getActualReadingDirection() == 1;
        if (bl3) {
            if (bl) {
                return n;
            }
            n3 = this._gm.convertDSIndexToVIndex(n) + 1;
            if (n3 <= this._gm.getVisibleItemCount() - 1) {
                return this._gm.convertVIndexToDSIndex(n3);
            }
        }
        if (bl2) {
            if (bl) {
                n3 = this._gm.convertDSIndexToVIndex(n) - 1;
                if (n3 >= 0) {
                    return this._gm.convertVIndexToDSIndex(n3);
                }
            } else {
                return n;
            }
        }
        return -1;
    }

    private boolean _isItemCompletelyOnScreen(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = this._gm.getItemPosition(n);
        int n3 = this._gm.getItemSize(n);
        point.x = -point.x;
        point.y = -point.y;
        if (this.isHorizontal()) {
            return n2 >= point.x && (n2 + n3 <= point.x + dimension.width || n3 > dimension.width);
        }
        return n2 >= point.y && (n2 + n3 <= point.y + dimension.height || n3 > dimension.height);
    }

    private void _checkForFirstItem(Dimension dimension) {
        int n;
        Dimension dimension2 = this.getInnerSize();
        if (this._firstItem != -1) {
            if (this.isHorizontal() && dimension.width != 0 || !this.isHorizontal() && dimension.height != 0) {
                this.setFirstItemOnScreen(this._firstItem);
            }
        } else if ((this.isHorizontal() && dimension2.width >= dimension.width && dimension.width != 0 || !this.isHorizontal() && dimension2.height >= dimension.height && dimension.height != 0) && (n = this.getNextVisibleItem(-1)) != -1) {
            this.setFirstItemOnScreen(n);
        }
    }

    private void _fireVisibleDataChanged() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private class PainterAdapter
    extends AbstractPainter {
        private final Dimension _minSize = new Dimension(0, 0);
        private HeaderItemPainter _toAdapt;

        public PainterAdapter(HeaderItemPainter headerItemPainter) {
            this._toAdapt = headerItemPainter;
        }

        @Override
        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Appearance appearance = (Appearance)paintContext.getPaintData(KEY_APPEARANCE);
            if (appearance == null) {
                return;
            }
            Object object = paintContext.getPaintData(null);
            boolean bl = (paintContext.getPaintState() & 0x80) != 0;
            boolean bl2 = (paintContext.getPaintState() & 2) == 0;
            bl2 = false;
            this._toAdapt.paint(graphics, n, n2, n3, n4, object, appearance, bl, bl2);
        }

        @Override
        public Dimension getMinimumSize(PaintContext paintContext) {
            return this._minSize;
        }

        @Override
        public int getRepaintFlags(PaintContext paintContext) {
            return 0;
        }
    }

    private class ItemPaintContext
    extends PaintContextProxy {
        private int _item;
        private PaintContext _context;

        public ItemPaintContext(PaintContext paintContext, int n) {
            this._context = paintContext;
            this.setItem(n);
        }

        public void setItem(int n) {
            this._item = n;
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._context;
        }

        @Override
        public int getPaintState() {
            int n = super.getPaintState();
            int n2 = this._item;
            HeaderSelection headerSelection = Header.this.getHeaderSelection();
            if (headerSelection.isItemSelected(n2) & Header.this.getDrawSelected()) {
                n |= 0x80;
            }
            if (Header.this.getArmedItem() == n2) {
                n |= 2;
            }
            return Header.this.getItemPaintState(n, n2);
        }

        @Override
        public Color getPaintForeground() {
            int n = this.getPaintState();
            return (n & 0x80) == 0 ? this.getAppearance().getForeground() : this.getAppearance().getSelectForeground();
        }

        @Override
        public Color getPaintBackground() {
            int n = this.getPaintState();
            return (n & 0x80) == 0 ? this.getAppearance().getBackground() : this.getAppearance().getSelectBackground();
        }

        @Override
        public Font getPaintFont() {
            int n = this.getPaintState();
            Font font = null;
            if ((n & 0x80) != 0) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        @Override
        public float getInteriorAlignmentX() {
            float f;
            Appearance appearance = this.getAppearance();
            int n = appearance.getHorizontalJustify();
            if (n == 0) {
                int n2 = appearance.getReadingDirection();
                switch (n2) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                n = LocaleUtils.getAlignmentForReadingDirection(n2);
            }
            switch (n) {
                case 3: {
                    f = 0.5f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            return f;
        }

        @Override
        public float getInteriorAlignmentY() {
            int n = this.getAppearance().getVerticalJustify();
            float f = 0.0f;
            switch (n) {
                case 1: {
                    f = 0.5f;
                    break;
                }
                case 0: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                }
            }
            return f;
        }

        @Override
        public int getReadingDirection() {
            int n = this.getAppearance().getReadingDirection();
            if (n == 0) {
                n = super.getReadingDirection();
            }
            return n;
        }

        @Override
        public Object getPaintData(Object object) {
            if (object == ComponentUI.MNEMONIC_INDEX_KEY) {
                return null;
            }
            if (KEY_APPEARANCE.equals(object)) {
                return this.getAppearance();
            }
            if (KEY_DRAW_RAISED.equals(object)) {
                return new Boolean(Header.this.getDrawRaised());
            }
            return Header.this.getDataSource().getData(this._item);
        }

        public Appearance getAppearance() {
            return Header.this._getItemAppearance(this._item);
        }
    }

    private class DSListen
    implements OneDDataSourceListener {
        private DSListen() {
        }

        @Override
        public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
            Header.this.internalItemsAdded(oneDDataSourceEvent);
        }

        @Override
        public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
            Header.this.internalItemsRemoved(oneDDataSourceEvent);
        }

        @Override
        public void invalidateItems(OneDDataSourceEvent oneDDataSourceEvent) {
            Header.this.internalInvalidateItems(oneDDataSourceEvent);
        }
    }
}

