/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Image;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.drawer.Drawer;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.basic.BasicLookAndFeel;
import oracle.ewt.laf.basic.DisablingPainter;
import oracle.ewt.laf.basic.DrawerBorderPainter;
import oracle.ewt.laf.basic.WhiteFilter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.FixedColorPainter;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterJoiner;
import oracle.ewt.painter.PainterStacker;
import oracle.ewt.plaf.DrawerUI;

public abstract class BasicDrawerUI
extends BasicComponentUI
implements DrawerUI {
    private static Painter[] _sArrowPainters = new Painter[4];

    protected BasicDrawerUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public Painter getPainter(LWComponent lWComponent) {
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        return new AlignmentPainter(new PainterJoiner(new DisablingPainter(uIDefaults.getPainter(BasicLookAndFeel.TRUNCATING_TEXT_PAINTER)), uIDefaults.getPainter(LookAndFeel.IMAGE_SET_PAINTER), 3));
    }

    @Override
    public BorderPainter getDrawerBorderPainter(LWComponent lWComponent) {
        int n = BasicDrawerUI.getOrientation(lWComponent);
        return DrawerBorderPainter.getDrawerBorderPainter(n);
    }

    @Override
    public Painter getPopUpArrowPainter(LWComponent lWComponent) {
        int n = 3 - BasicDrawerUI.getOrientation(lWComponent);
        return BasicDrawerUI.getArrowPainter(n);
    }

    @Override
    public int getPopUpOverlap(LWComponent lWComponent) {
        Painter painter = BasicDrawerUI.getArrowPainter(0);
        return painter.getPreferredSize((PaintContext)lWComponent.getPaintContext()).width + 1;
    }

    protected static int getOrientation(LWComponent lWComponent) {
        return ((Drawer)lWComponent).getOrientation();
    }

    public static Painter getArrowPainter(int n) {
        Painter painter = _sArrowPainters[n];
        if (painter == null) {
            Image image = BasicLookAndFeel.getArrowImage(n);
            image = ImageUtils.createFilteredImage(image, new WhiteFilter());
            BasicDrawerUI._sArrowPainters[n] = painter = new PainterStacker(new FixedColorPainter(FilledRectPainter.getPainter(), LookAndFeel.ARROW), new FixedImagePainter(image, 0));
        }
        return painter;
    }
}

