/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.meter.BoundedRangeModel;
import oracle.ewt.meter.BoundedRangeModelImpl;
import oracle.ewt.meter.StringRangeModel;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class ProgressBarPainter
extends AbstractPainter {
    private static final int _MAX_PREFERRED_RANGE = 100;
    private static Painter _sInstance;
    private static StringRangeModel _sFullRangeModel;

    protected ProgressBarPainter() {
    }

    public static Painter getPainter() {
        if (_sInstance == null) {
            _sInstance = new ProgressBarPainter();
        }
        return _sInstance;
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string;
        Color color = graphics.getColor();
        StringRangeModel stringRangeModel = this.getModel(paintContext);
        double d = this.getPercent(stringRangeModel);
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color2 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT);
        int n5 = (int)((double)n3 * d);
        if (n5 > 0) {
            graphics.setColor(color2);
            graphics.fillRect(n, n2, n + n5, n4);
            graphics.setColor(color);
        }
        if ((string = stringRangeModel.getStringValue(paintContext.getPaintLocale())) != null) {
            FontMetrics fontMetrics = paintContext.getFontMetrics(paintContext.getPaintFont());
            int n6 = fontMetrics.stringWidth(string);
            int n7 = (n3 - n6) / 2;
            if (n7 < 0) {
                n7 = 0;
            }
            int n8 = fontMetrics.getAscent();
            int n9 = (n4 - (n8 + fontMetrics.getDescent())) / 2 + n8;
            if (n5 > n7) {
                graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
                if (n5 < n7 + n6) {
                    Shape shape = graphics.getClip();
                    graphics.clipRect(n, n2, n5, n4);
                    GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
                    graphics.setClip(shape);
                    graphics.setColor(color);
                    graphics.clipRect(n + n5, n2, n3 - n5, n4);
                    GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
                    graphics.setClip(shape);
                } else {
                    GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
                    graphics.setColor(color);
                }
            } else {
                graphics.setColor(color);
                GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
            }
        }
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        return new Dimension(this.getMinimumWidth(paintContext), this.getMinimumHeight(paintContext));
    }

    @Override
    public Dimension getPreferredSize(PaintContext paintContext) {
        BoundedRangeModel boundedRangeModel = (BoundedRangeModel)paintContext.getPaintData("Model");
        Dimension dimension = this.getMinimumSize(paintContext);
        if (boundedRangeModel != null) {
            int n = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            if (n > 100) {
                n = 100;
            }
            if (n > dimension.width) {
                dimension.width = n;
            }
        }
        return dimension;
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return 0;
    }

    protected int getMinimumWidth(PaintContext paintContext) {
        StringRangeModel stringRangeModel = this.getModel(paintContext);
        FontMetrics fontMetrics = paintContext.getFontMetrics(paintContext.getPaintFont());
        String string = stringRangeModel.getMaximumLengthString(paintContext.getPaintLocale(), fontMetrics);
        if (string != null) {
            return fontMetrics.stringWidth(string);
        }
        return 0;
    }

    protected int getMinimumHeight(PaintContext paintContext) {
        FontMetrics fontMetrics = paintContext.getFontMetrics(paintContext.getPaintFont());
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    protected double getPercent(BoundedRangeModel boundedRangeModel) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (boundedRangeModel != null) {
            n = boundedRangeModel.getValue();
            n2 = boundedRangeModel.getMinimum();
            n3 = boundedRangeModel.getMaximum();
        }
        double d = n == n2 ? 0.0 : (n == n3 ? 1.0 : ((double)n - (double)n2) / (double)(n3 - n2));
        return d;
    }

    protected StringRangeModel getModel(PaintContext paintContext) {
        Object object = paintContext.getPaintData("Model");
        if (object != null && object instanceof StringRangeModel) {
            return (StringRangeModel)object;
        }
        if (_sFullRangeModel == null) {
            _sFullRangeModel = new BoundedRangeModelImpl(0, 0, 0);
        }
        return _sFullRangeModel;
    }
}

