/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.ruler.Ruler;
import oracle.ewt.ruler.RulerStyle;

public class RulerPainter
extends AbstractPainter {
    private static final int _NUMBERGAP = 2;
    private static final int _MINIMUMTICKGAP = 3;
    private static final int _DEFAULT_SIZE = 20;
    private Ruler _ruler;

    public RulerPainter(Ruler ruler) {
        this._ruler = ruler;
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this._ruler.isHorizontal()) {
            return this._ruler.convertInnerToOuterSize(Integer.MAX_VALUE, 20);
        }
        return this._ruler.convertInnerToOuterSize(20, Integer.MAX_VALUE);
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        Dimension dimension = this._ruler.getInnerSize();
        boolean bl = this._ruler.isHorizontal();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Color color = graphics.getColor();
        Color color2 = this._ruler.getRulerUI().getNumberColor(this._ruler);
        Point point = this._ruler.getCanvasOrigin();
        int n9 = fontMetrics.getAscent() + fontMetrics.getLeading();
        graphics.setColor(color);
        if (bl) {
            n8 = this._ruler.getInnerOrigin().y + dimension.height - 1;
            graphics.drawLine(n, n8, n3, n8);
        } else {
            n8 = this._ruler.getInnerOrigin().x + dimension.width - 1;
            graphics.drawLine(n8, n2, n8, n4);
        }
        if (bl) {
            n7 = -point.x + dimension.width;
            n6 = dimension.height;
        } else {
            n6 = dimension.width;
            n7 = -point.y + dimension.height;
        }
        n8 = 2 + fontMetrics.stringWidth("888");
        n7 += n8;
        RulerStyle rulerStyle = this._ruler.getRulerStyle();
        if (rulerStyle.getTickCount() == 0) {
            return;
        }
        double d = rulerStyle.getPixelsPerTick() / (double)rulerStyle.getTick(0).getFrequency();
        int n10 = bl ? -point.x : -point.y;
        int n11 = rulerStyle.getTickCount();
        int n12 = (int)Math.round((double)(n10 -= n8) / d);
        while ((n5 = (int)Math.round(d * (double)n12)) <= n7) {
            int n13;
            int n14 = 0;
            for (int i = 0; i < n11; ++i) {
                n13 = rulerStyle.getTick(i).getFrequency();
                if (n12 % n13 != 0 || !(d * (double)n13 >= 3.0)) continue;
                n14 = rulerStyle.getTick(i).getSize() * n6 / 100;
                break;
            }
            if (n14 > 0) {
                graphics.setColor(color);
                if (bl) {
                    graphics.drawLine(n5, dimension.height - n14 - 1, n5, dimension.height - 1);
                } else {
                    graphics.drawLine(dimension.width - n14 - 1, n5, dimension.width - 1, n5);
                }
            }
            n13 = rulerStyle.getTick(0).getFrequency();
            if (this._ruler.getShowNumbers() && n12 % n13 == 0 && d * (double)n13 >= 3.0) {
                int n15;
                int n16;
                String string = IntegerUtils.getString((int)(n12 / n13));
                if (bl) {
                    n16 = n5 + 2;
                    n15 = n9;
                } else {
                    n16 = 2;
                    n15 = n5 + n9;
                }
                graphics.setColor(color2);
                GraphicUtils.drawString(graphics, string, n16, n15);
            }
            ++n12;
        }
        n5 = this._ruler.getMarkerPosition();
        if (n5 == -1) {
            return;
        }
        graphics.setColor(color2);
        if (bl) {
            graphics.drawLine(n5, 0, n5, n4);
        } else {
            graphics.drawLine(0, n5, n3, n5);
        }
    }
}

