/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class GenericGroupBoxPainter
extends AbstractBorderPainter {
    public static final int TOP_SIDE = 0;
    public static final int LEFT_SIDE = 1;
    public static final int BOTTOM_SIDE = 2;
    public static final int RIGHT_SIDE = 3;
    private static final int _LABEL_INSET = 7;
    private static final int _BORDER_INSET = 3;
    private static final int _CORNER_INSET = 2;
    private Painter _labelPainter;
    private float _alignment;
    private int _side;

    public GenericGroupBoxPainter() {
        this(null, null);
    }

    public GenericGroupBoxPainter(Painter painter, Painter painter2) {
        this(painter, painter2, 0.0f);
    }

    public GenericGroupBoxPainter(Painter painter, Painter painter2, float f) {
        this(painter, painter2, f, 0);
    }

    public GenericGroupBoxPainter(Painter painter, Painter painter2, float f, int n) {
        super(painter);
        if (painter2 == null) {
            painter2 = NullPainter.getPainter();
        }
        this._labelPainter = painter2;
        this._alignment = f;
        this._side = n;
    }

    public Painter getLabelPainter() {
        return this._labelPainter;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        int n = 3;
        int n2 = 3;
        int n3 = 3;
        int n4 = 3;
        Dimension dimension = this._labelPainter.getPreferredSize(paintContext);
        switch (this._side) {
            case 0: {
                if (n >= dimension.height) break;
                n = dimension.height;
                break;
            }
            case 1: {
                if (n2 >= dimension.width) break;
                n2 = dimension.width;
                break;
            }
            case 2: {
                if (n3 >= dimension.height) break;
                n3 = dimension.height;
                break;
            }
            case 3: {
                if (n4 >= dimension.width) break;
                n4 = dimension.width;
            }
        }
        return new ImmInsets(n, n2, n3, n4);
    }

    @Override
    public void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        Rectangle rectangle = this._getLabelBounds(paintContext, n, n2, n3, n4);
        Color color = graphics.getColor();
        this._labelPainter.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n9 = n + n3 - 1;
        int n10 = n2 + n4 - 1;
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n11 = this._side;
        if (n11 == 0 || n11 == 2) {
            n8 = rectangle.height / 2;
            n7 = rectangle.x + rectangle.width;
            n5 = n6 = n9 - 2;
            if (n11 == 0) {
                n6 = rectangle.x;
                this._drawTopSide(graphics, uIDefaults, n7, n2 += n8, n5);
            } else {
                n5 = rectangle.x;
                this._drawBottomSide(graphics, uIDefaults, n7, n10 -= n8, n6);
            }
            this._drawTopSide(graphics, uIDefaults, n, n2, n6);
            this._drawBottomSide(graphics, uIDefaults, n, n10, n5);
            this._drawLeftSide(graphics, uIDefaults, n, n2, n10);
            this._drawRightSide(graphics, uIDefaults, n9, n2, n10);
        } else {
            n8 = rectangle.width / 2;
            n7 = rectangle.y + rectangle.height;
            n5 = n6 = n10 - 2;
            if (n11 == 1) {
                n6 = rectangle.y;
                this._drawLeftSide(graphics, uIDefaults, n += n8, n7, n5);
            } else {
                n5 = rectangle.y;
                this._drawRightSide(graphics, uIDefaults, n9 -= n8, n7, n6);
            }
            this._drawTopSide(graphics, uIDefaults, n, n2, n9);
            this._drawBottomSide(graphics, uIDefaults, n, n10, n9);
            this._drawLeftSide(graphics, uIDefaults, n, n2, n6);
            this._drawRightSide(graphics, uIDefaults, n9, n2, n5);
        }
        Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        n6 = n + 1;
        n5 = n2 + 1;
        int n12 = n9 - 1;
        int n13 = n10 - 1;
        graphics.setColor(color2);
        graphics.drawLine(n, n2, n6, n2);
        graphics.drawLine(n, n5, n, n5);
        graphics.drawLine(n12, n2, n12, n5);
        graphics.drawLine(n, n13, n6, n13);
        graphics.drawLine(n12, n13, n12, n13);
        graphics.setColor(color3);
        graphics.drawLine(n6, n5, n6, n5);
        graphics.drawLine(n9, n2, n9, n5);
        graphics.drawLine(n, n10, n6, n10);
        graphics.drawLine(n12, n10, n9, n10);
        graphics.drawLine(n9, n13, n9, n13);
        graphics.setColor(color);
    }

    private void _drawTopSide(Graphics graphics, UIDefaults uIDefaults, int n, int n2, int n3) {
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW));
        graphics.drawLine(n, n2, n3, n2);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT));
        graphics.drawLine(n, n2 + 1, n3, n2 + 1);
    }

    private void _drawLeftSide(Graphics graphics, UIDefaults uIDefaults, int n, int n2, int n3) {
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW));
        graphics.drawLine(n, n2, n, n3);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT));
        graphics.drawLine(n + 1, n2, n + 1, n3);
    }

    private void _drawBottomSide(Graphics graphics, UIDefaults uIDefaults, int n, int n2, int n3) {
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW));
        graphics.drawLine(n, n2 - 1, n3, n2 - 1);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT));
        graphics.drawLine(n, n2, n3, n2);
    }

    private void _drawRightSide(Graphics graphics, UIDefaults uIDefaults, int n, int n2, int n3) {
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW));
        graphics.drawLine(n - 1, n2, n - 1, n3);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT));
        graphics.drawLine(n, n2, n, n3);
    }

    @Override
    protected Painter getBorderPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Rectangle rectangle = this._getLabelBounds(paintContext, n3, n4, n, n2);
        Painter painter2 = this._labelPainter.getPainterAt(paintContext, rectangle.width, rectangle.height, n3 - rectangle.x, n4 - rectangle.y, painter);
        if (painter == this && painter2 != null) {
            painter2 = this;
        }
        return painter2;
    }

    @Override
    public boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return this._labelPainter.getRepaintFlags(paintContext);
    }

    @Override
    public int getInvalidateFlags(PaintContext paintContext) {
        return this._labelPainter.getInvalidateFlags(paintContext);
    }

    private Rectangle _getLabelBounds(PaintContext paintContext, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        Dimension dimension = this._labelPainter.getPreferredSize(paintContext);
        int n5 = dimension.width;
        int n6 = dimension.height;
        int n7 = 0;
        int n8 = this._side;
        if (n8 == 0 || n8 == 2) {
            if (n6 < 3) {
                n7 = 1;
            }
            int n9 = n8 == 0 ? n7 : (rectangle.y = n4 - (n7 == 0 ? n6 : n7));
            if ((n3 -= 14) < n5) {
                n5 = n3;
                rectangle.x = 7;
            } else {
                rectangle.x = 7 + (int)((float)(n3 - n5) * this._alignment);
            }
        } else {
            if (n5 < 3) {
                n7 = 1;
            }
            int n10 = n8 == 1 ? n7 : (rectangle.x = n3 - (n7 == 0 ? n5 : n7));
            if ((n4 -= 14) < n6) {
                n6 = n4;
                rectangle.y = 7;
            } else {
                rectangle.y = 7 + (int)((float)(n4 - n6) * this._alignment);
            }
        }
        rectangle.x += n;
        rectangle.y += n2;
        rectangle.width = n5;
        rectangle.height = n6;
        return rectangle;
    }
}

