/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.header.Header;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.basic.DisablingPainter;
import oracle.ewt.laf.basic.GridFocusPainter;
import oracle.ewt.laf.generic.GenericHeaderItemPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TruncatingTextPainter;
import oracle.ewt.plaf.TableHeaderUI;
import oracle.ewt.util.ImmInsets;

public class GenericTableHeaderUI
extends BasicComponentUI
implements TableHeaderUI {
    private static Painter _sDefaultPainter;
    private static BorderPainter _HORZONTAL_BORDER_PAINTER;
    private static BorderPainter _VERTICAL_BORDER_PAINTER;
    private static final ImmInsets _ITEM_INSETS;

    public GenericTableHeaderUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public void installUI(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        header.setDrawSelected(false);
    }

    @Override
    public BorderPainter getFocusItemPainter(LWComponent lWComponent) {
        return GridFocusPainter.getBorderPainter();
    }

    @Override
    public BorderPainter getFirstItemBorderPainter(LWComponent lWComponent) {
        return GenericTableHeaderUI._getBorder(lWComponent);
    }

    @Override
    public BorderPainter getLastItemBorderPainter(LWComponent lWComponent) {
        return GenericTableHeaderUI._getBorder(lWComponent);
    }

    @Override
    public BorderPainter getHeaderItemBorderPainter(LWComponent lWComponent) {
        return GenericTableHeaderUI._getBorder(lWComponent);
    }

    @Override
    public Painter getDefaultPainter(LWComponent lWComponent) {
        return GenericTableHeaderUI._getDefaultPainter();
    }

    @Override
    public Painter getExtraCanvasPainter(LWComponent lWComponent) {
        return GenericTableHeaderUI._getBorder(lWComponent);
    }

    @Override
    public Appearance getDefaultAppearance(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        Appearance appearance = new Appearance();
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        appearance.setForeground(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
        appearance.setBackground(uIDefaults.getColor(LookAndFeel.CONTROL));
        appearance.setSelectForeground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
        appearance.setSelectBackground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        appearance.setVerticalJustify(0);
        appearance.setHorizontalJustify(0);
        appearance.setInsets(_ITEM_INSETS);
        return appearance;
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("DefaultHeaderPainter".equals(object)) {
            return GenericTableHeaderUI._getDefaultPainter();
        }
        return null;
    }

    private static Painter _getDefaultPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new DisablingPainter(new TruncatingTextPainter(PaintContext.LABEL_KEY, false));
        }
        return _sDefaultPainter;
    }

    private static BorderPainter _getBorder(LWComponent lWComponent) {
        if (((Header)lWComponent).isHorizontal()) {
            return _HORZONTAL_BORDER_PAINTER;
        }
        return _VERTICAL_BORDER_PAINTER;
    }

    static {
        _HORZONTAL_BORDER_PAINTER = new GenericHeaderItemPainter();
        _VERTICAL_BORDER_PAINTER = new GenericHeaderItemPainter(false);
        _ITEM_INSETS = new ImmInsets(1, 1, 1, 1);
    }
}

