/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.generic.GenericTitleButtonBorder;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TitleBarUI;

public class GenericTitleBarUI
extends BasicComponentUI
implements TitleBarUI {
    private static Painter _sCloseIcon;
    private static Painter _sMaximizeIcon;
    private static Painter _sMinimizeIcon;
    private static Painter _sRestoreIcon;
    private static BorderPainter _sButtonBorder;

    public GenericTitleBarUI(LWComponent lWComponent) {
        super(lWComponent);
        if (_sCloseIcon == null) {
            UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
            _sCloseIcon = GenericTitleBarUI._loadStrip(uIDefaults, "Window.closeStrip");
            _sMaximizeIcon = GenericTitleBarUI._loadStrip(uIDefaults, "Window.maximizeStrip");
            _sMinimizeIcon = GenericTitleBarUI._loadStrip(uIDefaults, "Window.minimizeStrip");
            _sRestoreIcon = GenericTitleBarUI._loadStrip(uIDefaults, "Window.restoreStrip");
        }
    }

    @Override
    public BorderPainter getButtonBorderPainter(LWComponent lWComponent) {
        if (_sButtonBorder == null) {
            _sButtonBorder = new GenericTitleButtonBorder();
        }
        return _sButtonBorder;
    }

    @Override
    public int getCloseButtonSpacing(LWComponent lWComponent) {
        return 2;
    }

    @Override
    public Painter getCloseIcon(LWComponent lWComponent) {
        return _sCloseIcon;
    }

    @Override
    public Painter getMaximizeIcon(LWComponent lWComponent) {
        return _sMaximizeIcon;
    }

    @Override
    public Painter getMinimizeIcon(LWComponent lWComponent) {
        return _sMinimizeIcon;
    }

    @Override
    public Painter getRestoreIcon(LWComponent lWComponent) {
        return _sRestoreIcon;
    }

    @Override
    public Painter getCaptionFill(LWComponent lWComponent) {
        return NullPainter.getPainter();
    }

    private static Painter _loadStrip(UIDefaults uIDefaults, String string) {
        return new ImageSetPainter(new ImageStrip(uIDefaults.getImage(string), 1));
    }
}

