/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.generic.GenericLookAndFeel;
import oracle.ewt.laf.generic.GenericSeparatorPainter;
import oracle.ewt.laf.generic.ToolBarButtonPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.FixedSizePainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterJoiner;
import oracle.ewt.plaf.ToolBarUI;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;

public class GenericToolBarUI
extends BasicComponentUI
implements ToolBarUI {
    private static final int _IMAGESET_BIT = 1;
    private static final int _TEXT_BIT = 2;
    private static final int _HORIZONTAL_BIT = 4;
    private static final int _EXTRA_SEPARATOR_SIZE = 3;
    private static Painter[] _sContentPainters = new Painter[8];
    private static Painter _sVerticalSeparator;
    private static Painter _sHorizontalSeparator;
    private static BorderPainter _sHorizontalBorder;
    private static BorderPainter _sVerticalBorder;
    private static Painter _sVertBlankSeparator;
    private static Painter _sHorzBlankSeparator;

    public GenericToolBarUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public BorderPainter getDefaultBorderPainter(LWComponent lWComponent) {
        if (((ToolBar)lWComponent).isHorizontal()) {
            if (_sHorizontalBorder == null) {
                _sHorizontalBorder = this.getUIDefaults(lWComponent).getBorderPainter(TOOLBAR_HORIZONTAL_BORDER);
            }
            return _sHorizontalBorder;
        }
        if (_sVerticalBorder == null) {
            _sVerticalBorder = this.getUIDefaults(lWComponent).getBorderPainter(TOOLBAR_VERTICAL_BORDER);
        }
        return _sVerticalBorder;
    }

    @Override
    public Painter getButtonContentPainter(LWComponent lWComponent, ToolBarItem toolBarItem) {
        Painter painter;
        int n = 0;
        if (((ToolBar)lWComponent).isHorizontal()) {
            n += 4;
        }
        if (toolBarItem.getPaintData(PaintContext.LABEL_KEY) != null) {
            n += 2;
        }
        if (toolBarItem.getPaintData(PaintContext.IMAGESET_KEY) != null) {
            ++n;
        }
        if ((painter = _sContentPainters[n]) == null) {
            GenericToolBarUI._sContentPainters[n] = painter = new ToolBarButtonPainter(new FixedBorderPainter(this._createContentPainter(this.getUIDefaults(lWComponent), n), 0, 2, 0, 2));
        }
        return painter;
    }

    @Override
    public BorderPainter getButtonBorderPainter(LWComponent lWComponent) {
        return NullPainter.getPainter();
    }

    @Override
    public Painter getSeparatorPainter(LWComponent lWComponent, boolean bl) {
        boolean bl2 = ((ToolBar)lWComponent).isHorizontal();
        if (bl) {
            if (bl2) {
                if (_sVerticalSeparator == null) {
                    _sVerticalSeparator = new FixedBorderPainter(new GenericSeparatorPainter(false), 1, 3, 1, 3);
                }
                return _sVerticalSeparator;
            }
            if (_sHorizontalSeparator == null) {
                _sHorizontalSeparator = new FixedBorderPainter(new GenericSeparatorPainter(true), 3, 1, 3, 1);
            }
            return _sHorizontalSeparator;
        }
        if (bl2) {
            return _sVertBlankSeparator;
        }
        return _sHorzBlankSeparator;
    }

    @Override
    public int getBaseImageState(LWComponent lWComponent) {
        return (Integer)this.getUIDefaults(lWComponent).get(BASE_IMAGE_STATE);
    }

    private Painter _createContentPainter(UIDefaults uIDefaults, int n) {
        boolean bl = (n & 4) != 0;
        switch (n &= 0xFFFFFFFB) {
            default: {
                return null;
            }
            case 1: {
                return uIDefaults.getPainter(LookAndFeel.IMAGE_SET_PAINTER);
            }
            case 2: {
                return new FixedBorderPainter(this._createContentTextPainter(uIDefaults, bl), 1, 2, 1, 2);
            }
            case 3: 
        }
        return new PainterJoiner(this._createContentTextPainter(uIDefaults, bl), uIDefaults.getPainter(LookAndFeel.IMAGE_SET_PAINTER), 3);
    }

    private Painter _createContentTextPainter(UIDefaults uIDefaults, boolean bl) {
        Painter painter = uIDefaults.getPainter(GenericLookAndFeel.DEFAULT_TEXT_PAINTER);
        if (bl) {
            return new FixedBorderPainter(painter, 0, 4, 0, 4, false);
        }
        return painter;
    }

    static {
        _sVertBlankSeparator = new FixedSizePainter(8, -1);
        _sHorzBlankSeparator = new FixedSizePainter(-1, 8);
    }
}

