/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.util.ImmInsets;

public class OraclePopupMenuBorder
extends AbstractBorderPainter {
    private static final OraclePopupMenuBorder _POPUP_MENU_BORDER = new OraclePopupMenuBorder(true);
    private static final OraclePopupMenuBorder _RAISED_BORDER = new OraclePopupMenuBorder(false);
    private static final ImmInsets _POPUP_INSETS = new ImmInsets(3, 3, 3, 3);
    private static final ImmInsets _RAISED_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _POPUP_FILL_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _RAISED_FILL_INSETS = new ImmInsets(1, 1, 2, 2);
    private boolean _isPopUpBorder;

    private OraclePopupMenuBorder(boolean bl) {
        this._isPopUpBorder = bl;
    }

    public static OraclePopupMenuBorder getPopUpBorderPainter() {
        return _POPUP_MENU_BORDER;
    }

    public static OraclePopupMenuBorder getRaisedBorderPainter() {
        return _RAISED_BORDER;
    }

    @Override
    public ImmInsets getOwnFillInsets(PaintContext paintContext) {
        if (this._isPopUpBorder) {
            return _POPUP_FILL_INSETS;
        }
        return _RAISED_FILL_INSETS;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        if (this._isPopUpBorder) {
            return _POPUP_INSETS;
        }
        return _RAISED_INSETS;
    }

    @Override
    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color = graphics.getColor();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        graphics.setColor(uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY));
        graphics.drawLine(n + 3, n2, n6 - 4, n2);
        graphics.drawLine(n + 1, n2 + 1, n + 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        graphics.drawLine(n6 - 3, n2 + 1, n6 - 2, n2 + 1);
        graphics.drawLine(n6 - 2, n2 + 2, n6 - 2, n2 + 2);
        graphics.drawLine(n + 1, n5 - 3, n + 1, n5 - 2);
        graphics.drawLine(n + 2, n5 - 2, n + 2, n5 - 2);
        graphics.drawLine(n6 - 2, n5 - 3, n6 - 2, n5 - 2);
        graphics.drawLine(n6 - 3, n5 - 2, n6 - 3, n5 - 2);
        graphics.drawLine(n, n2 + 3, n, n5 - 4);
        graphics.drawLine(n6 - 1, n2 + 3, n6 - 1, n5 - 3);
        graphics.drawLine(n + 3, n5 - 1, n6 - 4, n5 - 1);
        if (this._isPopUpBorder) {
            graphics.setColor(Color.white);
            graphics.drawLine(n + 3, n2 + 1, n6 - 4, n2 + 1);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
            graphics.drawLine(n + 1, n2 + 3, n + 1, n5 - 4);
            graphics.drawLine(n + 2, n5 - 3, n + 2, n5 - 3);
            graphics.drawLine(n6 - 3, n2 + 2, n6 - 3, n2 + 2);
            graphics.drawLine(n6 - 2, n2 + 3, n6 - 2, n2 + 3);
        }
        graphics.setColor(uIDefaults.getColor("PopupMenu.darkBorder"));
        graphics.drawLine(n + 5, n5, n6 - 4, n5);
        graphics.drawLine(n6 - 3, n5 - 1, n6 - 2, n5 - 1);
        graphics.drawLine(n6 - 1, n5 - 3, n6 - 1, n5 - 2);
        graphics.drawLine(n6, n2 + 5, n6, n5 - 4);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.DARK_INTENSITY));
        graphics.drawLine(n + 2, n5 - 1, n + 2, n5 - 1);
        graphics.drawLine(n + 4, n5, n + 4, n5);
        graphics.drawLine(n6 - 3, n5, n6 - 3, n5);
        graphics.drawLine(n6 - 1, n5 - 1, n6 - 1, n5 - 1);
        graphics.drawLine(n6, n5 - 3, n6, n5 - 3);
        graphics.drawLine(n6, n2 + 4, n6, n2 + 4);
        graphics.drawLine(n6 - 1, n2 + 2, n6 - 1, n2 + 2);
        graphics.setColor(color);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }
}

