/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import oracle.ewt.UIDefaults;
import oracle.ewt.button.SpinButton;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.laf.oracle.SpinButtonPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.SpinButtonUI;

public class OracleSpinButtonUI
extends OracleComponentUI
implements SpinButtonUI {
    private static final String[] _IMAGE_NAMES = new String[]{"SpinButton.leftArrow", "SpinButton.rightArrow", "SpinButton.downArrow", "SpinButton.upArrow"};
    private Painter[] _spinPainters;
    private Painter[] _arrowPainters = new Painter[4];

    public OracleSpinButtonUI(LWComponent lWComponent) {
        super(lWComponent);
        this._spinPainters = new Painter[this.getMaxPainters()];
    }

    @Override
    public Painter getIncrementPainter(LWComponent lWComponent) {
        return this.getCachedPainter(lWComponent, true);
    }

    @Override
    public Painter getDecrementPainter(LWComponent lWComponent) {
        return this.getCachedPainter(lWComponent, false);
    }

    protected Painter getArrowPainter(LWComponent lWComponent, int n) {
        Painter painter = this._arrowPainters[n];
        if (painter == null) {
            UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
            int n2 = 1;
            int n3 = 2;
            if (n > 1) {
                n2 = 2;
                n3 = 1;
            }
            this._arrowPainters[n] = painter = new FixedBorderPainter(new ImageSetPainter(new SynthesizingImageSet(uIDefaults.getImage(_IMAGE_NAMES[n]), 1)), n2, n3, 2, 2);
        }
        return painter;
    }

    protected int getMaxPainters() {
        return 8;
    }

    protected boolean isVertical(LWComponent lWComponent) {
        return ((SpinButton)lWComponent).isVertical();
    }

    protected int getSpinIncrement(LWComponent lWComponent) {
        if (((SpinButton)lWComponent).isStandalone()) {
            return 4;
        }
        return 0;
    }

    protected Painter createSpinPainter(LWComponent lWComponent, int n, int n2) {
        return new SpinButtonPainter(new AlignmentPainter(this.getArrowPainter(lWComponent, n)), (n2 & 2) != 0, (n2 & 1) != 0, (n2 & 4) != 0);
    }

    protected final Painter getCachedPainter(LWComponent lWComponent, boolean bl) {
        int n;
        Painter painter;
        int n2 = 0;
        if (bl) {
            ++n2;
        }
        if (this.isVertical(lWComponent)) {
            n2 += 2;
        }
        if ((painter = this._spinPainters[n = n2 + this.getSpinIncrement(lWComponent)]) == null) {
            this._spinPainters[n] = painter = this.createSpinPainter(lWComponent, n2, n);
        }
        return painter;
    }
}

