/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.laf.oracle.OracleFocusPainter;
import oracle.ewt.laf.oracle.OracleThumbPainter;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

class OracleSplitPanePainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 5;
    private static final int _GRIPPY_STRIDE = 8;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 9;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 19;
    private boolean _isHorizontal;
    private boolean _paintFocus;
    private static final Painter _sHFOCUS_PAINTER = new OracleFocusPainter(null);
    private static final Painter _sVFOCUS_PAINTER = new OracleFocusPainter(null, true);

    public OracleSplitPanePainter(boolean bl) {
        this(bl, true);
    }

    public OracleSplitPanePainter(boolean bl, boolean bl2) {
        this._isHorizontal = bl;
        this._paintFocus = bl2;
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this._isHorizontal) {
            return new Dimension(19, 9);
        }
        return new Dimension(9, 19);
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return 167;
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        Color color = graphics.getColor();
        Color color2 = paintContext.getPaintBackground();
        graphics.setColor(color2);
        graphics.fillRect(n, n2, n3, n4);
        int n5 = paintContext.getPaintState();
        boolean bl2 = bl = (n5 & 0x20) != 0 && this._paintFocus;
        if ((n5 & 5) == 0) {
            int n6;
            if (bl) {
                if (ColorUtils.getApproximateLuminance(color2) <= 128) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(Color.black);
                }
                if (this._isHorizontal) {
                    _sHFOCUS_PAINTER.paint(paintContext, graphics, n, n2, n3, n4);
                } else {
                    _sVFOCUS_PAINTER.paint(paintContext, graphics, n, n2, n3, n4);
                }
            }
            int n7 = n6 = this._isHorizontal ? n3 : n4;
            if (n6 >= 19) {
                boolean bl3;
                int n8 = n6 / 40;
                if ((n8 |= 1) < 3) {
                    n8 = 3;
                }
                int n9 = n8 * 3 + (n8 - 1) * 5;
                int n10 = 3;
                int n11 = 3;
                int n12 = 0;
                int n13 = 0;
                if (this._isHorizontal) {
                    n10 = n9;
                    n12 = 8;
                } else {
                    n11 = n9;
                    n13 = 8;
                }
                int n14 = n + (n3 - n10) / 2;
                int n15 = n2 + (n4 - n11) / 2;
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
                Color color4 = uIDefaults.getColor(OracleColorScheme.CONTROL_SHADOW_DARK);
                boolean bl4 = bl3 = (n5 & 2) != 0 || bl;
                while (n8 > 0) {
                    OracleThumbPainter.__drawGrippy(graphics, n14, n15, color3, color4, bl3);
                    --n8;
                    n14 += n12;
                    n15 += n13;
                }
            }
        }
        graphics.setColor(color);
    }
}

