/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public final class PreferredSizeLayout
implements LayoutManager {
    private static LayoutManager _sInstance;
    private static final int _DEFAULT_SIZE = 100;

    private PreferredSizeLayout() {
    }

    public static LayoutManager getInstance() {
        if (_sInstance == null) {
            _sInstance = new PreferredSizeLayout();
        }
        return _sInstance;
    }

    @Override
    public final void addLayoutComponent(String string, Component component) {
    }

    @Override
    public final void removeLayoutComponent(Component component) {
    }

    @Override
    public final Dimension minimumLayoutSize(Container container) {
        if (container.getComponentCount() > 0) {
            Component component = container.getComponent(0);
            return component.getMinimumSize();
        }
        return new Dimension(100, 100);
    }

    @Override
    public final Dimension preferredLayoutSize(Container container) {
        if (container.getComponentCount() > 0) {
            Component component = container.getComponent(0);
            return new Dimension(component.getPreferredSize());
        }
        return new Dimension(100, 100);
    }

    @Override
    public final void layoutContainer(Container container) {
        if (container.getComponentCount() > 0) {
            Component component = container.getComponent(0);
            Dimension dimension = new Dimension(component.getPreferredSize());
            Dimension dimension2 = container.getSize();
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
            component.setSize(dimension.width, dimension.height);
        }
    }
}

