/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.sort.Sort;
import oracle.ewt.EwtComponent;
import oracle.ewt.dnd.DragGestureEvent;
import oracle.ewt.dnd.DragGestureListener;
import oracle.ewt.dnd.DragGestureRecognizer;
import oracle.ewt.dnd.DragSource;
import oracle.ewt.dnd.DragSourceDragEvent;
import oracle.ewt.dnd.DragSourceDropEvent;
import oracle.ewt.dnd.DragSourceEvent;
import oracle.ewt.dnd.DragSourceListener;
import oracle.ewt.dnd.DropTarget;
import oracle.ewt.dnd.DropTargetDragEvent;
import oracle.ewt.dnd.DropTargetDropEvent;
import oracle.ewt.dnd.DropTargetEvent;
import oracle.ewt.dnd.DropTargetListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWDataSourceList;

public abstract class AbstractDSListDragger {
    private DropTarget _target;
    private int _sourceActions = 0;
    private boolean _reordering;
    private Adapter _adapter;
    private ListenerManager _listeners;
    private static final DataFlavor _sStringFlavor = TransferUtils.getDataFlavor(String.class);
    private static final DataFlavor _sArrayFlavor = TransferUtils.getDataFlavor(String[].class);
    private static final int _AUTOSCROLL_REGION = 8;

    protected AbstractDSListDragger() {
        this(null);
    }

    protected AbstractDSListDragger(LWDataSourceList lWDataSourceList) {
        this._adapter = new Adapter(lWDataSourceList);
        EwtComponent ewtComponent = lWDataSourceList == null ? null : lWDataSourceList.getContent();
        this._target = new DropTarget(ewtComponent, this._adapter);
        if (lWDataSourceList == null) {
            this._target.setActive(true);
        }
        this.setReorderingAllowed(false);
        this.setTargetActions(0);
    }

    public LWDataSourceList getList() {
        return this._adapter.getList();
    }

    public void setList(LWDataSourceList lWDataSourceList) {
        this._adapter.setList(lWDataSourceList);
        EwtComponent ewtComponent = lWDataSourceList == null ? null : lWDataSourceList.getContent();
        this._target.setComponent(ewtComponent);
    }

    public void setActive(boolean bl) {
        this._target.setActive(bl);
    }

    public boolean isActive() {
        return this._target.isActive();
    }

    public void setTargetActions(int n) {
        this._target.setDefaultActions(n);
    }

    public int getTargetActions() {
        return this._target.getDefaultActions();
    }

    public void setSourceActions(int n) {
        this._sourceActions = n;
        this._updateSourceActions();
    }

    public int getSourceActions() {
        return this._sourceActions;
    }

    public void setReorderingAllowed(boolean bl) {
        this._reordering = bl;
        this._updateSourceActions();
    }

    public boolean isReorderingAllowed() {
        return this._reordering;
    }

    protected abstract void addItems(String[] var1, int var2);

    protected abstract void removeItems(int[] var1);

    protected abstract void reorderItems(int[] var1, int var2);

    protected Transferable createTransferable(LWDataSourceList lWDataSourceList) {
        int[] nArray = AbstractDSListDragger._getSortedIndexes(lWDataSourceList);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = lWDataSourceList.getItem(nArray[i]);
        }
        return ObjectTransferable.createTransferable((Object)stringArray);
    }

    protected boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent.isDataFlavorSupported(_sArrayFlavor) || dropTargetDragEvent.isDataFlavorSupported(_sStringFlavor);
    }

    protected String[] getStringsFromDrop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        String[] stringArray = null;
        try {
            if (transferable.isDataFlavorSupported(_sArrayFlavor)) {
                stringArray = (String[])transferable.getTransferData(_sArrayFlavor);
            } else if (transferable.isDataFlavorSupported(_sStringFlavor)) {
                String string = (String)transferable.getTransferData(_sStringFlavor);
                stringArray = new String[]{string};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    private void _updateSourceActions() {
        int n = this.getSourceActions();
        if (this.isReorderingAllowed()) {
            n |= 2;
        }
        this._adapter.setSourceActions(n);
    }

    private static int[] _getSortedIndexes(LWDataSourceList lWDataSourceList) {
        int[] nArray = lWDataSourceList.getSelectedIndexes();
        Sort.qSort((int[])nArray, (int)nArray.length, (boolean)true);
        return nArray;
    }

    private class Adapter
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private LWDataSourceList _list;
        private DragGestureRecognizer _recognizer;
        private transient int _dropIndex;
        private transient boolean _canDrag;
        private transient boolean _inDrag;
        private transient boolean _inDrop;

        public Adapter(LWDataSourceList lWDataSourceList) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            EwtComponent ewtComponent = lWDataSourceList == null ? null : lWDataSourceList.getContent();
            this._recognizer = dragSource.createDefaultDragGestureRecognizer(ewtComponent, 0, this);
            this._list = lWDataSourceList;
        }

        public LWDataSourceList getList() {
            return this._list;
        }

        public void setList(LWDataSourceList lWDataSourceList) {
            this._list = lWDataSourceList;
            EwtComponent ewtComponent = lWDataSourceList == null ? null : lWDataSourceList.getContent();
            this._recognizer.setComponent(ewtComponent);
        }

        public void setSourceActions(int n) {
            this._recognizer.setSourceActions(n);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            LWDataSourceList lWDataSourceList = this._list;
            if (lWDataSourceList.isIndexSelected(lWDataSourceList.getItemAt(dragGestureEvent.getDragOrigin().y)) && AbstractDSListDragger.this.isActive()) {
                this._inDrag = true;
                dragGestureEvent.startDrag(null, AbstractDSListDragger.this.createTransferable(lWDataSourceList), this);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess() && (AbstractDSListDragger.this.getSourceActions() & 2) != 0 && dragSourceDropEvent.getDropAction() == 2) {
                int[] nArray = AbstractDSListDragger._getSortedIndexes(this._list);
                this._list.freezeRepaints();
                try {
                    this._list.deselectAll();
                    AbstractDSListDragger.this.removeItems(nArray);
                }
                finally {
                    this._list.unfreezeRepaints();
                }
            }
            this._inDrag = false;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this._inDrop = true;
            this._dropIndex = -1;
            this.dragOver(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n;
            int n2 = this._getDropAction(dropTargetDragEvent.getDropAction());
            if (n2 != 0 && !AbstractDSListDragger.this.isDragAcceptable(dropTargetDragEvent)) {
                n2 = 0;
            }
            int n3 = this._dropIndex;
            if (n2 == 0) {
                dropTargetDragEvent.rejectDrag();
                n = -1;
            } else {
                dropTargetDragEvent.acceptDrag(n2);
                n = this._getDropIndex(dropTargetDragEvent.getLocation());
            }
            if (n3 != n) {
                this._eraseFeedback();
                this._dropIndex = n;
                this._drawFeedback();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            this._eraseFeedback();
            this._inDrop = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            boolean bl = false;
            this._eraseFeedback();
            int n = this._getDropAction(dropTargetDropEvent.getDropAction());
            if (n != 0) {
                LWDataSourceList lWDataSourceList = this._list;
                String[] stringArray = AbstractDSListDragger.this.getStringsFromDrop(dropTargetDropEvent);
                if (stringArray != null && stringArray.length > 0) {
                    int n2 = this._getDropIndex(dropTargetDropEvent.getLocation());
                    int[] nArray = AbstractDSListDragger._getSortedIndexes(lWDataSourceList);
                    if (AbstractDSListDragger.this.isReorderingAllowed() && this._inDrag) {
                        if (nArray.length > 1 || n2 != nArray[0] && n2 != nArray[0] + 1) {
                            bl = true;
                            dropTargetDropEvent.acceptDrop(1);
                            lWDataSourceList.freezeRepaints();
                            try {
                                lWDataSourceList.deselectAll();
                                for (int i = nArray.length - 1; i >= 0; --i) {
                                    if (nArray[i] >= n2) continue;
                                    --n2;
                                }
                                AbstractDSListDragger.this.reorderItems(nArray, n2);
                            }
                            finally {
                                lWDataSourceList.unfreezeRepaints();
                            }
                        }
                    } else if (!this._inDrag) {
                        bl = true;
                        dropTargetDropEvent.acceptDrop(n);
                        lWDataSourceList.freezeRepaints();
                        try {
                            lWDataSourceList.deselectAll();
                            AbstractDSListDragger.this.addItems(stringArray, n2);
                        }
                        finally {
                            lWDataSourceList.unfreezeRepaints();
                        }
                    }
                }
            }
            if (!bl) {
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.dropComplete(bl);
            this._inDrop = false;
        }

        private Rectangle _getFeedbackArea(int n) {
            int n2 = this._list.getRowHeight();
            Rectangle rectangle = new Rectangle(0, n * n2 - 1, this._list.getContent().getCanvasSize().width, 2);
            return rectangle;
        }

        private void _eraseFeedback() {
            Rectangle rectangle;
            int n = this._dropIndex;
            if (n >= 0 && (rectangle = this._getFeedbackArea(n)) != null) {
                this._list.getContent().paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _drawFeedback() {
            Graphics graphics;
            int n = this._dropIndex;
            if (n >= 0 && (graphics = this._list.getContent().getCanvasGraphics()) != null) {
                try {
                    Rectangle rectangle = this._getFeedbackArea(n);
                    graphics.setColor(Color.black);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                finally {
                    graphics.dispose();
                }
            }
        }

        private int _getDropIndex(Point point) {
            int n;
            int n2 = this._list.getContent().convertOuterToCanvas((int)0, (int)point.y).y;
            int n3 = this._list.getRowHeight();
            int n4 = (n2 + n3 / 2) / n3;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > (n = this._list.getItemCount())) {
                n4 = n;
            }
            return n4;
        }

        private int _getDropAction(int n) {
            int n2 = 0;
            if (AbstractDSListDragger.this.isReorderingAllowed() && this._inDrag) {
                n2 = 2;
            } else if (!this._inDrag && (n2 = n) == 3) {
                n2 = 1;
            }
            return n2;
        }
    }
}

