/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.access.AccessibleUtils;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.LabelUI;

public class LWLabel
extends AbstractPainterComponent {
    public static final int DEFAULT = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 3;
    public static final int RIGHT = 2;
    private static int _sInstanceCounter = 0;
    private boolean _myAltDown = false;
    private int _myActiveMnemonic = -1;
    private String _text;
    private ImageSet _imageSet;
    private Component _labelFor;

    public LWLabel() {
        this("", 0);
    }

    public LWLabel(String string) {
        this(string, 0);
    }

    public LWLabel(String string, int n) {
        if (n != 0) {
            this.setAlignment(n);
        }
        this._text = string;
    }

    @Override
    public Object getUIClassID() {
        return "LabelUI";
    }

    public String getText() {
        return this._text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        boolean bl = false;
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
        String string3 = this._text;
        Object object = this;
        synchronized (object) {
            if (!(string == this._text || this._text != null && this._text.equals(string))) {
                this._text = string;
                bl = true;
            }
        }
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string);
            object = accessibleContext.getAccessibleName();
            if (object != string2) {
                accessibleContext.firePropertyChange("AccessibleName", string2, object);
            }
        }
        if (bl) {
            this.invalidate();
            this.repaint();
        }
    }

    public final void setImage(Image image) {
        SynthesizingImageSet synthesizingImageSet = image != null ? new SynthesizingImageSet(image) : null;
        this.setImageSet(synthesizingImageSet);
    }

    public void setImageSet(ImageSet imageSet) {
        if (this._imageSet != imageSet) {
            this._imageSet = imageSet;
            this.invalidate();
            this.repaint();
        }
    }

    public ImageSet getImageSet() {
        return this._imageSet;
    }

    public Component getLabelFor() {
        return this._labelFor;
    }

    public void setLabelFor(Component component) {
        Component component2 = this._labelFor;
        this._labelFor = component;
        if (component2 instanceof LWComponent) {
            AccessibleUtils.setLabeledBy((LWComponent)component2, null);
        }
        if (component instanceof LWComponent) {
            AccessibleUtils.setLabeledBy((LWComponent)component, this);
        }
    }

    @Override
    public void setFocusable(boolean bl) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void postProcessKey(KeyEvent keyEvent) {
        Component component;
        if (keyEvent.getID() == 402) {
            if (keyEvent.getKeyCode() == 18 && this._myAltDown) {
                keyEvent.consume();
                this._myAltDown = false;
            } else if (keyEvent.getKeyCode() == this._myActiveMnemonic) {
                keyEvent.consume();
                this._myActiveMnemonic = -1;
            }
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (LWLabel.hasMnemonicModifier(keyEvent) && this.eventMatchesMnemonic(keyEvent) && (component = this.getLabelFor()) != null && component.isEnabled()) {
            this._myAltDown = true;
            this._myActiveMnemonic = keyEvent.getKeyCode();
            component.requestFocus();
            keyEvent.consume();
        }
        super.postProcessKey(keyEvent);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected Painter getPainter() {
        return ((LabelUI)this.getUI()).getPainter(this);
    }

    @Override
    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (object == null || object == PaintContext.LABEL_KEY) {
            String string = this.getText();
            if (string != null && string.length() > 0) {
                object2 = string;
            }
        } else if (object == PaintContext.IMAGESET_KEY) {
            object2 = this.getImageSet();
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        string = string + ",align=";
        switch (this.getActualAlignment()) {
            case 1: {
                string = string + "left";
                break;
            }
            case 3: {
                string = string + "center";
                break;
            }
            case 2: {
                string = string + "right";
                break;
            }
        }
        return string + ",text=" + this.getText();
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(LWLabel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

