/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuInvoker;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuItemContainer;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwMenu.MenuUtils;
import oracle.ewt.lwAWT.lwMenu.laf.HorzMenuController;
import oracle.ewt.plaf.MenuUI;
import oracle.ewt.popup.PopupOwner;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.ewt.util.LocaleUtils;

public class LWMenu
extends LWMenuItem
implements LWMenuInvoker {
    static final String _RESOURCE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private LWPopupMenu _subMenu;
    private boolean _displayed;
    private Task _popupTask;
    private Task _popdownTask;

    public LWMenu() {
    }

    public LWMenu(String string, LWPopupMenu lWPopupMenu) {
        super(string);
        this._subMenu = lWPopupMenu;
    }

    @Override
    public void activate() {
        LWPopupMenu lWPopupMenu = this.getSubMenu();
        if (lWPopupMenu != null && !this.isSubMenuDisplayed()) {
            this.setSubMenuDisplayed(true);
            LWMenuItem lWMenuItem = MenuUtils.getNextItem(lWPopupMenu, null);
            if (lWMenuItem != null) {
                lWMenuItem.setSelected(true);
            }
        }
    }

    public LWPopupMenu getSubMenu() {
        return this._subMenu;
    }

    @Override
    public void handleAccelerator(KeyEvent keyEvent) {
        LWPopupMenu lWPopupMenu = this.getSubMenu();
        if (this.isEnabled() && lWPopupMenu != null) {
            lWPopupMenu.handleAccelerator(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        super.handleAccelerator(keyEvent);
    }

    public boolean isSubMenuDisplayed() {
        return this._displayed;
    }

    @Override
    public void processMenuKeyEvent(KeyEvent keyEvent) {
        if (this.isSubMenuDisplayed()) {
            LWPopupMenu lWPopupMenu = this.getSubMenu();
            lWPopupMenu.processMenuKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        super.processMenuKeyEvent(keyEvent);
    }

    public final void setSubMenuDisplayed(boolean bl) {
        this.setSubMenuDisplayed(bl, 0);
    }

    public final void setSubMenuDisplayed(boolean bl, int n) {
        this.setSubMenuDisplayed(bl, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubMenuDisplayed(boolean bl, int n, boolean bl2) {
        LWPopupMenu lWPopupMenu = this.getSubMenu();
        if (lWPopupMenu == null) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n == 0 && bl != lWPopupMenu.isPoppedUp()) {
                this._cancelPopdown();
                this._cancelPopup();
                this._displayed = lWPopupMenu.isPoppedUp();
            }
        }
        if (bl != this.isSubMenuDisplayed()) {
            object = this._getImmediatePainter();
            if (object != null) {
                object.freezeRepaints();
            }
            try {
                if (bl2) {
                    this.setSelected(bl, true, false);
                }
                this._displayed = bl;
                if (!bl) {
                    this._schedulePopdown(n);
                }
            }
            finally {
                if (object != null) {
                    object.unfreezeRepaints();
                }
            }
            if (bl) {
                this._schedulePopup(n);
                LWMenuItemContainer lWMenuItemContainer = this.getMenuItemContainer();
                if (lWMenuItemContainer instanceof LWMenuBar) {
                    ((LWMenuBar)lWMenuItemContainer).putClientProperty(HorzMenuController._CLIENTPROP_DISPLAY_SUBMENU, Boolean.TRUE);
                }
            }
        }
    }

    protected Rectangle getPopupOverBounds() {
        return ((MenuUI)this.getUI()).getPopupOverBounds(this);
    }

    @Override
    protected final void setSelected(boolean bl, boolean bl2) {
        this.setSelected(bl, bl2, true);
    }

    protected void setSelected(boolean bl, boolean bl2, boolean bl3) {
        if (bl != this.isSelected()) {
            if (!bl && bl3) {
                this.setSubMenuDisplayed(false);
            }
            super.setSelected(bl, bl2);
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.SELECTED, bl ? AccessibleState.SELECTED : null);
            }
        }
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        LWPopupMenu lWPopupMenu = this.getSubMenu();
        if (lWPopupMenu != null) {
            lWPopupMenu.updateLocale(locale, locale2);
        }
    }

    @Override
    protected void updateReadingDirection(int n) {
        super.updateReadingDirection(n);
        LWPopupMenu lWPopupMenu = this.getSubMenu();
        if (lWPopupMenu != null) {
            lWPopupMenu.setReadingDirection(n);
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        LWPopupMenu lWPopupMenu = this._subMenu;
        if (lWPopupMenu != null) {
            lWPopupMenu.getAccessibleContext().setAccessibleParent(this);
        }
        return new MenuAccess();
    }

    public void setSubMenu(LWPopupMenu lWPopupMenu) {
        if (lWPopupMenu != this._subMenu) {
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            LWPopupMenu lWPopupMenu2 = this._subMenu;
            if (accessibleContext != null && lWPopupMenu2 != null) {
                lWPopupMenu2.getAccessibleContext().setAccessibleParent(null);
                accessibleContext.firePropertyChange("AccessibleChild", lWPopupMenu2.getAccessibleContext(), null);
            }
            this._schedulePopdown(0);
            this._subMenu = lWPopupMenu;
            if (accessibleContext != null && lWPopupMenu != null) {
                lWPopupMenu.getAccessibleContext().setAccessibleParent(this);
                accessibleContext.firePropertyChange("AccessibleChild", null, lWPopupMenu.getAccessibleContext());
            }
        }
    }

    @Override
    public void cancelDismissal() {
        this._cancelPopdown();
        this.setSubMenuDisplayed(true);
        LWMenuItemContainer lWMenuItemContainer = this.getMenuItemContainer();
        LWMenuInvoker lWMenuInvoker = lWMenuItemContainer.getMenuInvoker();
        if (lWMenuInvoker != null) {
            lWMenuInvoker.cancelDismissal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissMenu() {
        ImmediatePainter immediatePainter = this._getImmediatePainter();
        if (immediatePainter != null) {
            immediatePainter.freezeRepaints();
        }
        try {
            LWMenuInvoker lWMenuInvoker;
            this.setSubMenuDisplayed(false, 0);
            this.setSelected(false);
            LWMenuItemContainer lWMenuItemContainer = this.getMenuItemContainer();
            if (lWMenuItemContainer != null && (lWMenuInvoker = lWMenuItemContainer.getMenuInvoker()) != null) {
                lWMenuInvoker.dismissMenu();
            }
        }
        finally {
            if (immediatePainter != null) {
                immediatePainter.unfreezeRepaints();
            }
        }
    }

    @Override
    public Component getInvokerComponent() {
        return this;
    }

    @Override
    public Object getUIClassID() {
        return "MenuUI";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __popdown() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ImmediatePainter immediatePainter = this._getImmediatePainter();
            if (immediatePainter != null) {
                immediatePainter.freezeRepaints();
            }
            try {
                LWPopupMenu lWPopupMenu = this.getSubMenu();
                lWPopupMenu.paintImmediate();
                lWPopupMenu.popdown();
                this._popdownTask = null;
            }
            finally {
                if (immediatePainter != null) {
                    immediatePainter.unfreezeRepaints();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __popup() {
        Object object = this.getTreeLock();
        synchronized (object) {
            LWPopupMenu lWPopupMenu = this.getSubMenu();
            this._showPopupMenu();
            this._popupTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cancelPopdown() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this._popdownTask != null) {
                TaskScheduler taskScheduler = TaskScheduler.getDefaultTaskScheduler();
                taskScheduler.cancel(this._popdownTask);
                this._popdownTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cancelPopup() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this._popupTask != null) {
                TaskScheduler taskScheduler = TaskScheduler.getDefaultTaskScheduler();
                taskScheduler.cancel(this._popupTask);
                this._popupTask = null;
            }
        }
    }

    private ImmediatePainter _getImmediatePainter() {
        PopupOwner popupOwner = PopupUtils.findBottomPopupOwner(this);
        if (popupOwner == null) {
            return null;
        }
        for (Component component = (Component)((Object)popupOwner); component != null; component = component.getParent()) {
            if (!(component instanceof ImmediatePainter)) continue;
            return (ImmediatePainter)((Object)component);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _schedulePopdown(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            LWPopupMenu lWPopupMenu = this.getSubMenu();
            if (lWPopupMenu == null) {
                return;
            }
            this._cancelPopup();
            if (lWPopupMenu.isPoppedUp()) {
                if (n == 0) {
                    this._cancelPopdown();
                    this.__popdown();
                } else if (this._popupTask == null) {
                    PopdownTask popdownTask = new PopdownTask();
                    TaskScheduler taskScheduler = TaskScheduler.getDefaultTaskScheduler();
                    taskScheduler.schedule(popdownTask, n);
                    this._popdownTask = popdownTask;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _schedulePopup(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            LWPopupMenu lWPopupMenu = this.getSubMenu();
            if (lWPopupMenu == null) {
                return;
            }
            this._cancelPopdown();
            if (!lWPopupMenu.isPoppedUp()) {
                if (n == 0) {
                    this._cancelPopup();
                    this.__popup();
                } else if (this._popupTask == null) {
                    PopupTask popupTask = new PopupTask();
                    TaskScheduler taskScheduler = TaskScheduler.getDefaultTaskScheduler();
                    taskScheduler.schedule(popupTask, n);
                    this._popupTask = popupTask;
                }
            }
        }
    }

    private void _showPopupMenu() {
        LWPopupMenu lWPopupMenu = this.getSubMenu();
        int[] nArray = null;
        LWMenuItemContainer lWMenuItemContainer = this.getMenuItemContainer();
        if (lWMenuItemContainer.getOrientation() == 0) {
            nArray = new int[5];
            if (this.getActualReadingDirection() == 1) {
                nArray[0] = 13;
                nArray[1] = 8;
                nArray[2] = 22;
                nArray[3] = 17;
                nArray[4] = 2;
            } else {
                nArray[0] = 8;
                nArray[1] = 13;
                nArray[2] = 17;
                nArray[3] = 22;
                nArray[4] = 2;
            }
        } else {
            nArray = new int[2];
            int n = this.getActualReadingDirection() == 1 ? 15 : 20;
            nArray[0] = 2 + n;
            nArray[1] = 1 + n;
        }
        lWPopupMenu.popup(this, this.getPopupOverBounds(), nArray);
    }

    private class MenuAccess
    extends LWMenuItem.Access
    implements AccessibleSelection {
        private MenuAccess() {
            super(LWMenu.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        @Override
        public int getAccessibleChildrenCount() {
            LWPopupMenu lWPopupMenu = LWMenu.this.getSubMenu();
            if (lWPopupMenu == null) {
                return 0;
            }
            Component[] componentArray = lWPopupMenu.getContent().getComponents();
            int n = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            LWPopupMenu lWPopupMenu = LWMenu.this.getSubMenu();
            if (lWPopupMenu == null) {
                return null;
            }
            Component[] componentArray = lWPopupMenu.getContent().getComponents();
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                if (n2 == n) {
                    Accessible accessible = (Accessible)((Object)componentArray[i]);
                    accessible.getAccessibleContext().setAccessibleParent(LWMenu.this);
                    return accessible;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            return super.getAccessibleActionCount() + 1;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            if (n == this.getAccessibleActionCount() - 1) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LWMenu._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
                return resourceBundle.getString("TOGGLE_DROP_DOWN");
            }
            return super.getAccessibleActionDescription(n);
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (this.isEnabled() && n == this.getAccessibleActionCount() - 1) {
                LWMenu.this.setSubMenuDisplayed(!LWMenu.this.isSubMenuDisplayed());
                return true;
            }
            return super.doAccessibleAction(n);
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            LWPopupMenu lWPopupMenu = LWMenu.this.getSubMenu();
            if (lWPopupMenu == null || lWPopupMenu.getSelectedItem() == null) {
                return 0;
            }
            return 1;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            if (n != 0) {
                return null;
            }
            LWPopupMenu lWPopupMenu = LWMenu.this.getSubMenu();
            if (lWPopupMenu == null) {
                return null;
            }
            return lWPopupMenu.getSelectedItem();
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            Accessible accessible = this.getAccessibleSelection(0);
            if (accessible == null) {
                return false;
            }
            return this.getAccessibleChild(n) == accessible;
        }

        @Override
        public void addAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible instanceof LWMenuItem) {
                ((LWMenuItem)accessible).setSelected(true);
                if (accessible instanceof LWMenu) {
                    ((LWMenu)accessible).activate();
                }
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible instanceof LWMenuItem) {
                ((LWMenuItem)accessible).setSelected(false);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            Accessible accessible = this.getAccessibleSelection(0);
            if (accessible instanceof LWMenuItem) {
                ((LWMenuItem)accessible).setSelected(false);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private class PopdownTask
    implements Task {
        private PopdownTask() {
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            LWMenu.this.__popdown();
        }
    }

    private class PopupTask
    implements Task {
        private PopupTask() {
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            LWMenu.this.__popup();
        }
    }
}

