/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu.laf;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.MenuItemUI;

public class MenuItemPainter
extends AbstractPainter {
    private Painter[] _painters = new Painter[5];

    public MenuItemPainter(Painter painter, Painter painter2, Painter painter3, Painter painter4, Painter painter5) {
        this._painters[0] = this._getNonNullPainter(painter);
        this._painters[1] = this._getNonNullPainter(painter2);
        this._painters[2] = this._getNonNullPainter(painter3);
        this._painters[3] = this._getNonNullPainter(painter4);
        this._painters[4] = this._getNonNullPainter(painter5);
    }

    public MenuItemUI.MenuItemConstraints getConstraints(PaintContext paintContext) {
        Dimension dimension = this._painters[0].getMinimumSize(paintContext);
        Dimension dimension2 = this._painters[1].getMinimumSize(paintContext);
        Dimension dimension3 = this._painters[2].getMinimumSize(paintContext);
        Dimension dimension4 = this._painters[3].getMinimumSize(paintContext);
        Dimension dimension5 = this._painters[4].getMinimumSize(paintContext);
        int n = Math.max(dimension.width, dimension2.height);
        n = Math.max(n, dimension3.height);
        n = Math.max(n, dimension4.height);
        n = Math.max(n, dimension5.height);
        return new MenuItemUI.MenuItemConstraints(dimension.width, dimension2.width, dimension3.width, dimension4.width, dimension5.width, n);
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        int n = 0;
        int n2 = 0;
        MenuItemUI.MenuItemConstraints menuItemConstraints = (MenuItemUI.MenuItemConstraints)paintContext.getPaintData("constraints");
        if (menuItemConstraints != null) {
            n = menuItemConstraints.state + menuItemConstraints.image + menuItemConstraints.label + menuItemConstraints.accelerator + menuItemConstraints.submenu;
            n2 = menuItemConstraints.height;
        } else {
            for (int i = 0; i < this._painters.length; ++i) {
                Dimension dimension = this._painters[i].getMinimumSize(paintContext);
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                n += dimension.width;
            }
        }
        return new Dimension(n, n2);
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        MenuItemUI.MenuItemConstraints menuItemConstraints = (MenuItemUI.MenuItemConstraints)paintContext.getPaintData("constraints");
        if (menuItemConstraints == null) {
            menuItemConstraints = this.getConstraints(paintContext);
        }
        if (paintContext.getReadingDirection() == 1) {
            this._paint(paintContext, graphics, this._painters[0], n, n2, menuItemConstraints.state, n4);
            this._paint(paintContext, graphics, this._painters[1], n += menuItemConstraints.state, n2, menuItemConstraints.image, n4);
            this._paint(paintContext, graphics, this._painters[2], n += menuItemConstraints.image, n2, menuItemConstraints.label, n4);
            this._paint(paintContext, graphics, this._painters[3], n += menuItemConstraints.label, n2, menuItemConstraints.accelerator, n4);
            this._paint(paintContext, graphics, this._painters[4], n += menuItemConstraints.accelerator, n2, menuItemConstraints.submenu, n4);
        } else {
            this._paint(paintContext, graphics, this._painters[4], n, n2, menuItemConstraints.submenu, n4);
            this._paint(paintContext, graphics, this._painters[3], n += menuItemConstraints.submenu, n2, menuItemConstraints.accelerator, n4);
            this._paint(paintContext, graphics, this._painters[2], n += menuItemConstraints.accelerator, n2, menuItemConstraints.label, n4);
            this._paint(paintContext, graphics, this._painters[1], n += menuItemConstraints.label, n2, menuItemConstraints.image, n4);
            this._paint(paintContext, graphics, this._painters[0], n += menuItemConstraints.image, n2, menuItemConstraints.state, n4);
        }
    }

    @Override
    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        int n = 0;
        for (int i = 0; i < this._painters.length; ++i) {
            n |= this._painters[i].getRepaintFlags(paintContext);
        }
        return n;
    }

    @Override
    public int getInvalidateFlags(PaintContext paintContext) {
        int n = 0;
        for (int i = 0; i < this._painters.length; ++i) {
            n |= this._painters[i].getInvalidateFlags(paintContext);
        }
        return n;
    }

    private Painter _getNonNullPainter(Painter painter) {
        if (painter == null) {
            return NullPainter.getPainter();
        }
        return painter;
    }

    private void _paint(PaintContext paintContext, Graphics graphics, Painter painter, int n, int n2, int n3, int n4) {
        Dimension dimension = painter.getPreferredSize(paintContext);
        if (dimension.height < n4) {
            n2 += (n4 - dimension.height) / 2;
        }
        painter.paint(paintContext, graphics, n, n2, n3, dimension.height);
    }
}

