/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Toolkit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.util.LocaleUtils;

public class NumberTextField
extends LWTextField {
    private static final char _PLUS = '+';
    private static final String _PLUS_STRING = "+";
    private Class _type = Integer.class;
    private boolean _signed = true;
    private boolean _decimal;
    private int _decimalDigits = -1;
    private DecimalFormat _format;
    private DecimalFormat _oldFormat;

    public NumberTextField() {
        this((Number)null);
    }

    public NumberTextField(Number number) {
        if (number != null) {
            this.setDataType(number.getClass());
        }
        this.setNumber(number);
    }

    public NumberTextField(int n) {
        this((Number)null, n);
    }

    public NumberTextField(Number number, int n) {
        super(n);
        if (number != null) {
            this.setDataType(number.getClass());
        }
        this.setNumber(number);
    }

    public Number getNumber() {
        Number number;
        String string = this.getText();
        try {
            number = this._getNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            number = null;
        }
        return number;
    }

    public void setNumber(Number number) {
        if (number == null) {
            this.setText("");
        } else {
            String string = this.convertNumberToString(this._convertNumberType(number));
            this.setText(string);
        }
    }

    public void setDataType(Class clazz) {
        boolean bl;
        Number number = this.getNumber();
        this._type = clazz;
        if (number != null) {
            this.setNumber(number);
        }
        boolean bl2 = bl = this._type == Double.class || this._type == Double.TYPE || this._type == Float.class || this._type == Float.TYPE || this._type == BigDecimal.class;
        if (this._type == BigDecimal.class) {
            this.setDecimal(bl, Integer.MAX_VALUE);
        } else {
            this.setDecimal(bl);
        }
    }

    public Class getDataType() {
        return this._type;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public void setSigned(boolean bl) {
        if (bl != this.isSigned()) {
            this._signed = bl;
            if (!bl) {
                DecimalFormatSymbols decimalFormatSymbols = this._getDecimalFormat().getDecimalFormatSymbols();
                char c = decimalFormatSymbols.getMinusSign();
                String string = this.getText();
                int n = string.indexOf(c);
                if (n != -1) {
                    this.setText(string.substring(n + 1));
                } else {
                    n = string.indexOf(43);
                    if (n != -1) {
                        this.setText(string.substring(n + 1));
                    }
                }
            }
        }
    }

    public boolean isDecimal() {
        return this._decimal;
    }

    public void setDecimal(boolean bl) {
        this.setDecimal(bl, -1);
    }

    public void setDecimal(boolean bl, int n) {
        if (bl != this.isDecimal() || n != this._decimalDigits) {
            this._decimal = bl;
            if (n != this._decimalDigits) {
                this._format = null;
                if (bl) {
                    this._decimalDigits = n;
                    this._getDecimalFormat();
                }
            }
            this._decimalDigits = n;
            if (!bl) {
                DecimalFormatSymbols decimalFormatSymbols = this._getDecimalFormat().getDecimalFormatSymbols();
                char c = decimalFormatSymbols.getDecimalSeparator();
                String string = this.getText();
                int n2 = string.indexOf(c);
                String string2 = null;
                if (n2 != -1) {
                    if (n2 == 0) {
                        string2 = string.substring(1);
                    } else {
                        String string3 = string.substring(0, n2);
                        string2 = string3 + string.substring(n2 + 1);
                    }
                }
                if (string2 != null) {
                    this.setText(string2);
                }
            }
        }
    }

    @Override
    public void enableInputMethods(boolean bl) {
        super.enableInputMethods(false);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new NumberAccess();
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        if (!locale.equals(locale2)) {
            this._oldFormat = this._format;
            this._format = null;
            this._getDecimalFormat();
        }
    }

    protected boolean validateNumber(Number number) {
        return true;
    }

    protected String convertNumberToString(Number number) {
        if (this._format != null) {
            return this._format.format(number);
        }
        return number.toString();
    }

    @Override
    boolean __isOKToReplace(String string, int n, int n2) {
        if (!super.__isOKToReplace(string, n, n2)) {
            return false;
        }
        String string2 = this.getText();
        int n3 = string2.length();
        int n4 = string.length();
        if (n4 == 0 && n == 0 && n2 == n3) {
            return true;
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n2);
        String string5 = string3 + string4;
        DecimalFormatSymbols decimalFormatSymbols = this._getDecimalFormat().getDecimalFormatSymbols();
        char c = '+';
        char c2 = decimalFormatSymbols.getMinusSign();
        char c3 = decimalFormatSymbols.getDecimalSeparator();
        boolean bl = string5.indexOf(c) >= 0;
        boolean bl2 = string5.indexOf(c2) >= 0;
        boolean bl3 = string5.indexOf(c3) >= 0;
        boolean bl4 = this.isSigned();
        boolean bl5 = this.isDecimal();
        boolean bl6 = true;
        int n5 = n;
        for (int i = 0; i < n4; ++i) {
            n5 += i;
            char c4 = string.charAt(i);
            if (c4 == c || c4 == c2) {
                if (n5 == 0 && bl4 && !bl && !bl2) continue;
                bl6 = false;
                break;
            }
            if (c4 == c3) {
                if (bl5 && !bl3 && (n5 != 0 || !bl4 || !bl2 && !bl)) continue;
                bl6 = false;
                break;
            }
            if (c4 >= '0' && c4 <= '9') {
                if (n5 != 0 || !bl4 || !bl2 && !bl) continue;
                bl6 = false;
                break;
            }
            bl6 = false;
            break;
        }
        if (bl6) {
            string5 = string3 + string + string4;
            bl6 = this._validateNumberString(string5);
        }
        if (!bl6) {
            Toolkit.getDefaultToolkit().beep();
        }
        return bl6;
    }

    private boolean _validateNumberString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        DecimalFormatSymbols decimalFormatSymbols = this._getDecimalFormat().getDecimalFormatSymbols();
        char c = '+';
        char c2 = decimalFormatSymbols.getMinusSign();
        char c3 = decimalFormatSymbols.getDecimalSeparator();
        Number number = null;
        try {
            number = this._getNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string.equals(String.valueOf(c)) || string.equals(String.valueOf(c2)) || string.equals(String.valueOf(c3)) || string.equals(String.valueOf(c) + c3) || string.equals(String.valueOf(c2) + c3);
        }
        int n2 = string.indexOf(c3);
        int n3 = this._decimalDigits;
        if (n3 != -1 && n2 != -1 && n - n2 - 1 > n3) {
            return false;
        }
        return this.validateNumber(number);
    }

    private Number _getNumber(String string) throws NumberFormatException {
        Number number = null;
        if (string.startsWith(_PLUS_STRING)) {
            string = string.substring(1);
        }
        if (this._type == BigDecimal.class) {
            if ("".equals(string)) {
                throw new NumberFormatException();
            }
            return new BigDecimal(string);
        }
        if (this._type == BigInteger.class) {
            return new BigInteger(string);
        }
        DecimalFormat decimalFormat = this._getDecimalFormat();
        try {
            number = decimalFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new NumberFormatException();
        }
        if (this._type == Byte.TYPE || this._type == Byte.class) {
            if (number.doubleValue() > 127.0 || number.doubleValue() < -128.0) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Byte)) {
                number = new Byte(number.byteValue());
            }
        } else if (this._type == Short.TYPE || this._type == Short.class) {
            if (number.doubleValue() > 32767.0 || number.doubleValue() < -32768.0) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Short)) {
                number = new Short(number.shortValue());
            }
        } else if (this._type == Integer.TYPE || this._type == Integer.class) {
            if (number.doubleValue() > 2.147483647E9 || number.doubleValue() < -2.147483648E9) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Integer)) {
                number = IntegerUtils.getInteger((int)number.intValue());
            }
        } else if (this._type == Long.TYPE || this._type == Long.class) {
            if (number.doubleValue() > 9.223372036854776E18 || number.doubleValue() < -9.223372036854776E18) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Long)) {
                number = new Long(number.longValue());
            }
        } else if (this._type == Float.TYPE || this._type == Float.class) {
            if (Math.abs(number.doubleValue()) > 3.4028234663852886E38 || number.doubleValue() != 0.0 && Math.abs(number.doubleValue()) < (double)1.4E-45f) {
                throw new NumberFormatException();
            }
            if (!(number instanceof Float)) {
                number = new Float(number.floatValue());
            }
        } else if (!(number instanceof Double)) {
            number = new Double(number.doubleValue());
        }
        return number;
    }

    private Number _convertNumberType(Number number) {
        Number number2 = null;
        number2 = this._type == Byte.TYPE || this._type == Byte.class ? (Number)new Byte(number.byteValue()) : (Number)(this._type == Short.TYPE || this._type == Short.class ? (Number)new Short(number.shortValue()) : (Number)(this._type == Integer.TYPE || this._type == Integer.class ? (Number)IntegerUtils.getInteger((int)number.intValue()) : (Number)(this._type == Long.TYPE || this._type == Long.class ? (Number)new Long(number.longValue()) : (Number)(this._type == Float.TYPE || this._type == Float.class ? (Number)new Float(number.floatValue()) : (Number)(this._type == BigDecimal.class ? (Number)(number instanceof BigDecimal ? number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : new BigDecimal(number.doubleValue()))) : (Number)(this._type == BigInteger.class ? (Number)(number instanceof BigInteger ? number : new BigInteger(number.toString())) : (Number)new Double(number.doubleValue())))))));
        return number2;
    }

    private DecimalFormat _getDecimalFormat() {
        if (this._format == null) {
            Number number = null;
            if (this._oldFormat != null) {
                try {
                    number = this._oldFormat.parse(this.getText());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            Locale locale = LocaleUtils.getDefaultableLocale(this);
            this._format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            if ("ar".equals(locale.getLanguage())) {
                this._format.setNegativePrefix(String.valueOf(this._format.getDecimalFormatSymbols().getMinusSign()));
                this._format.setNegativeSuffix("");
            }
            this._format.setGroupingUsed(false);
            if (this._decimalDigits >= 0) {
                this._format.setMaximumFractionDigits(this._decimalDigits);
            }
            if (number != null) {
                this.setNumber(number);
            }
        }
        return this._format;
    }

    public class NumberAccess
    extends LWTextField.Access
    implements AccessibleValue {
        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return NumberTextField.this.getNumber();
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            if (NumberTextField.this.validateNumber(number)) {
                NumberTextField.this.setNumber(number);
                return true;
            }
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return null;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

