/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.util.Locale;
import java.util.Vector;
import oracle.ewt.LookAndFeel;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.lwText.CursorUtils;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.displayFilter.DisplayStringFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.Range;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WrapInfo;
import oracle.ewt.util.BIDIText;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

class Paragraph
implements WrapInfo {
    private StringBuffer _text;
    private int[] _rowStarts;
    private int _rowCount;
    private int _wrapValidCount;
    private LWTextArea _area;
    private int _firstValidRow;

    public static Paragraph[] createParagraphs(LWTextArea lWTextArea, String string, boolean bl) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return new Paragraph[]{new Paragraph(lWTextArea)};
        }
        int n3 = 0;
        Vector<Paragraph> vector = new Vector<Paragraph>();
        do {
            n = (n = string.indexOf(10, n3)) < 0 ? n2 : ++n;
            vector.addElement(new Paragraph(lWTextArea, string.substring(n3, n)));
            n3 = n;
        } while (n < n2);
        if (bl && ((Paragraph)vector.lastElement())._endsWithNewline()) {
            vector.addElement(new Paragraph(lWTextArea));
        }
        int n4 = vector.size();
        Paragraph[] paragraphArray = new Paragraph[n4];
        for (int i = 0; i < n4; ++i) {
            paragraphArray[i] = (Paragraph)vector.elementAt(i);
        }
        return paragraphArray;
    }

    public Paragraph(LWTextArea lWTextArea) {
        this(lWTextArea, "");
    }

    public Paragraph(LWTextArea lWTextArea, String string) {
        this._area = lWTextArea;
        this._text = new StringBuffer(string);
    }

    public int getTextLength() {
        return this._text.length();
    }

    public String getText() {
        return this._text.toString();
    }

    public String getText(int n, int n2) {
        String string = this.getText();
        if (n2 > string.length()) {
            return string.substring(n);
        }
        return string.substring(n, n2);
    }

    int _getRowAlignmentOffset(int n) {
        if (this._area.getActualAlignment() == 1) {
            return 0;
        }
        String string = this._getDisplayString(n);
        if (this._area._isBIDIEnabled()) {
            DisplayStringFilter displayStringFilter = this._area._getBIDIFilter();
            string = displayStringFilter.convertString(string);
        }
        return this._getRowAlignmentOffset(string);
    }

    private int _getRowAlignmentOffset(String string) {
        int n = this._area.getActualAlignment();
        if (n == 1) {
            return 0;
        }
        int n2 = this.getWrapWidth() - this.getFontMetrics().stringWidth(string) - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n == 3) {
            n2 >>= 1;
        }
        return n2;
    }

    private void _paintRow(Graphics graphics, int n, int n2, int n3, String string, boolean bl) {
        boolean bl2;
        boolean bl3 = StringUtils.containsRightToLeft(string);
        FontMetrics fontMetrics = null;
        boolean bl4 = bl2 = string.length() > 0 && string.charAt(0) == '\u202d';
        while (string.length() > 0) {
            int n4 = string.indexOf(9);
            if (n4 < 0) {
                this._area.getInputMethodManager().makeRowString(this._area.getGlobalPaintStart(), string.length());
                this.doDrawString(graphics, string, n + n3, n2);
                if (bl) {
                    this._area.setGlobalPaintStart(this._area.getGlobalPaintStart() + string.length() + 1);
                    break;
                }
                this._area.setGlobalPaintStart(this._area.getGlobalPaintStart() + string.length());
                break;
            }
            String string2 = string.substring(0, n4);
            this._area.getInputMethodManager().makeRowString(this._area.getGlobalPaintStart(), string2.length());
            this.doDrawString(graphics, string2, n + n3, n2);
            if (fontMetrics == null) {
                fontMetrics = this.getFontMetrics();
            }
            int n5 = fontMetrics.stringWidth(string2);
            n = this._area._getNextTab(n + fontMetrics.stringWidth(string2), bl3);
            string = bl2 ? '\u202d' + string.substring(n4 + 1) : string.substring(n4 + 1);
            this._area.setGlobalPaintStart(this._area.getGlobalPaintStart() + n4 + 1);
        }
    }

    private void doDrawString(Graphics graphics, String string, int n, int n2) {
        boolean bl = false;
        bl = this._area.getInputMethodManager().paintText(graphics, n, n2);
        if (!bl) {
            GraphicUtils.drawString(graphics, string, n, n2);
        }
    }

    private void _paintRowSelectionRange(Graphics graphics, FontMetrics fontMetrics, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        int n7 = n + fontMetrics.stringWidth(string.substring(0, n4));
        int n8 = 0;
        string = string.substring(n4, n5);
        boolean bl = StringUtils.containsRightToLeft(string);
        while (string.length() > 0) {
            int n9 = string.indexOf(9);
            if (n9 < 0) {
                n8 += fontMetrics.stringWidth(string);
                break;
            }
            String string2 = string.substring(0, n9);
            n8 += fontMetrics.stringWidth(string2);
            n8 = this._area._getNextTab(n7 + n8, bl) - n7;
            string = string.substring(n9 + 1);
        }
        graphics.clipRect(n7 + n3, n2, n8, n6);
        graphics.fillRect(n7 + n3, n2, n8, n6);
    }

    public int paintText(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        n5 = Math.min(n5, this.getRowCount() - 1);
        boolean bl = this._area._isBIDIEnabled();
        DisplayStringFilter displayStringFilter = null;
        if (bl) {
            displayStringFilter = this._area._getBIDIFilter();
        }
        while (n4 <= n5) {
            int n6 = this.getRowEnd(n4);
            boolean bl2 = n6 > 0 && this._text.charAt(n6 - 1) == '\n';
            String string = this._getDisplayString(n4++);
            if (bl) {
                string = displayStringFilter.convertString(string);
            }
            int n7 = this._getRowAlignmentOffset(string);
            this._paintRow(graphics, n, n2, n7, string, bl2);
            n2 += n3;
        }
        return n2;
    }

    public int paintSelectionRange(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2) {
        n5 = Math.min(n5, this.getRowCount() - 1);
        Color color3 = graphics.getColor();
        FontMetrics fontMetrics = this.getFontMetrics();
        int n8 = fontMetrics.getAscent() + fontMetrics.getLeading();
        int n9 = this._area.getCanvasSize().width;
        while (n4 <= n5) {
            boolean bl;
            String string = this._getDisplayString(n4);
            int n10 = string.length();
            if (n4 == n5 && n7 < n10) {
                n10 = n7;
            }
            int n11 = n;
            int n12 = n6;
            if (this._area._isBIDIEnabled() && n12 != 0 && n12 >= n10) {
                n12 = n10 - 1;
            }
            if (n12 > 0) {
                n11 += fontMetrics.stringWidth(string.substring(0, n12));
            }
            boolean bl2 = n10 != n7 || n4 != n5;
            int n13 = bl2 ? n9 : fontMetrics.stringWidth(string.substring(0, n10)) + 1;
            int n14 = this.getRowEnd(n4);
            boolean bl3 = bl = n14 > 0 && this._text.charAt(n14 - 1) == '\n';
            if (!this._area._isBIDIEnabled()) {
                if (bl2 || n12 != n10) {
                    n13 -= n11;
                    int n15 = this._getRowAlignmentOffset(string);
                    graphics.setColor(color2);
                    if (n12 == 0) {
                        graphics.fillRect(n11, n2, n13 + n15, n3);
                    } else {
                        graphics.fillRect(n11 + n15, n2, n13, n3);
                    }
                    graphics.setColor(color);
                    this._paintRow(graphics, n11, n2 + n8, n15, string.substring(n12, n10), bl);
                }
            } else {
                Range[] rangeArray;
                DisplayStringFilter displayStringFilter = this._area._getBIDIFilter();
                if (!bl2 || n12 > 0) {
                    if (n12 != n10) {
                        rangeArray = displayStringFilter.getDisplaySelectionRanges(string, n12, n10);
                        String string2 = displayStringFilter.convertString(string);
                        Shape shape = graphics.getClip();
                        for (int i = 0; i < rangeArray.length; ++i) {
                            int n16 = this._getRowAlignmentOffset(string2);
                            graphics.setColor(color2);
                            this._paintRowSelectionRange(graphics, fontMetrics, n, n2, n16, string2, rangeArray[i].start, rangeArray[i].end, n3);
                            graphics.setColor(color);
                            this._paintRow(graphics, n, n2 + n8, n16, string2, bl);
                            graphics.setClip(shape);
                        }
                    }
                } else {
                    rangeArray = displayStringFilter.convertString(string);
                    int n17 = this._getRowAlignmentOffset((String)rangeArray);
                    graphics.setColor(color2);
                    graphics.fillRect(n, n2, n13, n3);
                    graphics.setColor(color);
                    this._paintRow(graphics, n11, n2 + n8, n17, (String)rangeArray, bl);
                }
            }
            n6 = 0;
            ++n4;
            n2 += n3;
        }
        graphics.setColor(color3);
        return n2;
    }

    public void paintInsertionPoint(Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        int n5 = n;
        FontMetrics fontMetrics = this.getFontMetrics();
        String string = this._getDisplayString(n3);
        if (this._area._isBIDIEnabled()) {
            object = this._area._getBIDIFilter();
            n4 = object.valueIndexToDisplayIndex(string, n4);
            string = object.convertString(string);
        }
        object = string;
        int n6 = this._getRowAlignmentOffset(string);
        n += n6;
        if (n4 < string.length()) {
            string = string.substring(0, n4);
        }
        int n7 = CursorUtils.getcaretWidth();
        graphics.fillRect(n += fontMetrics.stringWidth(string), n2, n7, fontMetrics.getHeight());
        Shape shape = graphics.getClip();
        Color color = graphics.getColor();
        graphics.setClip(n, n2, n7, fontMetrics.getHeight());
        graphics.setColor(this._area.getUIDefaults().getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
        int n8 = fontMetrics.getAscent() + fontMetrics.getLeading();
        int n9 = this.getRowEnd(n3);
        boolean bl = n9 > 0 && this._text.charAt(n9 - 1) == '\n';
        this._paintRow(graphics, n5, n2 + n8, n6, (String)object, bl);
        graphics.setClip(shape);
        graphics.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeText(int n, int n2) {
        if (n != n2) {
            Paragraph paragraph = this;
            synchronized (paragraph) {
                String string = this.getText();
                int n3 = string.length();
                if (n2 > n3) {
                    n2 = n3;
                }
                if (n != n2) {
                    StringBuffer stringBuffer = new StringBuffer(n3 - (n2 - n));
                    if (n != 0) {
                        stringBuffer.append(string.substring(0, n));
                    }
                    if (n2 != n3) {
                        stringBuffer.append(string.substring(n2, n3));
                    }
                    this._text = stringBuffer;
                    this._invalidateFrom(n);
                    return stringBuffer.length() == 0;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertText(String string, int n) {
        if (string.length() > 0) {
            Paragraph paragraph = this;
            synchronized (paragraph) {
                if (n >= this._text.length()) {
                    this._text.append(string);
                } else {
                    this._text.insert(n, string);
                }
                this._invalidateFrom(n);
            }
        }
    }

    public int getRowCount() {
        this._wrapTextIfNecessary();
        return this._rowCount;
    }

    public synchronized int getRowStart(int n) {
        if (n == 0) {
            return 0;
        }
        int[] nArray = this._getRowStarts();
        return nArray[n];
    }

    public synchronized int getRowEnd(int n) {
        int[] nArray = this._getRowStarts();
        if (nArray == null) {
            return this.getTextLength();
        }
        return nArray[n + 1];
    }

    public Point indexToRowAndColumn(int n) {
        int n2 = this._indexToRow(n);
        return new Point(n - this.getRowStart(n2), n2);
    }

    public int measureWidth(FontMetrics fontMetrics, int n, int n2) {
        int n3 = this.getRowStart(n);
        int n4 = n3 + n2;
        if (this._area._isBIDIEnabled() && n4 != 0 && n4 >= this.getTextLength()) {
            n4 = this.getTextLength() - 1;
        }
        String string = this.getText().substring(n3, n4);
        if (this._area._isBIDIEnabled()) {
            String string2 = this._getDisplayString(n);
            DisplayStringFilter displayStringFilter = this._area._getBIDIFilter();
            n2 = displayStringFilter.valueIndexToDisplayIndex(string2, n2);
            string = displayStringFilter.convertString(string2);
            string = string.substring(0, n2);
        }
        return fontMetrics.stringWidth(string);
    }

    public int pixelToIndex(FontMetrics fontMetrics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this._text == null) {
            return 0;
        }
        if (n2 >= this.getRowCount()) {
            return this._text.length();
        }
        int n7 = this.getRowStart(n2);
        if (n <= 0) {
            return n7;
        }
        int n8 = this.getRowEnd(n2);
        if (n7 == n8) {
            return n7;
        }
        char[] cArray = new char[n8 - n7];
        this._text.getChars(n7, n8, cArray, 0);
        int n9 = n8 - n7;
        if (cArray[n9 - 1] == '\n') {
            --n9;
        }
        String string = new String(cArray, 0, n9);
        if (this._area._isBIDIEnabled()) {
            DisplayStringFilter displayStringFilter = this._area._getBIDIFilter();
            String string2 = displayStringFilter.convertString(string);
            cArray = string2.toCharArray();
            n9 = cArray.length;
            if ((n -= this._getRowAlignmentOffset(string2)) <= 0) {
                return n7 + displayStringFilter.displayIndexToValueIndex(string, -1);
            }
        } else if ((n -= this._getRowAlignmentOffset(string)) <= 0) {
            return n7;
        }
        if ((n6 = n / (n5 = FontUtils.getAverageWidth(fontMetrics))) >= n9) {
            n6 = n9 - 1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if ((n4 = fontMetrics.charsWidth(cArray, 0, n6)) < n) {
            while (n6 < n9) {
                int n10;
                n3 = cArray[n6];
                if ((n4 += (n10 = n3 == 9 ? fontMetrics.charsWidth(cArray, 0, n6 + 1) - n4 : fontMetrics.charWidth((char)n3))) > n) {
                    if (!BIDIText.isRightToLeft((char)n3)) {
                        if (n + (n10 >> 1) >= n4) {
                            ++n6;
                        }
                    } else if (n + (n10 >> 1) < n4) {
                        --n6;
                    }
                    break;
                }
                ++n6;
            }
        } else {
            n3 = 0;
            while (n4 > n && n6 > 0) {
                char c;
                n3 = (c = cArray[--n6]) == '\t' ? n4 - fontMetrics.charsWidth(cArray, 0, n6 + 1) : fontMetrics.charWidth(c);
                n4 -= n3;
            }
            if (!BIDIText.isRightToLeft(cArray[n6])) {
                if (n4 + (n3 >> 1) < n) {
                    ++n6;
                }
            } else if (n4 + (n3 >> 1) >= n) {
                --n6;
            }
        }
        if (this._area._isBIDIEnabled()) {
            DisplayStringFilter displayStringFilter = this._area._getBIDIFilter();
            n6 = displayStringFilter.displayIndexToValueIndex(string, n6);
        }
        return n6 + n7;
    }

    public Range findWord(int n) {
        char[] cArray = this.getText().toCharArray();
        return new Range(LWCommonText.findWordStart(cArray, n), LWCommonText.findWordEnd(cArray, n));
    }

    @Override
    public int getWrapWidth() {
        return this._area._getWrapWidth();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this._area._getFontMetrics();
    }

    @Override
    public Locale getLocale() {
        return LocaleUtils.getDefaultableLocale(this._area);
    }

    @Override
    public boolean addLine(String string, int n, int n2) {
        int n3 = ++this._rowCount;
        int[] nArray = this._rowStarts;
        if (nArray == null) {
            if (n2 == this.getTextLength()) {
                return false;
            }
            nArray = this._rowStarts = new int[2];
            nArray[0] = 0;
        }
        if (nArray.length <= n3) {
            nArray = new int[nArray.length * 2];
            System.arraycopy(this._rowStarts, 0, nArray, 0, n3);
            this._rowStarts = nArray;
        }
        if (n3 > 0) {
            n2 = nArray[n3 - 1] + n2 - n;
        }
        nArray[n3] = n2;
        return true;
    }

    private synchronized void _wrapTextIfNecessary() {
        if (!this._isWrappingValid() && this.getFontMetrics() != null) {
            TextWrapper textWrapper = this._area.getTextWrapper();
            String string = this.getText();
            if (string.length() > 0) {
                int n = this._firstValidRow;
                if (n <= 0) {
                    this._rowCount = 0;
                } else {
                    this._rowCount = n;
                    string = string.substring(this._rowStarts[this._rowCount]);
                }
                textWrapper.wrapParagraph(this, string);
            } else {
                this._rowStarts = null;
                this._rowCount = 1;
            }
            this._firstValidRow = -1;
            this._wrapValidCount = this._area._getWrapValidCount();
        }
    }

    private boolean _isWrappingValid() {
        if (this._wrapValidCount != this._area._getWrapValidCount()) {
            this._firstValidRow = 0;
        }
        return this._firstValidRow < 0;
    }

    private boolean _endsWithNewline() {
        return this._text.charAt(this._text.length() - 1) == '\n';
    }

    public int getRowDisplayEnd(int n) {
        int n2 = this.getRowEnd(n);
        if (n2 > 0 && this._text.charAt(n2 - 1) == '\n') {
            --n2;
        }
        return n2;
    }

    private String _getDisplayString(int n) {
        return this.getText().substring(this.getRowStart(n), this.getRowDisplayEnd(n));
    }

    private int[] _getRowStarts() {
        this._wrapTextIfNecessary();
        return this._rowStarts;
    }

    private int _indexToRow(int n) {
        int n2 = this.getRowCount();
        int[] nArray = this._getRowStarts();
        if (nArray == null) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[i + 1] < n) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    private void _invalidateFrom(int n) {
        int[] nArray = this._rowStarts;
        int n2 = this._firstValidRow;
        if (n2 < 0) {
            n2 = this._rowCount - 1;
        }
        while (n2 > 0) {
            if (nArray[n2] < n) {
                --n2;
                break;
            }
            --n2;
        }
        this._firstValidRow = n2;
    }
}

