/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText.im;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.TextEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.im.InputMethodUtil;
import oracle.ewt.util.EventQueueUtils;

class InputMethodListenerHandler
extends FocusAdapter
implements InputMethodListener,
AWTEventListener {
    private InputMethodUtil _imeUtil;
    private int _oldComposedStrLen = 0;
    private int _originalMaxLen = 0;
    private boolean _ignoreIMEEvents;

    public InputMethodListenerHandler(InputMethodUtil inputMethodUtil) {
        this._imeUtil = inputMethodUtil;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        if (this._ignoreIMEEvents) {
            return;
        }
        LWCommonText lWCommonText = this._imeUtil.getTextComponent();
        int n = inputMethodEvent.getCommittedCharacterCount();
        int n2 = 0;
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        AttributedString attributedString = null;
        if (this._oldComposedStrLen <= 0) {
            this._originalMaxLen = lWCommonText.getMaximumChars();
        }
        int n3 = this._imeUtil.getComposedStart();
        if (this._oldComposedStrLen <= 0 || n3 < 0) {
            n3 = lWCommonText.getCaretPosition();
        }
        int n4 = lWCommonText.getTextLength();
        n3 = Math.min(n3, n4);
        this._oldComposedStrLen = Math.min(this._oldComposedStrLen, n4 - n3);
        if (this._oldComposedStrLen > 0) {
            lWCommonText.replaceRangeWithoutCommit(null, n3, n3 + this._oldComposedStrLen);
            this._oldComposedStrLen = 0;
        }
        if (attributedCharacterIterator != null) {
            int n5;
            int n6;
            int n7 = attributedCharacterIterator.getBeginIndex();
            int n8 = attributedCharacterIterator.getEndIndex();
            int n9 = n7 + n;
            int n10 = lWCommonText.getSelectionStart();
            if (n10 < (n6 = lWCommonText.getSelectionEnd())) {
                lWCommonText.replaceRangeWithoutCommit("", n10, n6);
                n3 = lWCommonText.getCaretPosition();
            }
            char c = attributedCharacterIterator.first();
            if (n5 > 0) {
                lWCommonText.setMaximumChars(this._originalMaxLen);
                n4 = lWCommonText.getTextLength();
                for (n5 = n; n5 > 0 && this._originalMaxLen > n4; --n5) {
                    lWCommonText.replaceRangeWithoutCommit(String.valueOf(c), n3, n3);
                    lWCommonText.redispatchEvent(new TextEvent(lWCommonText, 900));
                    int n11 = lWCommonText.getTextLength();
                    n3 += n11 - n4;
                    n4 = n11;
                    c = attributedCharacterIterator.next();
                }
            }
            if ((n2 = n8 - n9) > 0) {
                StringBuffer stringBuffer = new StringBuffer(n2);
                attributedCharacterIterator.setIndex(n9);
                c = attributedCharacterIterator.current();
                while (c != '\uffff') {
                    stringBuffer.append(c);
                    c = attributedCharacterIterator.next();
                }
                n2 = stringBuffer.length();
                if (n2 > 0) {
                    int n12 = (int)Math.min((long)lWCommonText.getTextLength() + (long)n2, Integer.MAX_VALUE);
                    if (n12 > this._originalMaxLen) {
                        lWCommonText.setMaximumChars(n12);
                    }
                    n4 = lWCommonText.getTextLength();
                    lWCommonText.replaceRangeWithoutCommit(stringBuffer.toString(), n3, n3);
                    n2 = lWCommonText.getTextLength() - n4;
                    if (n2 > 0) {
                        int n13;
                        if (lWCommonText instanceof LWTextField) {
                            n13 = lWCommonText.getTextLength() - n2;
                            String string = lWCommonText.getText();
                            String string2 = ((LWTextField)lWCommonText).getDisplayStringFilter().convertString(string.substring(0, n13));
                            attributedString = new AttributedString(string2 + string.substring(n13));
                        } else {
                            attributedString = new AttributedString(lWCommonText.getText());
                        }
                        attributedString.addAttribute(TextAttribute.FONT, lWCommonText.getFont());
                        attributedCharacterIterator.setIndex(n9);
                        n13 = 0;
                        while (attributedCharacterIterator.getIndex() < n8) {
                            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, attributedCharacterIterator.getAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT), n3 + n13, n3 + n13 + 1);
                            attributedCharacterIterator.next();
                            ++n13;
                        }
                    }
                }
            }
        } else {
            n3 = -1;
        }
        this._imeUtil.setDisplayText(attributedString != null ? attributedString.getIterator() : null);
        if (n2 <= 0) {
            lWCommonText.setMaximumChars(this._originalMaxLen);
        }
        this._oldComposedStrLen = n2;
        this._imeUtil.setComposedStart(n3);
        this._setCaretPosition(inputMethodEvent.getCaret());
        lWCommonText.invalidateTextLayout();
        inputMethodEvent.consume();
    }

    @Override
    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this._setCaretPosition(inputMethodEvent.getCaret());
        inputMethodEvent.consume();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary() && focusEvent.getSource() == this._imeUtil.getTextComponent()) {
            this._addAWTEventListener();
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        FocusEvent focusEvent;
        if (aWTEvent instanceof FocusEvent && (focusEvent = (FocusEvent)aWTEvent).getID() == 1005 && !focusEvent.isTemporary()) {
            LWCommonText lWCommonText = this._imeUtil.getTextComponent();
            if (focusEvent.getSource() == lWCommonText) {
                InputContext inputContext;
                if (lWCommonText.isEditable() && (inputContext = lWCommonText.getInputContext()) != null) {
                    inputContext.endComposition();
                }
                this._removeAWTEventListener();
            }
        }
    }

    public void endComposition() {
        int n = this._imeUtil.getComposedStart();
        if (this._oldComposedStrLen > 0 && n >= 0) {
            LWCommonText lWCommonText = this._imeUtil.getTextComponent();
            int n2 = lWCommonText.getTextLength();
            n = Math.min(n, n2);
            this._oldComposedStrLen = Math.min(this._oldComposedStrLen, n2 - n);
            String string = null;
            int n3 = this._oldComposedStrLen;
            if (this._oldComposedStrLen > 0) {
                string = lWCommonText.getText();
                lWCommonText.replaceRangeWithoutCommit(null, n, n + this._oldComposedStrLen);
                this._oldComposedStrLen = 0;
            }
            lWCommonText.setMaximumChars(this._originalMaxLen);
            if (string != null) {
                n2 = lWCommonText.getTextLength();
                int n4 = n + n3;
                for (int i = n; i < n4 && this._originalMaxLen > n2; ++i) {
                    lWCommonText.replaceRangeWithoutCommit(String.valueOf(string.charAt(i)), n, n);
                    lWCommonText.redispatchEvent(new TextEvent(lWCommonText, 900));
                    int n5 = lWCommonText.getTextLength();
                    n += n5 - n2;
                    n2 = n5;
                }
            }
            this._imeUtil.setDisplayText(null);
            this._imeUtil.setComposedStart(-1);
            InputContext inputContext = lWCommonText.getInputContext();
            if (inputContext != null) {
                inputContext.endComposition();
                this._ignoreIMEEvents = true;
                EventQueueUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InputMethodListenerHandler.this._ignoreIMEEvents = false;
                    }
                });
            }
        }
    }

    private void _addAWTEventListener() {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(InputMethodListenerHandler.this, 4L);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void _removeAWTEventListener() {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(InputMethodListenerHandler.this);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void _setCaretPosition(TextHitInfo textHitInfo) {
        int n;
        if (textHitInfo != null && (n = this._imeUtil.getComposedStart()) >= 0) {
            this._imeUtil.getTextComponent().setCaretPosition(textHitInfo.getInsertionIndex() + n);
        }
    }
}

