/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Rectangle;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.lwAWT.lwWindow.laf.BaseWindowReshaper;

class BaseWindowResizer
extends BaseWindowReshaper {
    private Rectangle _initialWindowBounds;

    public BaseWindowResizer(LWWindow lWWindow) {
        super(lWWindow);
    }

    @Override
    protected boolean beginReshaping() {
        if (super.beginReshaping()) {
            LWWindow lWWindow = this.getWindow();
            this._initialWindowBounds = lWWindow.getBounds();
            WindowManager windowManager = this.getWindowManager();
            if (windowManager == null) {
                lWWindow.setReshaping(false);
            } else {
                windowManager.beginResizingWindow(lWWindow);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void endReshaping(boolean bl) {
        if (this.isReshaping()) {
            super.endReshaping(bl);
            LWWindow lWWindow = this.getWindow();
            WindowManager windowManager = this.getWindowManager();
            if (windowManager == null) {
                lWWindow.setReshaping(false);
            } else {
                windowManager.endResizingWindow(lWWindow, bl);
            }
        }
    }

    protected Rectangle getWindowBounds() {
        return new Rectangle(this._initialWindowBounds);
    }

    @Override
    protected boolean isWindowReshapable() {
        LWWindow lWWindow = this.getWindow();
        return lWWindow.isResizable() && !lWWindow.isMaximized() && !lWWindow.isMinimized();
    }

    protected void resizeWindow(int n, int n2, int n3, int n4) {
        WindowManager windowManager = this.getWindowManager();
        windowManager.resizeWindow(this.getWindow(), n, n2, n3, n4);
    }

    protected void setWindowBounds(Rectangle rectangle) {
        this._initialWindowBounds = new Rectangle(rectangle);
    }
}

