/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwWindow.LWWindow;

final class MouseWindowActivater
implements MouseListener,
MouseMotionListener {
    private static MouseWindowActivater _sInstance;

    private MouseWindowActivater() {
    }

    public static MouseWindowActivater getInstance() {
        if (_sInstance == null) {
            _sInstance = new MouseWindowActivater();
        }
        return _sInstance;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this._consumeDisabledEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this._consumeDisabledEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this._consumeDisabledEvent(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        Component component = mouseEvent.getComponent();
        LWWindow lWWindow = this._getWindow(component);
        if (lWWindow != null) {
            if (!lWWindow.isEnabled()) {
                this._consumeDisabledEvent(mouseEvent);
            } else {
                lWWindow.setActive(true);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._consumeDisabledEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this._consumeDisabledEvent(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this._consumeDisabledEvent(mouseEvent);
    }

    private void _consumeDisabledEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        Component component = mouseEvent.getComponent();
        LWWindow lWWindow = this._getWindow(component);
        if (lWWindow != null && !lWWindow.isEnabled() && this._isContentComponent(component, lWWindow)) {
            mouseEvent.consume();
        }
    }

    private LWWindow _getWindow(Component component) {
        while (component != null) {
            if (component instanceof LWWindow) {
                return (LWWindow)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private boolean _isContentComponent(Component component, LWWindow lWWindow) {
        Component component2 = lWWindow.getContent();
        LWMenuBar lWMenuBar = lWWindow.getMenuBar();
        while (component != lWWindow) {
            if (component == component2 || component == lWMenuBar) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }
}

