/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.laf.BaseWindowResizer;
import oracle.ewt.util.InputEventUtils;

public final class MouseWindowResizer
extends BaseWindowResizer
implements MouseListener,
MouseMotionListener {
    private int _initialMouseX;
    private int _initialMouseY;
    private int _resizeOrientation;
    private static final int _NORTH = 1;
    private static final int _SOUTH = 2;
    private static final int _EAST = 4;
    private static final int _WEST = 8;
    private static final int _NORTHEAST = 5;
    private static final int _NORTHWEST = 9;
    private static final int _SOUTHEAST = 6;
    private static final int _SOUTHWEST = 10;
    private static final int _RESIZE_HANDLE_SIZE = 20;
    private static final Insets _sDefaultInsets = new Insets(2, 2, 2, 2);

    public MouseWindowResizer(LWWindow lWWindow) {
        super(lWWindow);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isReshaping()) {
            this.endReshaping(false);
            mouseEvent.consume();
            return;
        }
        if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this._beginResizing(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.endReshaping(true);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this._updateCursor(mouseEvent, this.isWindowReshapable());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isReshaping()) {
            return;
        }
        int n = mouseEvent.getX() - this._initialMouseX;
        int n2 = mouseEvent.getY() - this._initialMouseY;
        Rectangle rectangle = this.getWindowBounds();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if ((this._resizeOrientation & 1) != 0) {
            n4 += n2;
            n6 -= n2;
        }
        if ((this._resizeOrientation & 8) != 0) {
            n3 += n;
            n5 -= n;
        }
        if ((this._resizeOrientation & 2) != 0) {
            n6 += n2;
        }
        if ((this._resizeOrientation & 4) != 0) {
            n5 += n;
        }
        LWWindow lWWindow = this.getWindow();
        Dimension dimension = lWWindow.getMinimumSize();
        Dimension dimension2 = lWWindow.getMaximumSize();
        if (n6 < dimension.height) {
            n6 = dimension.height;
            if ((this._resizeOrientation & 1) != 0) {
                n4 = rectangle.y + rectangle.height - n6;
            }
        } else if (n6 > dimension2.height) {
            n6 = dimension2.height;
            if ((this._resizeOrientation & 1) != 0) {
                n4 = rectangle.y + rectangle.height - n6;
            }
        }
        if (n5 < dimension.width) {
            n5 = dimension.width;
            if ((this._resizeOrientation & 8) != 0) {
                n3 = rectangle.x + rectangle.width - n5;
            }
        } else if (n5 > dimension2.width) {
            n5 = dimension2.width;
            if ((this._resizeOrientation & 8) != 0) {
                n3 = rectangle.x + rectangle.width - n5;
            }
        }
        this.resizeWindow(n3, n4, n5, n6);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this._updateCursor(mouseEvent, this.isWindowReshapable());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected MouseListener getMouseGrab() {
        return this;
    }

    private void _beginResizing(MouseEvent mouseEvent) {
        if (this.beginReshaping()) {
            this._initialMouseX = mouseEvent.getX();
            this._initialMouseY = mouseEvent.getY();
            this._resizeOrientation = this._getOrientation((Component)mouseEvent.getSource(), this._initialMouseX, this._initialMouseY);
        }
    }

    private void _updateCursor(MouseEvent mouseEvent, boolean bl) {
        Cursor cursor;
        Component component = (Component)mouseEvent.getSource();
        int n = 0;
        if (bl) {
            switch (this._getOrientation(component, mouseEvent.getX(), mouseEvent.getY())) {
                case 4: {
                    n = 11;
                    break;
                }
                case 1: {
                    n = 8;
                    break;
                }
                case 5: {
                    n = 7;
                    break;
                }
                case 9: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 9;
                    break;
                }
                case 6: {
                    n = 5;
                    break;
                }
                case 10: {
                    n = 4;
                    break;
                }
                case 8: {
                    n = 10;
                }
            }
        }
        if ((cursor = component.getCursor()) == null || cursor.getType() != n) {
            component.setCursor(Cursor.getPredefinedCursor(n));
        }
    }

    private int _getOrientation(Component component, int n, int n2) {
        Insets insets;
        int n3 = 1;
        Dimension dimension = component.getSize();
        Insets insets2 = insets = component instanceof Container ? ((Container)component).getInsets() : _sDefaultInsets;
        if (n2 < insets.top) {
            n3 = n < 20 ? 9 : (n >= dimension.width - 20 ? 5 : 1);
        } else if (n2 >= dimension.height - insets.bottom) {
            n3 = n < 20 ? 10 : (n >= dimension.width - 20 ? 6 : 2);
        } else if (n < insets.left) {
            n3 = n2 < 20 ? 9 : (n2 >= dimension.height - 20 ? 10 : 8);
        } else if (n >= dimension.width - insets.right) {
            n3 = n2 < 20 ? 5 : (n2 >= dimension.height - 20 ? 6 : 4);
        }
        return n3;
    }
}

