/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.FontMetrics;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.TextPainter;

public class TruncatingTextPainter
extends TextPainter {
    protected static final String _ELLIPSIS = "...";

    public TruncatingTextPainter() {
    }

    public TruncatingTextPainter(Object object) {
        super(object);
    }

    public TruncatingTextPainter(Object object, boolean bl) {
        super(object, bl);
    }

    @Override
    protected String getPaintText(PaintContext paintContext, String string, FontMetrics fontMetrics, int n) {
        int n2 = fontMetrics.stringWidth(string);
        if (n2 > n) {
            int n3 = fontMetrics.stringWidth(_ELLIPSIS);
            float f = this.getAlignmentX(paintContext);
            if (f == 1.0f || f != 0.0f && paintContext.getReadingDirection() == 2) {
                int n4 = 0;
                int n5 = string.length();
                for (int i = n - n3 - n2; i < 0; i += fontMetrics.charWidth(string.charAt(n4++))) {
                    if (n4 != n5) continue;
                }
                string = n5 > 0 && string.charAt(0) == '\u202d' ? "\u202d..." + string.substring(n4) : _ELLIPSIS + string.substring(n4);
            } else {
                int n6 = -1;
                int n7 = string.length();
                for (int i = n - n3; i > 0 && ++n6 != n7; i -= fontMetrics.charWidth(string.charAt(n6))) {
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                string = string.substring(0, n6) + _ELLIPSIS;
            }
        }
        return string;
    }

    protected static String getEllipsis(PaintContext paintContext) {
        return _ELLIPSIS;
    }
}

