/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.grid.Grid;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuAdapter;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuEvent;
import oracle.ewt.pivot.DrillEvent;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.util.ComponentUtils;

public class DrillPopup {
    private static final int _DEFAULT_IMAGE_WIDTH = 5;
    private static final int _DEFAULT_IMAGE_HEIGHT = 5;
    PivotTable _pivot;
    boolean _isHorizontal;
    int _column;
    int _row;
    Object[] _cmds;
    private _Listener _listener = new _Listener();
    private LWPopupMenu _menu;
    private boolean _dirty;
    private String[] _items;
    PivotHeader _header;

    public DrillPopup() {
        this(null, null);
    }

    public DrillPopup(String[] stringArray, Object[] objectArray) {
        this.setItems(stringArray, objectArray);
    }

    public void removeAll() {
        this._items = null;
        this._cmds = null;
    }

    public void setItems(String[] stringArray, Object[] objectArray) {
        this.removeAll();
        this._items = stringArray;
        this._cmds = objectArray;
        this._dirty = true;
    }

    public void show(DrillEvent drillEvent) {
        this._pivot = drillEvent.getPivotTable();
        this._column = drillEvent.getColumn();
        this._row = drillEvent.getRow();
        this._isHorizontal = drillEvent.isHorizontal();
        PivotHeader pivotHeader = this._isHorizontal ? this._pivot.getColumnPivotHeader() : this._pivot.getRowPivotHeader();
        Grid grid = pivotHeader.getGrid();
        int n = 5;
        int n2 = 5;
        Image image = pivotHeader.getDrillImage(this._column, this._row);
        if (image != null) {
            n = image.getWidth(pivotHeader);
            n2 = image.getHeight(pivotHeader);
        }
        boolean bl = grid.getActualReadingDirection() == 1;
        int n3 = bl ? grid.getColumnPosition(this._column) + n : grid.getColumnPosition(this._column) + grid.getColumnWidth(this._column) - n;
        int n4 = grid.getRowPosition(this._row) + n2 / 2;
        Point point = grid.convertCanvasToOuter(n3, n4);
        this._header = pivotHeader;
        this._header.setDrilling(true);
        this._showMenu(grid, point.x, point.y);
    }

    private void _showMenu(Component component, int n, int n2) {
        if (this._items == null || this._items.length == 0) {
            return;
        }
        if (this._menu == null) {
            this._menu = new MousePopupMenu();
            this._menu.addPopupMenuListener(new MenuListen());
        }
        if (this._dirty) {
            this._menu.getContent().removeAll();
            for (int i = 0; i < this._items.length; ++i) {
                LWMenuItem lWMenuItem = new LWMenuItem(this._items[i]);
                lWMenuItem.addActionListener(this._listener);
                lWMenuItem.setActionCommand(IntegerUtils.getString((int)i));
                this._menu.add(lWMenuItem);
            }
            this._dirty = false;
        }
        this._menu.popup(component, n, n2);
    }

    private class MenuListen
    extends LWPopupMenuAdapter {
        private MenuListen() {
        }

        @Override
        public void menuPoppedDown(LWPopupMenuEvent lWPopupMenuEvent) {
            if (DrillPopup.this._header != null) {
                DrillPopup.this._header.setDrilling(false);
            }
        }
    }

    private static class MousePopupMenu
    extends LWPopupMenu {
        private MousePopupMenu() {
        }

        @Override
        protected void processGrabbedMouseEvent(MouseEvent mouseEvent) {
            Component component = this.getMenuInvoker().getInvokerComponent();
            Component component2 = mouseEvent.getComponent();
            int n = mouseEvent.getID();
            if (n == 501) {
                super.processGrabbedMouseEvent(mouseEvent);
                if (component2 == component) {
                    mouseEvent.consume();
                }
            } else if (n == 502) {
                Component component3 = ComponentUtils.getTargetComponentOutside(component2, new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (component3 != component) {
                    super.processGrabbedMouseEvent(mouseEvent);
                }
            } else {
                super.processGrabbedMouseEvent(mouseEvent);
            }
        }
    }

    private class _Listener
    implements ActionListener {
        private _Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            DrillPopup.this._pivot.fireDrillEvent(DrillPopup.this._isHorizontal, DrillPopup.this._column, DrillPopup.this._row, DrillPopup.this._cmds[n]);
        }
    }
}

