/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dnd.DropTarget;
import oracle.ewt.dnd.DropTargetDragEvent;
import oracle.ewt.dnd.DropTargetDropEvent;
import oracle.ewt.dnd.DropTargetEvent;
import oracle.ewt.dnd.DropTargetListener;
import oracle.ewt.grid.Grid;
import oracle.ewt.header.Header;
import oracle.ewt.pivot.PivotGrid;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.pivot.PivotTransfer;

class PivotGridDropAdapter
implements DropTargetListener {
    private PivotGrid _pivotGrid;
    private PivotHeader _pivotHeader;

    public PivotGridDropAdapter(PivotGrid pivotGrid) {
        this._pivotGrid = pivotGrid;
        DropTarget dropTarget = new DropTarget(this._pivotGrid, this);
        Header header = this._pivotGrid.getColumnHeader();
        if (header != null) {
            dropTarget = new DropTarget(header, this);
        }
        if ((header = this._pivotGrid.getRowHeader()) != null) {
            dropTarget = new DropTarget(header, this);
        }
        Grid grid = this._pivotGrid.getGrid();
        dropTarget = new DropTarget(grid, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        this._updateFeedback(dropTargetDragEvent.getDropTargetContext().getComponent(), dropTargetDragEvent.getLocation());
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this._updatePivotHeader(null);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        this._updatePivotHeader(null);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        try {
            Object object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
            if (object instanceof PivotTransfer) {
                PivotTransfer pivotTransfer = (PivotTransfer)object;
                Object object2 = pivotTransfer.getSource();
                int n = pivotTransfer.getIndex();
                PivotHeader pivotHeader = this._getPivotHeader(dropTargetDropEvent.getDropTargetContext().getComponent(), dropTargetDropEvent.getLocation());
                int n2 = this._getIndex(pivotHeader);
                PivotTable pivotTable = this._pivotGrid.getPivotTable();
                boolean bl = true;
                if (object2 == pivotHeader) {
                    if (n < n2) {
                        --n2;
                    }
                    if (n == n2) {
                        bl = false;
                    }
                }
                if (bl) {
                    pivotTable.firePivotEvent(object2, n, pivotHeader, n2);
                    pivotTable.deselectAll();
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
        }
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._pivotGrid.isEnabled()) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    private PivotHeader _getPivotHeader(Component component, Point point) {
        PivotHeader pivotHeader = null;
        if (component == this._pivotGrid || component == this._pivotGrid.getGrid()) {
            boolean bl;
            boolean bl2 = bl = this._pivotGrid.getActualReadingDirection() == 1;
            pivotHeader = bl ? (point.x >= point.y ? this._getHorizontalHeader() : this._getVerticalHeader()) : (component.getSize().width - point.x >= point.y ? this._getHorizontalHeader() : this._getVerticalHeader());
        } else if (component == this._pivotGrid.getColumnHeader()) {
            pivotHeader = this._getHorizontalHeader();
        } else if (component == this._pivotGrid.getRowHeader()) {
            pivotHeader = this._getVerticalHeader();
        }
        return pivotHeader;
    }

    private void _updateFeedback(Component component, Point point) {
        PivotHeader pivotHeader = this._getPivotHeader(component, point);
        this._updatePivotHeader(pivotHeader);
    }

    private void _updatePivotHeader(PivotHeader pivotHeader) {
        if (this._pivotHeader != pivotHeader && this._pivotHeader != null) {
            this._pivotHeader.setDropLocation(-1, false);
        }
        this._pivotHeader = pivotHeader;
        if (this._pivotHeader != null) {
            int n = this._getIndex(pivotHeader);
            this._pivotHeader.setDropLocation(n, false);
        }
    }

    private int _getIndex(PivotHeader pivotHeader) {
        boolean bl = pivotHeader.isHorizontal();
        TwoDDataSource twoDDataSource = pivotHeader.getDataSource();
        return bl ? twoDDataSource.getRowCount() : twoDDataSource.getColumnCount();
    }

    private PivotHeader _getHorizontalHeader() {
        return this._pivotGrid.getPivotTable().getColumnPivotHeader();
    }

    private PivotHeader _getVerticalHeader() {
        return this._pivotGrid.getPivotTable().getRowPivotHeader();
    }
}

