/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.dataSource.NullOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceAdapter;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleAppearanceManager;
import oracle.ewt.grid.bigCell.AccessibleBigCellGrid;
import oracle.ewt.grid.bigCell.BigCellNavigator;
import oracle.ewt.header.AccessibleHeader;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderEvent;
import oracle.ewt.header.NullInputHandler;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.pivot.AbstractPivotHeaderCell;
import oracle.ewt.pivot.CollapseEvent;
import oracle.ewt.pivot.CollapseListener;
import oracle.ewt.pivot.DrillEvent;
import oracle.ewt.pivot.DrillListener;
import oracle.ewt.pivot.GridResizer;
import oracle.ewt.pivot.LevelHighlighter;
import oracle.ewt.pivot.PivotDragDropAdapter;
import oracle.ewt.pivot.PivotHeaderAppearMgr;
import oracle.ewt.pivot.PivotHeaderInputHandler;
import oracle.ewt.pivot.PivotHeaderPainter;
import oracle.ewt.pivot.PivotHeaderSelection;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.GridUI;
import oracle.ewt.plaf.PivotHeaderUI;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.LocaleUtils;

public class PivotHeader
extends SpreadTable {
    private static final ImmInsets _HEADER_INSETS = new ImmInsets(0, 0, 0, 0);
    private static final int _PIVOT_FEEDBACK_SIZE = 4;
    private static final int _RESIZE_FEEDBACK_SIZE = 3;
    int mouseItem = -1;
    int _dropIndex = -1;
    int _dragIndex = -1;
    boolean _swapping;
    int _highlightItem = -1;
    private int _resizeItem = -1;
    private int _newSize = -1;
    private Image _drillImage;
    private Image _drilledImage;
    private boolean _horizontal;
    private boolean _dragEnabled = true;
    private DrillListener _drillListener;
    private CollapseListener _collapseListener;
    private TwoDDataSourceAdapter _hListener;
    private TwoDDataSourceAdapter _vListener;
    private boolean _drilling;
    private boolean _needToValidateMinSize;
    private int _minSize;
    private boolean _displayDrillImages = true;
    private int _headerResizeItem = -1;

    public PivotHeader() {
        this(null, false);
    }

    public PivotHeader(TwoDDataSource twoDDataSource, boolean bl) {
        this._horizontal = bl;
        this._hListener = new _HListen();
        this._vListener = new _VListen();
        Grid grid = this.getGrid();
        grid.setUpperLeft(false);
        grid.setLowerRight(false);
        if (bl) {
            grid.setLowerLeft(false);
        } else {
            grid.setUpperRight(false);
        }
        grid.setOverlayBorderVisible(false);
        if (twoDDataSource == null) {
            this.setVisible(false);
        }
        this.setDataSource(twoDDataSource);
        Header header = bl ? this.getRowHeader() : this.getColumnHeader();
        header.setCanResizeItems(true);
        header.setCanMoveItems(false);
        header.setItemInputHandler(new CursorChange());
        header.setScrollByItem(false);
        Appearance appearance = header.getAppearance();
        appearance.setInsets(_HEADER_INSETS);
        header.setAppearance(appearance);
        GridResizer gridResizer = new GridResizer(this);
        LevelHighlighter levelHighlighter = new LevelHighlighter(this);
        PivotDragDropAdapter pivotDragDropAdapter = new PivotDragDropAdapter(this);
        Painter painter = this.getPivotHeaderUI().getDefaultHeaderItemPainter(this, !bl);
        header.setDefaultPainter(painter);
        PivotHeaderPainter pivotHeaderPainter = new PivotHeaderPainter(this);
        grid.setDefaultPainter(pivotHeaderPainter);
        this.setBorderPainter(null);
        grid.setVerticalSeparatorsVisible(false);
        grid.setHorizontalSeparatorsVisible(false);
        this.setInputHandler(new PivotHeaderInputHandler());
        grid.setGridSelection(new PivotHeaderSelection(this));
        grid.setGridKeyNavigator(BigCellNavigator.getGridKeyNavigator());
        SingleAppearanceManager singleAppearanceManager = (SingleAppearanceManager)grid.getAppearanceManager();
        PivotHeaderAppearMgr pivotHeaderAppearMgr = new PivotHeaderAppearMgr(singleAppearanceManager, this);
        grid.setAppearanceManager(pivotHeaderAppearMgr);
        singleAppearanceManager.setAppearance(this.getPivotHeaderUI().getDefaultAppearance(this));
        grid.setDrawFocusCellHighlite(true);
    }

    @Override
    public Object getUIClassID() {
        return "PivotHeaderUI";
    }

    public boolean isHorizontal() {
        return this._horizontal;
    }

    public final PivotTable getPivotTable() {
        Container container = this.getParent();
        if (container instanceof PivotTable) {
            return (PivotTable)container;
        }
        return null;
    }

    public final AppearanceManager getAppearanceManager() {
        AppearanceManager appearanceManager = this.getGrid().getAppearanceManager();
        if (appearanceManager instanceof PivotHeaderAppearMgr) {
            appearanceManager = ((PivotHeaderAppearMgr)appearanceManager).getWrapped();
        }
        return appearanceManager;
    }

    public final void setAppearanceManager(AppearanceManager appearanceManager) {
        if (!(appearanceManager instanceof PivotHeaderAppearMgr)) {
            appearanceManager = new PivotHeaderAppearMgr(appearanceManager, this);
        }
        this.getGrid().setAppearanceManager(appearanceManager);
    }

    public final TwoDDataSource getDataSource() {
        return this.getGrid().getDataSource();
    }

    public void setDataSource(TwoDDataSource twoDDataSource) {
        TwoDDataSource twoDDataSource2 = this.getDataSource();
        if (twoDDataSource == null) {
            if (this.isHorizontal()) {
                twoDDataSource2.removeDataSourceListener(this._hListener);
            } else {
                twoDDataSource2.removeDataSourceListener(this._vListener);
            }
            this.setDataSources(null, null, null);
        } else if (this.isHorizontal()) {
            twoDDataSource2.removeDataSourceListener(this._hListener);
            NullOneDDataSource nullOneDDataSource = new NullOneDDataSource(twoDDataSource.getRowCount());
            this.setDataSources(twoDDataSource, null, nullOneDDataSource);
            twoDDataSource.addDataSourceListener(this._hListener);
        } else {
            twoDDataSource2.removeDataSourceListener(this._vListener);
            NullOneDDataSource nullOneDDataSource = new NullOneDDataSource(twoDDataSource.getColumnCount());
            this.setDataSources(twoDDataSource, nullOneDDataSource, null);
            twoDDataSource.addDataSourceListener(this._vListener);
        }
    }

    public void setInputHandler(CellInputHandler cellInputHandler) {
        this.getGrid().setDefaultInputHandler(cellInputHandler);
    }

    public CellInputHandler getInputHandler() {
        return this.getGrid().getDefaultInputHandler();
    }

    public void setDefaultPainter(Painter painter) {
        this.getGrid().setDefaultPainter(painter);
        this.repaint();
    }

    public Painter getDefaultPainter() {
        return this.getGrid().getDefaultPainter();
    }

    public boolean isOutline() {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        return pivotHeaderPainter == null ? false : pivotHeaderPainter.isOutline();
    }

    public void setOutline(boolean bl) {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        if (pivotHeaderPainter != null && !this.isHorizontal() && this.isOutline() != bl) {
            pivotHeaderPainter.setOutline(bl);
            this.repaint();
        }
    }

    public void setKeepHeaderCellsVisible(boolean bl) {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        if (pivotHeaderPainter != null) {
            pivotHeaderPainter.setKeepHeaderCellsVisible(bl);
            this.repaint();
        }
    }

    public boolean getKeepHeaderCellsVisible() {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        return pivotHeaderPainter == null ? false : pivotHeaderPainter.getKeepHeaderCellsVisible();
    }

    public final PivotHeaderUI getPivotHeaderUI() {
        return (PivotHeaderUI)this.getUI();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setDragEnabled(this.isEnabled());
    }

    @Override
    public Dimension layoutCanvas() {
        Dimension dimension = super.layoutCanvas();
        this._validateMinimumSize();
        return dimension;
    }

    @Override
    public boolean isInteriorTransparent() {
        return this.getKeepHeaderCellsVisible() || super.isInteriorTransparent();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Header header = this.getHeader();
        if (header.getItemCount() == 0) {
            if (this.isHorizontal()) {
                dimension.height += header.getDefaultItemSize();
            } else {
                dimension.width += header.getDefaultItemSize();
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Header header = this.getHeader();
        if (header.getItemCount() == 0) {
            if (this.isHorizontal()) {
                dimension.height += header.getDefaultItemSize();
            } else {
                dimension.width += header.getDefaultItemSize();
            }
        }
        return dimension;
    }

    @Override
    public void setDrawRaised(boolean bl) {
        super.setDrawRaised(bl);
        if (this.isHorizontal()) {
            this.getRowHeader().setDrawRaised(bl);
        } else {
            this.getColumnHeader().setDrawRaised(bl);
        }
    }

    @Override
    public void setCanvasOrigin(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getCanvasWidth();
        int n6 = this.getInnerWidth();
        PivotTable pivotTable = this.getPivotTable();
        this.getGrid().setCanvasOrigin(n, n2);
        if (this.getActualReadingDirection() == 1 && n6 < n5 && n6 - n5 > n) {
            if (pivotTable != null && pivotTable.getEqualSizedColumns()) {
                n = n6 - n5;
            }
            n4 = this.getGrid().getCanvasWidth();
            n3 = this.getGrid().getInnerWidth();
            this.getGrid().setCanvasOrigin(n3 - n4, n2);
        }
        n4 = this.getCanvasHeight();
        n3 = this.getInnerHeight();
        if (n3 < n4 && n3 - n4 > n2) {
            if (pivotTable != null && pivotTable.getEqualSizedRows()) {
                n2 = n3 - n4;
            }
            int n7 = this.getGrid().getCanvasHeight();
            int n8 = this.getGrid().getInnerHeight();
            this.getGrid().setCanvasOrigin(n, n8 - n7);
        }
        super.setCanvasOrigin(n, n2);
    }

    protected Image getDrillImage(int n, int n2) {
        Image image = null;
        AbstractPivotHeaderCell abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            int n3 = abstractPivotHeaderCell.getDrillState();
            switch (n3) {
                case 0: {
                    image = null;
                    break;
                }
                case 2: {
                    if (this._drilledImage == null) {
                        this._drilledImage = this.getPivotHeaderUI().getDrilledImage(this);
                    }
                    image = this._drilledImage;
                    break;
                }
                case 1: {
                    if (this._drillImage == null) {
                        this._drillImage = this.getPivotHeaderUI().getDrillImage(this);
                    }
                    image = this._drillImage;
                }
            }
        }
        return image;
    }

    protected boolean isDrill(int n, int n2, int n3, int n4) {
        boolean bl = false;
        Image image = this.getDrillImage(n, n2);
        if (image != null) {
            AbstractPivotHeaderCell abstractPivotHeaderCell;
            int n5 = image.getWidth(this);
            int n6 = image.getHeight(this);
            if (this.getKeepHeaderCellsVisible() && (abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2)) != null) {
                int n7;
                Point point = this.getGrid().getCanvasOrigin();
                int n8 = this.getGrid().getColumnPosition(n);
                if (n8 < -point.x) {
                    n3 -= -point.x - n8;
                }
                if ((n7 = this.getGrid().getRowPosition(n2)) < -point.y) {
                    n4 -= -point.y - n7;
                }
            }
            bl = n3 >= 0 && n3 <= n5 && n4 >= 0 && n4 <= n6;
        }
        return bl;
    }

    protected boolean isDrillable(int n, int n2) {
        AbstractPivotHeaderCell abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            return abstractPivotHeaderCell.getDrillState() == 1;
        }
        return false;
    }

    protected boolean isCollapsable(int n, int n2) {
        AbstractPivotHeaderCell abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            return abstractPivotHeaderCell.getDrillState() == 2;
        }
        return false;
    }

    protected Cursor getPivotCursor(int n) {
        return Cursor.getPredefinedCursor(12);
    }

    protected Cursor getDrillCursor(int n, int n2) {
        return Cursor.getPredefinedCursor(12);
    }

    protected final int getDragIndex() {
        return this._dragIndex;
    }

    protected final boolean isSwapping() {
        return this._swapping;
    }

    protected final int getDropIndex() {
        return this._dropIndex;
    }

    @Override
    protected final Grid createGrid(TwoDDataSource twoDDataSource) {
        return this.createPivotHeaderGrid(twoDDataSource);
    }

    protected PivotHeaderGrid createPivotHeaderGrid(TwoDDataSource twoDDataSource) {
        return new PivotHeaderGrid(twoDDataSource);
    }

    @Override
    protected final Header createColumnHeader(OneDDataSource oneDDataSource) {
        return this.createColumnPivotHeaderHeader(oneDDataSource);
    }

    protected PivotHeaderHeader createColumnPivotHeaderHeader(OneDDataSource oneDDataSource) {
        return new PivotHeaderHeader(oneDDataSource, true);
    }

    @Override
    protected final Header createRowHeader(OneDDataSource oneDDataSource) {
        return this.createRowPivotHeaderHeader(oneDDataSource);
    }

    protected PivotHeaderHeader createRowPivotHeaderHeader(OneDDataSource oneDDataSource) {
        return new PivotHeaderHeader(oneDDataSource, false);
    }

    @Override
    protected void paintOverChildren(Graphics graphics) {
        if (!this._swapping && this._dropIndex != -1) {
            if (this.getPivotTable().isPivotAllowed()) {
                this._paintDropFeedback(graphics);
            }
        } else if (this._resizeItem != -1) {
            this._paintResizeFeedback(graphics);
        }
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this._drillImage = null;
        this._drilledImage = null;
    }

    void setDrillImagesDisplayed(boolean bl) {
        this._displayDrillImages = bl;
    }

    boolean getDrillImagesDisplayed() {
        return this._displayDrillImages;
    }

    AbstractPivotHeaderCell getPivotHeaderCell(int n, int n2) {
        Object object = this.getGrid().getDataSource().getData(n, n2);
        if (object instanceof AbstractPivotHeaderCell) {
            return (AbstractPivotHeaderCell)object;
        }
        return null;
    }

    void setDragEnabled(boolean bl) {
        this._dragEnabled = bl;
    }

    boolean isDragEnabled() {
        return this._dragEnabled;
    }

    void fireHeaderCellDrillRequest(int n, int n2) {
        if (this._drillListener == null) {
            return;
        }
        int n3 = 2001;
        DrillEvent drillEvent = new DrillEvent(this, n3, this.isHorizontal(), n, n2);
        this._drillListener.headerCellDrillRequest(drillEvent);
    }

    void fireCollapse(int n, int n2) {
        if (this._collapseListener == null) {
            return;
        }
        int n3 = 2001;
        CollapseEvent collapseEvent = new CollapseEvent(this, n3, this.isHorizontal(), n, n2);
        this._collapseListener.collapse(collapseEvent);
    }

    Image getDragImage(int n) {
        Header header;
        int n2;
        int n3;
        if (this.isHorizontal()) {
            n3 = this.getRowHeaderWidth();
            n2 = this.getRowHeight(n);
            header = this.getRowHeader();
        } else {
            n3 = this.getColumnWidth(n);
            n2 = this.getColumnHeaderHeight();
            header = this.getColumnHeader();
        }
        Image image = this.createImage(n3, n2);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            PaintContext paintContext = header.getPaintContext();
            BorderPainter borderPainter = header.getHeaderItemBorderPainter();
            ImmInsets immInsets = borderPainter.getInsets(paintContext);
            borderPainter.paint(paintContext, graphics, 0, 0, n3, n2);
            Painter painter = header.getDefaultPainter();
            painter.paint(paintContext, graphics, immInsets.left, immInsets.top, n3 -= immInsets.left + immInsets.right, n2 -= immInsets.top + immInsets.bottom);
        }
        return image;
    }

    synchronized void setDrillListener(DrillListener drillListener) {
        this._drillListener = drillListener;
    }

    synchronized void setCollapseListener(CollapseListener collapseListener) {
        this._collapseListener = collapseListener;
    }

    protected void setDropLocation(int n, boolean bl) {
        if (this._dropIndex != n || this._swapping != bl) {
            PivotHeaderAppearMgr pivotHeaderAppearMgr = this._getPivotHeaderAppearMgr();
            if (pivotHeaderAppearMgr != null) {
                int n2 = !bl ? -1 : (n == -1 ? -1 : (n == this._dragIndex ? -1 : n));
                pivotHeaderAppearMgr.setSwapItem(n2);
            }
            this._swapping = bl;
            if (n == -1 || this._dragIndex == -1 || this._swapping && this._dragIndex != n) {
                this._dropIndex = n;
                this.paintImmediate();
            } else {
                if (this._dragIndex != -1 && (this._dragIndex == n || this._dragIndex == n - 1)) {
                    n = -1;
                }
                this._dropIndex = n;
                this.paintImmediate();
            }
        }
    }

    void setDragItem(int n) {
        GridSelection gridSelection = this.getGrid().getGridSelection();
        if (this._dragIndex != -1) {
            if (this.isHorizontal()) {
                gridSelection.setRowSelected(this._dragIndex, false);
            } else {
                gridSelection.setColumnSelected(this._dragIndex, false);
            }
        }
        this._dragIndex = n;
        if (this._dragIndex != -1) {
            if (this.isHorizontal()) {
                gridSelection.setRowSelected(this._dragIndex, true);
            } else {
                gridSelection.setColumnSelected(this._dragIndex, true);
            }
        }
        this.repaint();
    }

    Header getHeader() {
        if (this.isHorizontal()) {
            return this.getRowHeader();
        }
        return this.getColumnHeader();
    }

    final boolean isDrilling() {
        return this._drilling;
    }

    final void setDrilling(boolean bl) {
        this._drilling = bl;
    }

    final int getResizeItem() {
        return this._resizeItem;
    }

    final void setResizeItem(int n) {
        this._resizeItem = n;
        if (this._resizeItem != -1) {
            this._newSize = this.isHorizontal() ? this.getColumnWidth(n) : this.getRowHeight(n);
        }
        this.paintImmediate();
    }

    final void updateResizeFeedback(int n) {
        this._newSize = n;
        this.paintImmediate();
    }

    final void setMinimumSize(int n) {
        this._minSize = n;
        this._needToValidateMinSize = true;
        this._validateMinimumSize();
    }

    final int getHeaderResizeItem() {
        return this._headerResizeItem;
    }

    final void setHeaderResizeItem(int n) {
        if (this._headerResizeItem != n) {
            this._headerResizeItem = n;
            PivotTable pivotTable = this.getPivotTable();
            PivotHeader pivotHeader = n == -1 ? null : this;
            pivotTable.setResizeHeader(pivotHeader);
        }
    }

    final void updateHeaderResizeFeedback() {
        if (this._headerResizeItem != -1) {
            this.getPivotTable().paintImmediate();
        }
    }

    final void setHighlightItem(int n) {
        if (this._highlightItem != n) {
            this._highlightItem = n;
            this.getHeader().paintImmediate();
        }
    }

    private void _validateMinimumSize() {
        if (!this._needToValidateMinSize) {
            return;
        }
        int n = this.getHeader().getItemCount();
        if (n != 0) {
            Dimension dimension = this.getInnerSize();
            if (this.isHorizontal()) {
                int n2 = this.getCanvasHeight();
                if (n2 == 0) {
                    this._needToValidateMinSize = true;
                } else {
                    this._needToValidateMinSize = false;
                    if (dimension.height > n2) {
                        int n3 = this.getRowHeight(n - 1) + (dimension.height - n2);
                        this.setRowHeight(n - 1, n3);
                    }
                }
            } else {
                int n4 = this.getCanvasWidth();
                if (n4 == 0) {
                    this._needToValidateMinSize = true;
                } else {
                    this._needToValidateMinSize = false;
                    if (dimension.width > n4) {
                        int n5 = this.getColumnWidth(n - 1) + (dimension.width - n4);
                        this.setColumnWidth(n - 1, n5);
                    }
                }
            }
        }
    }

    private void _paintDropFeedback(Graphics graphics) {
        Header header = this.getHeader();
        Rectangle rectangle = this.getInnerBounds();
        Dimension dimension = this.getCanvasSize();
        boolean bl = this.getActualReadingDirection() == 1;
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n = header.getItemCount();
        int n2 = this._dropIndex < n ? header.getItemPosition(this._dropIndex) : (this._dropIndex == n && n != 0 ? header.getItemPosition(this._dropIndex - 1) + header.getItemSize(this._dropIndex - 1) : 0);
        if (!this.isHorizontal()) {
            dimension.height += header.getSize().height;
            int n3 = bl ? n2 - 2 : (n != 0 ? (this._dropIndex == n ? header.getItemPosition(this._dropIndex - 1) - 2 : header.getItemSize(this._dropIndex) + header.getItemPosition(this._dropIndex) - 2) : 0);
            if (n3 < rectangle.x) {
                n3 = rectangle.x;
            }
            if (n3 + 4 > rectangle.width) {
                n3 = rectangle.width - 4;
            }
            if (dimension.height < rectangle.height && n != 0) {
                rectangle.height = dimension.height;
            }
            graphics.fillRect(n3, rectangle.y, 4, rectangle.height);
        } else {
            dimension.width += header.getSize().width;
            int n4 = n2 - 2;
            if (n4 < rectangle.y) {
                n4 = rectangle.y;
            }
            if (n4 + 4 > rectangle.height) {
                n4 = rectangle.height - 4;
            }
            if (bl) {
                if (dimension.width < rectangle.width && n != 0) {
                    rectangle.width = dimension.width;
                }
                graphics.fillRect(rectangle.x, n4, rectangle.width, 4);
            } else {
                graphics.fillRect(rectangle.x, n4, rectangle.width, 4);
            }
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    private void _paintResizeFeedback(Graphics graphics) {
        Color color = graphics.getColor();
        boolean bl = this.getActualReadingDirection() == 1;
        Grid grid = this.getGrid();
        if (this.isHorizontal()) {
            int n = 0;
            n = bl ? grid.getLocation().x + grid.getColumnPosition(this._resizeItem) + grid.getCanvasOriginX() + this._newSize - 1 : grid.getLocation().x + grid.getColumnPosition(this._resizeItem) + grid.getCanvasOriginX() - (this._newSize - grid.getColumnWidth(this._resizeItem)) - 1;
            int n2 = grid.getLocation().y + 1;
            int n3 = grid.getSize().height - 2;
            UIDefaults uIDefaults = this.getUIDefaults();
            graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
            graphics.setXORMode(uIDefaults.getColor(LookAndFeel.CONTROL));
            graphics.fillRect(n, n2, 3, n3);
            graphics.setPaintMode();
        } else {
            int n = grid.getLocation().y + grid.getRowPosition(this._resizeItem) + grid.getCanvasOriginY() + this._newSize - 1;
            int n4 = grid.getLocation().x + 1;
            int n5 = grid.getSize().width - 2;
            UIDefaults uIDefaults = this.getUIDefaults();
            graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
            graphics.setXORMode(uIDefaults.getColor(LookAndFeel.CONTROL));
            graphics.fillRect(n4, n, n5, 3);
            graphics.setPaintMode();
        }
        graphics.setColor(color);
    }

    private PivotHeaderPainter _getPivotHeaderPainter() {
        Painter painter = this.getGrid().getDefaultPainter();
        return painter instanceof PivotHeaderPainter ? (PivotHeaderPainter)painter : null;
    }

    private PivotHeaderAppearMgr _getPivotHeaderAppearMgr() {
        AppearanceManager appearanceManager = this.getGrid().getAppearanceManager();
        if (appearanceManager instanceof PivotHeaderAppearMgr) {
            return (PivotHeaderAppearMgr)appearanceManager;
        }
        return null;
    }

    private class _VListen
    extends TwoDDataSourceAdapter {
        private _VListen() {
        }

        @Override
        public void columnsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            Object object;
            OneDDataSource oneDDataSource = PivotHeader.this.getColumnHeader().getDataSource();
            if (oneDDataSource instanceof NullOneDDataSource) {
                object = (NullOneDDataSource)oneDDataSource;
                ((NullOneDDataSource)object).addItems(twoDDataSourceEvent.getColumnStartIndex(), twoDDataSourceEvent.getColumnCount());
            }
            if ((object = PivotHeader.this.getPivotTable()) != null) {
                ((EwtComponent)object).invalidateCanvas();
                ((PivotTable)object).invalidateParent();
            }
        }

        @Override
        public void columnsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            Object object;
            OneDDataSource oneDDataSource = PivotHeader.this.getColumnHeader().getDataSource();
            if (oneDDataSource instanceof NullOneDDataSource) {
                object = (NullOneDDataSource)oneDDataSource;
                ((NullOneDDataSource)object).removeItems(twoDDataSourceEvent.getColumnStartIndex(), twoDDataSourceEvent.getColumnCount());
            }
            if ((object = PivotHeader.this.getPivotTable()) != null) {
                ((EwtComponent)object).invalidateCanvas();
                ((PivotTable)object).invalidateParent();
            }
        }
    }

    private class _HListen
    extends TwoDDataSourceAdapter {
        private _HListen() {
        }

        @Override
        public void rowsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            Object object;
            OneDDataSource oneDDataSource = PivotHeader.this.getRowHeader().getDataSource();
            if (oneDDataSource instanceof NullOneDDataSource) {
                object = (NullOneDDataSource)oneDDataSource;
                ((NullOneDDataSource)object).addItems(twoDDataSourceEvent.getRowStartIndex(), twoDDataSourceEvent.getRowCount());
            }
            if ((object = PivotHeader.this.getPivotTable()) != null) {
                ((EwtComponent)object).invalidateCanvas();
                ((PivotTable)object).invalidateParent();
            }
        }

        @Override
        public void rowsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            Object object;
            OneDDataSource oneDDataSource = PivotHeader.this.getRowHeader().getDataSource();
            if (oneDDataSource instanceof NullOneDDataSource) {
                object = (NullOneDDataSource)oneDDataSource;
                ((NullOneDDataSource)object).removeItems(twoDDataSourceEvent.getRowStartIndex(), twoDDataSourceEvent.getRowCount());
            }
            if ((object = PivotHeader.this.getPivotTable()) != null) {
                ((EwtComponent)object).invalidateCanvas();
                ((PivotTable)object).invalidateParent();
            }
        }
    }

    private class CursorChange
    extends NullInputHandler {
        private CursorChange() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
            PivotHeader.this.mouseItem = n;
            header.setCursor(PivotHeader.this.getPivotCursor(n));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
            PivotHeader.this.mouseItem = n;
            header.setCursor(PivotHeader.this.getPivotCursor(n));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
            PivotHeader.this.mouseItem = -1;
            header.setCursor(Cursor.getDefaultCursor());
        }
    }

    public class AccessiblePivotHeaderGrid
    extends AccessibleBigCellGrid {
        public AccessiblePivotHeaderGrid(PivotHeaderGrid pivotHeaderGrid) {
            super(pivotHeaderGrid);
        }

        @Override
        public String getAccessibleName(int n, int n2) {
            String string = super.getAccessibleName(n, n2);
            if (string == null) {
                return string;
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.access.resource.AccessibilityBundle", LocaleUtils.getTranslationLocale(this.getLocale()));
            String string2 = null;
            if (PivotHeader.this.isDrillable(n, n2)) {
                string2 = "PIVOT_HEADER.IS_DRILLABLE";
            } else if (PivotHeader.this.isCollapsable(n, n2)) {
                string2 = "PIVOT_HEADER.IS_COLLAPSABLE";
            }
            if (string2 != null) {
                String string3 = resourceBundle.getString(string2);
                MessageFormat messageFormat = new MessageFormat(string3);
                Object[] objectArray = new Object[]{string};
                string = messageFormat.format(objectArray);
            }
            return string;
        }
    }

    public class PivotHeaderGrid
    extends Grid {
        public PivotHeaderGrid(TwoDDataSource twoDDataSource) {
            super(twoDDataSource);
            AccessiblePivotHeaderGrid accessiblePivotHeaderGrid = this.createAccessiblePivotHeaderGrid();
        }

        protected AccessiblePivotHeaderGrid createAccessiblePivotHeaderGrid() {
            return new AccessiblePivotHeaderGrid(this);
        }

        @Override
        public boolean isInteriorTransparent() {
            return PivotHeader.this.getKeepHeaderCellsVisible() || super.isInteriorTransparent();
        }

        @Override
        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected Object getPaintData(Object object) {
            if (PivotTable.KEY_DRAW_RAISED.equals(object)) {
                return PivotHeader.this.getPivotTable().getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.getPaintData(object);
        }

        @Override
        public void paintCell(int n, int n2) {
            AbstractPivotHeaderCell abstractPivotHeaderCell = PivotHeader.this.getPivotHeaderCell(n, n2);
            if (abstractPivotHeaderCell == null) {
                super.paintCell(n, n2);
            } else {
                int n3 = abstractPivotHeaderCell.getColumn();
                int n4 = abstractPivotHeaderCell.getRow();
                int n5 = abstractPivotHeaderCell.getColumnCount();
                int n6 = abstractPivotHeaderCell.getRowCount();
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        super.paintCell(n3 + i, n4 + j);
                    }
                }
            }
        }

        @Override
        protected void paintFocusCell(PaintContext paintContext, Graphics graphics) {
            Cell cell = this.getFocusCell();
            if (!this.getDrawFocusCellHighlite() || cell == null || !this.hasFocus()) {
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            AbstractPivotHeaderCell abstractPivotHeaderCell = PivotHeader.this.getPivotHeaderCell(cell.column, cell.row);
            if (abstractPivotHeaderCell == null) {
                if (!this.isColumnOnScreen(cell.column) || !this.isRowOnScreen(cell.row)) {
                    return;
                }
                n = this.getColumnPosition(cell.column);
                n2 = this.getRowPosition(cell.row);
                n3 = this.getColumnWidth(cell.column);
                n4 = this.getRowHeight(cell.row);
            } else {
                int n5;
                int n6 = abstractPivotHeaderCell.getColumn();
                int n7 = abstractPivotHeaderCell.getRow();
                int n8 = abstractPivotHeaderCell.getColumnCount();
                int n9 = abstractPivotHeaderCell.getRowCount();
                boolean bl = false;
                block0: for (n5 = 0; n5 < n8; ++n5) {
                    if (!this.isColumnOnScreen(n6 + n5)) continue;
                    for (int i = 0; i < n9; ++i) {
                        if (!this.isRowOnScreen(n7 + i)) continue;
                        bl = true;
                        break block0;
                    }
                    break;
                }
                if (!bl) {
                    return;
                }
                n = this.getColumnPosition(n6);
                n2 = this.getRowPosition(n7);
                for (n5 = 0; n5 < n8; ++n5) {
                    n3 += this.getColumnWidth(n6 + n5);
                }
                for (n5 = 0; n5 < n9; ++n5) {
                    n4 += this.getRowHeight(n7 + n5);
                }
            }
            GridUI gridUI = (GridUI)this.getUI();
            BorderPainter borderPainter = gridUI.getFocusCellPainter(this);
            if (borderPainter != null) {
                borderPainter.paint(paintContext, graphics, n, n2, n3, n4);
            }
        }
    }

    public class AccessiblePivotHeaderHeader
    extends AccessibleHeader {
        public AccessiblePivotHeaderHeader(PivotHeaderHeader pivotHeaderHeader) {
            super(pivotHeaderHeader);
        }

        @Override
        public String getAccessibleName(int n) {
            String string = super.getAccessibleName(n);
            if (string == null) {
                string = IntegerUtils.getString((int)n);
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.access.resource.AccessibilityBundle", LocaleUtils.getTranslationLocale(this.getLocale()));
            String string2 = resourceBundle.getString("PIVOT_HEADER.NAMED_LEVEL");
            MessageFormat messageFormat = new MessageFormat(string2);
            Object[] objectArray = new Object[]{string};
            string = messageFormat.format(objectArray);
            return string;
        }
    }

    public class PivotHeaderHeader
    extends Header {
        public PivotHeaderHeader(OneDDataSource oneDDataSource, boolean bl) {
            super(oneDDataSource, bl);
            AccessiblePivotHeaderHeader accessiblePivotHeaderHeader = this.createAccessiblePivotHeaderHeader();
        }

        @Override
        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isInteriorTransparent() {
            return PivotHeader.this.getKeepHeaderCellsVisible() || super.isInteriorTransparent();
        }

        @Override
        public void setItemSize(int n, int n2) {
            int n3;
            int n4;
            int n5 = this.isHorizontal() ? this.getCanvasWidth() : this.getCanvasHeight();
            if (n5 + (n4 = n2 - (n3 = this.getItemSize(n))) < PivotHeader.this._minSize) {
                n2 = PivotHeader.this._minSize + n3 - n5;
            }
            super.setItemSize(n, n2);
        }

        protected AccessiblePivotHeaderHeader createAccessiblePivotHeaderHeader() {
            return new AccessiblePivotHeaderHeader(this);
        }

        @Override
        protected void paintExtraCanvas(Graphics graphics, PaintContext paintContext, int n, int n2, int n3, int n4) {
            graphics.setColor(this.getAppearance().getBackground());
            graphics.fillRect(n, n2, n3, n4);
        }

        @Override
        protected void resetCursor() {
            if (PivotHeader.this.mouseItem == -1) {
                super.resetCursor();
            }
        }

        @Override
        protected int getItemPaintState(int n, int n2) {
            if (PivotHeader.this._dragIndex == n2 || PivotHeader.this._swapping & PivotHeader.this._dropIndex == n2) {
                n |= 2;
            } else if (PivotHeader.this._highlightItem == n2) {
                n |= 0x82;
            }
            return n;
        }

        @Override
        protected void processResizeEvent(HeaderEvent headerEvent) {
            super.processResizeEvent(headerEvent);
            int n = headerEvent.getID();
            int n2 = headerEvent.getHeaderItem();
            if (n == 2006) {
                n2 = -1;
            }
            PivotHeader.this.setHeaderResizeItem(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            PivotTable pivotTable = PivotHeader.this.getPivotTable();
            if (pivotTable != null) {
                pivotTable.freezeRepaints();
            }
            try {
                super.processMouseMotionEvent(mouseEvent);
                PivotHeader.this.updateHeaderResizeFeedback();
            }
            finally {
                if (pivotTable != null) {
                    pivotTable.unfreezeRepaints();
                }
            }
        }
    }
}

