/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.ProxyInputHandler;
import oracle.ewt.pivot.AbstractPivotHeaderCell;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.util.InputEventUtils;

public class PivotHeaderInputHandler
extends ProxyInputHandler {
    public PivotHeaderInputHandler() {
        super(NullInputHandler.getCellInputHandler());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        grid.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        PivotHeader pivotHeader = this._getHeader(grid);
        AbstractPivotHeaderCell abstractPivotHeaderCell = pivotHeader.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            Cursor cursor;
            Point point = this._convertPoint(grid, abstractPivotHeaderCell, n, n2, mouseEvent.getX(), mouseEvent.getY());
            int n3 = abstractPivotHeaderCell.getColumn();
            int n4 = abstractPivotHeaderCell.getRow();
            Cursor cursor2 = grid.getCursor();
            if (cursor2 != (cursor = pivotHeader.isDrill(n3, n4, point.x, point.y) ? pivotHeader.getDrillCursor(n3, n4) : Cursor.getDefaultCursor())) {
                grid.setCursor(cursor);
                mouseEvent.consume();
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.mouseMoved(mouseEvent, grid, n, n2);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
            return;
        }
        PivotHeader pivotHeader = this._getHeader(grid);
        AbstractPivotHeaderCell abstractPivotHeaderCell = pivotHeader.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            boolean bl = pivotHeader.isDrillable(n, n2);
            boolean bl2 = bl ? false : pivotHeader.isCollapsable(n, n2);
            Point point = this._convertPoint(grid, abstractPivotHeaderCell, n, n2, mouseEvent.getX(), mouseEvent.getY());
            if ((bl || bl2) && pivotHeader.isDrill(abstractPivotHeaderCell.getColumn(), abstractPivotHeaderCell.getRow(), point.x, point.y)) {
                if (bl) {
                    pivotHeader.fireHeaderCellDrillRequest(n, n2);
                } else {
                    pivotHeader.fireCollapse(n, n2);
                }
                mouseEvent.consume();
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.mousePressed(mouseEvent, grid, n, n2);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.isConsumed()) {
            return;
        }
        PivotHeader pivotHeader = this._getHeader(grid);
        AbstractPivotHeaderCell abstractPivotHeaderCell = pivotHeader.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            boolean bl;
            boolean bl2 = pivotHeader.isDrillable(n, n2);
            boolean bl3 = bl2 ? false : pivotHeader.isCollapsable(n, n2);
            boolean bl4 = bl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? keyEvent.isControlDown() : keyEvent.isAltDown();
            if (bl2 && bl && keyEvent.getKeyCode() == 40) {
                pivotHeader.fireHeaderCellDrillRequest(n, n2);
                keyEvent.consume();
            } else if (bl3 & bl & keyEvent.getKeyCode() == 38) {
                pivotHeader.fireCollapse(n, n2);
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent, grid, n, n2);
        }
    }

    private PivotHeader _getHeader(Grid grid) {
        Container container = grid.getParent();
        return (PivotHeader)container;
    }

    private Point _convertPoint(Grid grid, AbstractPivotHeaderCell abstractPivotHeaderCell, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = grid.getActualReadingDirection() == 1;
        if (!bl) {
            n3 = grid.getColumnWidth(abstractPivotHeaderCell.getColumn()) - n3;
        }
        for (int i = abstractPivotHeaderCell.getColumn(); i < n; ++i) {
            n3 += grid.getColumnWidth(i);
        }
        for (int i = abstractPivotHeaderCell.getRow(); i < n2; ++i) {
            n4 += grid.getRowHeight(i);
        }
        return new Point(n3, n4);
    }
}

