/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import oracle.ewt.event.Cancelable;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.pivot.CollapseEvent;
import oracle.ewt.pivot.CollapseListener;
import oracle.ewt.pivot.DrillEvent;
import oracle.ewt.pivot.DrillListener;
import oracle.ewt.pivot.PivotEvent;
import oracle.ewt.pivot.PivotGrid;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotHeaderEvent;
import oracle.ewt.pivot.PivotHeaderValidateEvent;
import oracle.ewt.pivot.PivotListener;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.table.TableCellSelectListener;
import oracle.ewt.table.TableColSelectListener;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableResizeListener;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.table.TableScrollListener;

final class PivotHeaderTabAdapt
implements TableCellSelectListener,
TableColSelectListener,
TableResizeListener,
TableRowSelectListener,
TableScrollListener,
PivotListener,
DrillListener,
CollapseListener {
    private PivotTable _pivot;

    public PivotHeaderTabAdapt(PivotTable pivotTable) {
        this._pivot = pivotTable;
    }

    @Override
    public void pivot(PivotEvent pivotEvent) {
    }

    @Override
    public void swap(PivotEvent pivotEvent) {
    }

    @Override
    public void headerCellDrillRequest(DrillEvent drillEvent) {
        this._pivot.postEvent(new DrillEvent(this._pivot, drillEvent.getID(), drillEvent.isHorizontal(), drillEvent.getColumn(), drillEvent.getRow(), drillEvent.getDrillData()));
    }

    @Override
    public void headerCellDrill(DrillEvent drillEvent) {
        this._pivot.postEvent(new DrillEvent(this._pivot, drillEvent.getID(), drillEvent.isHorizontal(), drillEvent.getColumn(), drillEvent.getRow(), drillEvent.getDrillData()));
    }

    @Override
    public void collapse(CollapseEvent collapseEvent) {
        this._pivot.postEvent(new CollapseEvent(this._pivot, collapseEvent.getID(), collapseEvent.isHorizontal(), collapseEvent.getColumn(), collapseEvent.getRow()));
    }

    @Override
    public void cellSelecting(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2001, ((PivotHeader)tableEvent.getSource()).isHorizontal(), tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    @Override
    public void cellSelected(TableEvent tableEvent) {
        PivotHeader pivotHeader = (PivotHeader)tableEvent.getSource();
        boolean bl = pivotHeader.isHorizontal();
        boolean bl2 = pivotHeader.isOutline();
        this._deselect(pivotHeader);
        int n = tableEvent.getColumn();
        int n2 = tableEvent.getRow();
        GridSelection gridSelection = pivotHeader.getGrid().getGridSelection();
        if (bl2) {
            if (bl) {
                gridSelection.setColumnSelected(n, true);
                n2 = pivotHeader.getGrid().getRowCount() - 1;
            } else {
                gridSelection.setRowSelected(n2, true);
                n = 0;
            }
        }
        this._pivot.postEvent(new PivotHeaderEvent(this._pivot, 2002, bl, n, n2));
    }

    @Override
    public void cellDeselecting(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2003, ((PivotHeader)tableEvent.getSource()).isHorizontal(), tableEvent.getColumn(), tableEvent.getRow());
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    @Override
    public void cellDeselected(TableEvent tableEvent) {
        this._pivot.postEvent(new PivotHeaderEvent(this._pivot, 2004, ((PivotHeader)tableEvent.getSource()).isHorizontal(), tableEvent.getColumn(), tableEvent.getRow()));
    }

    @Override
    public void columnSelecting(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2005, false, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    @Override
    public void columnSelected(TableEvent tableEvent) {
        this._deselect(tableEvent.getSource());
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2006, false, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotHeaderValidateEvent);
    }

    @Override
    public void columnDeselecting(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2007, false, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    @Override
    public void columnDeselected(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2008, false, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotHeaderValidateEvent);
    }

    @Override
    public void rowSelecting(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2009, true, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    @Override
    public void rowSelected(TableEvent tableEvent) {
        this._deselect(tableEvent.getSource());
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2010, true, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotHeaderValidateEvent);
    }

    @Override
    public void rowDeselecting(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2011, true, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        }
    }

    @Override
    public void rowDeselected(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2012, true, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotHeaderValidateEvent);
    }

    @Override
    public void columnResizing(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2013, false, tableEvent.getColumn(), -1);
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        } else {
            this._pivot.getRowPivotHeader().setDragEnabled(false);
        }
    }

    @Override
    public void columnResized(TableEvent tableEvent) {
        this._pivot.postEvent(new PivotHeaderEvent(this._pivot, 2014, false, tableEvent.getColumn(), -1));
        this._pivot.getRowPivotHeader().setDragEnabled(true);
    }

    @Override
    public void rowResizing(TableEvent tableEvent) {
        PivotHeaderValidateEvent pivotHeaderValidateEvent = new PivotHeaderValidateEvent(this._pivot, 2015, true, -1, tableEvent.getRow());
        this._pivot.postEvent(pivotHeaderValidateEvent);
        if (pivotHeaderValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tableEvent)).cancel();
        } else {
            this._pivot.getColumnPivotHeader().setDragEnabled(false);
        }
    }

    @Override
    public void rowResized(TableEvent tableEvent) {
        this._pivot.postEvent(new PivotHeaderEvent(this._pivot, 2016, true, -1, tableEvent.getRow()));
        this._pivot.getColumnPivotHeader().setDragEnabled(true);
    }

    @Override
    public void columnScrolling(TableEvent tableEvent) {
    }

    @Override
    public void rowScrolling(TableEvent tableEvent) {
    }

    @Override
    public void columnScrolled(TableEvent tableEvent) {
        PivotGrid pivotGrid;
        if (tableEvent.getSource() == this._pivot.getColumnPivotHeader() && (pivotGrid = this._pivot.getPivotGrid()) != null) {
            pivotGrid.setFirstColumnOnScreen(tableEvent.getColumn());
        }
    }

    @Override
    public void rowScrolled(TableEvent tableEvent) {
        PivotGrid pivotGrid;
        if (tableEvent.getSource() == this._pivot.getRowPivotHeader() && (pivotGrid = this._pivot.getPivotGrid()) != null) {
            pivotGrid.setFirstRowOnScreen(tableEvent.getRow());
        }
    }

    private void _deselect(Object object) {
        if (object == this._pivot.getColumnPivotHeader()) {
            this._pivot.getPivotGrid().getGrid().getGridSelection().deselectAll();
            this._pivot.getRowPivotHeader().getGrid().getGridSelection().deselectAll();
        } else if (object == this._pivot.getRowPivotHeader()) {
            this._pivot.getPivotGrid().getGrid().getGridSelection().deselectAll();
            this._pivot.getColumnPivotHeader().getGrid().getGridSelection().deselectAll();
        } else {
            this._pivot.getColumnPivotHeader().getGrid().getGridSelection().deselectAll();
            this._pivot.getRowPivotHeader().getGrid().getGridSelection().deselectAll();
        }
    }
}

