/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.dataSource.NullTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.header.Header;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.pivot.CollapseEvent;
import oracle.ewt.pivot.CollapseListener;
import oracle.ewt.pivot.DrillEvent;
import oracle.ewt.pivot.DrillListener;
import oracle.ewt.pivot.PivotCorner;
import oracle.ewt.pivot.PivotEvent;
import oracle.ewt.pivot.PivotGrid;
import oracle.ewt.pivot.PivotGridDropAdapter;
import oracle.ewt.pivot.PivotGridTabAdapt;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotHeaderEvent;
import oracle.ewt.pivot.PivotHeaderResListener;
import oracle.ewt.pivot.PivotHeaderSelListener;
import oracle.ewt.pivot.PivotHeaderTabAdapt;
import oracle.ewt.pivot.PivotListener;
import oracle.ewt.plaf.PivotTableUI;
import oracle.ewt.plaf.TableUI;
import oracle.ewt.print.PrinterUtils;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableCellSelectListener;
import oracle.ewt.table.TableColSelectListener;
import oracle.ewt.table.TableEditListener;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableFocusListener;
import oracle.ewt.table.TableResizeListener;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.table.TableScrollListener;
import oracle.ewt.util.LocaleUtils;

public class PivotTable
extends EwtComponent {
    public static final Object KEY_DRAW_RAISED = "pivotTable.drawRaised";
    public static final Object PRINT_RAISED = SpreadTable.PRINT_RAISED;
    public static final Object PRINT_CORNER_COMPONENT = "pivotTable.printCorner";
    public static final Object DUPLICATE_COLUMN_PIVOT_HEADER = SpreadTable.DUPLICATE_COLUMN_HEADERS;
    public static final Object DUPLICATE_ROW_PIVOT_HEADER = SpreadTable.DUPLICATE_ROW_HEADERS;
    public static final Object DISPLAY_COLUMN_SELECTORS = SpreadTable.DISPLAY_COLUMN_HEADERS;
    public static final Object DISPLAY_ROW_SELECTORS = SpreadTable.DISPLAY_ROW_HEADERS;
    public static final Object DUPLICATE_COLUMN_HEADER_DATA = "pivotTable.dupColHeaderData";
    public static final Object DUPLICATE_ROW_HEADER_DATA = "pivotTable.dupRowHeaderData";
    public static final Object DISPLAY_COLUMN_DRILL_IMAGES = "pivotTable.dispColDrillImage";
    public static final Object DISPLAY_ROW_DRILL_IMAGES = "pivotTable.dispRowDrillImage";
    private static final int _RESIZE_FEEDBACK_SIZE = 3;
    private boolean _swap;
    private boolean _pivot;
    PivotGrid _pivotGrid;
    PivotHeader _columnPivotHeader;
    PivotHeader _rowPivotHeader;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private ListenerManager _pivotListeners;
    private ListenerManager _drillListeners;
    private ListenerManager _collapseListeners;
    private ListenerManager _pivotHeaderSelListeners;
    private ListenerManager _pivotHeaderResListeners;
    private ListenerManager _cellSelectListeners;
    private ListenerManager _colSelectListeners;
    private ListenerManager _editListeners;
    private ListenerManager _focusListeners;
    private ListenerManager _resizeListeners;
    private ListenerManager _rowSelectListeners;
    private ListenerManager _scrollListeners;
    int _freezeLevel = 0;
    private boolean _equalSizeColumns;
    private boolean _equalSizeRows;
    private boolean _needToDefaultColumns;
    private boolean _needToDefaultRows;
    private Component _corner;
    private boolean _drawRaised = true;
    private PivotHeader _resizeHeader;
    private int _posBeforeResize = 0;
    private int _origXBeforeResize = 0;
    private int _origYBeforeResize = 0;

    public PivotTable() {
        this(NullTwoDDataSource.getTwoDDataSource(), NullTwoDDataSource.getTwoDDataSource(), NullTwoDDataSource.getTwoDDataSource());
    }

    public PivotTable(TwoDDataSource twoDDataSource, TwoDDataSource twoDDataSource2, TwoDDataSource twoDDataSource3) {
        this(new PivotGrid(twoDDataSource), new PivotHeader(twoDDataSource2, true), new PivotHeader(twoDDataSource3, false));
    }

    public PivotTable(PivotGrid pivotGrid, PivotHeader pivotHeader, PivotHeader pivotHeader2) {
        this.setLayout(new _LayoutMgr());
        PivotGridTabAdapt pivotGridTabAdapt = new PivotGridTabAdapt(this);
        pivotGrid.addCellSelectListener(pivotGridTabAdapt);
        pivotGrid.addColSelectListener(pivotGridTabAdapt);
        pivotGrid.addEditListener(pivotGridTabAdapt);
        pivotGrid.addFocusListener(pivotGridTabAdapt);
        pivotGrid.addResizeListener(pivotGridTabAdapt);
        pivotGrid.addRowSelectListener(pivotGridTabAdapt);
        pivotGrid.addScrollListener(pivotGridTabAdapt);
        this.add(pivotGrid);
        PivotHeaderTabAdapt pivotHeaderTabAdapt = new PivotHeaderTabAdapt(this);
        pivotHeader.addCellSelectListener(pivotHeaderTabAdapt);
        pivotHeader.addColSelectListener(pivotHeaderTabAdapt);
        pivotHeader.addResizeListener(pivotHeaderTabAdapt);
        pivotHeader.addRowSelectListener(pivotHeaderTabAdapt);
        pivotHeader.addScrollListener(pivotHeaderTabAdapt);
        pivotHeader.setDrillListener(pivotHeaderTabAdapt);
        pivotHeader.setCollapseListener(pivotHeaderTabAdapt);
        this.add(pivotHeader);
        PivotHeaderTabAdapt pivotHeaderTabAdapt2 = new PivotHeaderTabAdapt(this);
        pivotHeader2.addCellSelectListener(pivotHeaderTabAdapt2);
        pivotHeader2.addColSelectListener(pivotHeaderTabAdapt2);
        pivotHeader2.addResizeListener(pivotHeaderTabAdapt2);
        pivotHeader2.addRowSelectListener(pivotHeaderTabAdapt2);
        pivotHeader2.addScrollListener(pivotHeaderTabAdapt2);
        pivotHeader2.setDrillListener(pivotHeaderTabAdapt2);
        pivotHeader2.setCollapseListener(pivotHeaderTabAdapt2);
        this.add(pivotHeader2);
        this._pivotGrid = pivotGrid;
        this._columnPivotHeader = pivotHeader;
        this._rowPivotHeader = pivotHeader2;
        this._equalSizeColumns = true;
        this._equalSizeRows = true;
        new PivotGridDropAdapter(pivotGrid);
        this.setPivotAllowed(true);
    }

    public void setSwapAllowed(boolean bl) {
        this._swap = bl;
        boolean bl2 = this.isSwapAllowed() || this.isPivotAllowed();
        this.getRowPivotHeader().setDragEnabled(bl2);
        this.getColumnPivotHeader().setDragEnabled(bl2);
    }

    public boolean isSwapAllowed() {
        return this._swap;
    }

    public void setPivotAllowed(boolean bl) {
        this._pivot = bl;
        boolean bl2 = this.isSwapAllowed() || this.isPivotAllowed();
        this.getRowPivotHeader().setDragEnabled(bl2);
        this.getColumnPivotHeader().setDragEnabled(bl2);
    }

    public boolean isPivotAllowed() {
        return this._pivot;
    }

    public Component getCornerComponent() {
        if (this._corner == null) {
            this._corner = new PivotCorner(this);
            this.add(this._corner);
        }
        return this._corner;
    }

    public void setCornerComponent(Component component) {
        if (this._corner != null) {
            this.remove(this._corner);
        }
        this._corner = component;
        if (this._corner != null) {
            this.add(this._corner);
        }
        this.invalidateParent();
    }

    public void setDrawRaised(boolean bl) {
        if (this._drawRaised != bl) {
            this._drawRaised = bl;
            this.getColumnPivotHeader().setDrawRaised(bl);
            this.getRowPivotHeader().setDrawRaised(bl);
            this.getPivotGrid().setDrawRaised(bl);
            this.repaint();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setColumnPivotHeaderVisible(boolean bl) {
        if (this._columnPivotHeader.isVisible() != bl) {
            this._columnPivotHeader.setVisible(bl);
            this.invalidateCanvas();
        }
    }

    public void setRowPivotHeaderVisible(boolean bl) {
        if (this._rowPivotHeader.isVisible() != bl) {
            this._rowPivotHeader.setVisible(bl);
            this.invalidateCanvas();
        }
    }

    public boolean isColumnPivotHeaderVisible() {
        return this._columnPivotHeader.isVisible();
    }

    public boolean isRowPivotHeaderVisible() {
        return this._rowPivotHeader.isVisible();
    }

    public PivotGrid getPivotGrid() {
        return this._pivotGrid;
    }

    public final PivotHeader getPivotHeader(boolean bl) {
        return bl ? this.getColumnPivotHeader() : this.getRowPivotHeader();
    }

    public PivotHeader getRowPivotHeader() {
        return this._rowPivotHeader;
    }

    public PivotHeader getColumnPivotHeader() {
        return this._columnPivotHeader;
    }

    public void setDataSources(TwoDDataSource twoDDataSource, TwoDDataSource twoDDataSource2, TwoDDataSource twoDDataSource3) {
        this._pivotGrid.setDataSource(twoDDataSource);
        this._columnPivotHeader.setDataSource(twoDDataSource2);
        this._rowPivotHeader.setDataSource(twoDDataSource3);
        this.invalidateCanvas();
    }

    public final TwoDDataSource getGridDataSource() {
        return this._pivotGrid.getDataSource();
    }

    public final TwoDDataSource getColumnDataSource() {
        return this._columnPivotHeader.getDataSource();
    }

    public final TwoDDataSource getRowDataSource() {
        return this._rowPivotHeader.getDataSource();
    }

    public final AppearanceManager getGridAppearanceManager() {
        return this._pivotGrid.getAppearanceManager();
    }

    public final void setGridAppearanceManager(AppearanceManager appearanceManager) {
        this._pivotGrid.setAppearanceManager(appearanceManager);
    }

    public final AppearanceManager getColumnAppearanceManager() {
        return this._columnPivotHeader.getAppearanceManager();
    }

    public final void setColumnAppearanceManager(AppearanceManager appearanceManager) {
        this._columnPivotHeader.setAppearanceManager(appearanceManager);
    }

    public final AppearanceManager getRowAppearanceManager() {
        return this._rowPivotHeader.getAppearanceManager();
    }

    public final void setRowAppearanceManager(AppearanceManager appearanceManager) {
        this._rowPivotHeader.setAppearanceManager(appearanceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnWidth(int n, int n2) {
        this.freezeRepaints();
        try {
            this._pivotGrid.setColumnWidth(n, n2);
            if (n2 != -1) {
                n2 += this._getVerticalSize();
            }
            this._columnPivotHeader.setColumnWidth(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public int getColumnWidth(int n) {
        return this._pivotGrid.getColumnWidth(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowHeight(int n, int n2) {
        this.freezeRepaints();
        try {
            this._pivotGrid.setRowHeight(n, n2);
            if (n2 != -1) {
                n2 += this._getHorizontalSize();
            }
            this._rowPivotHeader.setRowHeight(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public int getRowHeight(int n) {
        return this._pivotGrid.getRowHeight(n);
    }

    public void setDefaultColumnWidth(int n) {
        this._pivotGrid.setDefaultColumnWidth(n);
        this._columnPivotHeader.setDefaultColumnWidth(n + this._getVerticalSize());
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public void setDefaultRowHeight(int n) {
        this._pivotGrid.setDefaultRowHeight(n);
        this._rowPivotHeader.setDefaultRowHeight(n + this._getHorizontalSize());
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public void setEqualSizedColumns(boolean bl) {
        if (this._equalSizeColumns != bl) {
            this._needToDefaultColumns = this._equalSizeColumns = bl;
        }
    }

    public boolean getEqualSizedColumns() {
        return this._equalSizeColumns;
    }

    public void setEqualSizedRows(boolean bl) {
        if (this._equalSizeRows != bl) {
            this._needToDefaultRows = this._equalSizeRows = bl;
        }
    }

    public boolean getEqualSizedRows() {
        return this._equalSizeRows;
    }

    public void setScrollByColumn(boolean bl) {
        if (bl == this.getScrollByColumn()) {
            return;
        }
        this._pivotGrid.setScrollByColumn(bl);
        if (this._columnPivotHeader != null) {
            this._columnPivotHeader.setScrollByColumn(bl);
        }
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean getScrollByColumn() {
        return this._pivotGrid.getScrollByColumn();
    }

    public void setScrollByRow(boolean bl) {
        if (bl == this.getScrollByRow()) {
            return;
        }
        this._pivotGrid.setScrollByRow(bl);
        if (this._rowPivotHeader != null) {
            this._rowPivotHeader.setScrollByRow(bl);
        }
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean getScrollByRow() {
        return this._pivotGrid.getScrollByRow();
    }

    public final void fireDrillEvent(boolean bl, int n, int n2, Object object) {
        this.postEvent(new DrillEvent(this, 2002, bl, n, n2, object));
    }

    public final void fireCollapseEvent(boolean bl, int n, int n2) {
        this.postEvent(new CollapseEvent(this, 2001, bl, n, n2));
    }

    public final void firePivotEvent(Object object, int n, Object object2, int n2) {
        if (!this.isPivotAllowed()) {
            throw new IllegalStateException("pivoting is not enabled.");
        }
        this.postEvent(new PivotEvent(object, 2001, object2, n, n2));
    }

    public final void fireSwapEvent(Object object, int n, Object object2, int n2) {
        if (!this.isSwapAllowed()) {
            throw new IllegalStateException("swapping is not enabled.");
        }
        this.postEvent(new PivotEvent(object, 2002, object2, n, n2));
    }

    public synchronized void addCellSelectListener(TableCellSelectListener tableCellSelectListener) {
        if (this._cellSelectListeners == null) {
            this._cellSelectListeners = new ListenerManager();
        }
        this._cellSelectListeners.addListener(tableCellSelectListener);
    }

    public synchronized void removeCellSelectListener(TableCellSelectListener tableCellSelectListener) {
        if (this._cellSelectListeners != null) {
            this._cellSelectListeners.removeListener(tableCellSelectListener);
        }
    }

    public synchronized void addColSelectListener(TableColSelectListener tableColSelectListener) {
        if (this._colSelectListeners == null) {
            this._colSelectListeners = new ListenerManager();
        }
        this._colSelectListeners.addListener(tableColSelectListener);
    }

    public synchronized void removeColSelectListener(TableColSelectListener tableColSelectListener) {
        if (this._colSelectListeners != null) {
            this._colSelectListeners.removeListener(tableColSelectListener);
        }
    }

    public synchronized void addEditListener(TableEditListener tableEditListener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener(tableEditListener);
    }

    public synchronized void removeEditListener(TableEditListener tableEditListener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener(tableEditListener);
        }
    }

    public synchronized void addFocusListener(TableFocusListener tableFocusListener) {
        if (this._focusListeners == null) {
            this._focusListeners = new ListenerManager();
        }
        this._focusListeners.addListener(tableFocusListener);
    }

    public synchronized void removeFocusListener(TableFocusListener tableFocusListener) {
        if (this._focusListeners != null) {
            this._focusListeners.removeListener(tableFocusListener);
        }
    }

    public synchronized void addResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener(tableResizeListener);
    }

    public synchronized void removeResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener(tableResizeListener);
        }
    }

    public synchronized void addRowSelectListener(TableRowSelectListener tableRowSelectListener) {
        if (this._rowSelectListeners == null) {
            this._rowSelectListeners = new ListenerManager();
        }
        this._rowSelectListeners.addListener(tableRowSelectListener);
    }

    public synchronized void removeRowSelectListener(TableRowSelectListener tableRowSelectListener) {
        if (this._rowSelectListeners != null) {
            this._rowSelectListeners.removeListener(tableRowSelectListener);
        }
    }

    public synchronized void addScrollListener(TableScrollListener tableScrollListener) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new ListenerManager();
        }
        this._scrollListeners.addListener(tableScrollListener);
    }

    public synchronized void removeScrollListener(TableScrollListener tableScrollListener) {
        if (this._scrollListeners != null) {
            this._scrollListeners.removeListener(tableScrollListener);
        }
    }

    public synchronized void addPivotListener(PivotListener pivotListener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener(pivotListener);
    }

    public synchronized void removePivotListener(PivotListener pivotListener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener(pivotListener);
        }
    }

    public synchronized void addDrillListener(DrillListener drillListener) {
        if (this._drillListeners == null) {
            this._drillListeners = new ListenerManager();
        }
        this._drillListeners.addListener(drillListener);
    }

    public synchronized void removeDrillListener(DrillListener drillListener) {
        if (this._drillListeners != null) {
            this._drillListeners.removeListener(drillListener);
        }
    }

    public synchronized void addCollapseListener(CollapseListener collapseListener) {
        if (this._collapseListeners == null) {
            this._collapseListeners = new ListenerManager();
        }
        this._collapseListeners.addListener(collapseListener);
    }

    public synchronized void removeCollapseListener(CollapseListener collapseListener) {
        if (this._collapseListeners != null) {
            this._collapseListeners.removeListener(collapseListener);
        }
    }

    public synchronized void addPivotHeaderSelListener(PivotHeaderSelListener pivotHeaderSelListener) {
        if (this._pivotHeaderSelListeners == null) {
            this._pivotHeaderSelListeners = new ListenerManager();
        }
        this._pivotHeaderSelListeners.addListener(pivotHeaderSelListener);
    }

    public synchronized void removePivotHeaderSelListener(PivotHeaderSelListener pivotHeaderSelListener) {
        if (this._pivotHeaderSelListeners != null) {
            this._pivotHeaderSelListeners.removeListener(pivotHeaderSelListener);
        }
    }

    public synchronized void addPivotHeaderResListener(PivotHeaderResListener pivotHeaderResListener) {
        if (this._pivotHeaderResListeners == null) {
            this._pivotHeaderResListeners = new ListenerManager();
        }
        this._pivotHeaderResListeners.addListener(pivotHeaderResListener);
    }

    public synchronized void removePivotHeaderResListener(PivotHeaderResListener pivotHeaderResListener) {
        if (this._pivotHeaderResListeners != null) {
            this._pivotHeaderResListeners.removeListener(pivotHeaderResListener);
        }
    }

    @Override
    public Object getUIClassID() {
        return "PivotTableUI";
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getPivotGrid().setEnabled(bl);
        this.getRowPivotHeader().setEnabled(bl);
        this.getColumnPivotHeader().setEnabled(bl);
    }

    @Override
    public void requestFocus() {
        this.getPivotGrid().requestFocus();
    }

    @Override
    public boolean isInteriorTransparent() {
        return this.getColumnPivotHeader().getKeepHeaderCellsVisible() || this.getRowPivotHeader().getKeepHeaderCellsVisible() || super.isInteriorTransparent();
    }

    @Override
    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        Font font;
        Color color;
        Graphics graphics2;
        Boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n;
        int n2;
        Shape shape = graphics.getClip();
        Rectangle rectangle = graphics.getClipRect();
        boolean bl6 = PrinterUtils.getPrinterProperty(dictionary, PRINT_CORNER_COMPONENT, false);
        boolean bl7 = rectangle.y == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_PIVOT_HEADER, true);
        boolean bl8 = rectangle.x == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_PIVOT_HEADER, true);
        PivotHeader pivotHeader = bl7 && this.isColumnPivotHeaderVisible() ? this.getColumnPivotHeader() : null;
        PivotHeader pivotHeader2 = bl8 && this.isRowPivotHeaderVisible() ? this.getRowPivotHeader() : null;
        int n3 = pivotHeader2 != null ? pivotHeader2.getSize().width : 0;
        int n4 = n2 = pivotHeader != null ? pivotHeader.getSize().height : 0;
        if (n2 >= rectangle.height) {
            n = rectangle.height / 8;
            n2 = rectangle.height - n;
        }
        if (n3 >= rectangle.width) {
            n = rectangle.width / 8;
            n3 = rectangle.width - n;
        }
        n = this.getDrawRaised() ? 1 : 0;
        boolean bl9 = PrinterUtils.getPrinterProperty(dictionary, PRINT_RAISED, false);
        this.freezeRepaints();
        this.setDrawRaised(bl9);
        rectangle.width -= n3;
        rectangle.height -= n2;
        if (pivotHeader != null) {
            bl5 = pivotHeader.getKeepHeaderCellsVisible();
            bl4 = PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_HEADER_DATA, true);
            bl3 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_DRILL_IMAGES, false);
            bl2 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_SELECTORS, false);
            bl = !bl2 && (pivotHeader2 == null || !bl6) && !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, bl);
            bl = !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, bl);
            pivotHeader.freezeRepaints();
            pivotHeader.setKeepHeaderCellsVisible(bl4);
            pivotHeader.setDrillImagesDisplayed(bl3);
            graphics2 = graphics;
            color = graphics2.getColor();
            font = graphics2.getFont();
            graphics2.translate(n3, rectangle.y);
            graphics2.setClip(rectangle.x, 0, rectangle.width, n2);
            graphics2.setFont(pivotHeader.getFont());
            graphics2.setColor(pivotHeader.getForeground());
            pivotHeader.printPage(paintContext, dictionary, graphics2);
            pivotHeader.setKeepHeaderCellsVisible(bl5);
            pivotHeader.setDrillImagesDisplayed(true);
            graphics2.translate(-n3, -rectangle.y);
            graphics2.setClip(shape);
            graphics2.setColor(color);
            graphics2.setFont(font);
            dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
            dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
            pivotHeader.unfreezeRepaints();
        }
        if (pivotHeader2 != null) {
            bl5 = pivotHeader2.getKeepHeaderCellsVisible();
            bl4 = PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_HEADER_DATA, true);
            bl3 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_DRILL_IMAGES, false);
            bl2 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_SELECTORS, false);
            bl = !bl2 && (pivotHeader == null || !bl6) && !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, bl);
            bl = !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, bl);
            pivotHeader2.freezeRepaints();
            pivotHeader2.setDrillImagesDisplayed(bl3);
            pivotHeader2.setKeepHeaderCellsVisible(bl4);
            graphics2 = graphics;
            color = graphics2.getColor();
            font = graphics2.getFont();
            graphics2.translate(rectangle.x, n2);
            graphics2.setClip(0, rectangle.y, n3, rectangle.height);
            graphics2.setFont(pivotHeader2.getFont());
            graphics2.setColor(pivotHeader2.getForeground());
            pivotHeader2.printPage(paintContext, dictionary, graphics2);
            pivotHeader2.setKeepHeaderCellsVisible(bl5);
            pivotHeader2.setDrillImagesDisplayed(true);
            graphics2.translate(-rectangle.x, -n2);
            graphics2.setClip(shape);
            graphics2.setColor(color);
            graphics2.setFont(font);
            dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
            dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
            pivotHeader2.unfreezeRepaints();
        }
        Boolean bl10 = !(bl5 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_SELECTORS, false)) && pivotHeader2 == null ? Boolean.TRUE : Boolean.FALSE;
        dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, bl10);
        bl5 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_SELECTORS, false);
        bl10 = !bl5 && pivotHeader == null ? Boolean.TRUE : Boolean.FALSE;
        dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, bl10);
        PivotGrid pivotGrid = this.getPivotGrid();
        graphics.translate(n3, n2);
        graphics.setClip(rectangle);
        graphics.setFont(pivotGrid.getFont());
        graphics.setColor(pivotGrid.getForeground());
        pivotGrid.printPage(paintContext, dictionary, graphics);
        graphics.translate(-n3, -n2);
        if (bl6) {
            graphics.translate(rectangle.x, rectangle.y);
            graphics.setClip(0, 0, n3, n2);
            this.getCornerComponent().paint(graphics);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
        graphics.setClip(shape);
        this.setDrawRaised(n != 0);
        dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
        dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
        this.unfreezeRepaints();
    }

    @Override
    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        Dimension dimension = this.getPivotGrid().getDocumentSize(paintContext, dictionary);
        return dimension;
    }

    @Override
    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl = n2 == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_PIVOT_HEADER, true);
        boolean bl2 = n == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_PIVOT_HEADER, true);
        int n7 = n6 = bl && this.isColumnPivotHeaderVisible() ? this.getColumnPivotHeader().getSize().height : 0;
        if (n6 < n4) {
            n4 -= n6;
        } else {
            n5 = n4 / 8;
            n6 = n4 - n5;
            n4 = n5;
        }
        int n8 = n5 = bl2 && this.isRowPivotHeaderVisible() ? this.getRowPivotHeader().getSize().width : 0;
        if (n5 < n3) {
            n3 -= n5;
        } else {
            int n9 = n3 / 8;
            n5 = n3 - n9;
            n3 = n9;
        }
        Rectangle rectangle = this.getPivotGrid().getPageBounds(paintContext, dictionary, n, n2, n3, n4);
        rectangle.width += n5;
        rectangle.height += n6;
        return rectangle;
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    @Override
    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        this._vAdjustable = adjustable;
        this._pivotGrid.attachVAdjustable(adjustable);
        this._rowPivotHeader.attachVAdjustable(adjustable);
    }

    @Override
    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        this._hAdjustable = adjustable;
        this._pivotGrid.attachHAdjustable(adjustable);
        this._columnPivotHeader.attachHAdjustable(adjustable);
    }

    @Override
    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (adjustable == this.getHAdjustable()) {
            this._hAdjustable = null;
            this._pivotGrid.detachAdjustable(adjustable);
            this._columnPivotHeader.detachAdjustable(adjustable);
        } else if (adjustable == this.getVAdjustable()) {
            this._vAdjustable = null;
            this._pivotGrid.detachAdjustable(adjustable);
            this._rowPivotHeader.detachAdjustable(adjustable);
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    @Override
    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    @Override
    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    @Override
    public void handleHScroll(int n, int n2) {
        this.freezeRepaints();
        this._pivotGrid.handleHScroll(n, n2);
        this._columnPivotHeader.handleHScroll(n, n2);
        this.unfreezeRepaints();
    }

    @Override
    public void handleVScroll(int n, int n2) {
        this.freezeRepaints();
        this._pivotGrid.handleVScroll(n, n2);
        this._rowPivotHeader.handleVScroll(n, n2);
        this.unfreezeRepaints();
    }

    @Override
    public boolean isChildClipped(Component component) {
        if (this._freezeLevel > 0) {
            return true;
        }
        return super.isChildClipped(component);
    }

    @Override
    public void freezeRepaints() {
        super.freezeRepaints();
        ++this._freezeLevel;
    }

    @Override
    public void unfreezeRepaints() {
        --this._freezeLevel;
        super.unfreezeRepaints();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this._pivotGrid.getPreferredSize();
        if (this.isColumnPivotHeaderVisible()) {
            dimension.height += this._columnPivotHeader.getPreferredSize().height;
        }
        if (this.isRowPivotHeaderVisible()) {
            dimension.width += this._rowPivotHeader.getPreferredSize().width;
        }
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this._pivotGrid.getMinimumSize();
        if (this.isColumnPivotHeaderVisible()) {
            dimension.height += this._columnPivotHeader.getMinimumSize().height;
        }
        if (this.isRowPivotHeaderVisible()) {
            dimension.width += this._rowPivotHeader.getMinimumSize().width;
        }
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int n = this.getPivotTableUI().getSelectorSize(this);
        this._pivotGrid.setColumnHeaderHeight(n);
        this._pivotGrid.setRowHeaderWidth(n);
        this._columnPivotHeader.setRowHeaderWidth(n);
        this._rowPivotHeader.setColumnHeaderHeight(n);
        int n2 = this._pivotGrid.getDefaultColumnWidth();
        int n3 = this._pivotGrid.getDefaultRowHeight();
        this._columnPivotHeader.setDefaultColumnWidth(n2 + this._getVerticalSize());
        this._rowPivotHeader.setDefaultRowHeight(n3 + this._getHorizontalSize());
    }

    @Override
    public Object getPaintData(Object object) {
        Object object2 = null;
        object2 = PivotTableUI.HORIZONTAL_KEY.equals(object) ? (this.getRowDataSource().getColumnCount() != 0 ? Boolean.TRUE : Boolean.FALSE) : (PivotTableUI.VERTICAL_KEY.equals(object) ? (this.getColumnDataSource().getRowCount() != 0 ? Boolean.TRUE : Boolean.FALSE) : (KEY_DRAW_RAISED.equals(object) ? (this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE) : (TableUI.KEY_DRAW_RAISED.equals(object) ? (this.getPivotGrid().getDrawRaised() ? Boolean.TRUE : Boolean.FALSE) : super.getPaintData(object))));
        return object2;
    }

    @Override
    protected EwtComponent getProxyConfigurer() {
        return this._pivotGrid.getGrid();
    }

    @Override
    protected Dimension layoutCanvas() {
        Dimension dimension = this._pivotGrid.getCanvasSize();
        if (this.isColumnPivotHeaderVisible()) {
            dimension.height += this._columnPivotHeader.getCanvasSize().height;
        }
        if (this.isRowPivotHeaderVisible()) {
            dimension.width += this._rowPivotHeader.getCanvasSize().width;
        }
        return dimension;
    }

    @Override
    protected void setCanvasSize(int n, int n2) {
        super.setCanvasSize(n, n2);
        this.invalidateParent();
    }

    protected final PivotTableUI getPivotTableUI() {
        return (PivotTableUI)this.getUI();
    }

    @Override
    protected void paintOverChildren(Graphics graphics) {
        if (this._resizeHeader != null) {
            PivotHeader pivotHeader = this._resizeHeader;
            Color color = graphics.getColor();
            int n = pivotHeader.getHeaderResizeItem();
            Header header = pivotHeader.getHeader();
            UIDefaults uIDefaults = this.getUIDefaults();
            graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
            if (pivotHeader.isHorizontal()) {
                int n2 = header.getItemPosition(n) + header.getItemSize(n);
                graphics.fillRect(0, n2, this.getInnerWidth(), 3);
            } else {
                int n3 = header.getItemPosition(n) + header.getItemSize(n);
                graphics.fillRect(n3, 0, 3, this.getInnerHeight());
            }
            graphics.setColor(color);
        }
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateTree() {
        this.freezeRepaints();
        try {
            super.validateTree();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PivotEvent) {
            this.processPivotEvent((PivotEvent)aWTEvent);
        } else if (aWTEvent instanceof DrillEvent) {
            this.processDrillEvent((DrillEvent)aWTEvent);
        } else if (aWTEvent instanceof CollapseEvent) {
            this.processCollapseEvent((CollapseEvent)aWTEvent);
        } else if (aWTEvent instanceof PivotHeaderEvent) {
            switch (aWTEvent.getID()) {
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2007: 
                case 2008: 
                case 2009: 
                case 2010: 
                case 2011: 
                case 2012: {
                    this.processPivotHeaderSelectEvent((PivotHeaderEvent)aWTEvent);
                    break;
                }
                case 2013: 
                case 2014: 
                case 2015: 
                case 2016: {
                    this.processPivotHeaderResizeEvent((PivotHeaderEvent)aWTEvent);
                }
            }
        } else if (aWTEvent instanceof TableEvent) {
            switch (aWTEvent.getID()) {
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processCellSelectEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2009: 
                case 2010: 
                case 2011: 
                case 2012: {
                    this.processColSelectEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2005: 
                case 2006: 
                case 2007: 
                case 2008: {
                    this.processRowSelectEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2027: 
                case 2028: {
                    this.processFocusCellEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2019: 
                case 2020: 
                case 2021: 
                case 2022: {
                    this.processScrollEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2017: 
                case 2018: {
                    this.processEditEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2013: 
                case 2014: 
                case 2015: 
                case 2016: {
                    this.processResizeEvent((TableEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processCellSelectEvent(TableEvent tableEvent) {
        if (this._cellSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._cellSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellSelecting(tableEvent);
                }
                break;
            }
            case 2003: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellDeselecting(tableEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellSelected(tableEvent);
                }
                break;
            }
            case 2004: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellDeselected(tableEvent);
                }
                break;
            }
        }
    }

    protected void processColSelectEvent(TableEvent tableEvent) {
        if (this._colSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._colSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2009: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnSelecting(tableEvent);
                }
                break;
            }
            case 2011: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnDeselecting(tableEvent);
                }
                break;
            }
            case 2010: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnSelected(tableEvent);
                }
                break;
            }
            case 2012: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnDeselected(tableEvent);
                }
                break;
            }
        }
    }

    protected void processEditEvent(TableEvent tableEvent) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2017: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEditing(tableEvent);
                }
                break;
            }
            case 2018: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEdited(tableEvent);
                }
                break;
            }
        }
    }

    protected void processFocusCellEvent(TableEvent tableEvent) {
        if (this._focusListeners == null) {
            return;
        }
        Enumeration enumeration = this._focusListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2027: {
                while (enumeration.hasMoreElements()) {
                    ((TableFocusListener)enumeration.nextElement()).focusCellChanging(tableEvent);
                }
                break;
            }
            case 2028: {
                while (enumeration.hasMoreElements()) {
                    ((TableFocusListener)enumeration.nextElement()).focusCellChanged(tableEvent);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResizeEvent(TableEvent tableEvent) {
        Object object;
        int n = tableEvent.getID();
        Grid grid = this._pivotGrid.getGrid();
        if (n == 2013) {
            this._posBeforeResize = grid.getColumnPosition(tableEvent.getColumn());
            this._origXBeforeResize = grid.getCanvasOriginX();
            this._origYBeforeResize = grid.getCanvasOriginY();
        } else if (n == 2015) {
            this._posBeforeResize = grid.getRowPosition(tableEvent.getRow());
            this._origYBeforeResize = grid.getCanvasOriginY();
            this._origXBeforeResize = grid.getCanvasOriginX();
        } else {
            int n2;
            int n3;
            object = this.layoutCanvas();
            this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
            this._pivotGrid.invalidate();
            this._pivotGrid.validate();
            if (n == 2014) {
                this._columnPivotHeader.invalidate();
                this._columnPivotHeader.validate();
                n3 = grid.getColumnPosition(tableEvent.getColumn());
                n2 = n3 - this._posBeforeResize;
                if ((n2 -= this._origXBeforeResize) < 0) {
                    n2 = 0;
                }
                this.freezeRepaints();
                try {
                    this.setCanvasOrigin(-n2, this._origYBeforeResize);
                    this._pivotGrid.setCanvasOrigin(-n2, this._origYBeforeResize);
                    this._columnPivotHeader.setCanvasOrigin(-n2, this._origYBeforeResize);
                }
                finally {
                    this.unfreezeRepaints();
                }
            }
            this._rowPivotHeader.invalidate();
            this._rowPivotHeader.validate();
            n3 = grid.getRowPosition(tableEvent.getRow());
            n2 = n3 - this._posBeforeResize;
            if ((n2 -= this._origYBeforeResize) < 0) {
                n2 = 0;
            }
            this.freezeRepaints();
            try {
                this.setCanvasOrigin(this._origXBeforeResize, -n2);
                this._pivotGrid.setCanvasOrigin(this._origXBeforeResize, -n2);
                this._rowPivotHeader.setCanvasOrigin(this._origXBeforeResize, -n2);
            }
            finally {
                this.unfreezeRepaints();
            }
            this._fixPivotGrid();
        }
        if (this._resizeListeners == null) {
            return;
        }
        object = this._resizeListeners.getListeners();
        if (object == null) {
            return;
        }
        switch (n) {
            case 2013: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResizing(tableEvent);
                }
                break;
            }
            case 2014: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResized(tableEvent);
                }
                break;
            }
            case 2015: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResizing(tableEvent);
                }
                break;
            }
            case 2016: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResized(tableEvent);
                }
                break;
            }
        }
    }

    protected void processRowSelectEvent(TableEvent tableEvent) {
        if (this._rowSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._rowSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowSelecting(tableEvent);
                }
                break;
            }
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowDeselecting(tableEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowSelected(tableEvent);
                }
                break;
            }
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowDeselected(tableEvent);
                }
                break;
            }
        }
    }

    protected void processScrollEvent(TableEvent tableEvent) {
        if (this._scrollListeners == null) {
            return;
        }
        Enumeration enumeration = this._scrollListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2019: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).columnScrolling(tableEvent);
                }
                break;
            }
            case 2021: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).rowScrolling(tableEvent);
                }
                break;
            }
            case 2020: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).columnScrolled(tableEvent);
                }
                break;
            }
            case 2022: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).rowScrolled(tableEvent);
                }
                break;
            }
        }
    }

    protected void processPivotEvent(PivotEvent pivotEvent) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (pivotEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    try {
                        ((PivotListener)enumeration.nextElement()).pivot(pivotEvent);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    try {
                        ((PivotListener)enumeration.nextElement()).swap(pivotEvent);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
        }
    }

    protected void processDrillEvent(DrillEvent drillEvent) {
        if (this._drillListeners == null) {
            return;
        }
        Enumeration enumeration = this._drillListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (drillEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((DrillListener)enumeration.nextElement()).headerCellDrillRequest(drillEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((DrillListener)enumeration.nextElement()).headerCellDrill(drillEvent);
                }
                break;
            }
        }
    }

    protected void processCollapseEvent(CollapseEvent collapseEvent) {
        if (this._collapseListeners == null) {
            return;
        }
        Enumeration enumeration = this._collapseListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (collapseEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((CollapseListener)enumeration.nextElement()).collapse(collapseEvent);
                }
                break;
            }
        }
    }

    protected void processPivotHeaderResizeEvent(PivotHeaderEvent pivotHeaderEvent) {
        this.invalidateCanvas();
        if (this._pivotHeaderResListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotHeaderResListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (pivotHeaderEvent.getID()) {
            case 2013: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerColumnResizing(pivotHeaderEvent);
                }
                break;
            }
            case 2014: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerColumnResized(pivotHeaderEvent);
                }
                break;
            }
            case 2015: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerRowResizing(pivotHeaderEvent);
                }
                break;
            }
            case 2016: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerRowResized(pivotHeaderEvent);
                }
                break;
            }
        }
    }

    protected void processPivotHeaderSelectEvent(PivotHeaderEvent pivotHeaderEvent) {
        if (this._pivotHeaderSelListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotHeaderSelListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (pivotHeaderEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerCellSelecting(pivotHeaderEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerCellSelected(pivotHeaderEvent);
                }
                break;
            }
            case 2003: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerCellDeselecting(pivotHeaderEvent);
                }
                break;
            }
            case 2004: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerCellDeselected(pivotHeaderEvent);
                }
                break;
            }
            case 2009: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerRowSelecting(pivotHeaderEvent);
                }
                break;
            }
            case 2010: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerRowSelected(pivotHeaderEvent);
                }
                break;
            }
            case 2011: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerRowDeselecting(pivotHeaderEvent);
                }
                break;
            }
            case 2012: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerRowDeselected(pivotHeaderEvent);
                }
                break;
            }
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerColumnSelecting(pivotHeaderEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerColumnSelected(pivotHeaderEvent);
                }
                break;
            }
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerColumnDeselecting(pivotHeaderEvent);
                }
                break;
            }
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderSelListener)enumeration.nextElement()).headerColumnDeselected(pivotHeaderEvent);
                }
                break;
            }
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    final void deselectAll() {
        this.getColumnPivotHeader().getGrid().getGridSelection().deselectAll();
        this.getColumnPivotHeader().getRowHeader().getHeaderSelection().deselectAll();
        this.getRowPivotHeader().getGrid().getGridSelection().deselectAll();
        this.getRowPivotHeader().getColumnHeader().getHeaderSelection().deselectAll();
        this.getPivotGrid().getGrid().getGridSelection().deselectAll();
        this.getPivotGrid().getColumnHeader().getHeaderSelection().deselectAll();
        this.getPivotGrid().getRowHeader().getHeaderSelection().deselectAll();
    }

    final void postEvent(AWTEvent aWTEvent) {
        this.processEvent(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryDefaultColumns() {
        if (this._needToDefaultColumns) {
            TwoDDataSource twoDDataSource = this.getGridDataSource();
            int n = twoDDataSource.getColumnCount();
            this.freezeRepaints();
            try {
                for (int i = 0; i < n; ++i) {
                    this._pivotGrid.setColumnWidth(i, -1);
                    this._columnPivotHeader.setColumnWidth(i, -1);
                }
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        this._needToDefaultColumns = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryDefaultRows() {
        if (this._needToDefaultRows) {
            TwoDDataSource twoDDataSource = this.getGridDataSource();
            int n = twoDDataSource.getRowCount();
            this.freezeRepaints();
            try {
                for (int i = 0; i < n; ++i) {
                    this._pivotGrid.setRowHeight(i, -1);
                    this._rowPivotHeader.setRowHeight(i, -1);
                }
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        this._needToDefaultRows = false;
    }

    final void invalidateParent() {
        Container container = this.getParent();
        if (container != null && container instanceof ScrollBox) {
            ((ScrollBox)container).invalidateCanvas();
        }
    }

    final void setResizeHeader(PivotHeader pivotHeader) {
        this._resizeHeader = pivotHeader;
        this.repaint();
    }

    private void _fixPivotGrid() {
        Adjustable adjustable;
        int n;
        int n2;
        int n3;
        Grid grid = this._pivotGrid.getGrid();
        Adjustable adjustable2 = this.getHAdjustable();
        if (adjustable2 != null) {
            int n4 = adjustable2.getValue();
            n3 = grid.getCanvasOriginX();
            n2 = this.getHValueOfOffset(n3);
            if (this.getScrollByColumn() && (n = grid.getColumnAt(-n3)) != -1 && grid.getColumnPosition(n) != -n3 && (n2 == 0 || -n3 + grid.getInnerWidth() == grid.getCanvasWidth())) {
                ++n2;
            }
            if (n4 != n2) {
                adjustable2.setValue(n2);
            }
        }
        if ((adjustable = this.getVAdjustable()) != null) {
            int n5;
            n3 = adjustable.getValue();
            n2 = grid.getCanvasOriginY();
            n = this.getVValueOfOffset(n2);
            if (this.getScrollByRow() && (n5 = grid.getRowAt(-n2)) != -1 && grid.getRowPosition(n5) != -n2 && (n == 0 || -n2 + grid.getInnerHeight() == grid.getCanvasHeight())) {
                ++n;
            }
            if (n3 != n) {
                adjustable.setValue(n);
            }
        }
    }

    private int _getHorizontalSize() {
        Grid grid = this._pivotGrid.getGrid();
        PaintContext paintContext = this.getPaintContext();
        Painter painter = grid.getHorizontalSeparatorPainter();
        return grid.getHorizontalSeparatorsVisible() ? painter.getPreferredSize((PaintContext)paintContext).height : 0;
    }

    private int _getVerticalSize() {
        Grid grid = this._pivotGrid.getGrid();
        PaintContext paintContext = this.getPaintContext();
        Painter painter = grid.getVerticalSeparatorPainter();
        return grid.getVerticalSeparatorsVisible() ? painter.getPreferredSize((PaintContext)paintContext).width : 0;
    }

    private class _LayoutMgr
    implements LayoutManager {
        private _LayoutMgr() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return ((PivotTable)container).getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            boolean bl;
            Dimension dimension = PivotTable.this.getInnerSize();
            if (dimension.width == 0 || dimension.height == 0) {
                return;
            }
            int n = PivotTable.this.isRowPivotHeaderVisible() ? PivotTable.this._rowPivotHeader.getPreferredSize().width : 0;
            int n2 = PivotTable.this.isColumnPivotHeaderVisible() ? PivotTable.this._columnPivotHeader.getPreferredSize().height : 0;
            Point point = PivotTable.this.getInnerOrigin();
            int n3 = point.x;
            int n4 = point.y;
            boolean bl2 = PivotTable.this.getActualReadingDirection() == 1;
            boolean bl3 = PivotTable.this.isRowPivotHeaderVisible();
            boolean bl4 = PivotTable.this.isColumnPivotHeaderVisible();
            Component component = PivotTable.this.getCornerComponent();
            int n5 = 0;
            int n6 = 0;
            Dimension dimension2 = component.getPreferredSize();
            boolean bl5 = dimension2.width > n;
            boolean bl6 = bl = dimension2.height > n2;
            if (bl5) {
                n = dimension2.width;
            }
            Dimension dimension3 = component.getMinimumSize();
            n5 = dimension3.width;
            n6 = dimension3.height;
            if (bl) {
                n2 = dimension2.height;
            }
            component.setVisible(true);
            if (bl2) {
                component.setBounds(point.x, point.y, n, n2);
            } else {
                component.setBounds(point.x + dimension.width - n, point.y, n, n2);
            }
            if (bl3) {
                if (bl2) {
                    PivotTable.this._rowPivotHeader.setBounds(point.x, point.y + n2, n, dimension.height - n2);
                } else {
                    PivotTable.this._rowPivotHeader.setBounds(point.x + dimension.width - n, point.y + n2, n, dimension.height - n2);
                }
            }
            if (bl4) {
                if (bl2) {
                    PivotTable.this._columnPivotHeader.setBounds(point.x + n, point.y, dimension.width - n, n2);
                } else {
                    PivotTable.this._columnPivotHeader.setBounds(point.x, point.y, dimension.width - n - 1, n2);
                }
            }
            if (bl2) {
                n3 += n;
            }
            int n7 = bl2 ? dimension.width - n3 : dimension.width - n3 - n;
            PivotTable.this._pivotGrid.setBounds(n3, n4 += n2, n7, dimension.height - n4);
            PivotTable.this._columnPivotHeader.setMinimumSize(n6);
            PivotTable.this._rowPivotHeader.setMinimumSize(n5);
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(PivotTable.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.access.resource.AccessibilityBundle", LocaleUtils.getTranslationLocale(this.getLocale()));
            AccessibleContext accessibleContext = PivotTable.this.getColumnPivotHeader().getAccessibleContext();
            String string = resourceBundle.getString("COLUMN_PIVOT_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getColumnPivotHeader().getRowHeader().getAccessibleContext();
            string = resourceBundle.getString("COLUMN_PIVOT_HEADER.HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getColumnPivotHeader().getGrid().getAccessibleContext();
            string = resourceBundle.getString("COLUMN_PIVOT_HEADER.GRID");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getRowPivotHeader().getColumnHeader().getAccessibleContext();
            string = resourceBundle.getString("ROW_PIVOT_HEADER.HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getRowPivotHeader().getAccessibleContext();
            string = resourceBundle.getString("ROW_PIVOT_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getRowPivotHeader().getGrid().getAccessibleContext();
            string = resourceBundle.getString("ROW_PIVOT_HEADER.GRID");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getPivotGrid().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getPivotGrid().getColumnHeader().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID.COLUMN_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getPivotGrid().getRowHeader().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID.ROW_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getPivotGrid().getGrid().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID.GRID");
            accessibleContext.setAccessibleName(string);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }
    }
}

