/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Dictionary;
import java.util.Hashtable;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;

public class PrinterUtils {
    public static final Object PAGE_KEY = "CurrPage";
    public static final Object XYPAGE_KEY = "CurrXYPage";

    private PrinterUtils() {
    }

    public static void print(LWComponent lWComponent, Dictionary dictionary, boolean bl, Frame frame, String string, Painter painter, Painter painter2, Painter painter3, double d, double d2, double d3, double d4) {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, null);
        if (printJob != null) {
            int n = printJob.getPageResolution();
            PrinterUtils.print(lWComponent, dictionary, bl, printJob, painter, painter2, painter3, (int)((double)n * d), (int)((double)n * d2), (int)((double)n * d3), (int)((double)n * d4));
            printJob.end();
        }
    }

    public static void print(LWComponent lWComponent, Dictionary dictionary, boolean bl, Frame frame, String string, Painter painter, Painter painter2, Painter painter3, int n, int n2, int n3, int n4) {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, null);
        if (printJob != null) {
            PrinterUtils.print(lWComponent, dictionary, bl, printJob, painter, painter2, painter3, n, n2, n3, n4);
            printJob.end();
        }
    }

    public static void print(LWComponent lWComponent, Dictionary hashtable, boolean bl, PrintJob printJob, Painter painter, Painter painter2, Painter painter3, int n, int n2, int n3, int n4) {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        Dimension dimension = printJob.getPageDimension();
        int n5 = dimension.width - n2 - n4;
        int n6 = dimension.height - n - n3;
        Graphics graphics = printJob.getGraphics();
        PrintPaintContext printPaintContext = new PrintPaintContext(lWComponent);
        int n7 = 1;
        int n8 = 1;
        int n9 = 1;
        printPaintContext.updatePage(graphics, n9, n7, n8);
        int n10 = 0;
        int n11 = 0;
        if (painter != null) {
            n10 = painter.getPreferredSize((PaintContext)printPaintContext).height;
        }
        if (painter2 != null) {
            n11 = painter2.getPreferredSize((PaintContext)printPaintContext).height;
        }
        Dimension dimension2 = lWComponent.getDocumentSize(printPaintContext, hashtable);
        int n12 = 1;
        int n13 = 0;
        int n14 = 0;
        int n15 = 1;
        int n16 = dimension2.height;
        int n17 = dimension2.width;
        if (!bl) {
            n12 = 0;
            n13 = 1;
            n14 = 1;
            n15 = 0;
            n16 = dimension2.width;
            n17 = dimension2.height;
        }
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        while (n20 <= n16) {
            int n21 = 0;
            Rectangle rectangle = null;
            while (n21 <= n17) {
                if (n10 != 0) {
                    painter.paint(printPaintContext, graphics, n2, n, n5, n10);
                }
                if (n11 != 0) {
                    painter2.paint(printPaintContext, graphics, n2, dimension.height - n3 - n11, n5, n11);
                }
                rectangle = lWComponent.getPageBounds(printPaintContext, hashtable, n18, n19, n5, n6 - n10 - n11);
                int n22 = rectangle.height;
                graphics.translate(n2, n + n10);
                graphics.setClip(0, 0, rectangle.width, rectangle.height);
                graphics.translate(-n18, -n19);
                lWComponent.printPage(printPaintContext, hashtable, graphics);
                if (painter3 != null) {
                    painter3.paint(printPaintContext, graphics, n18, n19, rectangle.width, rectangle.height);
                }
                if ((n21 = bl ? (n18 += rectangle.x) : (n19 += rectangle.y)) >= n17) continue;
                graphics.dispose();
                graphics = printJob.getGraphics();
                printPaintContext.updatePage(graphics, ++n9, n7 += n15, n8 += n14);
            }
            if (bl) {
                n18 = 0;
                n7 = 1;
                n20 = n19 += rectangle.y;
            } else {
                n19 = 0;
                n8 = 1;
                n20 = n18 += rectangle.x;
            }
            if (n20 >= n16) continue;
            graphics.dispose();
            graphics = printJob.getGraphics();
            printPaintContext.updatePage(graphics, ++n9, n7 += n13, n8 += n12);
        }
    }

    public static Object getPrinterProperty(Dictionary dictionary, Object object, Object object2) {
        Object v;
        if (dictionary != null && (v = dictionary.get(object)) != null) {
            return v;
        }
        return object2;
    }

    public static boolean getPrinterProperty(Dictionary dictionary, Object object, boolean bl) {
        try {
            Boolean bl2 = (Boolean)PrinterUtils.getPrinterProperty(dictionary, object, null);
            if (bl2 != null) {
                return bl2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static class PrintPaintContext
    extends PaintContextProxy {
        private LWComponent _printee;
        private transient PaintContext _printContext;
        private transient Graphics _printGraphics;
        private transient int _currPage;
        private transient int _currXPage;
        private transient int _currYPage;

        public PrintPaintContext(LWComponent lWComponent) {
            this._printee = lWComponent;
        }

        public void updatePage(Graphics graphics, int n, int n2, int n3) {
            if (graphics == null) {
                throw new IllegalArgumentException();
            }
            this._printContext = this._printee.getPrintPaintContext(graphics);
            this._printGraphics = graphics;
            this._currPage = n;
            this._currXPage = n2;
            this._currYPage = n3;
            graphics.setFont(this._printContext.getPaintFont());
            graphics.setColor(this._printContext.getPaintForeground());
        }

        @Override
        public Color getSurroundingColor() {
            return Color.white;
        }

        @Override
        public Object getPaintData(Object object) {
            if (object == PAGE_KEY) {
                return IntegerUtils.getInteger((int)this._currPage);
            }
            if (object == XYPAGE_KEY) {
                return new Point(this._currXPage, this._currYPage);
            }
            return this.getPaintContext().getPaintData(object);
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._printContext;
        }
    }
}

