/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.statusBar;

import javax.accessibility.AccessibleContext;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarItem;

public class StatusBarTextItem
extends StatusBarItem {
    private String _text;
    private String _minString;

    public StatusBarTextItem(String string) {
        this(string, -1, false);
    }

    public StatusBarTextItem(String string, int n, boolean bl) {
        super(n, bl);
        this._text = string == null || string.equals("") ? null : string;
    }

    public StatusBarTextItem(String string, String string2, boolean bl) {
        this(string, -1, bl);
        this._minString = string2 != null || !string2.equals("") ? string2 : null;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        if (this._text != string) {
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
            this._text = string;
            if (accessibleContext != null) {
                String string3 = accessibleContext.getAccessibleName();
                if (string3 == null) {
                    string3 = "";
                }
                string3 = string3.replace('\n', ' ');
                if ((string3 = string3.replace('\r', ' ')) != string2) {
                    accessibleContext.firePropertyChange("AccessibleName", string2, string3);
                }
            }
            this.repaint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getPaintData(Object object) {
        Object object2 = null;
        if (object == null || object == PaintContext.LABEL_KEY) {
            String string = this.getText();
            if (string == null) return null;
            if (string.length() <= 0) return null;
            object2 = string;
        } else if (object == "MinimumText") {
            String string;
            if (this._minString != null) {
                string = this._minString;
            } else {
                if (this.getText() == null) return "A";
                string = this.getText();
            }
            object2 = string;
        }
        if (object2 != null) return object2;
        return super.getPaintData(object);
    }

    @Override
    protected Painter getPainter() {
        StatusBar statusBar = this.getParent();
        if (statusBar != null) {
            return statusBar.getStatusBarUI().getTextPainter(statusBar);
        }
        return null;
    }

    @Override
    protected Painter getMinimumSizePainter() {
        StatusBar statusBar = this.getParent();
        if (statusBar != null) {
            return statusBar.getStatusBarUI().getMinimumSizeTextPainter(statusBar);
        }
        return null;
    }
}

