/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.thread;

import java.util.Enumeration;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.thread.SchedulerEvent;
import oracle.ewt.thread.SchedulerListener;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.timer.Timer;

public class TaskScheduler {
    private TaskQueue _queue = new TaskQueue();
    private Timer _timer;
    private ListenerManager _listeners;
    private static TaskScheduler _sTaskScheduler;
    private boolean _daemon;
    private String _name = "TaskScheduler timer";
    private int _priority = 5;
    private static final String _sDefaultName = "TaskScheduler timer";

    public static TaskScheduler getDefaultTaskScheduler() {
        if (_sTaskScheduler == null) {
            _sTaskScheduler = new TaskScheduler();
        }
        return _sTaskScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task, int n) {
        TaskQueue taskQueue;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        long l = System.currentTimeMillis() + (long)n;
        SchedulerEvent schedulerEvent = new SchedulerEvent(this, 1, task, l);
        this.processSchedulerEvent(schedulerEvent);
        if (schedulerEvent.isTaskRejected()) {
            return;
        }
        TaskQueue taskQueue2 = taskQueue = this._queue;
        synchronized (taskQueue2) {
            boolean bl = taskQueue.remove(task);
            boolean bl2 = bl = taskQueue.add(task, l) || bl;
            if (bl) {
                this._getTimer().schedule(taskQueue.getNextDelay());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Task task) {
        TaskQueue taskQueue;
        TaskQueue taskQueue2 = taskQueue = this._queue;
        synchronized (taskQueue2) {
            if (taskQueue.remove(task)) {
                Timer timer = this._getTimer();
                if (taskQueue.isEmpty()) {
                    timer.cancel();
                } else {
                    timer.schedule(taskQueue.getNextDelay());
                }
            }
        }
    }

    public void setDaemon(boolean bl) {
        this._daemon = bl;
        Timer timer = this._timer;
        if (timer != null) {
            timer.setDaemon(bl);
        }
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public void setName(String string) {
        this._name = string;
        Timer timer = this._timer;
        if (timer != null) {
            timer.setName(string);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setPriority(int n) {
        this._priority = n;
        Timer timer = this._timer;
        if (timer != null) {
            timer.setPriority(n);
        }
    }

    public int getPriority() {
        return this._priority;
    }

    public synchronized void addSchedulerListener(SchedulerListener schedulerListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(schedulerListener);
    }

    public synchronized void removeSchedulerListener(SchedulerListener schedulerListener) {
        this._listeners.removeListener(schedulerListener);
    }

    protected void processTask(Task task, long l) {
        try {
            SchedulerEvent schedulerEvent = new SchedulerEvent(this, 2, task, l);
            this.processSchedulerEvent(schedulerEvent);
            if (!schedulerEvent.isTaskRejected()) {
                this.runTask(task, new TaskEvent(this, task, l));
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void runTask(Task task, TaskEvent taskEvent) {
        task.runTask(taskEvent);
    }

    protected void finalize() throws Throwable {
        Timer timer = this._timer;
        if (timer != null) {
            this._timer = null;
            timer.kill();
        }
        super.finalize();
    }

    protected void processSchedulerEvent(SchedulerEvent schedulerEvent) {
        Enumeration enumeration;
        int n = schedulerEvent.getID();
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                SchedulerListener schedulerListener = (SchedulerListener)enumeration.nextElement();
                switch (n) {
                    case 1: {
                        schedulerListener.taskScheduled(schedulerEvent);
                        break;
                    }
                    case 2: {
                        schedulerListener.taskRunning(schedulerEvent);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Timer _getTimer() {
        Timer timer = this._timer;
        if (timer == null || timer.isKilled()) {
            TaskQueue taskQueue = this._queue;
            synchronized (taskQueue) {
                timer = new Timer(this._queue);
                timer.setName(this._name);
                timer.setDaemon(this._daemon);
                timer.setPriority(this._priority);
                this._timer = timer;
            }
        }
        return timer;
    }

    private class Element {
        public final Task task;
        public final long time;
        public Element next;

        public Element(Task task, long l, Element element) {
            this.task = task;
            this.time = l;
            this.next = element;
        }
    }

    private class TaskQueue
    implements Runnable {
        private Element _head;

        private TaskQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Element element = null;
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                if (this.isEmpty()) {
                    return;
                }
                long l = this.getNextDelay();
                if (l <= 0L) {
                    element = this.popFirstTask();
                }
            }
            if (element != null) {
                TaskScheduler.this.processTask(element.task, element.time);
            }
            taskQueue = this;
            synchronized (taskQueue) {
                if (!this.isEmpty()) {
                    TaskScheduler.this._getTimer().schedule(this.getNextDelay());
                }
            }
        }

        public boolean add(Task task, long l) {
            Element element = null;
            Element element2 = this._head;
            while (element2 != null && element2.time <= l) {
                element = element2;
                element2 = element2.next;
            }
            Element element3 = new Element(task, l, element2);
            if (element == null) {
                this._head = element3;
                return true;
            }
            element.next = element3;
            return false;
        }

        public boolean remove(Task task) {
            Element element = null;
            Element element2 = this._head;
            while (element2 != null) {
                if (element2.task == task) {
                    if (element == null) {
                        this._head = element2.next;
                        return true;
                    }
                    element.next = element2.next;
                    break;
                }
                element = element2;
                element2 = element2.next;
            }
            return false;
        }

        public Element popFirstTask() {
            Element element = this._head;
            this._head = element.next;
            return element;
        }

        public long getNextDelay() {
            long l = this._head.time - System.currentTimeMillis();
            if (l < 0L) {
                l = 0L;
            }
            return l;
        }

        public boolean isEmpty() {
            return this._head == null;
        }
    }
}

