/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.toolBar.ToolBar;

public abstract class ToolBarItem
extends PaintContextProxy
implements Accessible {
    public static final int ID_UNSPECIFIED = -1;
    private int _id = -1;
    private AccessibleContext _accessibleContext;

    public void setID(int n) {
        this._id = n;
    }

    public int getID() {
        return this._id;
    }

    protected abstract void setParent(ToolBar var1);

    public abstract ToolBar getParent();

    public abstract void setLocation(int var1, int var2);

    public abstract Point getLocation();

    public abstract Dimension getSize();

    public abstract Dimension getPreferredSize();

    public abstract Dimension getMinimumSize();

    public abstract void setSize(int var1, int var2);

    public abstract void storeSize(int var1, int var2);

    public abstract boolean inside(int var1, int var2);

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public boolean mouseEntered(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseExited(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseMoved(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    public void paint(Graphics graphics) {
    }

    public String getHelpText() {
        return null;
    }

    public void setHelpText(String string) {
    }

    public abstract Component getComponent();

    @Override
    public int getPaintState() {
        int n = super.getPaintState() & 0x15;
        if (!this.isEnabled()) {
            n |= 1;
        }
        return n;
    }

    @Override
    public Object getPaintData(Object object) {
        return null;
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    protected final AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected PaintContext getPaintContext() {
        ToolBar toolBar = this.getParent();
        if (toolBar != null) {
            return toolBar.getPaintContext();
        }
        return null;
    }

    public class Access
    extends AccessibleContext
    implements AccessibleComponent {
        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SEPARATOR;
        }

        @Override
        public String getAccessibleName() {
            Object object;
            String string = this.accessibleName;
            if (string == null && (object = ToolBarItem.this.getPaintData(PaintContext.LABEL_KEY)) instanceof String) {
                string = (String)object;
            }
            return string;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = this.getAccessibleParent().getAccessibleContext().getAccessibleStateSet();
            if (!this.isVisible()) {
                accessibleStateSet.remove(AccessibleState.VISIBLE);
                accessibleStateSet.remove(AccessibleState.SHOWING);
            }
            if (!this.isEnabled()) {
                accessibleStateSet.remove(AccessibleState.ENABLED);
            }
            return accessibleStateSet;
        }

        @Override
        public Accessible getAccessibleParent() {
            return ToolBarItem.this.getParent();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return ToolBarItem.this.getParent().getItemIndex(ToolBarItem.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return ToolBarItem.this.getParent().getLocale();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public Color getBackground() {
            return ToolBarItem.this.getPaintBackground();
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            return ToolBarItem.this.getPaintForeground();
        }

        @Override
        public void setForeground(Color color) {
        }

        @Override
        public Cursor getCursor() {
            Cursor cursor = ToolBarItem.this.getParent().getCursor();
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public Font getFont() {
            return ToolBarItem.this.getPaintFont();
        }

        @Override
        public void setFont(Font font) {
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return ToolBarItem.this.getFontMetrics(font);
        }

        @Override
        public boolean isEnabled() {
            return (ToolBarItem.this.getPaintState() & 1) == 0;
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isVisible() {
            return ToolBarItem.this.isVisible();
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isShowing() {
            return this.isVisible() && ToolBarItem.this.getParent().isShowing();
        }

        @Override
        public boolean contains(Point point) {
            Point point2 = this.getLocation();
            return ToolBarItem.this.inside(point.x + point2.x, point.y + point2.y);
        }

        @Override
        public Point getLocationOnScreen() {
            if (this.isShowing()) {
                ToolBar toolBar = ToolBarItem.this.getParent();
                Point point = toolBar.getLocationOnScreen();
                Point point2 = this.getLocation();
                point.x += point2.x;
                point.y += point2.y;
                point.translate(toolBar.getCanvasOriginX(), toolBar.getCanvasOriginY());
                return point;
            }
            return null;
        }

        @Override
        public Point getLocation() {
            Point point = ToolBarItem.this.getLocation();
            point = ToolBarItem.this.getParent().convertInteriorToOuter(point.x, point.y);
            return point;
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            return new Rectangle(this.getLocation(), this.getSize());
        }

        @Override
        public void setBounds(Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            return ToolBarItem.this.getSize();
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
        }
    }
}

