/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.undo;

import oracle.ewt.undo.CannotRedoException;
import oracle.ewt.undo.CannotUndoException;
import oracle.ewt.undo.UndoableEdit;

public class AbstractUndoableEdit
implements UndoableEdit {
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";
    boolean hasBeenDone = true;
    boolean alive = true;

    @Override
    public void die() {
        this.alive = false;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }

    @Override
    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    @Override
    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "";
    }

    @Override
    public String getUndoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Undo " + string : UndoName;
        return string;
    }

    @Override
    public String getRedoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Redo " + string : RedoName;
        return string;
    }

    public String toString() {
        return super.toString() + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive;
    }
}

