/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ewt.event.Cancelable;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.WizardPage;

public class ReentrantWizard
extends BaseWizard {
    private TabPanel _tabPanel = new TabPanel();
    private boolean _dontValidate;

    public ReentrantWizard() {
        this._tabPanel.addTabPanelListener(new TPLstn());
        this.setCanApply(true);
        this.add((Component)this._tabPanel, "Center");
    }

    @Override
    public synchronized WizardPage addPage(WizardPage wizardPage, WizardPage wizardPage2) {
        super.addPage(wizardPage, wizardPage2);
        this._tabPanel.addPage(new RWTPPage(wizardPage), this.getTabPanelPage(wizardPage2));
        return wizardPage;
    }

    @Override
    public synchronized void removePage(WizardPage wizardPage) {
        TabPanelPage tabPanelPage = this.getTabPanelPage(wizardPage);
        ((RWTPPage)tabPanelPage).detach(wizardPage);
        this._dontValidate = true;
        this._tabPanel.removePage(tabPanelPage);
        tabPanelPage.setContent(null);
        this._dontValidate = false;
        super.removePage(wizardPage);
    }

    @Override
    public synchronized void removeAllPages() {
        int n = this.getPageCount();
        while (--n >= 0) {
            this.removePage(this.getPageAt(n));
        }
    }

    @Override
    protected void doPrevious() {
        WizardPage wizardPage = this.getPreviousPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage);
        }
    }

    @Override
    protected void doNext() {
        WizardPage wizardPage = this.getNextPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage);
        }
    }

    protected TabPanelPage getTabPanelPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        if (n < this._tabPanel.getPageCount()) {
            return this._tabPanel.getPage(wizardPage.getIndex());
        }
        return null;
    }

    protected WizardPage getWizardPage(TabPanelPage tabPanelPage) {
        if (tabPanelPage == null) {
            return null;
        }
        return this.getPageAt(tabPanelPage.getIndex());
    }

    @Override
    protected boolean getMustFinish() {
        return false;
    }

    @Override
    protected void selectPage(WizardPage wizardPage, boolean bl) {
        WizardPage wizardPage2 = this.getSelectedPage();
        if (bl && !this.pageSelectionChanging(wizardPage)) {
            return;
        }
        this._dontValidate = true;
        super.selectPage(wizardPage, bl);
        wizardPage = this.getSelectedPage();
        TabPanelPage tabPanelPage = this.getTabPanelPage(wizardPage);
        if (tabPanelPage != null && tabPanelPage != this._tabPanel.getSelectedPage()) {
            tabPanelPage.setSelected(true);
        }
        this._dontValidate = false;
    }

    protected boolean pageSelectionChanging(WizardPage wizardPage) {
        return true;
    }

    @Override
    protected void enableButtons() {
        super.enableButtons();
        this._tabPanel.setEnabled(this.isEnabled());
    }

    private class TPLstn
    implements TabPanelListener {
        private TPLstn() {
        }

        @Override
        public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
            if (!(ReentrantWizard.this._dontValidate || ReentrantWizard.this.pageSelectionChanging(ReentrantWizard.this.getWizardPage(tabPanelEvent.getPage())) && ReentrantWizard.this.validateSelectedPage())) {
                ((Cancelable)((Object)tabPanelEvent)).cancel();
            }
        }

        @Override
        public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
            if (!ReentrantWizard.this._dontValidate) {
                ReentrantWizard.this.selectPage(ReentrantWizard.this.getWizardPage(tabPanelEvent.getPage()), false);
            }
        }
    }

    protected class RWTPPage
    extends TabPanelPage
    implements PropertyChangeListener {
        public RWTPPage(WizardPage wizardPage) {
            super(wizardPage.getContent(), wizardPage.getLabel());
            if (!wizardPage.isEnabled()) {
                this.setEnabled(false);
            }
            if (!wizardPage.isVisible()) {
                this.setVisible(false);
            }
            wizardPage.addPropertyChangeListener(this);
        }

        public void detach(WizardPage wizardPage) {
            wizardPage.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals("enabled")) {
                this.setEnabled((Boolean)object);
            } else if (string.equals("visible")) {
                this.setVisible((Boolean)object);
            } else if (string.equals("content")) {
                this.setContent((Component)object);
            } else if (string.equals("label")) {
                this.setLabel((String)object);
            }
        }
    }
}

