/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard.dWizard;

import java.util.NoSuchElementException;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.dWizard.WizardSequence;

public class SequenceSeries
implements WizardSequence {
    private WizardSequence[] _series;
    private int _index;

    public SequenceSeries(WizardSequence[] wizardSequenceArray) {
        if (wizardSequenceArray == null || wizardSequenceArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this._series = wizardSequenceArray;
    }

    @Override
    public void goToFirstPage() {
        this._index = 0;
        this._series[0].goToFirstPage();
        if (this.getCurrentPage() == null && this.getNextPage() != null) {
            this.goForward();
        }
    }

    @Override
    public void goToLastPage() {
        this._index = this._series.length - 1;
        this._series[this._index].goToLastPage();
        if (this.getCurrentPage() == null && this.getPreviousPage() != null) {
            this.goBackwards();
        }
    }

    @Override
    public void goForward() {
        int n = this._index;
        if (this._series[n].getNextPage() != null) {
            this._series[n].goForward();
        } else {
            do {
                if (this._index == this._series.length - 1) {
                    throw new NoSuchElementException();
                }
                this._series[++this._index].goToFirstPage();
            } while (this.getCurrentPage() == null);
        }
    }

    @Override
    public void goBackwards() {
        int n = this._index;
        if (this._series[n].getPreviousPage() != null) {
            this._series[n].goBackwards();
        } else {
            do {
                if (this._index == 0) {
                    throw new NoSuchElementException();
                }
                this._series[--this._index].goToLastPage();
            } while (this.getCurrentPage() == null);
        }
    }

    @Override
    public WizardPage getNextPage() {
        int n = this._index;
        WizardPage wizardPage = this._series[n].getNextPage();
        while (wizardPage == null && n < this._series.length - 1) {
            this._series[++n].goToFirstPage();
            wizardPage = this._series[n].getCurrentPage();
        }
        return wizardPage;
    }

    @Override
    public WizardPage getPreviousPage() {
        int n = this._index;
        WizardPage wizardPage = this._series[n].getPreviousPage();
        while (wizardPage == null && n > 0) {
            this._series[--n].goToLastPage();
            wizardPage = this._series[n].getCurrentPage();
        }
        return wizardPage;
    }

    @Override
    public WizardPage getCurrentPage() {
        return this._series[this._index].getCurrentPage();
    }

    @Override
    public int getPageCount() {
        int n = 0;
        for (int i = 0; i < this._series.length; ++i) {
            n += this._series[i].getPageCount();
        }
        return n;
    }
}

