/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.util.Date;
import oracle.bali.dbUI.constraint.ObjectTest;
import oracle.bali.dbUI.constraint.ObjectTestExpression;
import oracle.bali.dbUI.constraint.ObjectTestRow;

class BetweenObjectTest
implements ObjectTest {
    private ObjectTestExpression _toCheck;
    private ObjectTestExpression _first;
    private ObjectTestExpression _second;
    private boolean _not;

    public BetweenObjectTest(ObjectTestExpression toCheck, ObjectTestExpression first, ObjectTestExpression second, boolean not) {
        this._toCheck = toCheck;
        this._first = first;
        this._second = second;
        this._not = not;
    }

    public boolean test(ObjectTestRow row) {
        Object c = this._toCheck.getValue(row);
        Object f = this._first.getValue(row);
        Object s = this._second.getValue(row);
        boolean result = false;
        if (c == null && f == null && s == null) {
            result = true;
        } else if (c != null && f != null && s != null) {
            if (c instanceof Number && f instanceof Number && s instanceof Number) {
                double cv = ((Number)c).doubleValue();
                double fv = ((Number)f).doubleValue();
                double sv = ((Number)s).doubleValue();
                if (cv >= fv && cv <= sv || cv >= sv && cv <= fv) {
                    result = true;
                }
            } else if (c instanceof Date && f instanceof Date && s instanceof Date) {
                Date cv = (Date)c;
                Date fv = (Date)f;
                Date sv = (Date)s;
                if ((cv.equals(fv) || cv.after(fv)) && (sv.equals(cv) || sv.after(cv)) || (cv.equals(sv) || cv.after(sv)) && (fv.equals(cv) || fv.after(cv))) {
                    result = true;
                }
            } else if (c instanceof String && f instanceof String && s instanceof String) {
                int t2;
                String s1 = f.toString();
                String s2 = s.toString();
                String cString = c.toString();
                int t1 = s1.compareTo(cString);
                boolean bl = result = t1 != (t2 = s2.compareTo(cString));
            }
        }
        if (this._not) {
            result = !result;
        }
        return result;
    }
}

