/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.util.Vector;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;

public class DataConstraintUtils {
    private static DataConstraintUtils _sInstance;

    public static DataConstraintUtils getDataConstraintUtils() {
        if (_sInstance == null) {
            _sInstance = new DataConstraintUtils();
        }
        return _sInstance;
    }

    public DataConstraint simplifyConstraint(DataConstraint constraint) {
        DataConstraint child;
        if (constraint == null) {
            return constraint;
        }
        if (!(constraint instanceof DCExpression)) {
            return constraint;
        }
        DCExpression parent = (DCExpression)constraint;
        int childCount = parent.getConstraintCount();
        if (childCount == 0) {
            return constraint;
        }
        DataConstraint[] children = new DataConstraint[childCount];
        int realCount = 0;
        for (int i = 0; i < childCount; ++i) {
            child = this.simplifyConstraint(parent.getConstraint(i));
            if (child == null) continue;
            children[realCount] = child;
            ++realCount;
        }
        if (parent instanceof DCUnaryExpression) {
            DCUnaryExpression notParent = (DCUnaryExpression)parent;
            switch (realCount) {
                case 0: {
                    constraint = null;
                    break;
                }
                case 1: {
                    child = children[0];
                    if (!(child instanceof DCUnaryExpression)) break;
                    DCUnaryExpression notChild = (DCUnaryExpression)child;
                    constraint = notChild.getConstraint(0);
                }
            }
        } else if (parent instanceof DCBooleanExpression) {
            DCBooleanExpression andOrParent = (DCBooleanExpression)parent;
            switch (realCount) {
                case 0: {
                    constraint = null;
                    break;
                }
                case 1: {
                    constraint = children[0];
                    break;
                }
                default: {
                    int operand = andOrParent.getOperand();
                    Vector<DataConstraint> newChildren = new Vector<DataConstraint>(realCount);
                    for (int i = 0; i < realCount; ++i) {
                        child = children[i];
                        if (!(child instanceof DCBooleanExpression)) {
                            newChildren.addElement(child);
                            continue;
                        }
                        DCBooleanExpression andOrChild = (DCBooleanExpression)child;
                        if (andOrChild.getOperand() != operand) {
                            newChildren.addElement(child);
                            continue;
                        }
                        int tempCount = andOrChild.getConstraintCount();
                        for (int j = 0; j < tempCount; ++j) {
                            newChildren.addElement(andOrChild.getConstraint(j));
                        }
                    }
                    Object[] temp = new DataConstraint[newChildren.size()];
                    newChildren.copyInto(temp);
                    constraint = new DCBooleanExpression((DataConstraint[])temp, operand);
                }
            }
        }
        return constraint;
    }

    public DataConstraint removeConstraint(DataConstraint constraint, DataConstraint toRemove) {
        if (constraint == null || toRemove == null) {
            return constraint;
        }
        if (!(constraint instanceof DCExpression)) {
            if (constraint.equals(toRemove)) {
                constraint = null;
            }
            return constraint;
        }
        DCExpression parent = (DCExpression)constraint;
        if (parent instanceof DCUnaryExpression) {
            DCUnaryExpression notParent = (DCUnaryExpression)parent;
        } else if (parent instanceof DCBooleanExpression) {
            DCBooleanExpression andOrParent = (DCBooleanExpression)parent;
        }
        return constraint;
    }

    protected DataConstraintUtils() {
    }
}

