/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeDragSupport;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSimpleChild;
import oracle.bali.ewt.dTree.DTreeSimpleRoot;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.datatransfer.CompoundTransferable;
import oracle.bali.share.datatransfer.ObjectTransferable;

public class ColumnConstraintBuilder
extends LWComponent
implements Accessible {
    Column[] _columns;
    ConstraintBuilder _builder;
    P _provider;
    private DTreeSimpleRoot _root;
    private EWTScrollPane _scrollBox;
    private DTree _tree;
    private JSplitPane _splitter;

    public ColumnConstraintBuilder() {
        this(null);
    }

    public ColumnConstraintBuilder(Column[] columns) {
        this.setLayout(new BorderLayout());
        this._splitter = new JSplitPane();
        this._splitter.setContinuousLayout(false);
        this._tree = new DTree();
        this._root = new DTreeSimpleRoot();
        this._tree.setRoot((DTreeRootItem)this._root);
        this._tree.setDecoration(null);
        DTreeDragSupport dummy = new DTreeDragSupport(this._tree);
        this._builder = new ConstraintBuilder();
        this._scrollBox = new EWTScrollPane((Component)this._tree);
        this._provider = new P();
        this._builder.setDataDescriptorProvider(this._provider);
        this._splitter.add("left", (Component)this._scrollBox);
        this._splitter.add("right", (Component)((Object)this._builder));
        this.add("Center", this._splitter);
        this.setColumns(columns);
    }

    public ConstraintBuilder getConstraintBuilder() {
        return this._builder;
    }

    public void setColumns(Column[] columns) {
        int oldCount = this._columns == null ? 0 : this._columns.length;
        this._columns = null;
        if (columns != null) {
            int count = columns.length;
            this._columns = new Column[count];
            if (count != 0) {
                System.arraycopy(columns, 0, this._columns, 0, count);
            }
        }
        int newCount = this._columns == null ? 0 : this._columns.length;
        this.freezeRepaints();
        this._updateTree();
        this._provider.fireDescriptorCountChanged(oldCount, newCount);
        this.unfreezeRepaints();
    }

    public Column[] getColumns() {
        if (this._columns == null) {
            return null;
        }
        int count = this._columns.length;
        Column[] columns = new Column[count];
        if (count != 0) {
            System.arraycopy(this._columns, 0, columns, 0, count);
        }
        return columns;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._scrollBox.setEnabled(enabled);
        this._tree.setEnabled(enabled);
        this._builder.setEnabled(enabled);
    }

    public void requestFocus() {
        this._tree.requestFocus();
    }

    void addColumn(Column column) {
        ConstraintCompFactory f = ConstraintCompFactory.getConstraintCompFactory();
        ConstraintComponent comp = f.createConstraintComponent(this._provider, column, null);
        this._builder.addConstraintComponent(comp);
    }

    private void _updateTree() {
        int count;
        this._root.removeItems(0, this._root.getItemCount());
        if (this._columns != null) {
            Hashtable<String, CI> hash = new Hashtable<String, CI>();
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            for (int i = 0; i < this._columns.length; ++i) {
                Column column = this._columns[i];
                String name = column.getDisplayName(locale);
                Object hashObject = hash.get(name);
                if (hashObject != null) {
                    CI temp = (CI)((Object)hashObject);
                    name = temp.getColumn().getName();
                    temp.setLabel(name);
                    name = column.getName();
                }
                CI item = new CI(name, column);
                this._root.addItem((DTreeItem)item);
                if (hashObject != null) continue;
                hash.put(name, item);
            }
        }
        if ((count = this._root.getItemCount()) == 0) {
            this._tree.setPreferredItemsOnScreen(2);
        } else {
            this._root.setExpanded(true);
            this._tree.setPreferredItemsOnScreen(count + 1);
        }
        this._tree.setPreferredLevelsOnScreen(1);
        Dimension d = this._tree.getParent().getPreferredSize();
        Dimension prefSize = this.getPreferredSize();
    }

    private class P
    implements DataDescriptorProvider {
        private PropertyChangeSupport _propertySupport = new PropertyChangeSupport(this);

        public void fireDescriptorCountChanged(int oldCount, int newCount) {
            this._propertySupport.firePropertyChange("descriptorCount", new Integer(oldCount), new Integer(newCount));
        }

        public int getDescriptorCount() {
            return ColumnConstraintBuilder.this._columns == null ? 0 : ColumnConstraintBuilder.this._columns.length;
        }

        public DataDescriptor getDescriptor(int index) {
            return ColumnConstraintBuilder.this._columns[index];
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._propertySupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._propertySupport.removePropertyChangeListener(listener);
        }
    }

    private class CI
    extends DTreeSimpleChild
    implements DTreeDragSource {
        private Column _column;

        public CI(String name, Column column) {
            super(name, null);
            this._column = column;
        }

        public DTreeDragSource getDragSource() {
            return this;
        }

        public int getSourceActions(DTreeItem item) {
            return 2;
        }

        public Transferable getTransferable(DTreeItem item) {
            ConstraintCompFactory f = ConstraintCompFactory.getConstraintCompFactory();
            ConstraintComponent comp = f.createConstraintComponent(ColumnConstraintBuilder.this._provider, this._column, null);
            String name = this._column.getName();
            Transferable[] array = new Transferable[]{ObjectTransferable.createTransferable((Object)comp), ObjectTransferable.createTransferable((Object)this._column), ObjectTransferable.createTransferable((Object)name)};
            return new CompoundTransferable(array);
        }

        public void dragDropEnd(DTreeItem item, int dropAction) {
        }

        protected void mousePressed(MouseEvent e) {
            boolean leftButton;
            int count = e.getClickCount();
            boolean bl = leftButton = (e.getModifiers() & 0x10) != 0;
            if (leftButton && count == 2) {
                ColumnConstraintBuilder.this.addColumn(this._column);
            }
        }

        protected void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                ColumnConstraintBuilder.this.addColumn(this._column);
            }
        }

        public Column getColumn() {
            return this._column;
        }
    }
}

