/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db.impl;

import java.io.Serializable;
import java.util.Locale;
import oracle.bali.dbUI.db.DynamicColumn;
import oracle.bali.dbUI.db.Table;

public class DynamicColumnImpl
extends DynamicColumn
implements Serializable {
    private static final long serialVersionUID = 4560828997904356843L;
    private transient Table _table;
    private String _name;
    private String _displayName;
    private Class _type;
    private boolean _allowsNull;
    private Object _defaultValue;

    public DynamicColumnImpl(String name, String displayName, Class dataType, Table table) {
        this(name, displayName, dataType, false, null, table);
    }

    public DynamicColumnImpl(String name, String displayName, Class dataType, boolean allowsNull, Object defaultValue, Table table) {
        this._type = dataType;
        this._name = name;
        this._displayName = displayName;
        this._allowsNull = allowsNull;
        this._defaultValue = defaultValue;
        this._table = table;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public Table getTable() {
        return this._table;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        this.firePropertyChange("name", old, name);
    }

    public String getDisplayName(Locale locale) {
        return this._displayName;
    }

    public Class getDataType() {
        return this._type;
    }

    public void setDataType(Class type) {
        if (this._type != type) {
            Class old = this._type;
            this._type = type;
            this.firePropertyChange("dataType", old, type);
            Object defaultValue = this.getDefaultValue();
            if (defaultValue != null) {
                this.setDefaultValue(null);
            }
        }
    }

    public boolean isNullAllowed() {
        return this._allowsNull;
    }

    public void setNullAllowed(boolean allowsNull) {
        Boolean old = new Boolean(this._allowsNull);
        this._allowsNull = allowsNull;
        this.firePropertyChange("nullAllowed", old, new Boolean(this._allowsNull));
    }

    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(Object value) {
        Object old = this._defaultValue;
        this._defaultValue = value;
        this.firePropertyChange("defaultValue", old, value);
    }

    public Object getMetaData(Object key) {
        return null;
    }
}

