/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.Cursor;
import java.util.Vector;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.EdgeFactory;
import oracle.bali.dbUI.graph.EdgeImpl;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.Port;

public class DefaultEdgeFactory
implements EdgeFactory {
    private static EdgeFactory _sEdgeFactory;

    public static EdgeFactory getEdgeFactory() {
        if (_sEdgeFactory == null) {
            _sEdgeFactory = new DefaultEdgeFactory();
        }
        return _sEdgeFactory;
    }

    public boolean isEdgeValid(Port sourcePort, Port targetPort) {
        if (sourcePort == null || targetPort == null) {
            return false;
        }
        return sourcePort.isSourceable() && targetPort.isTargetable();
    }

    public Edge createEdge(Port sourcePort, Port targetPort) {
        if (sourcePort == null || targetPort == null) {
            return null;
        }
        return new EdgeImpl(sourcePort, targetPort);
    }

    public Cursor getCursor(Port sourcePort, Port targetPort) {
        return this.isEdgeValid(sourcePort, targetPort) ? Cursor.getPredefinedCursor(1) : Cursor.getDefaultCursor();
    }

    public Port[] getTargetablePorts(Port source, Node targetNode) {
        Vector<Port> v = new Vector<Port>();
        int count = targetNode.getPortCount();
        for (int i = 0; i < count; ++i) {
            Port p = targetNode.getPort(i);
            if (!this.isEdgeValid(source, p)) continue;
            v.addElement(p);
        }
        int portCount = v.size();
        if (portCount == 0) {
            return null;
        }
        Object[] ports = new Port[portCount];
        v.copyInto(ports);
        return ports;
    }

    protected DefaultEdgeFactory() {
    }
}

